/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.sampling;

import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.sampling.GetAllSampleConfigurationAction;
import org.elasticsearch.action.admin.indices.sampling.SamplingConfiguration;
import org.elasticsearch.action.admin.indices.sampling.SamplingMetadata;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.local.TransportLocalProjectMetadataAction;
import org.elasticsearch.cluster.ProjectState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.ProjectMetadata;
import org.elasticsearch.cluster.project.ProjectResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;

public class TransportGetAllSampleConfigurationAction
extends TransportLocalProjectMetadataAction<GetAllSampleConfigurationAction.Request, GetAllSampleConfigurationAction.Response> {
    private static final Logger logger = LogManager.getLogger(TransportGetAllSampleConfigurationAction.class);

    @Inject
    public TransportGetAllSampleConfigurationAction(ActionFilters actionFilters, TransportService transportService, ClusterService clusterService, ProjectResolver projectResolver) {
        super("indices:monitor/sample/config/get_all", actionFilters, transportService.getTaskManager(), clusterService, EsExecutors.DIRECT_EXECUTOR_SERVICE, projectResolver);
    }

    @Override
    protected void localClusterStateOperation(Task task, GetAllSampleConfigurationAction.Request request, ProjectState state, ActionListener<GetAllSampleConfigurationAction.Response> listener) {
        ProjectMetadata projectMetadata = state.metadata();
        if (projectMetadata == null) {
            logger.debug("No project metadata found");
            listener.onResponse(new GetAllSampleConfigurationAction.Response(Map.of()));
            return;
        }
        SamplingMetadata samplingMetadata = (SamplingMetadata)projectMetadata.custom("sampling");
        if (samplingMetadata == null) {
            logger.debug("No sampling metadata found");
            listener.onResponse(new GetAllSampleConfigurationAction.Response(Map.of()));
            return;
        }
        Map<String, SamplingConfiguration> indexToSampleConfigMap = samplingMetadata.getIndexToSamplingConfigMap();
        logger.debug("Retrieved sampling configurations");
        listener.onResponse(new GetAllSampleConfigurationAction.Response(indexToSampleConfigMap == null ? Map.of() : indexToSampleConfigMap));
    }

    @Override
    protected ClusterBlockException checkBlock(GetAllSampleConfigurationAction.Request request, ProjectState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
    }
}

