/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.sampling;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.admin.indices.sampling.GetSampleAction;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.Scope;
import org.elasticsearch.rest.ServerlessScope;
import org.elasticsearch.rest.action.RestCancellableNodeClient;
import org.elasticsearch.rest.action.RestRefCountedChunkedToXContentListener;

@ServerlessScope(value=Scope.INTERNAL)
public class RestGetSampleAction
extends BaseRestHandler {
    @Override
    public String getName() {
        return "get_sample";
    }

    @Override
    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.GET, "/{index}/_sample"));
    }

    @Override
    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        String[] indexNames = request.param("index").split(",");
        if (indexNames.length > 1) {
            throw new ActionRequestValidationException().addValidationError("Can only get samples for a single index at a time, but found " + Arrays.stream(indexNames).collect(Collectors.joining(", ", "[", "]")));
        }
        GetSampleAction.Request getSampleRequest = new GetSampleAction.Request(indexNames[0]);
        return channel -> new RestCancellableNodeClient(client, request.getHttpChannel()).execute(GetSampleAction.INSTANCE, getSampleRequest, new RestRefCountedChunkedToXContentListener((RestChannel)channel));
    }
}

