/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.sampling;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.admin.indices.sampling.DeleteSampleConfigurationAction;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestUtils;
import org.elasticsearch.rest.Scope;
import org.elasticsearch.rest.ServerlessScope;
import org.elasticsearch.rest.action.RestToXContentListener;

@ServerlessScope(value=Scope.INTERNAL)
public class RestDeleteSampleConfigurationAction
extends BaseRestHandler {
    @Override
    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.DELETE, "/{index}/_sample/config"));
    }

    @Override
    public String getName() {
        return "delete_sample_configuration_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        String[] indexNames = request.param("index").split(",");
        if (indexNames.length > 1) {
            throw new ActionRequestValidationException().addValidationError("Can only delete sampling configuration for a single index at a time, but found " + Arrays.stream(indexNames).collect(Collectors.joining(", ", "[", "]")));
        }
        DeleteSampleConfigurationAction.Request deleteSampleConfigRequest = new DeleteSampleConfigurationAction.Request(RestUtils.getMasterNodeTimeout(request), RestUtils.getAckTimeout(request));
        deleteSampleConfigRequest.indices(indexNames[0]);
        return channel -> client.execute(DeleteSampleConfigurationAction.INSTANCE, deleteSampleConfigRequest, new RestToXContentListener((RestChannel)channel));
    }
}

