/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.legacygeo.mapper;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.lucene.geo.LatLonGeometry;
import org.apache.lucene.search.Query;
import org.apache.lucene.spatial.prefix.PrefixTreeStrategy;
import org.apache.lucene.spatial.prefix.RecursivePrefixTreeStrategy;
import org.apache.lucene.spatial.prefix.TermQueryPrefixTreeStrategy;
import org.apache.lucene.spatial.prefix.tree.GeohashPrefixTree;
import org.apache.lucene.spatial.prefix.tree.PackedQuadPrefixTree;
import org.apache.lucene.spatial.prefix.tree.QuadPrefixTree;
import org.apache.lucene.spatial.prefix.tree.SpatialPrefixTree;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.Explicit;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.geo.GeoUtils;
import org.elasticsearch.common.geo.GeometryFormatterFactory;
import org.elasticsearch.common.geo.Orientation;
import org.elasticsearch.common.geo.ShapeRelation;
import org.elasticsearch.common.geo.SpatialStrategy;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.unit.DistanceUnit;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.core.CheckedConsumer;
import org.elasticsearch.geometry.Geometry;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.index.IndexVersions;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.mapper.AbstractGeometryFieldMapper;
import org.elasticsearch.index.mapper.AbstractShapeGeometryFieldMapper;
import org.elasticsearch.index.mapper.BlockLoader;
import org.elasticsearch.index.mapper.DocumentParserContext;
import org.elasticsearch.index.mapper.DocumentParsingException;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.GeoShapeQueryable;
import org.elasticsearch.index.mapper.IndexType;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperBuilderContext;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.legacygeo.ShapesAvailability;
import org.elasticsearch.legacygeo.XShapeCollection;
import org.elasticsearch.legacygeo.builders.ShapeBuilder;
import org.elasticsearch.legacygeo.parsers.ShapeParser;
import org.elasticsearch.legacygeo.query.LegacyGeoShapeQueryProcessor;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.locationtech.spatial4j.context.SpatialContext;
import org.locationtech.spatial4j.shape.Point;
import org.locationtech.spatial4j.shape.Shape;
import org.locationtech.spatial4j.shape.jts.JtsGeometry;

@Deprecated
public class LegacyGeoShapeFieldMapper
extends AbstractShapeGeometryFieldMapper<ShapeBuilder<?, ?, ?>> {
    public static final String CONTENT_TYPE = "geo_shape";
    public static final Set<String> DEPRECATED_PARAMETERS = Set.of("strategy", "tree", "tree_levels", "precision", "distance_error_pct", "points_only");
    @Deprecated
    public static final Mapper.TypeParser PARSER = (name, node, parserContext) -> {
        boolean ignoreMalformedByDefault = (Boolean)IGNORE_MALFORMED_SETTING.get(parserContext.getSettings());
        boolean coerceByDefault = (Boolean)COERCE_SETTING.get(parserContext.getSettings());
        Builder builder = new Builder(name, parserContext.indexVersionCreated(), ignoreMalformedByDefault, coerceByDefault);
        builder.parse(name, parserContext, node);
        return builder;
    };
    private final IndexVersion indexCreatedVersion;
    private final Builder builder;

    public static boolean containsDeprecatedParameter(Set<String> paramKeys) {
        return DEPRECATED_PARAMETERS.stream().anyMatch(paramKeys::contains);
    }

    public static Set<String> getDeprecatedParameters(Set<String> paramKeys) {
        return DEPRECATED_PARAMETERS.stream().filter(p -> paramKeys.contains(p)).collect(Collectors.toSet());
    }

    private static Builder builder(FieldMapper in) {
        return ((LegacyGeoShapeFieldMapper)in).builder;
    }

    public LegacyGeoShapeFieldMapper(String simpleName, MappedFieldType mappedFieldType, FieldMapper.BuilderParams builderParams, LegacyGeoShapeParser parser, Builder builder) {
        super(simpleName, mappedFieldType, builderParams, (Explicit)builder.ignoreMalformed.get(), (Explicit)builder.coerce.get(), (Explicit)builder.ignoreZValue.get(), (Explicit)builder.orientation.get(), (AbstractGeometryFieldMapper.Parser)parser);
        this.indexCreatedVersion = builder.indexCreatedVersion;
        this.builder = builder;
    }

    public Map<String, NamedAnalyzer> indexAnalyzers() {
        return Map.of(this.mappedFieldType.name(), Lucene.KEYWORD_ANALYZER);
    }

    public GeoShapeFieldType fieldType() {
        return (GeoShapeFieldType)super.fieldType();
    }

    public String strategy() {
        return this.fieldType().strategy().getStrategyName();
    }

    protected void index(DocumentParserContext context, ShapeBuilder<?, ?, ?> shapeBuilder) {
        if (shapeBuilder == null) {
            return;
        }
        Object shape = shapeBuilder.buildS4J();
        if (this.fieldType().pointsOnly()) {
            if (shape instanceof XShapeCollection && ((XShapeCollection)((Object)shape)).pointsOnly()) {
                List shapes = ((XShapeCollection)((Object)shape)).getShapes();
                for (Shape s : shapes) {
                    context.doc().addAll(Arrays.asList(this.fieldType().defaultPrefixTreeStrategy().createIndexableFields(s)));
                }
                return;
            }
            if (!(shape instanceof Point)) {
                throw new DocumentParsingException(context.parser().getTokenLocation(), "[{" + this.fieldType().name() + "}] is configured for points only but a " + String.valueOf(shape instanceof JtsGeometry ? ((JtsGeometry)shape).getGeom().getGeometryType() : shape.getClass()) + " was found");
            }
        }
        context.doc().addAll(Arrays.asList(this.fieldType().defaultPrefixTreeStrategy().createIndexableFields(shape)));
        context.addToFieldNames(this.fieldType().name());
    }

    protected String contentType() {
        return CONTENT_TYPE;
    }

    public FieldMapper.Builder getMergeBuilder() {
        return new Builder(this.leafName(), this.indexCreatedVersion, (Boolean)((Explicit)this.builder.ignoreMalformed.getDefaultValue()).value(), (Boolean)((Explicit)this.builder.coerce.getDefaultValue()).value()).init((FieldMapper)this);
    }

    protected void checkIncomingMergeType(FieldMapper mergeWith) {
        if (!(mergeWith instanceof LegacyGeoShapeFieldMapper) && CONTENT_TYPE.equals(mergeWith.typeName())) {
            throw new IllegalArgumentException("mapper [" + this.fullPath() + "] of type [geo_shape] cannot change strategy from [recursive] to [BKD]");
        }
        super.checkIncomingMergeType(mergeWith);
    }

    public static class Builder
    extends FieldMapper.Builder {
        FieldMapper.Parameter<Boolean> indexed = FieldMapper.Parameter.indexParam(m -> (Boolean)LegacyGeoShapeFieldMapper.builder((FieldMapper)m).indexed.get(), (boolean)true);
        final FieldMapper.Parameter<Explicit<Boolean>> ignoreMalformed;
        final FieldMapper.Parameter<Explicit<Boolean>> ignoreZValue = AbstractGeometryFieldMapper.ignoreZValueParam(m -> (Explicit)LegacyGeoShapeFieldMapper.builder((FieldMapper)m).ignoreZValue.get());
        final FieldMapper.Parameter<Explicit<Boolean>> coerce;
        FieldMapper.Parameter<Explicit<Orientation>> orientation = AbstractShapeGeometryFieldMapper.orientationParam(m -> (Explicit)LegacyGeoShapeFieldMapper.builder((FieldMapper)m).orientation.get());
        FieldMapper.Parameter<SpatialStrategy> strategy = new FieldMapper.Parameter("strategy", false, () -> SpatialStrategy.RECURSIVE, (n, c, o) -> SpatialStrategy.fromString((String)o.toString()), m -> (SpatialStrategy)LegacyGeoShapeFieldMapper.builder((FieldMapper)m).strategy.get(), (b, f, v) -> b.field(f, v.getStrategyName()), SpatialStrategy::getStrategyName).deprecated();
        FieldMapper.Parameter<String> tree = FieldMapper.Parameter.stringParam((String)"tree", (boolean)false, m -> (String)LegacyGeoShapeFieldMapper.builder((FieldMapper)m).tree.get(), (String)"quadtree").deprecated();
        FieldMapper.Parameter<Integer> treeLevels = new FieldMapper.Parameter("tree_levels", false, () -> null, (n, c, o) -> o == null ? null : Integer.valueOf(XContentMapValues.nodeIntegerValue((Object)o)), m -> (Integer)LegacyGeoShapeFieldMapper.builder((FieldMapper)m).treeLevels.get(), (b, f, v) -> {
            if (v != null && v != 0) {
                b.field(f, v);
            } else {
                b.field(f, Defaults.defaultTreeLevel((String)this.tree.get()));
            }
        }, Objects::toString).deprecated();
        FieldMapper.Parameter<DistanceUnit.Distance> precision = new FieldMapper.Parameter("precision", false, () -> null, (n, c, o) -> o == null ? null : DistanceUnit.Distance.parseDistance((String)o.toString()), m -> (DistanceUnit.Distance)LegacyGeoShapeFieldMapper.builder((FieldMapper)m).precision.get(), (b, f, v) -> {
            if (v == null) {
                b.field(f, "50.0m");
            } else {
                b.field(f, v.toString());
            }
        }, Objects::toString).deprecated();
        FieldMapper.Parameter<Double> distanceErrorPct = new FieldMapper.Parameter("distance_error_pct", true, () -> null, (n, c, o) -> o == null ? null : Double.valueOf(XContentMapValues.nodeDoubleValue((Object)o)), m -> (Double)LegacyGeoShapeFieldMapper.builder((FieldMapper)m).distanceErrorPct.get(), XContentBuilder::field, Objects::toString).deprecated().acceptsNull();
        FieldMapper.Parameter<Boolean> pointsOnly = new FieldMapper.Parameter("points_only", false, () -> null, (n, c, o) -> XContentMapValues.nodeBooleanValue((Object)o), m -> (Boolean)LegacyGeoShapeFieldMapper.builder((FieldMapper)m).pointsOnly.get(), (b, f, v) -> {
            if (v == null) {
                b.field(f, this.strategy.get() == SpatialStrategy.TERM);
            } else {
                b.field(f, v);
            }
        }, Objects::toString).deprecated().acceptsNull();
        FieldMapper.Parameter<Map<String, String>> meta = FieldMapper.Parameter.metaParam();
        private final IndexVersion indexCreatedVersion;

        public Builder(String name, IndexVersion version, boolean ignoreMalformedByDefault, boolean coerceByDefault) {
            super(name);
            if (!ShapesAvailability.JTS_AVAILABLE || !ShapesAvailability.SPATIAL4J_AVAILABLE) {
                throw new ElasticsearchParseException("Non-BKD field parameters are not supported for [{}] field type", new Object[]{LegacyGeoShapeFieldMapper.CONTENT_TYPE});
            }
            this.indexCreatedVersion = version;
            this.ignoreMalformed = AbstractGeometryFieldMapper.ignoreMalformedParam(m -> (Explicit)LegacyGeoShapeFieldMapper.builder((FieldMapper)m).ignoreMalformed.get(), (boolean)ignoreMalformedByDefault);
            this.coerce = AbstractShapeGeometryFieldMapper.coerceParam(m -> (Explicit)LegacyGeoShapeFieldMapper.builder((FieldMapper)m).coerce.get(), (boolean)coerceByDefault);
            this.pointsOnly.addValidator(v -> {
                if (v == null) {
                    return;
                }
                if (!v.booleanValue() && SpatialStrategy.TERM == this.strategy.get()) {
                    throw new IllegalArgumentException("points_only cannot be set to false for term strategy");
                }
            });
            if (version.onOrAfter((VersionId)IndexVersions.V_7_0_0)) {
                this.strategy.alwaysSerialize();
            }
            this.treeLevels.setSerializerCheck((id, ic, v) -> ic || id && this.precision.get() == null);
            this.precision.setSerializerCheck((id, ic, v) -> ic || id && this.treeLevels.get() == null);
        }

        protected FieldMapper.Parameter<?>[] getParameters() {
            return new FieldMapper.Parameter[]{this.indexed, this.ignoreMalformed, this.ignoreZValue, this.coerce, this.orientation, this.strategy, this.tree, this.treeLevels, this.precision, this.distanceErrorPct, this.pointsOnly, this.meta};
        }

        public Builder coerce(boolean coerce) {
            this.coerce.setValue((Object)Explicit.explicitBoolean((boolean)coerce));
            return this;
        }

        private void setupFieldTypeDeprecatedParameters(GeoShapeFieldType ft) {
            ft.setStrategy((SpatialStrategy)this.strategy.get());
            ft.setTree((String)this.tree.get());
            if (this.treeLevels.get() != null) {
                ft.setTreeLevels((Integer)this.treeLevels.get());
            }
            if (this.precision.get() != null) {
                ft.setPrecisionInMeters(((DistanceUnit.Distance)this.precision.get()).value);
            }
            if (this.pointsOnly.get() != null) {
                ft.setPointsOnly((Boolean)this.pointsOnly.get());
            }
            if (this.distanceErrorPct.get() != null) {
                ft.setDistanceErrorPct((Double)this.distanceErrorPct.get());
            }
            if (ft.treeLevels() == 0 && ft.precisionInMeters() < 0.0) {
                ft.setDefaultDistanceErrorPct(0.025);
            }
        }

        private static void setupPrefixTrees(GeoShapeFieldType ft) {
            GeohashPrefixTree prefixTree;
            if (ft.tree().equals("geohash")) {
                prefixTree = new GeohashPrefixTree((SpatialContext)ShapeBuilder.SPATIAL_CONTEXT, Builder.getLevels(ft.treeLevels(), ft.precisionInMeters(), Defaults.GEOHASH_TREE_LEVELS, true));
            } else if (ft.tree().equals("legacyquadtree")) {
                prefixTree = new QuadPrefixTree((SpatialContext)ShapeBuilder.SPATIAL_CONTEXT, Builder.getLevels(ft.treeLevels(), ft.precisionInMeters(), Defaults.QUADTREE_LEVELS, false));
            } else if (ft.tree().equals("quadtree")) {
                prefixTree = new PackedQuadPrefixTree((SpatialContext)ShapeBuilder.SPATIAL_CONTEXT, Builder.getLevels(ft.treeLevels(), ft.precisionInMeters(), Defaults.QUADTREE_LEVELS, false));
            } else {
                throw new IllegalArgumentException("Unknown prefix tree type [" + ft.tree() + "]");
            }
            RecursivePrefixTreeStrategy rpts = new RecursivePrefixTreeStrategy((SpatialPrefixTree)prefixTree, ft.name());
            rpts.setDistErrPct(ft.distanceErrorPct());
            rpts.setPruneLeafyBranches(false);
            ft.recursiveStrategy = rpts;
            TermQueryPrefixTreeStrategy termStrategy = new TermQueryPrefixTreeStrategy((SpatialPrefixTree)prefixTree, ft.name());
            termStrategy.setDistErrPct(ft.distanceErrorPct());
            ft.termStrategy = termStrategy;
            ft.defaultPrefixTreeStrategy = ft.resolvePrefixTreeStrategy(ft.strategy());
            ft.defaultPrefixTreeStrategy.setPointsOnly(ft.pointsOnly());
        }

        private GeoShapeFieldType buildFieldType(LegacyGeoShapeParser parser, MapperBuilderContext context) {
            GeoShapeFieldType ft = new GeoShapeFieldType(context.buildFullName(this.leafName()), (Boolean)this.indexed.get(), (Orientation)((Explicit)this.orientation.get()).value(), parser, (Map)this.meta.get());
            this.setupFieldTypeDeprecatedParameters(ft);
            Builder.setupPrefixTrees(ft);
            return ft;
        }

        private static int getLevels(int treeLevels, double precisionInMeters, int defaultLevels, boolean geoHash) {
            if (treeLevels > 0 || precisionInMeters >= 0.0) {
                return Math.max(treeLevels, precisionInMeters >= 0.0 ? (geoHash ? GeoUtils.geoHashLevelsForPrecision((double)precisionInMeters) : GeoUtils.quadTreeLevelsForPrecision((double)precisionInMeters)) : 0);
            }
            return defaultLevels;
        }

        public LegacyGeoShapeFieldMapper build(MapperBuilderContext context) {
            LegacyGeoShapeParser parser = new LegacyGeoShapeParser();
            GeoShapeFieldType ft = this.buildFieldType(parser, context);
            return new LegacyGeoShapeFieldMapper(this.leafName(), (MappedFieldType)ft, this.builderParams((Mapper.Builder)this, context), parser, this);
        }
    }

    public static final class GeoShapeFieldType
    extends AbstractShapeGeometryFieldMapper.AbstractShapeGeometryFieldType<ShapeBuilder<?, ?, ?>>
    implements GeoShapeQueryable {
        private String tree = "quadtree";
        private SpatialStrategy strategy = Defaults.STRATEGY;
        private boolean pointsOnly = false;
        private int treeLevels = 0;
        private double precisionInMeters = -1.0;
        private Double distanceErrorPct;
        private double defaultDistanceErrorPct = 0.0;
        private PrefixTreeStrategy defaultPrefixTreeStrategy;
        private RecursivePrefixTreeStrategy recursiveStrategy;
        private TermQueryPrefixTreeStrategy termStrategy;
        private final LegacyGeoShapeQueryProcessor queryProcessor = new LegacyGeoShapeQueryProcessor(this);

        private GeoShapeFieldType(String name, boolean indexed, Orientation orientation, LegacyGeoShapeParser parser, Map<String, String> meta) {
            super(name, IndexType.terms((boolean)indexed, (boolean)false), false, (AbstractGeometryFieldMapper.Parser)parser, orientation, meta);
        }

        public GeoShapeFieldType(String name) {
            this(name, true, Orientation.RIGHT, null, Collections.emptyMap());
        }

        public Query geoShapeQuery(SearchExecutionContext context, String fieldName, ShapeRelation relation, LatLonGeometry ... geometries) {
            throw new UnsupportedOperationException("process method should not be called for PrefixTree based geo_shapes");
        }

        public Query geoShapeQuery(SearchExecutionContext context, String fieldName, SpatialStrategy spatialStrategy, ShapeRelation relation, Geometry shape) {
            return this.queryProcessor.geoShapeQuery(shape, fieldName, spatialStrategy, relation, context);
        }

        public String typeName() {
            return LegacyGeoShapeFieldMapper.CONTENT_TYPE;
        }

        public String tree() {
            return this.tree;
        }

        public void setTree(String tree) {
            this.tree = tree;
        }

        public SpatialStrategy strategy() {
            return this.strategy;
        }

        public void setStrategy(SpatialStrategy strategy) {
            this.strategy = strategy;
            if (this.strategy.equals((Object)SpatialStrategy.TERM)) {
                this.pointsOnly = true;
            }
        }

        public boolean pointsOnly() {
            return this.pointsOnly;
        }

        public void setPointsOnly(boolean pointsOnly) {
            this.pointsOnly = pointsOnly;
        }

        public int treeLevels() {
            return this.treeLevels;
        }

        public void setTreeLevels(int treeLevels) {
            this.treeLevels = treeLevels;
        }

        public double precisionInMeters() {
            return this.precisionInMeters;
        }

        public void setPrecisionInMeters(double precisionInMeters) {
            this.precisionInMeters = precisionInMeters;
        }

        public double distanceErrorPct() {
            return this.distanceErrorPct == null ? this.defaultDistanceErrorPct : this.distanceErrorPct;
        }

        public void setDistanceErrorPct(double distanceErrorPct) {
            this.distanceErrorPct = distanceErrorPct;
        }

        public void setDefaultDistanceErrorPct(double defaultDistanceErrorPct) {
            this.defaultDistanceErrorPct = defaultDistanceErrorPct;
        }

        public PrefixTreeStrategy defaultPrefixTreeStrategy() {
            return this.defaultPrefixTreeStrategy;
        }

        public PrefixTreeStrategy resolvePrefixTreeStrategy(SpatialStrategy spatialStrategy) {
            return this.resolvePrefixTreeStrategy(spatialStrategy.getStrategyName());
        }

        public PrefixTreeStrategy resolvePrefixTreeStrategy(String strategyName) {
            if (SpatialStrategy.RECURSIVE.getStrategyName().equals(strategyName)) {
                return this.recursiveStrategy;
            }
            if (SpatialStrategy.TERM.getStrategyName().equals(strategyName)) {
                return this.termStrategy;
            }
            throw new IllegalArgumentException("Unknown prefix tree strategy [" + strategyName + "]");
        }

        protected Function<List<ShapeBuilder<?, ?, ?>>, List<Object>> getFormatter(String format) {
            return GeometryFormatterFactory.getFormatter((String)format, ShapeBuilder::buildGeometry);
        }

        public BlockLoader blockLoader(MappedFieldType.BlockLoaderContext blContext) {
            return this.blockLoaderFromSource(blContext);
        }
    }

    private static class LegacyGeoShapeParser
    extends AbstractGeometryFieldMapper.Parser<ShapeBuilder<?, ?, ?>> {
        private LegacyGeoShapeParser() {
        }

        public void parse(XContentParser parser, CheckedConsumer<ShapeBuilder<?, ?, ?>, IOException> consumer, AbstractGeometryFieldMapper.MalformedValueHandler malformedHandler) throws IOException {
            try {
                if (parser.currentToken() == XContentParser.Token.START_ARRAY) {
                    while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                        this.parse(parser, consumer, malformedHandler);
                    }
                } else {
                    consumer.accept(ShapeParser.parse(parser));
                }
            }
            catch (ElasticsearchParseException e) {
                malformedHandler.notify((Exception)((Object)e));
            }
        }

        public ShapeBuilder<?, ?, ?> normalizeFromSource(ShapeBuilder<?, ?, ?> geometry) {
            return geometry;
        }
    }

    public static class PrefixTrees {
        public static final String LEGACY_QUADTREE = "legacyquadtree";
        public static final String QUADTREE = "quadtree";
        public static final String GEOHASH = "geohash";
    }

    public static class Defaults {
        public static final SpatialStrategy STRATEGY = SpatialStrategy.RECURSIVE;
        public static final String TREE = "quadtree";
        public static final String PRECISION = "50m";
        public static final int QUADTREE_LEVELS = GeoUtils.quadTreeLevelsForPrecision((String)"50m");
        public static final int GEOHASH_TREE_LEVELS = GeoUtils.geoHashLevelsForPrecision((String)"50m");
        public static final boolean POINTS_ONLY = false;
        public static final double DISTANCE_ERROR_PCT = 0.025;

        public static int defaultTreeLevel(String tree) {
            return switch (tree) {
                case "geohash" -> GEOHASH_TREE_LEVELS;
                case "legacyquadtree", TREE -> QUADTREE_LEVELS;
                default -> throw new IllegalArgumentException("Unknown prefix type [" + tree + "]");
            };
        }
    }
}

