/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.gpu.codec;

import com.nvidia.cuvs.CuVSResources;
import org.elasticsearch.xpack.gpu.codec.GPUMemoryService;

class TrackingGPUMemoryService
implements GPUMemoryService {
    private final long totalMemoryInBytes;
    private long availableMemoryInBytes;

    TrackingGPUMemoryService(long totalMemoryInBytes) {
        this.totalMemoryInBytes = totalMemoryInBytes;
        this.availableMemoryInBytes = totalMemoryInBytes;
    }

    @Override
    public long totalMemoryInBytes(CuVSResources res) {
        return this.totalMemoryInBytes;
    }

    @Override
    public long availableMemoryInBytes(CuVSResources res) {
        return this.availableMemoryInBytes;
    }

    @Override
    public void reserveMemory(long memoryInBytes) {
        this.availableMemoryInBytes -= memoryInBytes;
    }

    @Override
    public void releaseMemory(long memoryInBytes) {
        this.availableMemoryInBytes += memoryInBytes;
    }
}

