/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.action.role;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.support.TransportAction;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class BulkRolesResponse
extends ActionResponse
implements ToXContentObject {
    private final List<Item> items;

    public BulkRolesResponse(List<Item> items) {
        this.items = items;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        Map<String, List<Item>> itemsByType = this.items.stream().collect(Collectors.groupingBy(Item::getResultType));
        for (Map.Entry<String, List<Item>> resultEntry : itemsByType.entrySet()) {
            if (!resultEntry.getKey().equals("errors")) {
                builder.startArray(resultEntry.getKey());
                for (Item item : resultEntry.getValue()) {
                    item.toXContent(builder, params);
                }
                builder.endArray();
                continue;
            }
            builder.startObject("errors");
            builder.field("count", resultEntry.getValue().size());
            builder.startObject("details");
            for (Item item : resultEntry.getValue()) {
                builder.startObject(item.roleName);
                item.toXContent(builder, params);
                builder.endObject();
            }
            builder.endObject();
            builder.endObject();
        }
        builder.endObject();
        return builder;
    }

    public void writeTo(StreamOutput out) throws IOException {
        TransportAction.localOnly();
    }

    public List<Item> getItems() {
        return this.items;
    }

    public static class Item
    implements ToXContentObject {
        private final Exception cause;
        private final String roleName;
        private final DocWriteResponse.Result resultType;

        private Item(String roleName, DocWriteResponse.Result resultType, Exception cause) {
            this.roleName = roleName;
            this.resultType = resultType;
            this.cause = cause;
        }

        Item(StreamInput in) throws IOException {
            this.roleName = in.readString();
            this.resultType = DocWriteResponse.Result.readFrom((StreamInput)in);
            this.cause = in.readException();
        }

        public Exception getCause() {
            return this.cause;
        }

        public String getResultType() {
            return this.resultType == null ? "errors" : this.resultType.getLowercase();
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            if (this.resultType == null) {
                ElasticsearchException.generateThrowableXContent((XContentBuilder)builder, (ToXContent.Params)params, (Throwable)this.cause);
            } else {
                builder.value(this.roleName);
            }
            return builder;
        }

        public static Item success(String roleName, DocWriteResponse.Result result) {
            return new Item(roleName, result, null);
        }

        public static Item failure(String roleName, Exception cause) {
            return new Item(roleName, null, cause);
        }

        public String getRoleName() {
            return this.roleName;
        }

        public boolean isFailed() {
            return this.cause != null;
        }

        public String getFailureMessage() {
            if (this.cause != null) {
                return this.cause.getMessage();
            }
            return null;
        }
    }

    public static class Builder {
        private final List<Item> items = new LinkedList<Item>();

        public Builder addItem(Item item) {
            this.items.add(item);
            return this;
        }

        public BulkRolesResponse build() {
            return new BulkRolesResponse(this.items);
        }
    }
}

