/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.inference.assignment;

import java.io.IOException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.elasticsearch.ResourceAlreadyExistsException;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.Diff;
import org.elasticsearch.cluster.DiffableUtils;
import org.elasticsearch.cluster.NamedDiff;
import org.elasticsearch.cluster.SimpleDiffable;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.ProjectMetadata;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ChunkedToXContent;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.inference.assignment.TrainedModelAssignment;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public class TrainedModelAssignmentMetadata
implements Metadata.ProjectCustom {
    private static final TrainedModelAssignmentMetadata EMPTY = new TrainedModelAssignmentMetadata(Collections.emptyMap());
    public static final String DEPRECATED_NAME = "trained_model_allocation";
    public static final String NAME = "trained_model_assignment";
    private final Map<String, TrainedModelAssignment> deploymentRoutingEntries;
    private final String writeableName;

    public static TrainedModelAssignmentMetadata fromXContent(XContentParser parser) throws IOException {
        return new TrainedModelAssignmentMetadata(parser.map(LinkedHashMap::new, TrainedModelAssignment::fromXContent));
    }

    public static TrainedModelAssignmentMetadata fromStream(StreamInput input) throws IOException {
        return new TrainedModelAssignmentMetadata(input, NAME);
    }

    public static TrainedModelAssignmentMetadata fromStreamOld(StreamInput input) throws IOException {
        return new TrainedModelAssignmentMetadata(input, DEPRECATED_NAME);
    }

    public static NamedDiff<Metadata.ProjectCustom> readDiffFrom(StreamInput in) throws IOException {
        return new TrainedModeAssignmentDiff(in);
    }

    public static NamedDiff<Metadata.ProjectCustom> readDiffFromOld(StreamInput in) throws IOException {
        return new TrainedModeAssignmentDiff(in, DEPRECATED_NAME);
    }

    public static Builder builder(ClusterState clusterState) {
        return Builder.fromMetadata(TrainedModelAssignmentMetadata.fromState(clusterState));
    }

    @Deprecated(forRemoval=true)
    public static TrainedModelAssignmentMetadata fromState(ClusterState clusterState) {
        TrainedModelAssignmentMetadata trainedModelAssignmentMetadata = (TrainedModelAssignmentMetadata)clusterState.metadata().getSingleProjectCustom(NAME);
        if (trainedModelAssignmentMetadata == null) {
            trainedModelAssignmentMetadata = (TrainedModelAssignmentMetadata)clusterState.metadata().getSingleProjectCustom(DEPRECATED_NAME);
        }
        return trainedModelAssignmentMetadata == null ? EMPTY : trainedModelAssignmentMetadata;
    }

    public static TrainedModelAssignmentMetadata fromMetadata(ProjectMetadata projectMetadata) {
        TrainedModelAssignmentMetadata trainedModelAssignmentMetadata = (TrainedModelAssignmentMetadata)projectMetadata.custom(NAME);
        if (trainedModelAssignmentMetadata == null) {
            trainedModelAssignmentMetadata = (TrainedModelAssignmentMetadata)projectMetadata.custom(DEPRECATED_NAME);
        }
        return trainedModelAssignmentMetadata == null ? EMPTY : trainedModelAssignmentMetadata;
    }

    public static List<TrainedModelAssignment> assignmentsForModelId(ClusterState clusterState, String modelId) {
        return TrainedModelAssignmentMetadata.fromState(clusterState).allAssignments().values().stream().filter(assignment -> modelId.equals(assignment.getModelId())).collect(Collectors.toList());
    }

    public static Optional<TrainedModelAssignment> assignmentForDeploymentId(ClusterState clusterState, String deploymentId) {
        return Optional.ofNullable(TrainedModelAssignmentMetadata.fromState(clusterState)).map(metadata -> metadata.getDeploymentAssignment(deploymentId));
    }

    public TrainedModelAssignmentMetadata(Map<String, TrainedModelAssignment> modelRoutingEntries) {
        this(modelRoutingEntries, NAME);
    }

    private TrainedModelAssignmentMetadata(Map<String, TrainedModelAssignment> modelRoutingEntries, String writeableName) {
        this.deploymentRoutingEntries = ExceptionsHelper.requireNonNull(modelRoutingEntries, NAME);
        this.writeableName = writeableName;
    }

    private TrainedModelAssignmentMetadata(StreamInput in, String writeableName) throws IOException {
        this.deploymentRoutingEntries = in.readOrderedMap(StreamInput::readString, TrainedModelAssignment::new);
        this.writeableName = writeableName;
    }

    public TrainedModelAssignment getDeploymentAssignment(String deploymentId) {
        return this.deploymentRoutingEntries.get(deploymentId);
    }

    public boolean isAssigned(String deploymentId) {
        return this.deploymentRoutingEntries.containsKey(deploymentId);
    }

    public boolean modelIsDeployed(String modelId) {
        return this.deploymentRoutingEntries.values().stream().anyMatch(assignment -> modelId.equals(assignment.getModelId()));
    }

    public List<TrainedModelAssignment> getDeploymentsUsingModel(String modelId) {
        return this.deploymentRoutingEntries.values().stream().filter(assignment -> modelId.equals(assignment.getModelId())).collect(Collectors.toList());
    }

    public Map<String, TrainedModelAssignment> allAssignments() {
        return Collections.unmodifiableMap(this.deploymentRoutingEntries);
    }

    public Iterator<? extends ToXContent> toXContentChunked(ToXContent.Params ignored) {
        return Iterators.map(this.deploymentRoutingEntries.entrySet().iterator(), entry -> (builder, params) -> ((TrainedModelAssignment)entry.getValue()).toXContent(builder.field((String)entry.getKey()), params));
    }

    public Diff<Metadata.ProjectCustom> diff(Metadata.ProjectCustom previousState) {
        return new TrainedModeAssignmentDiff((TrainedModelAssignmentMetadata)previousState, this);
    }

    public EnumSet<Metadata.XContentContext> context() {
        return Metadata.ALL_CONTEXTS;
    }

    public String getWriteableName() {
        return this.writeableName;
    }

    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersion.minimumCompatible();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeMap(this.deploymentRoutingEntries, StreamOutput::writeWriteable);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TrainedModelAssignmentMetadata that = (TrainedModelAssignmentMetadata)o;
        return Objects.equals(this.deploymentRoutingEntries, that.deploymentRoutingEntries);
    }

    public int hashCode() {
        return Objects.hash(this.deploymentRoutingEntries);
    }

    public String toString() {
        return Strings.toString((ChunkedToXContent)this);
    }

    public boolean hasOutdatedAssignments() {
        return this.deploymentRoutingEntries.values().stream().anyMatch(TrainedModelAssignment::hasOutdatedRoutingEntries);
    }

    public boolean hasDeployment(String deploymentId) {
        return this.deploymentRoutingEntries.containsKey(deploymentId);
    }

    public static class TrainedModeAssignmentDiff
    implements NamedDiff<Metadata.ProjectCustom> {
        private final Diff<Map<String, TrainedModelAssignment>> modelRoutingEntries;
        private final String writeableName;

        static Diff<TrainedModelAssignment> readFrom(StreamInput in) throws IOException {
            return SimpleDiffable.readDiffFrom(TrainedModelAssignment::new, (StreamInput)in);
        }

        public TrainedModeAssignmentDiff(TrainedModelAssignmentMetadata before, TrainedModelAssignmentMetadata after) {
            this.modelRoutingEntries = DiffableUtils.diff(before.deploymentRoutingEntries, after.deploymentRoutingEntries, (DiffableUtils.KeySerializer)DiffableUtils.getStringKeySerializer());
            this.writeableName = TrainedModelAssignmentMetadata.NAME;
        }

        private TrainedModeAssignmentDiff(StreamInput in) throws IOException {
            this.modelRoutingEntries = DiffableUtils.readJdkMapDiff((StreamInput)in, (DiffableUtils.KeySerializer)DiffableUtils.getStringKeySerializer(), TrainedModelAssignment::new, TrainedModeAssignmentDiff::readFrom);
            this.writeableName = TrainedModelAssignmentMetadata.NAME;
        }

        private TrainedModeAssignmentDiff(StreamInput in, String writeableName) throws IOException {
            this.modelRoutingEntries = DiffableUtils.readJdkMapDiff((StreamInput)in, (DiffableUtils.KeySerializer)DiffableUtils.getStringKeySerializer(), TrainedModelAssignment::new, TrainedModeAssignmentDiff::readFrom);
            this.writeableName = writeableName;
        }

        public Metadata.ProjectCustom apply(Metadata.ProjectCustom part) {
            return new TrainedModelAssignmentMetadata(new TreeMap<String, TrainedModelAssignment>((Map)this.modelRoutingEntries.apply(((TrainedModelAssignmentMetadata)part).deploymentRoutingEntries)), this.writeableName);
        }

        public String getWriteableName() {
            return this.writeableName;
        }

        public TransportVersion getMinimalSupportedVersion() {
            return TransportVersion.minimumCompatible();
        }

        public void writeTo(StreamOutput out) throws IOException {
            this.modelRoutingEntries.writeTo(out);
        }
    }

    public static class Builder {
        private final Map<String, TrainedModelAssignment.Builder> deploymentRoutingEntries = new LinkedHashMap<String, TrainedModelAssignment.Builder>();

        public static Builder empty() {
            return new Builder();
        }

        public static Builder fromMetadata(TrainedModelAssignmentMetadata modelAssignmentMetadata) {
            return new Builder(modelAssignmentMetadata);
        }

        private Builder() {
        }

        private Builder(TrainedModelAssignmentMetadata modelAssignmentMetadata) {
            modelAssignmentMetadata.deploymentRoutingEntries.forEach((deploymentId, assignment) -> this.deploymentRoutingEntries.put((String)deploymentId, TrainedModelAssignment.Builder.fromAssignment(assignment)));
        }

        public boolean hasModelDeployment(String deploymentId) {
            return this.deploymentRoutingEntries.containsKey(deploymentId);
        }

        public Builder addNewAssignment(String deploymentId, TrainedModelAssignment.Builder assignment) {
            if (this.deploymentRoutingEntries.containsKey(deploymentId)) {
                throw new ResourceAlreadyExistsException("[{}] assignment already exists", new Object[]{deploymentId});
            }
            this.deploymentRoutingEntries.put(deploymentId, assignment);
            return this;
        }

        public Builder updateAssignment(String deploymentId, TrainedModelAssignment.Builder assignment) {
            if (!this.deploymentRoutingEntries.containsKey(deploymentId)) {
                throw new ResourceNotFoundException("[{}] assignment does not exist", new Object[]{deploymentId});
            }
            this.deploymentRoutingEntries.put(deploymentId, assignment);
            return this;
        }

        public Builder addOrOverwriteAssignment(String deploymentId, TrainedModelAssignment.Builder assignment) {
            this.deploymentRoutingEntries.put(deploymentId, assignment);
            return this;
        }

        public TrainedModelAssignment.Builder getAssignment(String deploymentId) {
            return this.deploymentRoutingEntries.get(deploymentId);
        }

        public Builder removeAssignment(String deploymentId) {
            this.deploymentRoutingEntries.remove(deploymentId);
            return this;
        }

        public TrainedModelAssignmentMetadata build() {
            return this.build(TrainedModelAssignmentMetadata.NAME);
        }

        public TrainedModelAssignmentMetadata buildOld() {
            return this.build(TrainedModelAssignmentMetadata.DEPRECATED_NAME);
        }

        private TrainedModelAssignmentMetadata build(String writeableName) {
            LinkedHashMap<String, TrainedModelAssignment> assignments = new LinkedHashMap<String, TrainedModelAssignment>();
            this.deploymentRoutingEntries.forEach((deploymentId, assignment) -> assignments.put((String)deploymentId, assignment.build()));
            return new TrainedModelAssignmentMetadata(assignments, writeableName);
        }
    }
}

