/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.action;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ChunkedToXContent;
import org.elasticsearch.core.Strings;
import org.elasticsearch.ingest.IngestStats;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.action.AbstractGetResourcesRequest;
import org.elasticsearch.xpack.core.action.AbstractGetResourcesResponse;
import org.elasticsearch.xpack.core.action.util.QueryPage;
import org.elasticsearch.xpack.core.ml.inference.TrainedModelConfig;
import org.elasticsearch.xpack.core.ml.inference.assignment.AssignmentStats;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.InferenceStats;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.TrainedModelSizeStats;

public class GetTrainedModelsStatsAction
extends ActionType<Response> {
    public static final GetTrainedModelsStatsAction INSTANCE = new GetTrainedModelsStatsAction();
    public static final String NAME = "cluster:monitor/xpack/ml/inference/stats/get";
    public static final ParseField MODEL_ID = new ParseField("model_id", new String[0]);
    public static final ParseField MODEL_SIZE_STATS = new ParseField("model_size_stats", new String[0]);
    public static final ParseField PIPELINE_COUNT = new ParseField("pipeline_count", new String[0]);
    public static final ParseField INFERENCE_STATS = new ParseField("inference_stats", new String[0]);
    public static final ParseField DEPLOYMENT_STATS = new ParseField("deployment_stats", new String[0]);

    private GetTrainedModelsStatsAction() {
        super(NAME);
    }

    public static class Response
    extends AbstractGetResourcesResponse<TrainedModelStats> {
        public static final ParseField RESULTS_FIELD = new ParseField("trained_model_stats", new String[0]);

        public Response(StreamInput in) throws IOException {
            super(in);
        }

        public Response(QueryPage<TrainedModelStats> trainedModels) {
            super(trainedModels);
        }

        @Override
        protected Writeable.Reader<TrainedModelStats> getReader() {
            return TrainedModelStats::new;
        }

        public static class Builder {
            private long totalModelCount;
            private Map<String, Set<String>> expandedModelIdsWithAliases;
            private Map<String, TrainedModelSizeStats> modelSizeStatsMap;
            private Map<String, IngestStats> ingestStatsMap;
            private Map<String, InferenceStats> inferenceStatsMap;
            private Map<String, AssignmentStats> assignmentStatsMap;

            public Builder setTotalModelCount(long totalModelCount) {
                this.totalModelCount = totalModelCount;
                return this;
            }

            public Builder setExpandedModelIdsWithAliases(Map<String, Set<String>> expandedIdsWithAliases) {
                this.expandedModelIdsWithAliases = expandedIdsWithAliases;
                return this;
            }

            public Map<String, Set<String>> getExpandedModelIdsWithAliases() {
                return this.expandedModelIdsWithAliases;
            }

            public Builder setModelSizeStatsByModelId(Map<String, TrainedModelSizeStats> modelSizeStatsByModelId) {
                this.modelSizeStatsMap = modelSizeStatsByModelId;
                return this;
            }

            public Builder setIngestStatsByModelId(Map<String, IngestStats> ingestStatsByModelId) {
                this.ingestStatsMap = ingestStatsByModelId;
                return this;
            }

            public Builder setInferenceStatsByModelId(Map<String, InferenceStats> inferenceStatsByModelId) {
                this.inferenceStatsMap = inferenceStatsByModelId;
                return this;
            }

            public Builder setDeploymentStatsByDeploymentId(Map<String, AssignmentStats> assignmentStatsMap) {
                this.assignmentStatsMap = assignmentStatsMap;
                return this;
            }

            public Response build(Map<String, Set<String>> modelToDeploymentIds) {
                int numResponses = this.expandedModelIdsWithAliases.size();
                for (Map.Entry<String, Set<String>> entry : modelToDeploymentIds.entrySet()) {
                    assert (this.expandedModelIdsWithAliases.containsKey(entry.getKey()));
                    assert (entry.getValue().size() > 0);
                    numResponses += entry.getValue().size() - 1;
                }
                if (this.inferenceStatsMap == null) {
                    this.inferenceStatsMap = Collections.emptyMap();
                }
                ArrayList trainedModelStats = new ArrayList(numResponses);
                this.expandedModelIdsWithAliases.keySet().forEach(modelId -> {
                    if (!modelToDeploymentIds.containsKey(modelId)) {
                        TrainedModelSizeStats modelSizeStats = this.modelSizeStatsMap.get(modelId);
                        IngestStats ingestStats = this.ingestStatsMap.get(modelId);
                        InferenceStats inferenceStats = this.inferenceStatsMap.get(modelId);
                        trainedModelStats.add(new TrainedModelStats((String)modelId, modelSizeStats, ingestStats, ingestStats == null ? 0 : ingestStats.pipelineStats().size(), inferenceStats, null));
                    } else {
                        for (String deploymentId : (Set)modelToDeploymentIds.get(modelId)) {
                            AssignmentStats assignmentStats = this.assignmentStatsMap.get(deploymentId);
                            if (assignmentStats == null) continue;
                            InferenceStats inferenceStats = assignmentStats.getOverallInferenceStats();
                            IngestStats ingestStats = this.ingestStatsMap.get(deploymentId);
                            if (ingestStats == null) {
                                ingestStats = this.ingestStatsMap.get(modelId);
                            }
                            TrainedModelSizeStats modelSizeStats = this.modelSizeStatsMap.get(modelId);
                            trainedModelStats.add(new TrainedModelStats((String)modelId, modelSizeStats, ingestStats, ingestStats == null ? 0 : ingestStats.pipelineStats().size(), inferenceStats, assignmentStats));
                        }
                    }
                });
                trainedModelStats.sort((modelStats1, modelStats2) -> {
                    int comparison = modelStats1.getModelId().compareTo(modelStats2.getModelId());
                    if (comparison == 0) {
                        String deploymentId2;
                        String deploymentId1 = modelStats1.getDeploymentStats() == null ? null : modelStats1.getDeploymentStats().getDeploymentId();
                        String string = deploymentId2 = modelStats2.getDeploymentStats() == null ? null : modelStats1.getDeploymentStats().getDeploymentId();
                        assert (deploymentId1 != null && deploymentId2 != null) : "2 results for model " + modelStats1.getModelId() + " both should have deployment stats";
                        comparison = deploymentId1.compareTo(deploymentId2);
                    }
                    return comparison;
                });
                return new Response(new QueryPage<TrainedModelStats>(trainedModelStats, this.totalModelCount, RESULTS_FIELD));
            }
        }

        public static class TrainedModelStats
        implements ToXContentObject,
        Writeable {
            private final String modelId;
            private final TrainedModelSizeStats modelSizeStats;
            private final IngestStats ingestStats;
            private final InferenceStats inferenceStats;
            private final AssignmentStats deploymentStats;
            private final int pipelineCount;

            public TrainedModelStats(String modelId, TrainedModelSizeStats modelSizeStats, IngestStats ingestStats, int pipelineCount, InferenceStats inferenceStats, AssignmentStats deploymentStats) {
                this.modelId = Objects.requireNonNull(modelId);
                this.modelSizeStats = modelSizeStats;
                IngestStats ingestStats2 = this.ingestStats = ingestStats == null ? IngestStats.IDENTITY : ingestStats;
                if (pipelineCount < 0) {
                    throw new ElasticsearchException("[{}] must be a greater than or equal to 0", new Object[]{PIPELINE_COUNT.getPreferredName()});
                }
                this.pipelineCount = pipelineCount;
                this.inferenceStats = inferenceStats;
                this.deploymentStats = deploymentStats;
            }

            public TrainedModelStats(StreamInput in) throws IOException {
                this.modelId = in.readString();
                this.modelSizeStats = (TrainedModelSizeStats)in.readOptionalWriteable(TrainedModelSizeStats::new);
                this.ingestStats = IngestStats.read((StreamInput)in);
                this.pipelineCount = in.readVInt();
                this.inferenceStats = (InferenceStats)in.readOptionalWriteable(InferenceStats::new);
                this.deploymentStats = (AssignmentStats)in.readOptionalWriteable(AssignmentStats::new);
            }

            public String getModelId() {
                return this.modelId;
            }

            public TrainedModelSizeStats getModelSizeStats() {
                return this.modelSizeStats;
            }

            public IngestStats getIngestStats() {
                return this.ingestStats;
            }

            public int getPipelineCount() {
                return this.pipelineCount;
            }

            public InferenceStats getInferenceStats() {
                return this.inferenceStats;
            }

            public AssignmentStats getDeploymentStats() {
                return this.deploymentStats;
            }

            public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
                builder.startObject();
                builder.field(MODEL_ID.getPreferredName(), this.modelId);
                if (this.modelSizeStats != null) {
                    builder.field(MODEL_SIZE_STATS.getPreferredName(), (ToXContent)this.modelSizeStats);
                }
                builder.field(PIPELINE_COUNT.getPreferredName(), this.pipelineCount);
                if (this.pipelineCount > 0) {
                    ChunkedToXContent.wrapAsToXContent((ChunkedToXContent)this.ingestStats).toXContent(builder, params);
                }
                if (this.inferenceStats != null) {
                    builder.field(INFERENCE_STATS.getPreferredName(), (ToXContent)this.inferenceStats);
                }
                if (this.deploymentStats != null) {
                    builder.field(DEPLOYMENT_STATS.getPreferredName(), (ToXContent)this.deploymentStats);
                }
                builder.endObject();
                return builder;
            }

            public void writeTo(StreamOutput out) throws IOException {
                out.writeString(this.modelId);
                out.writeOptionalWriteable((Writeable)this.modelSizeStats);
                this.ingestStats.writeTo(out);
                out.writeVInt(this.pipelineCount);
                out.writeOptionalWriteable((Writeable)this.inferenceStats);
                out.writeOptionalWriteable((Writeable)this.deploymentStats);
            }

            public int hashCode() {
                return Objects.hash(this.modelId, this.modelSizeStats, this.ingestStats, this.pipelineCount, this.inferenceStats, this.deploymentStats);
            }

            public boolean equals(Object obj) {
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                TrainedModelStats other = (TrainedModelStats)obj;
                return Objects.equals(this.modelId, other.modelId) && Objects.equals(this.modelSizeStats, other.modelSizeStats) && Objects.equals(this.ingestStats, other.ingestStats) && Objects.equals(this.pipelineCount, other.pipelineCount) && Objects.equals(this.deploymentStats, other.deploymentStats) && Objects.equals(this.inferenceStats, other.inferenceStats);
            }
        }
    }

    public static final class Request
    extends AbstractGetResourcesRequest {
        public static final ParseField ALLOW_NO_MATCH = new ParseField("allow_no_match", new String[0]);

        public Request() {
            this.setAllowNoResources(true);
        }

        public Request(String id) {
            this.setResourceId(id);
            this.setAllowNoResources(true);
        }

        public Request(StreamInput in) throws IOException {
            super(in);
        }

        @Override
        public String getCancelableTaskDescription() {
            return Strings.format((String)"get_trained_model_stats[%s]", (Object[])new Object[]{this.getResourceId()});
        }

        @Override
        public String getResourceIdField() {
            return TrainedModelConfig.MODEL_ID.getPreferredName();
        }
    }
}

