/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.inference.results;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.rest.RestStatus;

public record ModelStoreResponse(String inferenceId, RestStatus status, @Nullable Exception failureCause) implements Writeable
{
    public ModelStoreResponse(StreamInput in) throws IOException {
        this(in.readString(), RestStatus.readFrom((StreamInput)in), in.readException());
    }

    public boolean failed() {
        return this.failureCause != null;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.inferenceId);
        RestStatus.writeTo((StreamOutput)out, (RestStatus)this.status);
        out.writeException((Throwable)this.failureCause);
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ModelStoreResponse that = (ModelStoreResponse)o;
        return this.status == that.status && Objects.equals(this.inferenceId, that.inferenceId) && Objects.equals(this.failureCause == null ? null : this.failureCause.getMessage(), that.failureCause == null ? null : that.failureCause.getMessage()) && Objects.equals(this.failureCause == null ? null : this.failureCause.getClass(), that.failureCause == null ? null : that.failureCause.getClass());
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.inferenceId, this.status, this.failureCause == null ? null : this.failureCause.getMessage(), this.failureCause == null ? null : this.failureCause.getClass());
    }
}

