/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.datastreams;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.XPackFeatureUsage;
import org.elasticsearch.xpack.core.ilm.DownsampleAction;

public class TimeSeriesFeatureSetUsage
extends XPackFeatureUsage {
    private static final TransportVersion TIME_SERIES_TELEMETRY = TransportVersion.fromName((String)"time_series_telemetry");
    private final long timeSeriesDataStreamCount;
    private final long timeSeriesIndexCount;
    private final DownsamplingUsage downsamplingUsage;

    public TimeSeriesFeatureSetUsage(StreamInput input) throws IOException {
        super(input);
        this.timeSeriesDataStreamCount = input.readVLong();
        if (this.timeSeriesDataStreamCount == 0L) {
            this.timeSeriesIndexCount = 0L;
            this.downsamplingUsage = null;
        } else {
            this.timeSeriesIndexCount = input.readVLong();
            this.downsamplingUsage = (DownsamplingUsage)input.readOptionalWriteable(DownsamplingUsage::read);
        }
    }

    public TimeSeriesFeatureSetUsage(long timeSeriesDataStreamCount, long timeSeriesIndexCount, DownsamplingFeatureStats dlmDownsamplingStats, Map<String, Long> indexCountPerInterval) {
        this(timeSeriesDataStreamCount, timeSeriesIndexCount, null, null, dlmDownsamplingStats, indexCountPerInterval);
    }

    public TimeSeriesFeatureSetUsage(long timeSeriesDataStreamCount, long timeSeriesIndexCount, DownsamplingFeatureStats ilmDownsamplingStats, IlmPolicyStats ilmPolicyStats, DownsamplingFeatureStats dlmDownsamplingStats, Map<String, Long> indexCountPerInterval) {
        super("time_series", true, true);
        this.timeSeriesDataStreamCount = timeSeriesDataStreamCount;
        if (timeSeriesDataStreamCount == 0L) {
            this.timeSeriesIndexCount = 0L;
            this.downsamplingUsage = null;
        } else {
            this.timeSeriesIndexCount = timeSeriesIndexCount;
            this.downsamplingUsage = new DownsamplingUsage(ilmDownsamplingStats, ilmPolicyStats, dlmDownsamplingStats, indexCountPerInterval);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVLong(this.timeSeriesDataStreamCount);
        if (this.timeSeriesDataStreamCount > 0L) {
            out.writeVLong(this.timeSeriesIndexCount);
            out.writeOptionalWriteable((Writeable)this.downsamplingUsage);
        }
    }

    public TransportVersion getMinimalSupportedVersion() {
        return TIME_SERIES_TELEMETRY;
    }

    public long getTimeSeriesDataStreamCount() {
        return this.timeSeriesDataStreamCount;
    }

    public long getTimeSeriesIndexCount() {
        return this.timeSeriesIndexCount;
    }

    public DownsamplingUsage getDownsamplingUsage() {
        return this.downsamplingUsage;
    }

    @Override
    protected void innerXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        super.innerXContent(builder, params);
        builder.field("data_stream_count", this.timeSeriesDataStreamCount);
        if (this.timeSeriesDataStreamCount > 0L) {
            builder.field("index_count", this.timeSeriesIndexCount);
        }
        if (this.downsamplingUsage != null) {
            builder.field("downsampling", (ToXContent)this.downsamplingUsage);
        }
    }

    public String toString() {
        return Strings.toString((ToXContent)this);
    }

    public int hashCode() {
        return Objects.hash(this.timeSeriesDataStreamCount, this.timeSeriesIndexCount, this.downsamplingUsage);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        TimeSeriesFeatureSetUsage other = (TimeSeriesFeatureSetUsage)obj;
        return this.timeSeriesDataStreamCount == other.timeSeriesDataStreamCount && this.timeSeriesIndexCount == other.timeSeriesIndexCount && Objects.equals(this.downsamplingUsage, other.downsamplingUsage);
    }

    public record DownsamplingUsage(DownsamplingFeatureStats ilmDownsamplingStats, IlmPolicyStats ilmPolicyStats, DownsamplingFeatureStats dlmDownsamplingStats, Map<String, Long> indexCountPerInterval) implements Writeable,
    ToXContentObject
    {
        public static DownsamplingUsage read(StreamInput in) throws IOException {
            DownsamplingFeatureStats ilmDownsamplingStats = (DownsamplingFeatureStats)in.readOptionalWriteable(DownsamplingFeatureStats::read);
            IlmPolicyStats ilmPolicyStats = ilmDownsamplingStats != null ? IlmPolicyStats.read(in) : null;
            DownsamplingFeatureStats dlmDownsamplingStats = DownsamplingFeatureStats.read(in);
            Map indexCountPerInterval = in.readImmutableMap(StreamInput::readString, StreamInput::readVLong);
            return new DownsamplingUsage(ilmDownsamplingStats, ilmPolicyStats, dlmDownsamplingStats, indexCountPerInterval);
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeOptionalWriteable((Writeable)this.ilmDownsamplingStats);
            if (this.ilmDownsamplingStats != null) {
                this.ilmPolicyStats.writeTo(out);
            }
            this.dlmDownsamplingStats.writeTo(out);
            out.writeMap(this.indexCountPerInterval, StreamOutput::writeString, StreamOutput::writeVLong);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            if (this.indexCountPerInterval != null && !this.indexCountPerInterval.isEmpty()) {
                builder.startObject("index_count_per_interval");
                for (Map.Entry<String, Long> entry : this.indexCountPerInterval.entrySet()) {
                    builder.field(entry.getKey(), entry.getValue());
                }
                builder.endObject();
            }
            if (this.ilmDownsamplingStats != null) {
                builder.startObject("ilm");
                this.ilmDownsamplingStats.toXContent(builder, params);
                this.ilmPolicyStats.toXContent(builder, params);
                builder.endObject();
            }
            if (this.dlmDownsamplingStats != null) {
                builder.startObject("dlm");
                this.dlmDownsamplingStats.toXContent(builder, params);
                builder.endObject();
            }
            return builder.endObject();
        }
    }

    public record DownsamplingFeatureStats(long dataStreamsCount, long indexCount, long minRounds, double averageRounds, long maxRounds) implements Writeable,
    ToXContentFragment
    {
        static final DownsamplingFeatureStats EMPTY = new DownsamplingFeatureStats(0L, 0L, 0L, 0.0, 0L);

        public static DownsamplingFeatureStats read(StreamInput in) throws IOException {
            long dataStreamsCount = in.readVLong();
            if (dataStreamsCount == 0L) {
                return EMPTY;
            }
            return new DownsamplingFeatureStats(dataStreamsCount, in.readVLong(), in.readVLong(), in.readDouble(), in.readVLong());
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeVLong(this.dataStreamsCount);
            if (this.dataStreamsCount != 0L) {
                out.writeVLong(this.indexCount);
                out.writeVLong(this.minRounds);
                out.writeDouble(this.averageRounds);
                out.writeVLong(this.maxRounds);
            }
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.field("downsampled_data_stream_count", this.dataStreamsCount);
            if (this.dataStreamsCount > 0L) {
                builder.field("downsampled_index_count", this.indexCount);
                builder.startObject("rounds_per_data_stream");
                builder.field("min", this.minRounds);
                builder.field("average", this.averageRounds);
                builder.field("max", this.maxRounds);
                builder.endObject();
            }
            return builder;
        }
    }

    public record IlmPolicyStats(Map<String, Long> downsamplingPhases, long forceMergeExplicitlyEnabledCounter, long forceMergeExplicitlyDisabledCounter, long forceMergeDefaultCounter, long downsampledForceMergeNeededCounter) implements Writeable,
    ToXContentFragment
    {
        public static final IlmPolicyStats EMPTY = new IlmPolicyStats(Map.of(), 0L, 0L, 0L, 0L);

        static IlmPolicyStats read(StreamInput in) throws IOException {
            Map downsamplingPhases = in.readImmutableMap(StreamInput::readString, StreamInput::readVLong);
            long forceMergeExplicitlyEnabledCounter = 0L;
            long forceMergeExplicitlyDisabledCounter = 0L;
            long forceMergeDefaultCounter = 0L;
            long downsampledForceMergeNeededCounter = 0L;
            if (in.getTransportVersion().supports(DownsampleAction.ILM_FORCE_MERGE_IN_DOWNSAMPLING)) {
                forceMergeExplicitlyEnabledCounter = in.readVLong();
                forceMergeExplicitlyDisabledCounter = in.readVLong();
                forceMergeDefaultCounter = in.readVLong();
                downsampledForceMergeNeededCounter = in.readVLong();
            }
            return new IlmPolicyStats(downsamplingPhases, forceMergeExplicitlyEnabledCounter, forceMergeExplicitlyDisabledCounter, forceMergeDefaultCounter, downsampledForceMergeNeededCounter);
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeMap(this.downsamplingPhases, StreamOutput::writeString, StreamOutput::writeVLong);
            if (out.getTransportVersion().supports(DownsampleAction.ILM_FORCE_MERGE_IN_DOWNSAMPLING)) {
                out.writeVLong(this.forceMergeExplicitlyEnabledCounter);
                out.writeVLong(this.forceMergeExplicitlyDisabledCounter);
                out.writeVLong(this.forceMergeDefaultCounter);
                out.writeVLong(this.downsampledForceMergeNeededCounter);
            }
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.field("phases_in_use", this.downsamplingPhases);
            builder.startObject("force_merge");
            builder.field("explicitly_enabled_count", this.forceMergeExplicitlyEnabledCounter);
            builder.field("explicitly_disabled_count", this.forceMergeExplicitlyDisabledCounter);
            builder.field("undefined_count", this.forceMergeDefaultCounter);
            builder.field("undefined_force_merge_needed_count", this.downsampledForceMergeNeededCounter);
            builder.endObject();
            return null;
        }
    }
}

