/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.async;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Base64;
import java.util.Objects;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.ByteBufferStreamInput;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.tasks.TaskId;

public final class AsyncExecutionId
implements Writeable {
    public static final String ASYNC_EXECUTION_ID_HEADER = "X-Elasticsearch-Async-Id";
    public static final String ASYNC_EXECUTION_IS_RUNNING_HEADER = "X-Elasticsearch-Async-Is-Running";
    private final String docId;
    private final TaskId taskId;
    private final String encoded;

    public AsyncExecutionId(String docId, TaskId taskId) {
        this(docId, taskId, AsyncExecutionId.encode(docId, taskId));
    }

    private AsyncExecutionId(String docId, TaskId taskId, String encoded) {
        this.docId = docId;
        this.taskId = taskId;
        this.encoded = encoded;
    }

    public String getDocId() {
        return this.docId;
    }

    public TaskId getTaskId() {
        return this.taskId;
    }

    public String getEncoded() {
        return this.encoded;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AsyncExecutionId searchId = (AsyncExecutionId)o;
        return this.docId.equals(searchId.docId) && this.taskId.equals((Object)searchId.taskId);
    }

    public int hashCode() {
        return Objects.hash(this.docId, this.taskId);
    }

    public String toString() {
        return "AsyncExecutionId{docId='" + this.docId + "', taskId=" + String.valueOf(this.taskId) + "}";
    }

    public static String encode(String docId, TaskId taskId) {
        String string;
        BytesStreamOutput out = new BytesStreamOutput();
        try {
            out.writeString(docId);
            out.writeString(taskId.toString());
            string = Base64.getUrlEncoder().encodeToString(BytesReference.toBytes((BytesReference)out.bytes()));
        }
        catch (Throwable throwable) {
            try {
                try {
                    out.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
        }
        out.close();
        return string;
    }

    public static AsyncExecutionId decode(String id) {
        String taskId;
        String docId;
        ByteBuffer byteBuffer;
        try {
            byteBuffer = ByteBuffer.wrap(Base64.getUrlDecoder().decode(id));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("invalid id: [" + id + "]", e);
        }
        try (ByteBufferStreamInput in = new ByteBufferStreamInput(byteBuffer);){
            docId = in.readString();
            taskId = in.readString();
            if (in.available() > 0) {
                throw new IllegalArgumentException("invalid id: [" + id + "]");
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException("invalid id: [" + id + "]", e);
        }
        return new AsyncExecutionId(docId, new TaskId(taskId), id);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.getEncoded());
    }

    public static AsyncExecutionId readFrom(StreamInput input) throws IOException {
        return AsyncExecutionId.decode(input.readString());
    }
}

