/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.LegacyActionRequest;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.sql.proto.Mode;
import org.elasticsearch.xpack.sql.proto.RequestInfo;
import org.elasticsearch.xpack.sql.proto.SqlVersion;

public abstract class AbstractSqlRequest
extends LegacyActionRequest {
    private RequestInfo requestInfo;

    protected AbstractSqlRequest() {
        this.requestInfo = new RequestInfo(Mode.PLAIN);
    }

    protected AbstractSqlRequest(RequestInfo requestInfo) {
        this.requestInfo = requestInfo;
    }

    protected AbstractSqlRequest(StreamInput in) throws IOException {
        super(in);
        Mode mode = (Mode)in.readEnum(Mode.class);
        String clientId = in.readOptionalString();
        String clientVersion = in.readOptionalString();
        this.requestInfo = new RequestInfo(mode, clientId, clientVersion);
    }

    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.requestInfo == null || this.requestInfo.mode() == null) {
            validationException = ValidateActions.addValidationError((String)"[mode] is required", validationException);
        }
        return validationException;
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeEnum((Enum)this.requestInfo.mode());
        out.writeOptionalString(this.requestInfo.clientId());
        out.writeOptionalString(this.requestInfo.version() == null ? null : this.requestInfo.version().toString());
    }

    public RequestInfo requestInfo() {
        return this.requestInfo;
    }

    public void requestInfo(RequestInfo requestInfo) {
        this.requestInfo = requestInfo;
    }

    public Mode mode() {
        return this.requestInfo.mode();
    }

    public void mode(Mode mode) {
        this.requestInfo.mode(mode);
    }

    public void mode(String mode) {
        this.requestInfo.mode(Mode.fromString((String)mode));
    }

    public String clientId() {
        return this.requestInfo.clientId();
    }

    public void clientId(String clientId) {
        this.requestInfo.clientId(clientId);
    }

    public void version(String clientVersion) {
        this.requestInfo.version(clientVersion);
    }

    public SqlVersion version() {
        return this.requestInfo.version();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        AbstractSqlRequest that = (AbstractSqlRequest)((Object)o);
        return Objects.equals(this.requestInfo, that.requestInfo);
    }

    public int hashCode() {
        return this.requestInfo.hashCode();
    }
}

