/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.channels.Channel;
import java.nio.channels.FileChannel;
import java.nio.file.attribute.FileTime;
import jnr.constants.platform.Errno;
import jnr.posix.FileStat;
import org.jruby.util.FileResource;
import org.jruby.util.JRubyFile;
import org.jruby.util.RegularFileResource;
import org.jruby.util.io.ModeFlags;

final class NullDeviceResource
implements FileResource {
    private static final String NUL_DEVICE = "NUL:";
    private static final JRubyFile file = new JRubyFile("NUL:");

    NullDeviceResource() {
    }

    @Override
    public String absolutePath() {
        return NUL_DEVICE;
    }

    @Override
    public String canonicalPath() {
        return NUL_DEVICE;
    }

    @Override
    public String path() {
        return NUL_DEVICE;
    }

    @Override
    public long length() {
        return 0L;
    }

    @Override
    public long lastModified() {
        return 0L;
    }

    public FileTime creationTime() {
        return FileTime.fromMillis(this.lastModified());
    }

    public FileTime lastModifiedTime() {
        return FileTime.fromMillis(this.lastModified());
    }

    public FileTime lastAccessTime() {
        return FileTime.fromMillis(this.lastModified());
    }

    @Override
    public boolean exists() {
        return true;
    }

    @Override
    public boolean canExecute() {
        return false;
    }

    @Override
    public int errno() {
        return Errno.ENOENT.intValue();
    }

    @Override
    public boolean isFile() {
        return true;
    }

    @Override
    public boolean isDirectory() {
        return false;
    }

    @Override
    public boolean isSymLink() {
        return false;
    }

    @Override
    public boolean canRead() {
        return true;
    }

    @Override
    public boolean canWrite() {
        return true;
    }

    @Override
    public String[] list() {
        return null;
    }

    @Override
    public FileStat stat() {
        return null;
    }

    @Override
    public FileStat lstat() {
        return null;
    }

    public String toString() {
        return NUL_DEVICE;
    }

    @Override
    public boolean isNull() {
        return true;
    }

    @Override
    public InputStream openInputStream() throws IOException {
        return new FileInputStream(file);
    }

    @Override
    public Channel openChannel(int flags2, int perm) throws IOException {
        return this.createChannel(ModeFlags.createModeFlags(flags2));
    }

    private Channel createChannel(ModeFlags flags2) throws IOException {
        FileChannel fileChannel;
        try {
            if (flags2.isWritable() && !flags2.isReadable()) {
                FileOutputStream fos = new FileOutputStream(file, flags2.isAppendable());
                fileChannel = fos.getChannel();
            } else {
                RandomAccessFile raf = new RandomAccessFile(file, flags2.toJavaModeString());
                fileChannel = raf.getChannel();
            }
        }
        catch (FileNotFoundException ex) {
            throw RegularFileResource.mapFileNotFoundOnGetChannel(this, ex);
        }
        return fileChannel;
    }

    @Override
    public <T> T unwrap(Class<T> type2) {
        if (type2 == File.class || type2 == JRubyFile.class) {
            return (T)file;
        }
        throw new UnsupportedOperationException("unwrap: " + type2.getName());
    }
}

