/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.serializers.schema.id;

import io.confluent.kafka.serializers.schema.id.SchemaId;
import io.confluent.kafka.serializers.schema.id.SchemaIdDeserializer;
import java.nio.ByteBuffer;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.Headers;

public class DualSchemaIdDeserializer
implements SchemaIdDeserializer {
    @Override
    public ByteBuffer deserialize(String topic, boolean isKey, Headers headers, byte[] payload, SchemaId schemaId) throws SerializationException {
        try {
            byte[] headerValue;
            Header header;
            String headerKey = isKey ? "__key_schema_id" : "__value_schema_id";
            Header header2 = header = headers != null ? headers.lastHeader(headerKey) : null;
            if (header != null && (headerValue = header.value()) != null) {
                schemaId.fromBytes(ByteBuffer.wrap(headerValue));
                return ByteBuffer.wrap(payload);
            }
            return schemaId.fromBytes(ByteBuffer.wrap(payload));
        }
        catch (Exception e) {
            throw new SerializationException("Error deserializing schema ID", (Throwable)e);
        }
    }
}

