/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

package org.elasticsearch.xpack.core.security.action.apikey;

import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;

import java.util.List;
import java.util.Map;

import static org.elasticsearch.action.ValidateActions.addValidationError;

public final class UpdateCrossClusterApiKeyRequest extends BaseSingleUpdateApiKeyRequest {

    public UpdateCrossClusterApiKeyRequest(
        final String id,
        @Nullable CrossClusterApiKeyRoleDescriptorBuilder roleDescriptorBuilder,
        @Nullable final Map<String, Object> metadata,
        @Nullable TimeValue expiration,
        @Nullable CertificateIdentity certificateIdentity
    ) {
        super(roleDescriptorBuilder == null ? null : List.of(roleDescriptorBuilder.build()), metadata, expiration, id, certificateIdentity);
    }

    @Override
    public ApiKey.Type getType() {
        return ApiKey.Type.CROSS_CLUSTER;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = super.validate();
        if (roleDescriptors == null && metadata == null && certificateIdentity == null) {
            validationException = addValidationError(
                "must update [access], [metadata], or [certificate_identity] for cross-cluster API keys",
                validationException
            );
        }
        return validationException;
    }
}
