/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.lucene.comparators;

import java.io.IOException;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.DocValuesSkipper;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.DocValuesRangeIterator;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.LeafFieldComparator;
import org.apache.lucene.search.Pruning;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.util.DocIdSetBuilder;
import org.apache.lucene.util.IntsRef;
import org.elasticsearch.lucene.comparators.XUpdateableDocIdSetIterator;

public abstract class XNumericComparator<T extends Number>
extends FieldComparator<T> {
    private static final int MIN_SKIP_INTERVAL = 32;
    private static final int MAX_SKIP_INTERVAL = 8192;
    protected final T missingValue;
    private final long missingValueAsLong;
    protected final String field;
    protected final boolean reverse;
    private final int bytesCount;
    protected boolean topValueSet;
    protected boolean singleSort;
    protected boolean hitsThresholdReached;
    protected boolean queueFull;
    protected Pruning pruning;

    protected XNumericComparator(String field, T missingValue, boolean reverse, Pruning pruning, int bytesCount) {
        this.field = field;
        this.missingValue = missingValue;
        this.missingValueAsLong = this.missingValueAsComparableLong();
        this.reverse = reverse;
        this.pruning = pruning;
        this.bytesCount = bytesCount;
    }

    public void setTopValue(T value) {
        this.topValueSet = true;
    }

    public void setSingleSort() {
        this.singleSort = true;
    }

    public void disableSkipping() {
        this.pruning = Pruning.NONE;
    }

    protected abstract long missingValueAsComparableLong();

    protected abstract long sortableBytesToLong(byte[] var1);

    private class DVSkipperCompetitiveDISIBuilder
    extends CompetitiveDISIBuilder {
        private final DocValuesSkipper skipper;
        private final TwoPhaseIterator innerTwoPhase;

        DVSkipperCompetitiveDISIBuilder(DocValuesSkipper skipper, NumericLeafComparator leafComparator) throws IOException {
            super(leafComparator);
            this.skipper = skipper;
            final NumericDocValues docValues = leafComparator.getNumericDocValues(leafComparator.context, XNumericComparator.this.field);
            this.innerTwoPhase = new TwoPhaseIterator((DocIdSetIterator)docValues){

                public boolean matches() throws IOException {
                    long value = docValues.longValue();
                    return value >= DVSkipperCompetitiveDISIBuilder.this.minValueAsLong && value <= DVSkipperCompetitiveDISIBuilder.this.maxValueAsLong;
                }

                public float matchCost() {
                    return 2.0f;
                }
            };
            this.postInitializeCompetitiveIterator();
        }

        @Override
        protected int docCount() {
            return this.skipper.docCount();
        }

        void postInitializeCompetitiveIterator() {
            if (XNumericComparator.this.queueFull && XNumericComparator.this.hitsThresholdReached) {
                if (this.docCount() < this.maxDoc && this.isMissingValueCompetitive()) {
                    return;
                }
                long bottom = this.leafComparator.bottomAsComparableLong();
                if (!XNumericComparator.this.reverse && bottom < this.skipper.minValue()) {
                    this.competitiveIterator.update(DocIdSetIterator.empty());
                } else if (XNumericComparator.this.reverse && bottom > this.skipper.maxValue()) {
                    this.competitiveIterator.update(DocIdSetIterator.empty());
                }
            }
        }

        @Override
        protected void doUpdateCompetitiveIterator() {
            DocValuesRangeIterator twoPhaseIterator = new DocValuesRangeIterator(this.innerTwoPhase, this.skipper, this.minValueAsLong, this.maxValueAsLong, false);
            this.competitiveIterator.update(TwoPhaseIterator.asDocIdSetIterator((TwoPhaseIterator)twoPhaseIterator));
        }
    }

    private class PointsCompetitiveDISIBuilder
    extends CompetitiveDISIBuilder {
        private final PointValues pointValues;
        private PointValues.PointTree pointTree;
        private long iteratorCost;
        private int tryUpdateFailCount;

        PointsCompetitiveDISIBuilder(PointValues pointValues, NumericLeafComparator comparator) throws IOException {
            super(comparator);
            this.iteratorCost = -1L;
            this.tryUpdateFailCount = 0;
            LeafReaderContext context = comparator.context;
            FieldInfo info = context.reader().getFieldInfos().fieldInfo(XNumericComparator.this.field);
            if (info == null || info.getPointDimensionCount() == 0) {
                throw new IllegalStateException("Field " + XNumericComparator.this.field + " doesn't index points according to FieldInfos yet returns non-null PointValues");
            }
            if (info.getPointDimensionCount() > 1) {
                throw new IllegalArgumentException("Field " + XNumericComparator.this.field + " is indexed with multiple dimensions, sorting is not supported");
            }
            if (info.getPointNumBytes() != XNumericComparator.this.bytesCount) {
                throw new IllegalArgumentException("Field " + XNumericComparator.this.field + " is indexed with " + info.getPointNumBytes() + " bytes per dimension, but " + String.valueOf(this) + " expected " + XNumericComparator.this.bytesCount);
            }
            this.pointValues = pointValues;
            this.postInitializeCompetitiveIterator();
        }

        @Override
        void setScorer(Scorable scorer) throws IOException {
            if (this.iteratorCost == -1L) {
                this.iteratorCost = scorer instanceof Scorer ? ((Scorer)scorer).iterator().cost() : (long)this.maxDoc;
                this.updateCompetitiveIterator();
            }
        }

        @Override
        protected int docCount() {
            return this.pointValues.getDocCount();
        }

        void postInitializeCompetitiveIterator() throws IOException {
            if (XNumericComparator.this.queueFull && XNumericComparator.this.hitsThresholdReached) {
                if (this.docCount() < this.maxDoc && this.isMissingValueCompetitive()) {
                    return;
                }
                long bottom = this.leafComparator.bottomAsComparableLong();
                long minValue = XNumericComparator.this.sortableBytesToLong(this.pointValues.getMinPackedValue());
                long maxValue = XNumericComparator.this.sortableBytesToLong(this.pointValues.getMaxPackedValue());
                if (!XNumericComparator.this.reverse && bottom < minValue) {
                    this.competitiveIterator.update(DocIdSetIterator.empty());
                } else if (XNumericComparator.this.reverse && bottom > maxValue) {
                    this.competitiveIterator.update(DocIdSetIterator.empty());
                }
            }
        }

        @Override
        protected void doUpdateCompetitiveIterator() throws IOException {
            final DocIdSetBuilder result = new DocIdSetBuilder(this.maxDoc);
            PointValues.IntersectVisitor visitor = new PointValues.IntersectVisitor(){
                DocIdSetBuilder.BulkAdder adder;

                public void grow(int count) {
                    this.adder = result.grow(count);
                }

                public void visit(int docID) {
                    if (docID <= PointsCompetitiveDISIBuilder.this.maxDocVisited) {
                        return;
                    }
                    this.adder.add(docID);
                }

                public void visit(int docID, byte[] packedValue) {
                    if (docID <= PointsCompetitiveDISIBuilder.this.maxDocVisited) {
                        return;
                    }
                    long l = XNumericComparator.this.sortableBytesToLong(packedValue);
                    if (l >= PointsCompetitiveDISIBuilder.this.minValueAsLong && l <= PointsCompetitiveDISIBuilder.this.maxValueAsLong) {
                        this.adder.add(docID);
                    }
                }

                public void visit(DocIdSetIterator iterator) throws IOException {
                    if (iterator.advance(PointsCompetitiveDISIBuilder.this.maxDocVisited + 1) != Integer.MAX_VALUE) {
                        this.adder.add(iterator.docID());
                        this.adder.add(iterator);
                    }
                }

                public void visit(IntsRef ref) {
                    this.adder.add(ref, PointsCompetitiveDISIBuilder.this.maxDocVisited + 1);
                }

                public PointValues.Relation compare(byte[] minPackedValue, byte[] maxPackedValue) {
                    long min = XNumericComparator.this.sortableBytesToLong(minPackedValue);
                    long max = XNumericComparator.this.sortableBytesToLong(maxPackedValue);
                    if (min > PointsCompetitiveDISIBuilder.this.maxValueAsLong || max < PointsCompetitiveDISIBuilder.this.minValueAsLong) {
                        return PointValues.Relation.CELL_OUTSIDE_QUERY;
                    }
                    if (min < PointsCompetitiveDISIBuilder.this.minValueAsLong || max > PointsCompetitiveDISIBuilder.this.maxValueAsLong) {
                        return PointValues.Relation.CELL_CROSSES_QUERY;
                    }
                    return PointValues.Relation.CELL_INSIDE_QUERY;
                }
            };
            long threshold = this.iteratorCost >>> 3;
            if (PointValues.isEstimatedPointCountGreaterThanOrEqualTo((PointValues.IntersectVisitor)visitor, (PointValues.PointTree)this.getPointTree(), (long)threshold)) {
                this.updateSkipInterval(false);
                if ((long)this.pointValues.getDocCount() < this.iteratorCost) {
                    this.competitiveIterator.update((DocIdSetIterator)this.leafComparator.getNumericDocValues(this.leafComparator.context, XNumericComparator.this.field));
                    this.iteratorCost = this.pointValues.getDocCount();
                }
                return;
            }
            this.pointValues.intersect(visitor);
            this.competitiveIterator.update(result.build().iterator());
            this.iteratorCost = this.competitiveIterator.cost();
            this.updateSkipInterval(true);
        }

        private PointValues.PointTree getPointTree() throws IOException {
            if (this.pointTree == null) {
                this.pointTree = this.pointValues.getPointTree();
            }
            return this.pointTree;
        }

        private void updateSkipInterval(boolean success) {
            if (this.updateCounter > 256) {
                if (success) {
                    this.currentSkipInterval = Math.max(this.currentSkipInterval / 2, 32);
                    this.tryUpdateFailCount = 0;
                } else if (this.tryUpdateFailCount >= 3) {
                    this.currentSkipInterval = Math.min(this.currentSkipInterval * 2, 8192);
                    this.tryUpdateFailCount = 0;
                } else {
                    ++this.tryUpdateFailCount;
                }
            }
        }
    }

    protected abstract class CompetitiveDISIBuilder {
        final int maxDoc;
        final NumericLeafComparator leafComparator;
        final boolean leafTopSet;
        protected final XUpdateableDocIdSetIterator competitiveIterator;
        protected long minValueAsLong;
        protected long maxValueAsLong;
        int maxDocVisited;
        int updateCounter;
        int currentSkipInterval;

        protected CompetitiveDISIBuilder(NumericLeafComparator leafComparator) {
            this.leafTopSet = XNumericComparator.this.topValueSet;
            this.competitiveIterator = new XUpdateableDocIdSetIterator();
            this.minValueAsLong = Long.MIN_VALUE;
            this.maxValueAsLong = Long.MAX_VALUE;
            this.maxDocVisited = -1;
            this.updateCounter = 0;
            this.currentSkipInterval = 32;
            this.leafComparator = leafComparator;
            this.maxDoc = leafComparator.context.reader().maxDoc();
            this.competitiveIterator.update(DocIdSetIterator.all((int)this.maxDoc));
            if (this.leafTopSet) {
                this.encodeTop();
            }
        }

        void setScorer(Scorable scorer) throws IOException {
        }

        protected abstract int docCount();

        final void updateCompetitiveIterator() throws IOException {
            if (!XNumericComparator.this.hitsThresholdReached) {
                return;
            }
            if (!this.leafTopSet && !XNumericComparator.this.queueFull) {
                return;
            }
            if (this.docCount() < this.maxDoc && this.isMissingValueCompetitive()) {
                return;
            }
            ++this.updateCounter;
            if (this.updateCounter > 256 && (this.updateCounter & this.currentSkipInterval - 1) != this.currentSkipInterval - 1) {
                return;
            }
            if (XNumericComparator.this.queueFull) {
                this.encodeBottom();
            }
            this.doUpdateCompetitiveIterator();
        }

        protected abstract void doUpdateCompetitiveIterator() throws IOException;

        private void setMaxDocVisited(int maxDocVisited) {
            this.maxDocVisited = maxDocVisited;
        }

        private void encodeBottom() {
            if (!XNumericComparator.this.reverse) {
                this.maxValueAsLong = this.leafComparator.bottomAsComparableLong();
                if (XNumericComparator.this.pruning == Pruning.GREATER_THAN_OR_EQUAL_TO && this.maxValueAsLong != Long.MIN_VALUE) {
                    --this.maxValueAsLong;
                }
            } else {
                this.minValueAsLong = this.leafComparator.bottomAsComparableLong();
                if (XNumericComparator.this.pruning == Pruning.GREATER_THAN_OR_EQUAL_TO && this.minValueAsLong != Long.MAX_VALUE) {
                    ++this.minValueAsLong;
                }
            }
        }

        private void encodeTop() {
            if (!XNumericComparator.this.reverse) {
                this.minValueAsLong = this.leafComparator.topAsComparableLong();
                if (XNumericComparator.this.singleSort && XNumericComparator.this.pruning == Pruning.GREATER_THAN_OR_EQUAL_TO && XNumericComparator.this.queueFull && this.minValueAsLong != Long.MAX_VALUE) {
                    ++this.minValueAsLong;
                }
            } else {
                this.maxValueAsLong = this.leafComparator.topAsComparableLong();
                if (XNumericComparator.this.singleSort && XNumericComparator.this.pruning == Pruning.GREATER_THAN_OR_EQUAL_TO && XNumericComparator.this.queueFull && this.maxValueAsLong != Long.MIN_VALUE) {
                    --this.maxValueAsLong;
                }
            }
        }

        boolean isMissingValueCompetitive() {
            int result;
            if (XNumericComparator.this.queueFull) {
                boolean competitive;
                result = Long.compare(XNumericComparator.this.missingValueAsLong, this.leafComparator.bottomAsComparableLong());
                boolean bl = XNumericComparator.this.reverse ? (XNumericComparator.this.pruning == Pruning.GREATER_THAN_OR_EQUAL_TO ? result > 0 : result >= 0) : (XNumericComparator.this.pruning == Pruning.GREATER_THAN_OR_EQUAL_TO ? result < 0 : (competitive = result <= 0));
                if (!competitive) {
                    return false;
                }
            }
            if (this.leafTopSet) {
                result = Long.compare(XNumericComparator.this.missingValueAsLong, this.leafComparator.topAsComparableLong());
                return XNumericComparator.this.reverse ? result <= 0 : result >= 0;
            }
            return true;
        }
    }

    public abstract class NumericLeafComparator
    implements LeafFieldComparator {
        private final LeafReaderContext context;
        protected final NumericDocValues docValues;
        private final CompetitiveDISIBuilder competitiveDISIBuilder;

        public NumericLeafComparator(LeafReaderContext context) throws IOException {
            this.context = context;
            this.docValues = this.getNumericDocValues(context, XNumericComparator.this.field);
            this.competitiveDISIBuilder = this.buildCompetitiveDISIBuilder(context);
        }

        protected CompetitiveDISIBuilder buildCompetitiveDISIBuilder(LeafReaderContext context) throws IOException {
            if (XNumericComparator.this.pruning == Pruning.NONE) {
                return null;
            }
            LeafReader reader = context.reader();
            PointValues pointValues = reader.getPointValues(XNumericComparator.this.field);
            if (pointValues != null) {
                return new PointsCompetitiveDISIBuilder(pointValues, this);
            }
            DocValuesSkipper skipper = reader.getDocValuesSkipper(XNumericComparator.this.field);
            if (skipper != null) {
                return new DVSkipperCompetitiveDISIBuilder(skipper, this);
            }
            return null;
        }

        protected NumericDocValues getNumericDocValues(LeafReaderContext context, String field) throws IOException {
            return DocValues.getNumeric((LeafReader)context.reader(), (String)field);
        }

        public void setBottom(int slot) throws IOException {
            XNumericComparator.this.queueFull = true;
            if (this.competitiveDISIBuilder != null) {
                this.competitiveDISIBuilder.updateCompetitiveIterator();
            }
        }

        public void copy(int slot, int doc) throws IOException {
            if (this.competitiveDISIBuilder != null) {
                this.competitiveDISIBuilder.setMaxDocVisited(doc);
            }
        }

        public void setScorer(Scorable scorer) throws IOException {
            if (this.competitiveDISIBuilder != null) {
                this.competitiveDISIBuilder.setScorer(scorer);
            }
        }

        public void setHitsThresholdReached() throws IOException {
            XNumericComparator.this.hitsThresholdReached = true;
            if (this.competitiveDISIBuilder != null) {
                this.competitiveDISIBuilder.updateCompetitiveIterator();
            }
        }

        public DocIdSetIterator competitiveIterator() {
            return this.competitiveDISIBuilder == null ? null : this.competitiveDISIBuilder.competitiveIterator;
        }

        protected abstract long bottomAsComparableLong();

        protected abstract long topAsComparableLong();
    }
}

