/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation;

import java.util.List;
import org.elasticsearch.compute.aggregation.AggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.IntermediateStateDesc;
import org.elasticsearch.compute.aggregation.TopLongIntAggregatorFunction;
import org.elasticsearch.compute.aggregation.TopLongIntGroupingAggregatorFunction;
import org.elasticsearch.compute.operator.DriverContext;

public final class TopLongIntAggregatorFunctionSupplier
implements AggregatorFunctionSupplier {
    private final int limit;
    private final boolean ascending;

    public TopLongIntAggregatorFunctionSupplier(int limit, boolean ascending) {
        this.limit = limit;
        this.ascending = ascending;
    }

    @Override
    public List<IntermediateStateDesc> nonGroupingIntermediateStateDesc() {
        return TopLongIntAggregatorFunction.intermediateStateDesc();
    }

    @Override
    public List<IntermediateStateDesc> groupingIntermediateStateDesc() {
        return TopLongIntGroupingAggregatorFunction.intermediateStateDesc();
    }

    @Override
    public TopLongIntAggregatorFunction aggregator(DriverContext driverContext, List<Integer> channels) {
        return TopLongIntAggregatorFunction.create(driverContext, channels, this.limit, this.ascending);
    }

    @Override
    public TopLongIntGroupingAggregatorFunction groupingAggregator(DriverContext driverContext, List<Integer> channels) {
        return TopLongIntGroupingAggregatorFunction.create(channels, driverContext, this.limit, this.ascending);
    }

    @Override
    public String describe() {
        return "top_long of ints";
    }
}

