/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation;

import java.util.List;
import org.elasticsearch.compute.aggregation.AggregatorFunction;
import org.elasticsearch.compute.aggregation.IntermediateStateDesc;
import org.elasticsearch.compute.aggregation.TopLongIntAggregator;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BooleanVector;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.data.LongVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;

public final class TopLongIntAggregatorFunction
implements AggregatorFunction {
    private static final List<IntermediateStateDesc> INTERMEDIATE_STATE_DESC = List.of(new IntermediateStateDesc("top", ElementType.LONG), new IntermediateStateDesc("output", ElementType.INT));
    private final DriverContext driverContext;
    private final TopLongIntAggregator.SingleState state;
    private final List<Integer> channels;
    private final int limit;
    private final boolean ascending;

    public TopLongIntAggregatorFunction(DriverContext driverContext, List<Integer> channels, TopLongIntAggregator.SingleState state, int limit, boolean ascending) {
        this.driverContext = driverContext;
        this.channels = channels;
        this.state = state;
        this.limit = limit;
        this.ascending = ascending;
    }

    public static TopLongIntAggregatorFunction create(DriverContext driverContext, List<Integer> channels, int limit, boolean ascending) {
        return new TopLongIntAggregatorFunction(driverContext, channels, TopLongIntAggregator.initSingle(driverContext.bigArrays(), limit, ascending), limit, ascending);
    }

    public static List<IntermediateStateDesc> intermediateStateDesc() {
        return INTERMEDIATE_STATE_DESC;
    }

    @Override
    public int intermediateBlockCount() {
        return INTERMEDIATE_STATE_DESC.size();
    }

    @Override
    public void addRawInput(Page page, BooleanVector mask) {
        if (!mask.allFalse()) {
            if (mask.allTrue()) {
                this.addRawInputNotMasked(page);
            } else {
                this.addRawInputMasked(page, mask);
            }
        }
    }

    private void addRawInputMasked(Page page, BooleanVector mask) {
        LongBlock vBlock = (LongBlock)page.getBlock(this.channels.get(0));
        IntBlock outputValueBlock = (IntBlock)page.getBlock(this.channels.get(1));
        LongVector vVector = vBlock.asVector();
        if (vVector == null) {
            this.addRawBlock(vBlock, outputValueBlock, mask);
            return;
        }
        IntVector outputValueVector = outputValueBlock.asVector();
        if (outputValueVector == null) {
            this.addRawBlock(vBlock, outputValueBlock, mask);
            return;
        }
        this.addRawVector(vVector, outputValueVector, mask);
    }

    private void addRawInputNotMasked(Page page) {
        LongBlock vBlock = (LongBlock)page.getBlock(this.channels.get(0));
        IntBlock outputValueBlock = (IntBlock)page.getBlock(this.channels.get(1));
        LongVector vVector = vBlock.asVector();
        if (vVector == null) {
            this.addRawBlock(vBlock, outputValueBlock);
            return;
        }
        IntVector outputValueVector = outputValueBlock.asVector();
        if (outputValueVector == null) {
            this.addRawBlock(vBlock, outputValueBlock);
            return;
        }
        this.addRawVector(vVector, outputValueVector);
    }

    private void addRawVector(LongVector vVector, IntVector outputValueVector) {
        for (int valuesPosition = 0; valuesPosition < vVector.getPositionCount(); ++valuesPosition) {
            long vValue = vVector.getLong(valuesPosition);
            int outputValueValue = outputValueVector.getInt(valuesPosition);
            TopLongIntAggregator.combine(this.state, vValue, outputValueValue);
        }
    }

    private void addRawVector(LongVector vVector, IntVector outputValueVector, BooleanVector mask) {
        for (int valuesPosition = 0; valuesPosition < vVector.getPositionCount(); ++valuesPosition) {
            if (!mask.getBoolean(valuesPosition)) continue;
            long vValue = vVector.getLong(valuesPosition);
            int outputValueValue = outputValueVector.getInt(valuesPosition);
            TopLongIntAggregator.combine(this.state, vValue, outputValueValue);
        }
    }

    private void addRawBlock(LongBlock vBlock, IntBlock outputValueBlock) {
        for (int p = 0; p < vBlock.getPositionCount(); ++p) {
            int outputValueValueCount;
            int vValueCount = vBlock.getValueCount(p);
            if (vValueCount == 0 || (outputValueValueCount = outputValueBlock.getValueCount(p)) == 0) continue;
            int vStart = vBlock.getFirstValueIndex(p);
            int vEnd = vStart + vValueCount;
            for (int vOffset = vStart; vOffset < vEnd; ++vOffset) {
                long vValue = vBlock.getLong(vOffset);
                int outputValueStart = outputValueBlock.getFirstValueIndex(p);
                int outputValueEnd = outputValueStart + outputValueValueCount;
                for (int outputValueOffset = outputValueStart; outputValueOffset < outputValueEnd; ++outputValueOffset) {
                    int outputValueValue = outputValueBlock.getInt(outputValueOffset);
                    TopLongIntAggregator.combine(this.state, vValue, outputValueValue);
                }
            }
        }
    }

    private void addRawBlock(LongBlock vBlock, IntBlock outputValueBlock, BooleanVector mask) {
        for (int p = 0; p < vBlock.getPositionCount(); ++p) {
            int outputValueValueCount;
            int vValueCount;
            if (!mask.getBoolean(p) || (vValueCount = vBlock.getValueCount(p)) == 0 || (outputValueValueCount = outputValueBlock.getValueCount(p)) == 0) continue;
            int vStart = vBlock.getFirstValueIndex(p);
            int vEnd = vStart + vValueCount;
            for (int vOffset = vStart; vOffset < vEnd; ++vOffset) {
                long vValue = vBlock.getLong(vOffset);
                int outputValueStart = outputValueBlock.getFirstValueIndex(p);
                int outputValueEnd = outputValueStart + outputValueValueCount;
                for (int outputValueOffset = outputValueStart; outputValueOffset < outputValueEnd; ++outputValueOffset) {
                    int outputValueValue = outputValueBlock.getInt(outputValueOffset);
                    TopLongIntAggregator.combine(this.state, vValue, outputValueValue);
                }
            }
        }
    }

    @Override
    public void addIntermediateInput(Page page) {
        assert (this.channels.size() == this.intermediateBlockCount());
        assert (page.getBlockCount() >= this.channels.get(0) + TopLongIntAggregatorFunction.intermediateStateDesc().size());
        Object topUncast = page.getBlock(this.channels.get(0));
        if (topUncast.areAllValuesNull()) {
            return;
        }
        LongBlock top = (LongBlock)topUncast;
        assert (top.getPositionCount() == 1);
        Object outputUncast = page.getBlock(this.channels.get(1));
        if (outputUncast.areAllValuesNull()) {
            return;
        }
        IntBlock output = (IntBlock)outputUncast;
        assert (output.getPositionCount() == 1);
        TopLongIntAggregator.combineIntermediate(this.state, top, output);
    }

    @Override
    public void evaluateIntermediate(Block[] blocks, int offset, DriverContext driverContext) {
        this.state.toIntermediate(blocks, offset, driverContext);
    }

    @Override
    public void evaluateFinal(Block[] blocks, int offset, DriverContext driverContext) {
        blocks[offset] = TopLongIntAggregator.evaluateFinal(this.state, driverContext);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append("[");
        sb.append("channels=").append(this.channels);
        sb.append("]");
        return sb.toString();
    }

    public void close() {
        this.state.close();
    }
}

