/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation;

import java.util.List;
import org.elasticsearch.compute.aggregation.AggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.IntermediateStateDesc;
import org.elasticsearch.compute.aggregation.TopIntIntAggregatorFunction;
import org.elasticsearch.compute.aggregation.TopIntIntGroupingAggregatorFunction;
import org.elasticsearch.compute.operator.DriverContext;

public final class TopIntIntAggregatorFunctionSupplier
implements AggregatorFunctionSupplier {
    private final int limit;
    private final boolean ascending;

    public TopIntIntAggregatorFunctionSupplier(int limit, boolean ascending) {
        this.limit = limit;
        this.ascending = ascending;
    }

    @Override
    public List<IntermediateStateDesc> nonGroupingIntermediateStateDesc() {
        return TopIntIntAggregatorFunction.intermediateStateDesc();
    }

    @Override
    public List<IntermediateStateDesc> groupingIntermediateStateDesc() {
        return TopIntIntGroupingAggregatorFunction.intermediateStateDesc();
    }

    @Override
    public TopIntIntAggregatorFunction aggregator(DriverContext driverContext, List<Integer> channels) {
        return TopIntIntAggregatorFunction.create(driverContext, channels, this.limit, this.ascending);
    }

    @Override
    public TopIntIntGroupingAggregatorFunction groupingAggregator(DriverContext driverContext, List<Integer> channels) {
        return TopIntIntGroupingAggregatorFunction.create(channels, driverContext, this.limit, this.ascending);
    }

    @Override
    public String describe() {
        return "top_int of ints";
    }
}

