/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plugin;

import org.apache.lucene.util.SetOnce;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.search.internal.SearchContext;
import org.elasticsearch.search.lookup.SourceFilter;
import org.elasticsearch.search.lookup.SourceProvider;
import org.elasticsearch.xpack.esql.planner.EsPhysicalOperationProviders;
import org.elasticsearch.xpack.esql.plugin.ReinitializingSourceProvider;

class ComputeSearchContext
implements Releasable {
    private final int index;
    private final SearchContext searchContext;
    private final SetOnce<EsPhysicalOperationProviders.ShardContext> shardContext = new SetOnce();

    ComputeSearchContext(int index, SearchContext searchContext) {
        this.index = index;
        this.searchContext = searchContext;
    }

    public int index() {
        return this.index;
    }

    EsPhysicalOperationProviders.ShardContext shardContext() {
        if (this.shardContext.get() == null) {
            this.shardContext.set((Object)this.createShardContext());
        }
        return (EsPhysicalOperationProviders.ShardContext)this.shardContext.get();
    }

    public SearchContext searchContext() {
        return this.searchContext;
    }

    private EsPhysicalOperationProviders.ShardContext createShardContext() {
        SearchExecutionContext searchExecutionContext = new SearchExecutionContext(this, this.searchContext.getSearchExecutionContext()){

            public SourceProvider createSourceProvider(SourceFilter sourceFilter) {
                return new ReinitializingSourceProvider(x$0 -> super.createSourceProvider(x$0));
            }
        };
        return new EsPhysicalOperationProviders.DefaultShardContext(this.index, this, searchExecutionContext, this.searchContext.request().getAliasFilter());
    }

    public void close() {
        Releasables.close((Releasable)this.searchContext);
    }
}

