/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.parser;

import java.util.BitSet;
import java.util.EmptyStackException;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.DiagnosticErrorListener;
import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.atn.ATNConfigSet;
import org.antlr.v4.runtime.atn.ParserATNSimulator;
import org.antlr.v4.runtime.atn.PredictionMode;
import org.antlr.v4.runtime.dfa.DFA;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.elasticsearch.logging.LogManager;
import org.elasticsearch.logging.Logger;
import org.elasticsearch.xpack.esql.core.expression.Literal;
import org.elasticsearch.xpack.esql.parser.ParsingException;
import org.elasticsearch.xpack.esql.parser.PromqlBaseLexer;
import org.elasticsearch.xpack.esql.parser.PromqlBaseParser;
import org.elasticsearch.xpack.esql.parser.promql.PromqlAstBuilder;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;

public class PromqlParser {
    private static final Logger log = LogManager.getLogger(PromqlParser.class);
    private final boolean DEBUG = false;
    private static final BaseErrorListener ERROR_LISTENER = new BaseErrorListener(){

        public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String message, RecognitionException e) {
            throw new ParsingException(message, (Exception)((Object)e), line, charPositionInLine);
        }
    };

    public LogicalPlan createStatement(String query) {
        return this.createStatement(query, null, null, 0, 0);
    }

    public LogicalPlan createStatement(String query, Literal start, Literal end, int startLine, int startColumn) {
        if (log.isDebugEnabled()) {
            log.debug("Parsing as expression: {}", new Object[]{query});
        }
        return this.invokeParser(query, start, end, startLine, startColumn, PromqlBaseParser::singleStatement, PromqlAstBuilder::plan);
    }

    private <T> T invokeParser(String query, Literal start, Literal end, int startLine, int startColumn, Function<PromqlBaseParser, ParserRuleContext> parseFunction, BiFunction<PromqlAstBuilder, ParserRuleContext, T> visitor) {
        try {
            PromqlBaseLexer lexer = new PromqlBaseLexer((CharStream)CharStreams.fromString((String)query));
            lexer.removeErrorListeners();
            lexer.addErrorListener((ANTLRErrorListener)ERROR_LISTENER);
            CommonTokenStream tokenStream = new CommonTokenStream((TokenSource)lexer);
            PromqlBaseParser parser = new PromqlBaseParser((TokenStream)tokenStream);
            parser.removeErrorListeners();
            parser.addErrorListener((ANTLRErrorListener)ERROR_LISTENER);
            ((ParserATNSimulator)parser.getInterpreter()).setPredictionMode(PredictionMode.SLL);
            ParserRuleContext tree = parseFunction.apply(parser);
            if (log.isTraceEnabled()) {
                log.trace("Parse tree: {}", new Object[]{tree.toStringTree()});
            }
            return visitor.apply(new PromqlAstBuilder(start, end, startLine, startColumn), tree);
        }
        catch (StackOverflowError e) {
            throw new ParsingException("PromQL statement is too large, causing stack overflow when generating the parsing tree: [{}]", query);
        }
        catch (EmptyStackException ese) {
            throw new ParsingException("Invalid query [{}]", query);
        }
    }

    private static void debug(PromqlBaseParser parser) {
        ((ParserATNSimulator)parser.getInterpreter()).setPredictionMode(PredictionMode.LL_EXACT_AMBIG_DETECTION);
        parser.addParseListener((ParseTreeListener)new Parser.TraceListener((Parser)parser));
        parser.addErrorListener((ANTLRErrorListener)new DiagnosticErrorListener(false){

            public void reportAttemptingFullContext(Parser recognizer, DFA dfa, int startIndex, int stopIndex, BitSet conflictingAlts, ATNConfigSet configs) {
            }

            public void reportContextSensitivity(Parser recognizer, DFA dfa, int startIndex, int stopIndex, int prediction, ATNConfigSet configs) {
            }
        });
    }
}

