/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.fulltext;

import java.io.IOException;
import java.time.ZoneOffset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryStringQueryBuilder;
import org.elasticsearch.xpack.esql.core.InvalidArgumentException;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.MapExpression;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.querydsl.query.Query;
import org.elasticsearch.xpack.esql.core.querydsl.query.QueryStringQuery;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.expression.Foldables;
import org.elasticsearch.xpack.esql.expression.function.ConfigurationFunction;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionAppliesTo;
import org.elasticsearch.xpack.esql.expression.function.FunctionAppliesToLifecycle;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.MapParam;
import org.elasticsearch.xpack.esql.expression.function.OptionalArgument;
import org.elasticsearch.xpack.esql.expression.function.Options;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.fulltext.FullTextFunction;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;
import org.elasticsearch.xpack.esql.optimizer.rules.physical.local.LucenePushdownPredicates;
import org.elasticsearch.xpack.esql.planner.TranslatorHandler;
import org.elasticsearch.xpack.esql.session.Configuration;

public class QueryString
extends FullTextFunction
implements OptionalArgument,
ConfigurationFunction {
    public static final Map<String, DataType> ALLOWED_OPTIONS = Map.ofEntries(Map.entry(QueryStringQueryBuilder.BOOST_FIELD.getPreferredName(), DataType.FLOAT), Map.entry(QueryStringQueryBuilder.ALLOW_LEADING_WILDCARD_FIELD.getPreferredName(), DataType.BOOLEAN), Map.entry(QueryStringQueryBuilder.ANALYZE_WILDCARD_FIELD.getPreferredName(), DataType.BOOLEAN), Map.entry(QueryStringQueryBuilder.ANALYZER_FIELD.getPreferredName(), DataType.KEYWORD), Map.entry(QueryStringQueryBuilder.GENERATE_SYNONYMS_PHRASE_QUERY.getPreferredName(), DataType.BOOLEAN), Map.entry(QueryStringQueryBuilder.DEFAULT_FIELD_FIELD.getPreferredName(), DataType.KEYWORD), Map.entry(QueryStringQueryBuilder.DEFAULT_OPERATOR_FIELD.getPreferredName(), DataType.KEYWORD), Map.entry(QueryStringQueryBuilder.ENABLE_POSITION_INCREMENTS_FIELD.getPreferredName(), DataType.BOOLEAN), Map.entry(QueryStringQueryBuilder.FUZZINESS_FIELD.getPreferredName(), DataType.KEYWORD), Map.entry(QueryStringQueryBuilder.FUZZY_MAX_EXPANSIONS_FIELD.getPreferredName(), DataType.INTEGER), Map.entry(QueryStringQueryBuilder.FUZZY_PREFIX_LENGTH_FIELD.getPreferredName(), DataType.INTEGER), Map.entry(QueryStringQueryBuilder.FUZZY_TRANSPOSITIONS_FIELD.getPreferredName(), DataType.BOOLEAN), Map.entry(QueryStringQueryBuilder.LENIENT_FIELD.getPreferredName(), DataType.BOOLEAN), Map.entry(QueryStringQueryBuilder.MAX_DETERMINIZED_STATES_FIELD.getPreferredName(), DataType.INTEGER), Map.entry(QueryStringQueryBuilder.MINIMUM_SHOULD_MATCH_FIELD.getPreferredName(), DataType.KEYWORD), Map.entry(QueryStringQueryBuilder.QUOTE_ANALYZER_FIELD.getPreferredName(), DataType.KEYWORD), Map.entry(QueryStringQueryBuilder.QUOTE_FIELD_SUFFIX_FIELD.getPreferredName(), DataType.KEYWORD), Map.entry(QueryStringQueryBuilder.PHRASE_SLOP_FIELD.getPreferredName(), DataType.INTEGER), Map.entry(QueryStringQueryBuilder.REWRITE_FIELD.getPreferredName(), DataType.KEYWORD), Map.entry(QueryStringQueryBuilder.TIME_ZONE_FIELD.getPreferredName(), DataType.KEYWORD));
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "QStr", QueryString::readFrom);
    private final Configuration configuration;
    private final transient Expression options;
    public static final Set<DataType> QUERY_DATA_TYPES = Set.of(DataType.KEYWORD, DataType.TEXT);

    @FunctionInfo(returnType={"boolean"}, appliesTo={@FunctionAppliesTo(lifeCycle=FunctionAppliesToLifecycle.PREVIEW, version="9.0.0"), @FunctionAppliesTo(lifeCycle=FunctionAppliesToLifecycle.GA, version="9.1.0")}, description="Performs a <<query-dsl-query-string-query,query string query>>. Returns true if the provided query string matches the row.", examples={@Example(file="qstr-function", tag="qstr-with-field"), @Example(file="qstr-function", tag="qstr-with-options", applies_to="stack: ga 9.1.0")})
    public QueryString(Source source, @Param(name="query", type={"keyword", "text"}, description="Query string in Lucene query string format.") Expression queryString, @MapParam(name="options", params={@MapParam.MapParamEntry(name="default_field", type={"keyword"}, valueHint={"standard"}, description="Default field to search if no field is provided in the query string. Supports wildcards (*)."), @MapParam.MapParamEntry(name="allow_leading_wildcard", type={"boolean"}, valueHint={"true", "false"}, description="If true, the wildcard characters * and ? are allowed as the first character of the query string. Defaults to true."), @MapParam.MapParamEntry(name="allow_wildcard", type={"boolean"}, valueHint={"false", "true"}, description="If true, the query attempts to analyze wildcard terms in the query string. Defaults to false."), @MapParam.MapParamEntry(name="analyzer", type={"keyword"}, valueHint={"standard"}, description="Analyzer used to convert the text in the query value into token. Defaults to the index-time analyzer mapped for the default_field."), @MapParam.MapParamEntry(name="auto_generate_synonyms_phrase_query", type={"boolean"}, valueHint={"true", "false"}, description="If true, match phrase queries are automatically created for multi-term synonyms. Defaults to true."), @MapParam.MapParamEntry(name="fuzziness", type={"keyword"}, valueHint={"AUTO", "1", "2"}, description="Maximum edit distance allowed for matching."), @MapParam.MapParamEntry(name="boost", type={"float"}, valueHint={"2.5"}, description="Floating point number used to decrease or increase the relevance scores of the query."), @MapParam.MapParamEntry(name="default_operator", type={"keyword"}, valueHint={"OR", "AND"}, description="Default boolean logic used to interpret text in the query string if no operators are specified."), @MapParam.MapParamEntry(name="enable_position_increments", type={"boolean"}, valueHint={"true", "false"}, description="If true, enable position increments in queries constructed from a query_string search. Defaults to true."), @MapParam.MapParamEntry(name="fields", type={"keyword"}, valueHint={"standard"}, description="Array of fields to search. Supports wildcards (*)."), @MapParam.MapParamEntry(name="fuzzy_max_expansions", type={"integer"}, valueHint={"50"}, description="Maximum number of terms to which the query expands for fuzzy matching. Defaults to 50."), @MapParam.MapParamEntry(name="fuzzy_prefix_length", type={"integer"}, valueHint={"0"}, description="Number of beginning characters left unchanged for fuzzy matching. Defaults to 0."), @MapParam.MapParamEntry(name="fuzzy_transpositions", type={"boolean"}, valueHint={"true", "false"}, description="If true, edits for fuzzy matching include transpositions of two adjacent characters (ab \u2192 ba). Defaults to true."), @MapParam.MapParamEntry(name="lenient", type={"boolean"}, valueHint={"true", "false"}, description="If false, format-based errors, such as providing a text query value for a numeric field, are returned. Defaults to false."), @MapParam.MapParamEntry(name="max_determinized_states", type={"integer"}, valueHint={"10000"}, description="Maximum number of automaton states required for the query. Default is 10000."), @MapParam.MapParamEntry(name="minimum_should_match", type={"string"}, valueHint={"standard"}, description="Minimum number of clauses that must match for a document to be returned."), @MapParam.MapParamEntry(name="quote_analyzer", type={"keyword"}, valueHint={"standard"}, description="Analyzer used to convert quoted text in the query string into tokens. Defaults to the search_quote_analyzer mapped for the default_field."), @MapParam.MapParamEntry(name="phrase_slop", type={"integer"}, valueHint={"0"}, description="Maximum number of positions allowed between matching tokens for phrases. Defaults to 0 (which means exact matches are required)."), @MapParam.MapParamEntry(name="quote_field_suffix", type={"keyword"}, valueHint={"standard"}, description="Suffix appended to quoted text in the query string."), @MapParam.MapParamEntry(name="rewrite", type={"keyword"}, valueHint={"standard"}, description="Method used to rewrite the query."), @MapParam.MapParamEntry(name="time_zone", type={"keyword"}, valueHint={"standard"}, description="Coordinated Universal Time (UTC) offset or IANA time zone used to convert date values in the query string to UTC.")}, description="(Optional) Additional options for Query String as <<esql-function-named-params,function named parameters>>. See <<query-dsl-query-string-query,query string query>> for more information.", optional=true) Expression options, Configuration configuration) {
        this(source, queryString, options, null, configuration);
    }

    public QueryString(Source source, Expression queryString, Expression options, QueryBuilder queryBuilder, Configuration configuration) {
        super(source, queryString, options == null ? List.of(queryString) : List.of(queryString, options), queryBuilder);
        this.configuration = configuration;
        this.options = options;
    }

    private static QueryString readFrom(StreamInput in) throws IOException {
        Source source = Source.readFrom((StreamInput)((PlanStreamInput)in));
        Expression query = (Expression)in.readNamedWriteable(Expression.class);
        QueryBuilder queryBuilder = null;
        if (in.getTransportVersion().supports(TransportVersions.V_8_18_0)) {
            queryBuilder = (QueryBuilder)in.readOptionalNamedWriteable(QueryBuilder.class);
        }
        return new QueryString(source, query, null, queryBuilder, ((PlanStreamInput)in).configuration());
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.source().writeTo(out);
        out.writeNamedWriteable((NamedWriteable)this.query());
        if (out.getTransportVersion().supports(TransportVersions.V_8_18_0)) {
            out.writeOptionalNamedWriteable((NamedWriteable)this.queryBuilder());
        }
    }

    public String getWriteableName() {
        return QueryString.ENTRY.name;
    }

    public String functionName() {
        return "QSTR";
    }

    public Expression options() {
        return this.options;
    }

    private Expression.TypeResolution resolveQuery() {
        Expression.TypeResolution result = TypeResolutions.isType((Expression)this.query(), QUERY_DATA_TYPES::contains, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.FIRST, (String[])new String[]{"keyword, text"}).and(TypeResolutions.isNotNull((Expression)this.query(), (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.FIRST));
        if (result.unresolved()) {
            return result;
        }
        result = Foldables.resolveTypeQuery(this.query(), this.sourceText(), Foldables.TypeResolutionValidator.forPreOptimizationValidation(this.query()));
        if (!result.equals(Expression.TypeResolution.TYPE_RESOLVED)) {
            return result;
        }
        return Expression.TypeResolution.TYPE_RESOLVED;
    }

    private Map<String, Object> queryStringOptions() throws InvalidArgumentException {
        if (this.options() == null && this.configuration.zoneId().equals(ZoneOffset.UTC)) {
            return null;
        }
        HashMap<String, Object> queryStringOptions = new HashMap<String, Object>();
        if (this.options() != null) {
            Options.populateMap((MapExpression)this.options(), queryStringOptions, this.source(), TypeResolutions.ParamOrdinal.SECOND, ALLOWED_OPTIONS);
        }
        queryStringOptions.putIfAbsent(QueryStringQueryBuilder.TIME_ZONE_FIELD.getPreferredName(), this.configuration.zoneId().getId());
        return queryStringOptions;
    }

    @Override
    protected Expression.TypeResolution resolveParams() {
        return this.resolveQuery().and(Options.resolve(this.options(), this.source(), TypeResolutions.ParamOrdinal.SECOND, ALLOWED_OPTIONS));
    }

    public Expression replaceChildren(List<Expression> newChildren) {
        return new QueryString(this.source(), newChildren.getFirst(), newChildren.size() == 1 ? null : newChildren.get(1), this.queryBuilder(), this.configuration);
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, QueryString::new, (Object)this.query(), (Object)this.options(), (Object)this.queryBuilder(), (Object)this.configuration);
    }

    @Override
    protected Query translate(LucenePushdownPredicates pushdownPredicates, TranslatorHandler handler) {
        return new QueryStringQuery(this.source(), Foldables.queryAsString(this.query(), this.sourceText()), Map.of(), this.queryStringOptions());
    }

    @Override
    public Expression replaceQueryBuilder(QueryBuilder queryBuilder) {
        return new QueryString(this.source(), this.query(), this.options(), queryBuilder, this.configuration);
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueryString qstr = (QueryString)o;
        return Objects.equals(this.query(), qstr.query()) && Objects.equals(this.queryBuilder(), qstr.queryBuilder()) && Objects.equals(this.configuration, qstr.configuration);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.query(), this.queryBuilder(), this.configuration);
    }
}

