/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.aggregate;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.compute.aggregation.AggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.DimensionValuesByteRefGroupingAggregatorFunction;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.Literal;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.expression.function.aggregate.AggregateFunction;
import org.elasticsearch.xpack.esql.expression.function.aggregate.Values;
import org.elasticsearch.xpack.esql.planner.ToAggregator;

public class DimensionValues
extends AggregateFunction
implements ToAggregator {
    private static final Map<DataType, Supplier<AggregatorFunctionSupplier>> SUPPLIERS = Map.ofEntries(Map.entry(DataType.KEYWORD, DimensionValuesByteRefGroupingAggregatorFunction.FunctionSupplier::new), Map.entry(DataType.TEXT, DimensionValuesByteRefGroupingAggregatorFunction.FunctionSupplier::new), Map.entry(DataType.IP, DimensionValuesByteRefGroupingAggregatorFunction.FunctionSupplier::new), Map.entry(DataType.VERSION, DimensionValuesByteRefGroupingAggregatorFunction.FunctionSupplier::new), Map.entry(DataType.GEO_POINT, DimensionValuesByteRefGroupingAggregatorFunction.FunctionSupplier::new), Map.entry(DataType.CARTESIAN_POINT, DimensionValuesByteRefGroupingAggregatorFunction.FunctionSupplier::new), Map.entry(DataType.GEO_SHAPE, DimensionValuesByteRefGroupingAggregatorFunction.FunctionSupplier::new), Map.entry(DataType.CARTESIAN_SHAPE, DimensionValuesByteRefGroupingAggregatorFunction.FunctionSupplier::new));
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "DimensionValues", DimensionValues::new);
    public static final TransportVersion DIMENSION_VALUES_VERSION = TransportVersion.fromName((String)"dimension_values");

    public DimensionValues(Source source, Expression field) {
        super(source, field, (Expression)Literal.TRUE, (Expression)NO_WINDOW, Collections.emptyList());
    }

    private DimensionValues(StreamInput in) throws IOException {
        super(in);
    }

    public String getWriteableName() {
        return DimensionValues.ENTRY.name;
    }

    protected NodeInfo<DimensionValues> info() {
        return NodeInfo.create((Node)this, DimensionValues::new, (Object)this.field());
    }

    public DimensionValues replaceChildren(List<Expression> newChildren) {
        return new DimensionValues(this.source(), newChildren.get(0));
    }

    @Override
    public DimensionValues withFilter(Expression filter) {
        Literal l;
        if (filter instanceof Literal && (l = (Literal)filter).value() == Boolean.TRUE) {
            return this;
        }
        throw new UnsupportedOperationException("Dimension values do not support filters");
    }

    public DataType dataType() {
        return this.field().dataType().noText();
    }

    @Override
    protected Expression.TypeResolution resolveType() {
        return new Values(this.source(), this.field(), this.filter(), this.window()).resolveType();
    }

    @Override
    public AggregatorFunctionSupplier supplier() {
        Supplier<AggregatorFunctionSupplier> supplier = SUPPLIERS.get(this.field().dataType());
        if (supplier != null) {
            return supplier.get();
        }
        return new Values(this.source(), this.field(), this.filter(), this.window()).supplier();
    }
}

