/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.elasticsearch.common.logging.LoggerMessageFormat;
import org.elasticsearch.common.lucene.BytesRefs;
import org.elasticsearch.xpack.esql.core.InvalidArgumentException;
import org.elasticsearch.xpack.esql.core.expression.EntryExpression;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.Literal;
import org.elasticsearch.xpack.esql.core.expression.MapExpression;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.core.type.DataTypeConverter;

public class Options {
    public static Expression.TypeResolution resolve(Expression options, Source source, TypeResolutions.ParamOrdinal paramOrdinal, Map<String, DataType> allowedOptions) {
        return Options.resolve(options, source, paramOrdinal, null, (MapExpression opts, Map<String, Object> optsMap) -> Options.populateMap(opts, optsMap, source, paramOrdinal, allowedOptions));
    }

    public static Expression.TypeResolution resolve(Expression options, Source source, TypeResolutions.ParamOrdinal paramOrdinal, Map<String, DataType> allowedOptions, Consumer<Map<String, Object>> verifyOptions) {
        return Options.resolve(options, source, paramOrdinal, verifyOptions, (MapExpression opts, Map<String, Object> optsMap) -> Options.populateMap(opts, optsMap, source, paramOrdinal, allowedOptions));
    }

    public static Expression.TypeResolution resolveWithMultipleDataTypesAllowed(Expression options, Source source, TypeResolutions.ParamOrdinal paramOrdinal, Map<String, Collection<DataType>> allowedOptions) {
        return Options.resolve(options, source, paramOrdinal, null, (MapExpression opts, Map<String, Object> optsMap) -> Options.populateMapWithExpressionsMultipleDataTypesAllowed(opts, optsMap, source, paramOrdinal, allowedOptions));
    }

    private static Expression.TypeResolution resolve(Expression options, Source source, TypeResolutions.ParamOrdinal paramOrdinal, Consumer<Map<String, Object>> verifyOptions, BiConsumer<MapExpression, Map<String, Object>> populateMap) {
        if (options != null) {
            Expression.TypeResolution resolution = TypeResolutions.isNotNull((Expression)options, (String)source.text(), (TypeResolutions.ParamOrdinal)paramOrdinal);
            if (resolution.unresolved()) {
                return resolution;
            }
            resolution = TypeResolutions.isMapExpression((Expression)options, (String)source.text(), (TypeResolutions.ParamOrdinal)paramOrdinal);
            if (resolution.unresolved()) {
                return resolution;
            }
            try {
                HashMap optionsMap = new HashMap();
                populateMap.accept((MapExpression)options, optionsMap);
                if (verifyOptions != null) {
                    verifyOptions.accept(optionsMap);
                }
            }
            catch (InvalidArgumentException e) {
                return new Expression.TypeResolution(e.getMessage());
            }
        }
        return Expression.TypeResolution.TYPE_RESOLVED;
    }

    public static void populateMap(MapExpression options, Map<String, Object> optionsMap, Source source, TypeResolutions.ParamOrdinal paramOrdinal, Map<String, DataType> allowedOptions) throws InvalidArgumentException {
        for (EntryExpression entry : options.entryExpressions()) {
            Expression optionExpr = entry.key();
            Expression valueExpr = entry.value();
            Expression.TypeResolution optionNameResolution = TypeResolutions.isFoldable((Expression)optionExpr, (String)source.text(), (TypeResolutions.ParamOrdinal)paramOrdinal);
            if (optionNameResolution.unresolved()) {
                throw new InvalidArgumentException(optionNameResolution.message(), new Object[0]);
            }
            Object optionExprLiteral = ((Literal)optionExpr).value();
            String optionName = BytesRefs.toString((Object)optionExprLiteral);
            DataType dataType = allowedOptions.get(optionName);
            if (!(valueExpr instanceof Literal)) {
                throw new InvalidArgumentException(LoggerMessageFormat.format(null, (String)"Invalid option [{}] in [{}], expected a [{}] value", (Object[])new Object[]{optionName, source.text(), dataType}), new Object[0]);
            }
            Object valueExprLiteral = ((Literal)valueExpr).value();
            String optionValue = BytesRefs.toString((Object)valueExprLiteral);
            if (dataType == null) {
                throw new InvalidArgumentException(LoggerMessageFormat.format(null, (String)"Invalid option [{}] in [{}], expected one of {}", (Object[])new Object[]{optionName, source.text(), allowedOptions.keySet()}), new Object[0]);
            }
            try {
                optionsMap.put(optionName, DataTypeConverter.convert((Object)optionValue, (DataType)dataType));
            }
            catch (InvalidArgumentException e) {
                throw new InvalidArgumentException(LoggerMessageFormat.format(null, (String)"Invalid option [{}] in [{}], {}", (Object[])new Object[]{optionName, source.text(), e.getMessage()}), new Object[0]);
            }
        }
    }

    public static void populateMapWithExpressionsMultipleDataTypesAllowed(MapExpression options, Map<String, Object> optionsMap, Source source, TypeResolutions.ParamOrdinal paramOrdinal, Map<String, Collection<DataType>> allowedOptions) throws InvalidArgumentException {
        if (options == null) {
            return;
        }
        for (EntryExpression entry : options.entryExpressions()) {
            Expression optionExpr = entry.key();
            Expression valueExpr = entry.value();
            Expression.TypeResolution optionNameResolution = TypeResolutions.isFoldable((Expression)optionExpr, (String)source.text(), (TypeResolutions.ParamOrdinal)paramOrdinal);
            if (optionNameResolution.unresolved()) {
                throw new InvalidArgumentException(optionNameResolution.message(), new Object[0]);
            }
            Object optionExprLiteral = ((Literal)optionExpr).value();
            String optionName = BytesRefs.toString((Object)optionExprLiteral);
            Collection<DataType> allowedDataTypes = allowedOptions.get(optionName);
            if (!(valueExpr instanceof Literal)) {
                throw new InvalidArgumentException(LoggerMessageFormat.format(null, (String)"Invalid option [{}] in [{}], expected a [{}] value", (Object[])new Object[]{optionName, source.text(), allowedDataTypes}), new Object[0]);
            }
            if (allowedDataTypes == null || allowedDataTypes.isEmpty()) {
                throw new InvalidArgumentException(LoggerMessageFormat.format(null, (String)"Invalid option [{}] in [{}], expected one of {}", (Object[])new Object[]{optionName, source.text(), allowedOptions.keySet()}), new Object[0]);
            }
            Literal valueExprLiteral = (Literal)valueExpr;
            if (!allowedDataTypes.contains(valueExprLiteral.dataType())) {
                throw new InvalidArgumentException(LoggerMessageFormat.format(null, (String)"Invalid option [{}] in [{}], allowed types [{}]", (Object[])new Object[]{optionName, source.text(), allowedDataTypes}), new Object[0]);
            }
            optionsMap.put(optionName, valueExprLiteral);
        }
    }
}

