/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.action;

import java.io.IOException;
import java.util.concurrent.Executor;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionListenerResponseHandler;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.RemoteClusterActionType;
import org.elasticsearch.action.fieldcaps.FieldCapabilitiesRequest;
import org.elasticsearch.action.fieldcaps.FieldCapabilitiesResponse;
import org.elasticsearch.action.fieldcaps.TransportFieldCapabilitiesAction;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.Transport;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.esql.action.EsqlResolveFieldsResponse;

public class EsqlResolveFieldsAction
extends HandledTransportAction<FieldCapabilitiesRequest, EsqlResolveFieldsResponse> {
    public static final String NAME = "indices:data/read/esql/resolve_fields";
    public static final ActionType<EsqlResolveFieldsResponse> TYPE = new ActionType("indices:data/read/esql/resolve_fields");
    public static final RemoteClusterActionType<EsqlResolveFieldsResponse> RESOLVE_REMOTE_TYPE = new RemoteClusterActionType("indices:data/read/esql/resolve_fields", EsqlResolveFieldsResponse::new);
    private final TransportFieldCapabilitiesAction fieldCapsAction;

    @Inject
    public EsqlResolveFieldsAction(TransportService transportService, ActionFilters actionFilters, TransportFieldCapabilitiesAction fieldCapsAction) {
        super(NAME, transportService, actionFilters, FieldCapabilitiesRequest::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.fieldCapsAction = fieldCapsAction;
    }

    protected void doExecute(Task task, FieldCapabilitiesRequest request, ActionListener<EsqlResolveFieldsResponse> listener) {
        this.fieldCapsAction.executeRequest(task, request, (TransportFieldCapabilitiesAction.LinkedRequestExecutor)new TransportFieldCapabilitiesAction.LinkedRequestExecutor<EsqlResolveFieldsResponse>(this){

            public void executeRemoteRequest(TransportService transportService, Transport.Connection conn, FieldCapabilitiesRequest remoteRequest, ActionListenerResponseHandler<FieldCapabilitiesResponse> responseHandler) {
                transportService.sendRequest(conn, RESOLVE_REMOTE_TYPE.name(), (TransportRequest)remoteRequest, TransportRequestOptions.EMPTY, responseHandler);
            }

            public EsqlResolveFieldsResponse read(StreamInput in) throws IOException {
                return new EsqlResolveFieldsResponse(in);
            }

            public EsqlResolveFieldsResponse wrapPrimary(FieldCapabilitiesResponse primary) {
                return new EsqlResolveFieldsResponse(primary);
            }

            public FieldCapabilitiesResponse unwrapPrimary(EsqlResolveFieldsResponse esqlResolveFieldsResponse) {
                return esqlResolveFieldsResponse.caps();
            }
        }, listener);
    }
}

