/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.telemetry;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

public record Measurement(Number value, Map<String, Object> attributes, boolean isDouble) {
    public Measurement {
        Objects.requireNonNull(value);
    }

    public boolean isLong() {
        return !this.isDouble;
    }

    public double getDouble() {
        assert (this.isDouble);
        return this.value.doubleValue();
    }

    public long getLong() {
        assert (this.isLong());
        return this.value.longValue();
    }

    public static List<Measurement> combine(List<Measurement> measurements) {
        if (measurements == null || measurements.isEmpty()) {
            return Collections.emptyList();
        }
        boolean isDouble = measurements.get((int)0).isDouble;
        HashMap byAttr = new HashMap();
        measurements.forEach(m -> {
            if (m.isDouble != isDouble) {
                throw new IllegalArgumentException("cannot combine measurements of different types");
            }
            byAttr.compute(m.attributes, (k, v) -> {
                if (v == null) {
                    return m.value;
                }
                if (isDouble) {
                    return v.doubleValue() + m.getDouble();
                }
                return v.longValue() + m.getLong();
            });
        });
        return byAttr.entrySet().stream().map(entry -> new Measurement((Number)entry.getValue(), (Map)entry.getKey(), isDouble)).collect(Collectors.toList());
    }

    public static <T> List<T> getMeasurementValues(List<Measurement> measurements, Function<Measurement, T> getMeasurementValue) {
        ArrayList<T> measurementValues = new ArrayList<T>(measurements.size());
        for (Measurement measurement : measurements) {
            T measurementValue = getMeasurementValue.apply(measurement);
            measurementValues.add(measurementValue);
        }
        return measurementValues;
    }

    public static <Attr, T> Map<Attr, List<T>> groupMeasurementsByAttribute(List<Measurement> measurements, Function<Map<String, Object>, Attr> getAttribute, Function<Measurement, T> getMeasurementValue) {
        HashMap<Object, List> measurementsByNode = new HashMap<Object, List>();
        for (Measurement measurement : measurements) {
            Attr attr = getAttribute.apply(measurement.attributes());
            List nodeMeasurements = measurementsByNode.computeIfAbsent(attr, k -> new ArrayList());
            nodeMeasurements.add(getMeasurementValue.apply(measurement));
        }
        return measurementsByNode;
    }
}

