/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security;

import io.netty.channel.Channel;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpUtil;
import java.io.Closeable;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.net.InetSocketAddress;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.security.AccessController;
import java.security.Provider;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.ActionFilter;
import org.elasticsearch.action.support.DestructiveOperations;
import org.elasticsearch.action.support.UnsafePlainActionFuture;
import org.elasticsearch.bootstrap.BootstrapCheck;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.IndexTemplateMetadata;
import org.elasticsearch.cluster.metadata.ProjectId;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.project.ProjectResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.CheckedBiConsumer;
import org.elasticsearch.common.TriConsumer;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.logging.DeprecationCategory;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.network.NetworkModule;
import org.elasticsearch.common.network.NetworkService;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsFilter;
import org.elasticsearch.common.settings.SettingsModule;
import org.elasticsearch.common.ssl.KeyStoreUtil;
import org.elasticsearch.common.ssl.SslConfiguration;
import org.elasticsearch.common.transport.BoundTransportAddress;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.PageCacheRecycler;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.common.util.concurrent.ListenableFuture;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.common.util.concurrent.ThrottledTaskRunner;
import org.elasticsearch.common.util.iterable.Iterables;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.core.IOUtils;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Strings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.features.FeatureService;
import org.elasticsearch.features.NodeFeature;
import org.elasticsearch.http.HttpPreRequest;
import org.elasticsearch.http.HttpRequest;
import org.elasticsearch.http.HttpServerTransport;
import org.elasticsearch.http.netty4.Netty4HttpServerTransport;
import org.elasticsearch.http.netty4.internal.HttpHeadersAuthenticatorUtils;
import org.elasticsearch.http.netty4.internal.HttpValidator;
import org.elasticsearch.index.IndexModule;
import org.elasticsearch.index.shard.SearchOperationListener;
import org.elasticsearch.indices.IndicesQueryCache;
import org.elasticsearch.indices.SystemIndexDescriptor;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.ingest.Processor;
import org.elasticsearch.license.ClusterStateLicenseService;
import org.elasticsearch.license.License;
import org.elasticsearch.license.LicenseService;
import org.elasticsearch.license.LicensedFeature;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.node.PluginComponentBinding;
import org.elasticsearch.persistent.PersistentTasksExecutor;
import org.elasticsearch.persistent.PersistentTasksService;
import org.elasticsearch.plugins.ActionPlugin;
import org.elasticsearch.plugins.ClusterCoordinationPlugin;
import org.elasticsearch.plugins.ClusterPlugin;
import org.elasticsearch.plugins.ExtensiblePlugin;
import org.elasticsearch.plugins.FieldPredicate;
import org.elasticsearch.plugins.IngestPlugin;
import org.elasticsearch.plugins.MapperPlugin;
import org.elasticsearch.plugins.NetworkPlugin;
import org.elasticsearch.plugins.PersistentTaskPlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.plugins.ReloadablePlugin;
import org.elasticsearch.plugins.SearchPlugin;
import org.elasticsearch.plugins.SystemIndexPlugin;
import org.elasticsearch.plugins.interceptor.RestServerActionPlugin;
import org.elasticsearch.reservedstate.ReservedProjectStateHandler;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestHeaderDefinition;
import org.elasticsearch.rest.RestInterceptor;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.search.crossproject.CrossProjectModeDecider;
import org.elasticsearch.search.crossproject.ProjectRoutingResolver;
import org.elasticsearch.search.internal.ShardSearchRequest;
import org.elasticsearch.telemetry.TelemetryProvider;
import org.elasticsearch.threadpool.ExecutorBuilder;
import org.elasticsearch.threadpool.FixedExecutorBuilder;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.LinkedProjectConfigService;
import org.elasticsearch.transport.RemoteClusterSettings;
import org.elasticsearch.transport.Transport;
import org.elasticsearch.transport.TransportInterceptor;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestHandler;
import org.elasticsearch.transport.netty4.AcceptChannelHandler;
import org.elasticsearch.transport.netty4.SharedGroupFactory;
import org.elasticsearch.transport.netty4.TLSConfig;
import org.elasticsearch.watcher.ResourceWatcherService;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xpack.core.XPackPlugin;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.core.action.XPackInfoFeatureAction;
import org.elasticsearch.xpack.core.action.XPackUsageFeatureAction;
import org.elasticsearch.xpack.core.security.SecurityContext;
import org.elasticsearch.xpack.core.security.SecurityExtension;
import org.elasticsearch.xpack.core.security.SecurityField;
import org.elasticsearch.xpack.core.security.SecuritySettings;
import org.elasticsearch.xpack.core.security.action.ActionTypes;
import org.elasticsearch.xpack.core.security.action.ClearSecurityCacheAction;
import org.elasticsearch.xpack.core.security.action.DelegatePkiAuthenticationAction;
import org.elasticsearch.xpack.core.security.action.UpdateIndexMigrationVersionAction;
import org.elasticsearch.xpack.core.security.action.apikey.BulkUpdateApiKeyAction;
import org.elasticsearch.xpack.core.security.action.apikey.BulkUpdateApiKeyRequestTranslator;
import org.elasticsearch.xpack.core.security.action.apikey.CreateApiKeyAction;
import org.elasticsearch.xpack.core.security.action.apikey.CreateApiKeyRequestBuilderFactory;
import org.elasticsearch.xpack.core.security.action.apikey.CreateCrossClusterApiKeyAction;
import org.elasticsearch.xpack.core.security.action.apikey.GetApiKeyAction;
import org.elasticsearch.xpack.core.security.action.apikey.GrantApiKeyAction;
import org.elasticsearch.xpack.core.security.action.apikey.InvalidateApiKeyAction;
import org.elasticsearch.xpack.core.security.action.apikey.QueryApiKeyAction;
import org.elasticsearch.xpack.core.security.action.apikey.UpdateApiKeyAction;
import org.elasticsearch.xpack.core.security.action.apikey.UpdateApiKeyRequestTranslator;
import org.elasticsearch.xpack.core.security.action.apikey.UpdateCrossClusterApiKeyAction;
import org.elasticsearch.xpack.core.security.action.enrollment.KibanaEnrollmentAction;
import org.elasticsearch.xpack.core.security.action.enrollment.NodeEnrollmentAction;
import org.elasticsearch.xpack.core.security.action.oidc.OpenIdConnectAuthenticateAction;
import org.elasticsearch.xpack.core.security.action.oidc.OpenIdConnectLogoutAction;
import org.elasticsearch.xpack.core.security.action.oidc.OpenIdConnectPrepareAuthenticationAction;
import org.elasticsearch.xpack.core.security.action.privilege.ClearPrivilegesCacheAction;
import org.elasticsearch.xpack.core.security.action.privilege.DeletePrivilegesAction;
import org.elasticsearch.xpack.core.security.action.privilege.GetBuiltinPrivilegesAction;
import org.elasticsearch.xpack.core.security.action.privilege.GetBuiltinPrivilegesResponseTranslator;
import org.elasticsearch.xpack.core.security.action.privilege.GetPrivilegesAction;
import org.elasticsearch.xpack.core.security.action.privilege.PutPrivilegesAction;
import org.elasticsearch.xpack.core.security.action.profile.ActivateProfileAction;
import org.elasticsearch.xpack.core.security.action.profile.GetProfilesAction;
import org.elasticsearch.xpack.core.security.action.profile.SetProfileEnabledAction;
import org.elasticsearch.xpack.core.security.action.profile.SuggestProfilesAction;
import org.elasticsearch.xpack.core.security.action.profile.UpdateProfileDataAction;
import org.elasticsearch.xpack.core.security.action.realm.ClearRealmCacheAction;
import org.elasticsearch.xpack.core.security.action.role.BulkPutRoleRequestBuilderFactory;
import org.elasticsearch.xpack.core.security.action.role.ClearRolesCacheAction;
import org.elasticsearch.xpack.core.security.action.role.DeleteRoleAction;
import org.elasticsearch.xpack.core.security.action.role.GetRolesAction;
import org.elasticsearch.xpack.core.security.action.role.PutRoleAction;
import org.elasticsearch.xpack.core.security.action.role.PutRoleRequestBuilderFactory;
import org.elasticsearch.xpack.core.security.action.rolemapping.DeleteRoleMappingAction;
import org.elasticsearch.xpack.core.security.action.rolemapping.GetRoleMappingsAction;
import org.elasticsearch.xpack.core.security.action.rolemapping.PutRoleMappingAction;
import org.elasticsearch.xpack.core.security.action.saml.SamlAuthenticateAction;
import org.elasticsearch.xpack.core.security.action.saml.SamlInvalidateSessionAction;
import org.elasticsearch.xpack.core.security.action.saml.SamlLogoutAction;
import org.elasticsearch.xpack.core.security.action.saml.SamlPrepareAuthenticationAction;
import org.elasticsearch.xpack.core.security.action.saml.SamlSpMetadataAction;
import org.elasticsearch.xpack.core.security.action.service.CreateServiceAccountTokenAction;
import org.elasticsearch.xpack.core.security.action.service.DeleteServiceAccountTokenAction;
import org.elasticsearch.xpack.core.security.action.service.GetServiceAccountAction;
import org.elasticsearch.xpack.core.security.action.service.GetServiceAccountCredentialsAction;
import org.elasticsearch.xpack.core.security.action.service.GetServiceAccountNodesCredentialsAction;
import org.elasticsearch.xpack.core.security.action.settings.GetSecuritySettingsAction;
import org.elasticsearch.xpack.core.security.action.settings.UpdateSecuritySettingsAction;
import org.elasticsearch.xpack.core.security.action.stats.GetSecurityStatsAction;
import org.elasticsearch.xpack.core.security.action.token.CreateTokenAction;
import org.elasticsearch.xpack.core.security.action.token.InvalidateTokenAction;
import org.elasticsearch.xpack.core.security.action.token.RefreshTokenAction;
import org.elasticsearch.xpack.core.security.action.user.AuthenticateAction;
import org.elasticsearch.xpack.core.security.action.user.DeleteUserAction;
import org.elasticsearch.xpack.core.security.action.user.GetUserPrivilegesAction;
import org.elasticsearch.xpack.core.security.action.user.GetUsersAction;
import org.elasticsearch.xpack.core.security.action.user.HasPrivilegesAction;
import org.elasticsearch.xpack.core.security.action.user.HasPrivilegesRequestBuilderFactory;
import org.elasticsearch.xpack.core.security.action.user.ProfileHasPrivilegesAction;
import org.elasticsearch.xpack.core.security.action.user.PutUserAction;
import org.elasticsearch.xpack.core.security.authc.Authentication;
import org.elasticsearch.xpack.core.security.authc.AuthenticationFailureHandler;
import org.elasticsearch.xpack.core.security.authc.AuthenticationServiceField;
import org.elasticsearch.xpack.core.security.authc.CustomAuthenticator;
import org.elasticsearch.xpack.core.security.authc.DefaultAuthenticationFailureHandler;
import org.elasticsearch.xpack.core.security.authc.InternalRealmsSettings;
import org.elasticsearch.xpack.core.security.authc.Realm;
import org.elasticsearch.xpack.core.security.authc.RealmConfig;
import org.elasticsearch.xpack.core.security.authc.RealmSettings;
import org.elasticsearch.xpack.core.security.authc.Subject;
import org.elasticsearch.xpack.core.security.authc.service.NodeLocalServiceAccountTokenStore;
import org.elasticsearch.xpack.core.security.authc.service.ServiceAccountTokenStore;
import org.elasticsearch.xpack.core.security.authc.support.UserRoleMapper;
import org.elasticsearch.xpack.core.security.authz.AuthorizationEngine;
import org.elasticsearch.xpack.core.security.authz.AuthorizationServiceField;
import org.elasticsearch.xpack.core.security.authz.AuthorizedProjectsResolver;
import org.elasticsearch.xpack.core.security.authz.RestrictedIndices;
import org.elasticsearch.xpack.core.security.authz.RoleDescriptor;
import org.elasticsearch.xpack.core.security.authz.accesscontrol.DocumentSubsetBitsetCache;
import org.elasticsearch.xpack.core.security.authz.accesscontrol.IndicesAccessControl;
import org.elasticsearch.xpack.core.security.authz.accesscontrol.SecurityIndexReaderWrapper;
import org.elasticsearch.xpack.core.security.authz.permission.FieldPermissions;
import org.elasticsearch.xpack.core.security.authz.permission.FieldPermissionsCache;
import org.elasticsearch.xpack.core.security.authz.permission.SimpleRole;
import org.elasticsearch.xpack.core.security.authz.store.ReservedRolesStore;
import org.elasticsearch.xpack.core.security.authz.store.RoleRetrievalResult;
import org.elasticsearch.xpack.core.security.support.Automatons;
import org.elasticsearch.xpack.core.security.user.AnonymousUser;
import org.elasticsearch.xpack.core.ssl.SSLConfigurationSettings;
import org.elasticsearch.xpack.core.ssl.SSLService;
import org.elasticsearch.xpack.core.ssl.SslProfile;
import org.elasticsearch.xpack.core.ssl.TransportTLSBootstrapCheck;
import org.elasticsearch.xpack.core.ssl.action.GetCertificateInfoAction;
import org.elasticsearch.xpack.core.ssl.action.TransportGetCertificateInfoAction;
import org.elasticsearch.xpack.core.ssl.rest.RestGetCertificateInfoAction;
import org.elasticsearch.xpack.security.InitialNodeSecurityAutoConfiguration;
import org.elasticsearch.xpack.security.PkiRealmBootstrapCheck;
import org.elasticsearch.xpack.security.SecurityInfoTransportAction;
import org.elasticsearch.xpack.security.SecurityUsageServices;
import org.elasticsearch.xpack.security.SecurityUsageTransportAction;
import org.elasticsearch.xpack.security.TokenSSLBootstrapCheck;
import org.elasticsearch.xpack.security.action.TransportClearSecurityCacheAction;
import org.elasticsearch.xpack.security.action.TransportDelegatePkiAuthenticationAction;
import org.elasticsearch.xpack.security.action.apikey.TransportBulkUpdateApiKeyAction;
import org.elasticsearch.xpack.security.action.apikey.TransportCreateApiKeyAction;
import org.elasticsearch.xpack.security.action.apikey.TransportCreateCrossClusterApiKeyAction;
import org.elasticsearch.xpack.security.action.apikey.TransportGetApiKeyAction;
import org.elasticsearch.xpack.security.action.apikey.TransportGrantApiKeyAction;
import org.elasticsearch.xpack.security.action.apikey.TransportInvalidateApiKeyAction;
import org.elasticsearch.xpack.security.action.apikey.TransportQueryApiKeyAction;
import org.elasticsearch.xpack.security.action.apikey.TransportUpdateApiKeyAction;
import org.elasticsearch.xpack.security.action.apikey.TransportUpdateCrossClusterApiKeyAction;
import org.elasticsearch.xpack.security.action.enrollment.TransportKibanaEnrollmentAction;
import org.elasticsearch.xpack.security.action.enrollment.TransportNodeEnrollmentAction;
import org.elasticsearch.xpack.security.action.filter.SecurityActionFilter;
import org.elasticsearch.xpack.security.action.oidc.TransportOpenIdConnectAuthenticateAction;
import org.elasticsearch.xpack.security.action.oidc.TransportOpenIdConnectLogoutAction;
import org.elasticsearch.xpack.security.action.oidc.TransportOpenIdConnectPrepareAuthenticationAction;
import org.elasticsearch.xpack.security.action.privilege.TransportClearPrivilegesCacheAction;
import org.elasticsearch.xpack.security.action.privilege.TransportDeletePrivilegesAction;
import org.elasticsearch.xpack.security.action.privilege.TransportGetBuiltinPrivilegesAction;
import org.elasticsearch.xpack.security.action.privilege.TransportGetPrivilegesAction;
import org.elasticsearch.xpack.security.action.privilege.TransportPutPrivilegesAction;
import org.elasticsearch.xpack.security.action.profile.TransportActivateProfileAction;
import org.elasticsearch.xpack.security.action.profile.TransportGetProfilesAction;
import org.elasticsearch.xpack.security.action.profile.TransportProfileHasPrivilegesAction;
import org.elasticsearch.xpack.security.action.profile.TransportSetProfileEnabledAction;
import org.elasticsearch.xpack.security.action.profile.TransportSuggestProfilesAction;
import org.elasticsearch.xpack.security.action.profile.TransportUpdateProfileDataAction;
import org.elasticsearch.xpack.security.action.realm.TransportClearRealmCacheAction;
import org.elasticsearch.xpack.security.action.role.TransportBulkDeleteRolesAction;
import org.elasticsearch.xpack.security.action.role.TransportBulkPutRolesAction;
import org.elasticsearch.xpack.security.action.role.TransportClearRolesCacheAction;
import org.elasticsearch.xpack.security.action.role.TransportDeleteRoleAction;
import org.elasticsearch.xpack.security.action.role.TransportGetRolesAction;
import org.elasticsearch.xpack.security.action.role.TransportPutRoleAction;
import org.elasticsearch.xpack.security.action.role.TransportQueryRoleAction;
import org.elasticsearch.xpack.security.action.rolemapping.ReservedRoleMappingAction;
import org.elasticsearch.xpack.security.action.rolemapping.TransportDeleteRoleMappingAction;
import org.elasticsearch.xpack.security.action.rolemapping.TransportGetRoleMappingsAction;
import org.elasticsearch.xpack.security.action.rolemapping.TransportPutRoleMappingAction;
import org.elasticsearch.xpack.security.action.saml.TransportSamlAuthenticateAction;
import org.elasticsearch.xpack.security.action.saml.TransportSamlCompleteLogoutAction;
import org.elasticsearch.xpack.security.action.saml.TransportSamlInvalidateSessionAction;
import org.elasticsearch.xpack.security.action.saml.TransportSamlLogoutAction;
import org.elasticsearch.xpack.security.action.saml.TransportSamlPrepareAuthenticationAction;
import org.elasticsearch.xpack.security.action.saml.TransportSamlSpMetadataAction;
import org.elasticsearch.xpack.security.action.service.TransportCreateServiceAccountTokenAction;
import org.elasticsearch.xpack.security.action.service.TransportDeleteServiceAccountTokenAction;
import org.elasticsearch.xpack.security.action.service.TransportGetServiceAccountAction;
import org.elasticsearch.xpack.security.action.service.TransportGetServiceAccountCredentialsAction;
import org.elasticsearch.xpack.security.action.service.TransportGetServiceAccountNodesCredentialsAction;
import org.elasticsearch.xpack.security.action.settings.TransportGetSecuritySettingsAction;
import org.elasticsearch.xpack.security.action.settings.TransportReloadRemoteClusterCredentialsAction;
import org.elasticsearch.xpack.security.action.settings.TransportUpdateSecuritySettingsAction;
import org.elasticsearch.xpack.security.action.stats.TransportSecurityStatsAction;
import org.elasticsearch.xpack.security.action.token.TransportCreateTokenAction;
import org.elasticsearch.xpack.security.action.token.TransportInvalidateTokenAction;
import org.elasticsearch.xpack.security.action.token.TransportRefreshTokenAction;
import org.elasticsearch.xpack.security.action.user.TransportAuthenticateAction;
import org.elasticsearch.xpack.security.action.user.TransportChangePasswordAction;
import org.elasticsearch.xpack.security.action.user.TransportDeleteUserAction;
import org.elasticsearch.xpack.security.action.user.TransportGetUserPrivilegesAction;
import org.elasticsearch.xpack.security.action.user.TransportGetUsersAction;
import org.elasticsearch.xpack.security.action.user.TransportHasPrivilegesAction;
import org.elasticsearch.xpack.security.action.user.TransportPutUserAction;
import org.elasticsearch.xpack.security.action.user.TransportQueryUserAction;
import org.elasticsearch.xpack.security.action.user.TransportSetEnabledAction;
import org.elasticsearch.xpack.security.audit.AuditTrailService;
import org.elasticsearch.xpack.security.audit.logfile.LoggingAuditTrail;
import org.elasticsearch.xpack.security.authc.ApiKeyService;
import org.elasticsearch.xpack.security.authc.AuthenticationService;
import org.elasticsearch.xpack.security.authc.InternalRealms;
import org.elasticsearch.xpack.security.authc.PluggableAuthenticatorChain;
import org.elasticsearch.xpack.security.authc.Realms;
import org.elasticsearch.xpack.security.authc.RemoteClusterAuthenticationService;
import org.elasticsearch.xpack.security.authc.TokenService;
import org.elasticsearch.xpack.security.authc.esnative.NativeUsersStore;
import org.elasticsearch.xpack.security.authc.esnative.ReservedRealm;
import org.elasticsearch.xpack.security.authc.saml.SamlAuthenticateResponseHandler;
import org.elasticsearch.xpack.security.authc.service.CachingServiceAccountTokenStore;
import org.elasticsearch.xpack.security.authc.service.CompositeServiceAccountTokenStore;
import org.elasticsearch.xpack.security.authc.service.FileServiceAccountTokenStore;
import org.elasticsearch.xpack.security.authc.service.IndexServiceAccountTokenStore;
import org.elasticsearch.xpack.security.authc.service.ServiceAccountService;
import org.elasticsearch.xpack.security.authc.support.SecondaryAuthActions;
import org.elasticsearch.xpack.security.authc.support.SecondaryAuthenticator;
import org.elasticsearch.xpack.security.authc.support.mapper.CompositeRoleMapper;
import org.elasticsearch.xpack.security.authc.support.mapper.NativeRoleMappingStore;
import org.elasticsearch.xpack.security.authc.support.mapper.ProjectStateRoleMapper;
import org.elasticsearch.xpack.security.authz.AuthorizationDenialMessages;
import org.elasticsearch.xpack.security.authz.AuthorizationService;
import org.elasticsearch.xpack.security.authz.DlsFlsRequestCacheDifferentiator;
import org.elasticsearch.xpack.security.authz.FileRoleValidator;
import org.elasticsearch.xpack.security.authz.ReservedRoleNameChecker;
import org.elasticsearch.xpack.security.authz.SecuritySearchOperationListener;
import org.elasticsearch.xpack.security.authz.accesscontrol.OptOutQueryCache;
import org.elasticsearch.xpack.security.authz.interceptor.BulkShardRequestInterceptor;
import org.elasticsearch.xpack.security.authz.interceptor.DlsFlsLicenseRequestInterceptor;
import org.elasticsearch.xpack.security.authz.interceptor.IndicesAliasesRequestInterceptor;
import org.elasticsearch.xpack.security.authz.interceptor.RequestInterceptor;
import org.elasticsearch.xpack.security.authz.interceptor.ResizeRequestInterceptor;
import org.elasticsearch.xpack.security.authz.interceptor.SearchRequestCacheDisablingInterceptor;
import org.elasticsearch.xpack.security.authz.interceptor.SearchRequestInterceptor;
import org.elasticsearch.xpack.security.authz.interceptor.ShardSearchRequestInterceptor;
import org.elasticsearch.xpack.security.authz.interceptor.UpdateRequestInterceptor;
import org.elasticsearch.xpack.security.authz.interceptor.ValidateRequestInterceptor;
import org.elasticsearch.xpack.security.authz.store.CompositeRolesStore;
import org.elasticsearch.xpack.security.authz.store.DeprecationRoleDescriptorConsumer;
import org.elasticsearch.xpack.security.authz.store.FileRolesStore;
import org.elasticsearch.xpack.security.authz.store.NativePrivilegeStore;
import org.elasticsearch.xpack.security.authz.store.NativeRolesStore;
import org.elasticsearch.xpack.security.authz.store.RoleProviders;
import org.elasticsearch.xpack.security.ingest.SetSecurityUserProcessor;
import org.elasticsearch.xpack.security.operator.DefaultOperatorOnlyRegistry;
import org.elasticsearch.xpack.security.operator.FileOperatorUsersStore;
import org.elasticsearch.xpack.security.operator.OperatorOnlyRegistry;
import org.elasticsearch.xpack.security.operator.OperatorPrivileges;
import org.elasticsearch.xpack.security.profile.ProfileService;
import org.elasticsearch.xpack.security.rest.RemoteHostHeader;
import org.elasticsearch.xpack.security.rest.SecurityRestFilter;
import org.elasticsearch.xpack.security.rest.action.RestAuthenticateAction;
import org.elasticsearch.xpack.security.rest.action.RestDelegatePkiAuthenticationAction;
import org.elasticsearch.xpack.security.rest.action.apikey.RestBulkUpdateApiKeyAction;
import org.elasticsearch.xpack.security.rest.action.apikey.RestClearApiKeyCacheAction;
import org.elasticsearch.xpack.security.rest.action.apikey.RestCreateApiKeyAction;
import org.elasticsearch.xpack.security.rest.action.apikey.RestCreateCrossClusterApiKeyAction;
import org.elasticsearch.xpack.security.rest.action.apikey.RestGetApiKeyAction;
import org.elasticsearch.xpack.security.rest.action.apikey.RestGrantApiKeyAction;
import org.elasticsearch.xpack.security.rest.action.apikey.RestInvalidateApiKeyAction;
import org.elasticsearch.xpack.security.rest.action.apikey.RestQueryApiKeyAction;
import org.elasticsearch.xpack.security.rest.action.apikey.RestUpdateApiKeyAction;
import org.elasticsearch.xpack.security.rest.action.apikey.RestUpdateCrossClusterApiKeyAction;
import org.elasticsearch.xpack.security.rest.action.enrollment.RestKibanaEnrollAction;
import org.elasticsearch.xpack.security.rest.action.enrollment.RestNodeEnrollmentAction;
import org.elasticsearch.xpack.security.rest.action.oauth2.RestGetTokenAction;
import org.elasticsearch.xpack.security.rest.action.oauth2.RestInvalidateTokenAction;
import org.elasticsearch.xpack.security.rest.action.oidc.RestOpenIdConnectAuthenticateAction;
import org.elasticsearch.xpack.security.rest.action.oidc.RestOpenIdConnectLogoutAction;
import org.elasticsearch.xpack.security.rest.action.oidc.RestOpenIdConnectPrepareAuthenticationAction;
import org.elasticsearch.xpack.security.rest.action.privilege.RestClearPrivilegesCacheAction;
import org.elasticsearch.xpack.security.rest.action.privilege.RestDeletePrivilegesAction;
import org.elasticsearch.xpack.security.rest.action.privilege.RestGetBuiltinPrivilegesAction;
import org.elasticsearch.xpack.security.rest.action.privilege.RestGetPrivilegesAction;
import org.elasticsearch.xpack.security.rest.action.privilege.RestPutPrivilegesAction;
import org.elasticsearch.xpack.security.rest.action.profile.RestActivateProfileAction;
import org.elasticsearch.xpack.security.rest.action.profile.RestDisableProfileAction;
import org.elasticsearch.xpack.security.rest.action.profile.RestEnableProfileAction;
import org.elasticsearch.xpack.security.rest.action.profile.RestGetProfilesAction;
import org.elasticsearch.xpack.security.rest.action.profile.RestSuggestProfilesAction;
import org.elasticsearch.xpack.security.rest.action.profile.RestUpdateProfileDataAction;
import org.elasticsearch.xpack.security.rest.action.realm.RestClearRealmCacheAction;
import org.elasticsearch.xpack.security.rest.action.role.RestBulkDeleteRolesAction;
import org.elasticsearch.xpack.security.rest.action.role.RestBulkPutRolesAction;
import org.elasticsearch.xpack.security.rest.action.role.RestClearRolesCacheAction;
import org.elasticsearch.xpack.security.rest.action.role.RestDeleteRoleAction;
import org.elasticsearch.xpack.security.rest.action.role.RestGetRolesAction;
import org.elasticsearch.xpack.security.rest.action.role.RestPutRoleAction;
import org.elasticsearch.xpack.security.rest.action.role.RestQueryRoleAction;
import org.elasticsearch.xpack.security.rest.action.rolemapping.RestDeleteRoleMappingAction;
import org.elasticsearch.xpack.security.rest.action.rolemapping.RestGetRoleMappingsAction;
import org.elasticsearch.xpack.security.rest.action.rolemapping.RestPutRoleMappingAction;
import org.elasticsearch.xpack.security.rest.action.saml.RestSamlAuthenticateAction;
import org.elasticsearch.xpack.security.rest.action.saml.RestSamlCompleteLogoutAction;
import org.elasticsearch.xpack.security.rest.action.saml.RestSamlInvalidateSessionAction;
import org.elasticsearch.xpack.security.rest.action.saml.RestSamlLogoutAction;
import org.elasticsearch.xpack.security.rest.action.saml.RestSamlPrepareAuthenticationAction;
import org.elasticsearch.xpack.security.rest.action.saml.RestSamlSpMetadataAction;
import org.elasticsearch.xpack.security.rest.action.service.RestClearServiceAccountTokenStoreCacheAction;
import org.elasticsearch.xpack.security.rest.action.service.RestCreateServiceAccountTokenAction;
import org.elasticsearch.xpack.security.rest.action.service.RestDeleteServiceAccountTokenAction;
import org.elasticsearch.xpack.security.rest.action.service.RestGetServiceAccountAction;
import org.elasticsearch.xpack.security.rest.action.service.RestGetServiceAccountCredentialsAction;
import org.elasticsearch.xpack.security.rest.action.settings.RestGetSecuritySettingsAction;
import org.elasticsearch.xpack.security.rest.action.settings.RestUpdateSecuritySettingsAction;
import org.elasticsearch.xpack.security.rest.action.stats.RestSecurityStatsAction;
import org.elasticsearch.xpack.security.rest.action.user.RestChangePasswordAction;
import org.elasticsearch.xpack.security.rest.action.user.RestDeleteUserAction;
import org.elasticsearch.xpack.security.rest.action.user.RestGetUserPrivilegesAction;
import org.elasticsearch.xpack.security.rest.action.user.RestGetUsersAction;
import org.elasticsearch.xpack.security.rest.action.user.RestHasPrivilegesAction;
import org.elasticsearch.xpack.security.rest.action.user.RestProfileHasPrivilegesAction;
import org.elasticsearch.xpack.security.rest.action.user.RestPutUserAction;
import org.elasticsearch.xpack.security.rest.action.user.RestQueryUserAction;
import org.elasticsearch.xpack.security.rest.action.user.RestSetEnabledAction;
import org.elasticsearch.xpack.security.support.CacheInvalidatorRegistry;
import org.elasticsearch.xpack.security.support.ExtensionComponents;
import org.elasticsearch.xpack.security.support.QueryableBuiltInRolesProviderFactory;
import org.elasticsearch.xpack.security.support.QueryableBuiltInRolesSynchronizer;
import org.elasticsearch.xpack.security.support.ReloadableSecurityComponent;
import org.elasticsearch.xpack.security.support.SecurityIndexManager;
import org.elasticsearch.xpack.security.support.SecurityMigrations;
import org.elasticsearch.xpack.security.support.SecuritySystemIndices;
import org.elasticsearch.xpack.security.transport.CrossClusterAccessSecurityExtension;
import org.elasticsearch.xpack.security.transport.RemoteClusterTransportInterceptor;
import org.elasticsearch.xpack.security.transport.SSLEngineUtils;
import org.elasticsearch.xpack.security.transport.SecurityHttpSettings;
import org.elasticsearch.xpack.security.transport.SecurityServerTransportInterceptor;
import org.elasticsearch.xpack.security.transport.extension.RemoteClusterSecurityComponents;
import org.elasticsearch.xpack.security.transport.extension.RemoteClusterSecurityExtension;
import org.elasticsearch.xpack.security.transport.filter.IPFilter;
import org.elasticsearch.xpack.security.transport.netty4.SecurityNetty4ServerTransport;

public class Security
extends Plugin
implements SystemIndexPlugin,
IngestPlugin,
NetworkPlugin,
ClusterPlugin,
ClusterCoordinationPlugin,
MapperPlugin,
ExtensiblePlugin,
SearchPlugin,
RestServerActionPlugin,
ReloadablePlugin,
PersistentTaskPlugin {
    public static final String SECURITY_CRYPTO_THREAD_POOL_NAME = "security-crypto";
    public static final LicensedFeature.Momentary IP_FILTERING_FEATURE = LicensedFeature.momentaryLenient(null, (String)"security-ip-filtering", (License.OperationMode)License.OperationMode.GOLD);
    public static final LicensedFeature.Momentary AUDITING_FEATURE = LicensedFeature.momentary(null, (String)"security-auditing", (License.OperationMode)License.OperationMode.GOLD);
    public static final LicensedFeature.Momentary TOKEN_SERVICE_FEATURE = LicensedFeature.momentary(null, (String)"security-token-service", (License.OperationMode)License.OperationMode.STANDARD);
    private static final String REALMS_FEATURE_FAMILY = "security-realms";
    public static final LicensedFeature.Persistent LDAP_REALM_FEATURE = LicensedFeature.persistent((String)"security-realms", (String)"ldap", (License.OperationMode)License.OperationMode.GOLD);
    public static final LicensedFeature.Persistent AD_REALM_FEATURE = LicensedFeature.persistent((String)"security-realms", (String)"active-directory", (License.OperationMode)License.OperationMode.GOLD);
    public static final LicensedFeature.Persistent PKI_REALM_FEATURE = LicensedFeature.persistent((String)"security-realms", (String)"pki", (License.OperationMode)License.OperationMode.GOLD);
    public static final LicensedFeature.Persistent SAML_REALM_FEATURE = LicensedFeature.persistent((String)"security-realms", (String)"saml", (License.OperationMode)License.OperationMode.PLATINUM);
    public static final LicensedFeature.Persistent OIDC_REALM_FEATURE = LicensedFeature.persistent((String)"security-realms", (String)"oidc", (License.OperationMode)License.OperationMode.PLATINUM);
    public static final LicensedFeature.Persistent JWT_REALM_FEATURE = LicensedFeature.persistent((String)"security-realms", (String)"jwt", (License.OperationMode)License.OperationMode.PLATINUM);
    public static final LicensedFeature.Persistent KERBEROS_REALM_FEATURE = LicensedFeature.persistent((String)"security-realms", (String)"kerberos", (License.OperationMode)License.OperationMode.PLATINUM);
    public static final LicensedFeature.Persistent CUSTOM_REALMS_FEATURE = LicensedFeature.persistent((String)"security-realms", (String)"custom", (License.OperationMode)License.OperationMode.PLATINUM);
    public static final LicensedFeature.Momentary DELEGATED_AUTHORIZATION_FEATURE = LicensedFeature.momentary(null, (String)"security-delegated-authorization", (License.OperationMode)License.OperationMode.PLATINUM);
    public static final LicensedFeature.Momentary AUTHORIZATION_ENGINE_FEATURE = LicensedFeature.momentary(null, (String)"security-authorization-engine", (License.OperationMode)License.OperationMode.PLATINUM);
    public static final LicensedFeature.Persistent CUSTOM_ROLE_PROVIDERS_FEATURE = LicensedFeature.persistent(null, (String)"security-roles-provider", (License.OperationMode)License.OperationMode.PLATINUM);
    public static final LicensedFeature.Momentary OPERATOR_PRIVILEGES_FEATURE = LicensedFeature.momentary(null, (String)"operator-privileges", (License.OperationMode)License.OperationMode.ENTERPRISE);
    public static final LicensedFeature.Momentary USER_PROFILE_COLLABORATION_FEATURE = LicensedFeature.momentary(null, (String)"user-profile-collaboration", (License.OperationMode)License.OperationMode.STANDARD);
    public static final LicensedFeature.Momentary ADVANCED_REMOTE_CLUSTER_SECURITY_FEATURE = LicensedFeature.momentary(null, (String)"advanced-remote-cluster-security", (License.OperationMode)License.OperationMode.ENTERPRISE);
    private static final Logger logger = LogManager.getLogger(Security.class);
    private Settings settings;
    private final boolean enabled;
    private final SetOnce<Boolean> dlsFlsEnabled = new SetOnce();
    private final SecuritySystemIndices systemIndices;
    private final ListenableFuture<Void> nodeStartedListenable;
    private final SetOnce<TransportInterceptor> securityInterceptor = new SetOnce();
    private final SetOnce<IPFilter> ipFilter = new SetOnce();
    private final SetOnce<AuthenticationService> authcService = new SetOnce();
    private final SetOnce<SecondaryAuthenticator> secondayAuthc = new SetOnce();
    private final SetOnce<AuditTrailService> auditTrailService = new SetOnce();
    private final SetOnce<SecurityContext> securityContext = new SetOnce();
    private final SetOnce<ThreadContext> threadContext = new SetOnce();
    private final SetOnce<TokenService> tokenService = new SetOnce();
    private final SetOnce<SecurityActionFilter> securityActionFilter = new SetOnce();
    private final SetOnce<SharedGroupFactory> sharedGroupFactory = new SetOnce();
    private final SetOnce<DocumentSubsetBitsetCache> dlsBitsetCache = new SetOnce();
    private final SetOnce<List<BootstrapCheck>> bootstrapChecks = new SetOnce();
    private final List<SecurityExtension> securityExtensions = new ArrayList<SecurityExtension>();
    private final SetOnce<Transport> transportReference = new SetOnce();
    private final SetOnce<ScriptService> scriptServiceReference = new SetOnce();
    private final SetOnce<OperatorOnlyRegistry> operatorOnlyRegistry = new SetOnce();
    private final SetOnce<PutRoleRequestBuilderFactory> putRoleRequestBuilderFactory = new SetOnce();
    private final SetOnce<BulkPutRoleRequestBuilderFactory> bulkPutRoleRequestBuilderFactory = new SetOnce();
    private final SetOnce<CreateApiKeyRequestBuilderFactory> createApiKeyRequestBuilderFactory = new SetOnce();
    private final SetOnce<UpdateApiKeyRequestTranslator> updateApiKeyRequestTranslator = new SetOnce();
    private final SetOnce<BulkUpdateApiKeyRequestTranslator> bulkUpdateApiKeyRequestTranslator = new SetOnce();
    private final SetOnce<RestGrantApiKeyAction.RequestTranslator> grantApiKeyRequestTranslator = new SetOnce();
    private final SetOnce<GetBuiltinPrivilegesResponseTranslator> getBuiltinPrivilegesResponseTranslator = new SetOnce();
    private final SetOnce<HasPrivilegesRequestBuilderFactory> hasPrivilegesRequestBuilderFactory = new SetOnce();
    private final SetOnce<FileRolesStore> fileRolesStore = new SetOnce();
    private final SetOnce<OperatorPrivileges.OperatorPrivilegesService> operatorPrivilegesService = new SetOnce();
    private final SetOnce<ReservedRoleMappingAction> reservedRoleMappingAction = new SetOnce();
    private final SetOnce<Realms> realms = new SetOnce();
    private final SetOnce<Client> client = new SetOnce();
    private final SetOnce<List<ReloadableSecurityComponent>> reloadableComponents = new SetOnce();
    private final SetOnce<AuthorizationDenialMessages> authorizationDenialMessages = new SetOnce();
    private final SetOnce<ReservedRoleNameChecker.Factory> reservedRoleNameCheckerFactory = new SetOnce();
    private final SetOnce<FileRoleValidator> fileRoleValidator = new SetOnce();
    private final SetOnce<SecondaryAuthActions> secondaryAuthActions = new SetOnce();
    private final SetOnce<QueryableBuiltInRolesProviderFactory> queryableRolesProviderFactory = new SetOnce();
    private final SetOnce<SamlAuthenticateResponseHandler.Factory> samlAuthenticateResponseHandlerFactory = new SetOnce();
    private final SetOnce<RemoteClusterSecurityExtension.Provider> remoteClusterSecurityExtensionProvider = new SetOnce();
    private final SetOnce<RemoteClusterSecurityExtension> remoteClusterSecurityExtension = new SetOnce();
    private final SetOnce<RemoteClusterAuthenticationService> remoteClusterAuthenticationService = new SetOnce();
    private final SetOnce<SecurityMigrations.Manager> migrationManager = new SetOnce();
    private final SetOnce<List<Closeable>> closableComponents = new SetOnce();

    public Security(Settings settings) {
        this(settings, Collections.emptyList());
    }

    Security(Settings settings, List<SecurityExtension> extensions) {
        this.settings = settings;
        this.enabled = (Boolean)XPackSettings.SECURITY_ENABLED.get(settings);
        this.systemIndices = new SecuritySystemIndices(settings);
        this.nodeStartedListenable = new ListenableFuture();
        if (this.enabled) {
            Security.runStartupChecks(settings);
            Automatons.updateConfiguration((Settings)settings);
        } else {
            this.ensureNoRemoteClusterCredentialsOnDisabledSecurity(settings);
            this.bootstrapChecks.set(Collections.emptyList());
        }
        this.securityExtensions.addAll(extensions);
    }

    private void ensureNoRemoteClusterCredentialsOnDisabledSecurity(Settings settings) {
        assert (!this.enabled);
        List<String> remoteClusterCredentialsSettingKeys = RemoteClusterSettings.REMOTE_CLUSTER_CREDENTIALS.getAllConcreteSettings(settings).map(Setting::getKey).sorted().toList();
        if (!remoteClusterCredentialsSettingKeys.isEmpty()) {
            throw new IllegalArgumentException(Strings.format((String)"Found [%s] remote clusters with credentials [%s]. Security [%s] must be enabled to connect to them. Please either enable security or remove these settings from the keystore.", (Object[])new Object[]{remoteClusterCredentialsSettingKeys.size(), org.elasticsearch.common.Strings.collectionToCommaDelimitedString(remoteClusterCredentialsSettingKeys), XPackSettings.SECURITY_ENABLED.getKey()}));
        }
    }

    private static void runStartupChecks(Settings settings) {
        Security.validateRealmSettings(settings);
        if (((Boolean)XPackSettings.FIPS_MODE_ENABLED.get(settings)).booleanValue()) {
            Security.validateForFips(settings);
        }
    }

    protected Clock getClock() {
        return Clock.systemUTC();
    }

    protected SSLService getSslService() {
        return XPackPlugin.getSharedSslService();
    }

    protected LicenseService getLicenseService() {
        return XPackPlugin.getSharedLicenseService();
    }

    protected XPackLicenseState getLicenseState() {
        return XPackPlugin.getSharedLicenseState();
    }

    protected Client getClient() {
        return (Client)this.client.get();
    }

    protected List<ReloadableSecurityComponent> getReloadableSecurityComponents() {
        return (List)this.reloadableComponents.get();
    }

    public static Path resolveSecuredConfigFile(Environment env, String file) {
        Path legacyConfig;
        Path config = env.configDir().resolve(file);
        if (!AccessController.doPrivileged(() -> Files.exists(config, new LinkOption[0])).booleanValue() && AccessController.doPrivileged(() -> Security.lambda$resolveSecuredConfigFile$1(legacyConfig = env.configDir().resolve("x-pack").resolve(file))).booleanValue()) {
            DeprecationLogger.getLogger(XPackPlugin.class).warn(DeprecationCategory.OTHER, "config_file_path", "Config file [" + file + "] is in a deprecated location. Move from " + String.valueOf(legacyConfig) + " to " + String.valueOf(config), new Object[0]);
            return legacyConfig;
        }
        return config;
    }

    public Collection<?> createComponents(Plugin.PluginServices services) {
        try {
            return this.createComponents(services.client(), services.threadPool(), services.clusterService(), services.featureService(), services.resourceWatcherService(), services.scriptService(), services.xContentRegistry(), services.environment(), services.indexNameExpressionResolver(), services.telemetryProvider(), new PersistentTasksService(services.clusterService(), services.threadPool(), services.client()), services.linkedProjectConfigService(), services.projectResolver(), services.projectRoutingResolver());
        }
        catch (Exception e) {
            throw new IllegalStateException("security initialization failed", e);
        }
    }

    Collection<Object> createComponents(Client client, ThreadPool threadPool, ClusterService clusterService, FeatureService featureService, ResourceWatcherService resourceWatcherService, ScriptService scriptService, NamedXContentRegistry xContentRegistry, Environment environment, IndexNameExpressionResolver expressionResolver, TelemetryProvider telemetryProvider, PersistentTasksService persistentTasksService, LinkedProjectConfigService linkedProjectConfigService, ProjectResolver projectResolver, ProjectRoutingResolver projectRoutingResolver) throws Exception {
        logger.info("Security is {}", (Object)(this.enabled ? "enabled" : "disabled"));
        if (!this.enabled) {
            return Collections.singletonList(new SecurityUsageServices(null, null, null, null, null, null));
        }
        this.client.set((Object)client);
        this.settings = environment.settings();
        this.systemIndices.init(client, featureService, clusterService, projectResolver);
        this.migrationManager.set((Object)new SecurityMigrations.Manager(clusterService, persistentTasksService, this.systemIndices));
        this.scriptServiceReference.set((Object)scriptService);
        ArrayList<BootstrapCheck> checks = new ArrayList<BootstrapCheck>();
        Collections.addAll(checks, new TokenSSLBootstrapCheck(), new PkiRealmBootstrapCheck(this.getSslService()), new TransportTLSBootstrapCheck());
        checks.addAll(InternalRealms.getBootstrapChecks(this.settings, environment));
        this.bootstrapChecks.set(Collections.unmodifiableList(checks));
        this.threadContext.set((Object)threadPool.getThreadContext());
        ArrayList<Object> components = new ArrayList<Object>();
        this.securityContext.set((Object)new SecurityContext(this.settings, threadPool.getThreadContext()));
        components.add(this.securityContext.get());
        RestrictedIndices restrictedIndices = new RestrictedIndices(expressionResolver);
        LoggingAuditTrail auditTrail = (Boolean)XPackSettings.AUDIT_ENABLED.get(this.settings) != false ? new LoggingAuditTrail(this.settings, clusterService, threadPool) : null;
        AuditTrailService auditTrailService = new AuditTrailService(auditTrail, this.getLicenseState());
        components.add(auditTrailService);
        this.auditTrailService.set((Object)auditTrailService);
        TokenService tokenService = new TokenService(this.settings, Clock.systemUTC(), client, this.getLicenseState(), (SecurityContext)this.securityContext.get(), this.systemIndices.getMainIndexManager(), this.systemIndices.getTokenIndexManager(), clusterService);
        this.tokenService.set((Object)tokenService);
        components.add(tokenService);
        NativeUsersStore nativeUsersStore = new NativeUsersStore(this.settings, client, this.systemIndices.getMainIndexManager());
        NativeRoleMappingStore nativeRoleMappingStore = new NativeRoleMappingStore(this.settings, client, this.systemIndices.getMainIndexManager(), scriptService);
        ProjectStateRoleMapper projectStateRoleMapper = new ProjectStateRoleMapper(this.settings, scriptService, clusterService, projectResolver);
        CompositeRoleMapper userRoleMapper = new CompositeRoleMapper(nativeRoleMappingStore, projectStateRoleMapper);
        AnonymousUser anonymousUser = new AnonymousUser(this.settings);
        components.add(anonymousUser);
        ReservedRealm reservedRealm = new ReservedRealm(environment, this.settings, nativeUsersStore, anonymousUser, threadPool);
        ExtensionComponents extensionComponents = new ExtensionComponents(environment, client, clusterService, resourceWatcherService, userRoleMapper, projectResolver, telemetryProvider);
        HashMap<String, Realm.Factory> realmFactories = new HashMap<String, Realm.Factory>(InternalRealms.getFactories(threadPool, this.settings, resourceWatcherService, this.getSslService(), nativeUsersStore, userRoleMapper, this.systemIndices.getMainIndexManager()));
        for (SecurityExtension extension : this.securityExtensions) {
            Map newRealms = extension.getRealms((SecurityExtension.SecurityComponents)extensionComponents);
            for (Map.Entry entry : newRealms.entrySet()) {
                if (realmFactories.put((String)entry.getKey(), (Realm.Factory)entry.getValue()) == null) continue;
                throw new IllegalArgumentException("Realm type [" + (String)entry.getKey() + "] is already registered");
            }
        }
        Realms realms = new Realms(this.settings, environment, realmFactories, this.getLicenseState(), threadPool.getThreadContext(), reservedRealm);
        components.add(nativeUsersStore);
        components.add(new PluginComponentBinding(NativeRoleMappingStore.class, (Object)nativeRoleMappingStore));
        components.add(new PluginComponentBinding(UserRoleMapper.class, (Object)userRoleMapper));
        components.add(projectStateRoleMapper);
        components.add((Object)reservedRealm);
        components.add(realms);
        this.realms.set((Object)realms);
        this.systemIndices.getMainIndexManager().addStateListener((TriConsumer<ProjectId, SecurityIndexManager.IndexState, SecurityIndexManager.IndexState>)((TriConsumer)nativeRoleMappingStore::onSecurityIndexStateChange));
        CacheInvalidatorRegistry cacheInvalidatorRegistry = new CacheInvalidatorRegistry();
        components.add(cacheInvalidatorRegistry);
        ServiceAccountService serviceAccountService = this.createServiceAccountService(components, cacheInvalidatorRegistry, extensionComponents, () -> new IndexServiceAccountTokenStore(this.settings, threadPool, this.getClock(), client, this.systemIndices.getMainIndexManager(), clusterService, cacheInvalidatorRegistry), () -> new FileServiceAccountTokenStore(environment, resourceWatcherService, threadPool, clusterService, cacheInvalidatorRegistry));
        components.add(serviceAccountService);
        this.systemIndices.getMainIndexManager().addStateListener((TriConsumer<ProjectId, SecurityIndexManager.IndexState, SecurityIndexManager.IndexState>)((TriConsumer)cacheInvalidatorRegistry::onSecurityIndexStateChange));
        NativePrivilegeStore privilegeStore = new NativePrivilegeStore(this.settings, client, this.systemIndices.getMainIndexManager(), cacheInvalidatorRegistry, clusterService);
        components.add(privilegeStore);
        ReservedRolesStore reservedRolesStore = new ReservedRolesStore(Set.copyOf((Collection)ReservedRolesStore.INCLUDED_RESERVED_ROLES_SETTING.get(this.settings)));
        this.dlsBitsetCache.set((Object)new DocumentSubsetBitsetCache(this.settings));
        FieldPermissionsCache fieldPermissionsCache = new FieldPermissionsCache(this.settings);
        RoleDescriptor.setFieldPermissionsCache((FieldPermissionsCache)fieldPermissionsCache);
        if (this.putRoleRequestBuilderFactory.get() == null) {
            this.putRoleRequestBuilderFactory.set((Object)new PutRoleRequestBuilderFactory.Default());
        }
        if (this.bulkPutRoleRequestBuilderFactory.get() == null) {
            this.bulkPutRoleRequestBuilderFactory.set((Object)new BulkPutRoleRequestBuilderFactory.Default());
        }
        if (this.createApiKeyRequestBuilderFactory.get() == null) {
            this.createApiKeyRequestBuilderFactory.set((Object)new CreateApiKeyRequestBuilderFactory.Default());
        }
        if (this.getBuiltinPrivilegesResponseTranslator.get() == null) {
            this.getBuiltinPrivilegesResponseTranslator.set((Object)new GetBuiltinPrivilegesResponseTranslator.Default());
        }
        if (this.updateApiKeyRequestTranslator.get() == null) {
            this.updateApiKeyRequestTranslator.set((Object)new UpdateApiKeyRequestTranslator.Default());
        }
        if (this.bulkUpdateApiKeyRequestTranslator.get() == null) {
            this.bulkUpdateApiKeyRequestTranslator.set((Object)new BulkUpdateApiKeyRequestTranslator.Default());
        }
        if (this.grantApiKeyRequestTranslator.get() == null) {
            this.grantApiKeyRequestTranslator.set((Object)new RestGrantApiKeyAction.RequestTranslator.Default());
        }
        if (this.hasPrivilegesRequestBuilderFactory.get() == null) {
            this.hasPrivilegesRequestBuilderFactory.trySet((Object)new HasPrivilegesRequestBuilderFactory.Default());
        }
        if (this.reservedRoleNameCheckerFactory.get() == null) {
            this.reservedRoleNameCheckerFactory.set((Object)new ReservedRoleNameChecker.Factory.Default());
        }
        if (this.fileRoleValidator.get() == null) {
            this.fileRoleValidator.set((Object)new FileRoleValidator.Default());
        }
        if (this.samlAuthenticateResponseHandlerFactory.get() == null) {
            this.samlAuthenticateResponseHandlerFactory.set((Object)new SamlAuthenticateResponseHandler.DefaultFactory());
        }
        components.add(new PluginComponentBinding(SamlAuthenticateResponseHandler.class, (Object)((SamlAuthenticateResponseHandler.Factory)this.samlAuthenticateResponseHandlerFactory.get()).create(this.settings, tokenService, this.getClock())));
        this.fileRolesStore.set((Object)new FileRolesStore(this.settings, environment, resourceWatcherService, this.getLicenseState(), xContentRegistry, (FileRoleValidator)this.fileRoleValidator.get()));
        ReservedRoleNameChecker reservedRoleNameChecker = ((ReservedRoleNameChecker.Factory)this.reservedRoleNameCheckerFactory.get()).create(clusterService, projectResolver, ((FileRolesStore)this.fileRolesStore.get())::exists);
        components.add(new PluginComponentBinding(ReservedRoleNameChecker.class, (Object)reservedRoleNameChecker));
        LinkedHashMap<String, List<BiConsumer<Set<String>, ActionListener<RoleRetrievalResult>>>> customRoleProviders = new LinkedHashMap<String, List<BiConsumer<Set<String>, ActionListener<RoleRetrievalResult>>>>();
        for (SecurityExtension extension : this.securityExtensions) {
            List providers = extension.getRolesProviders((SecurityExtension.SecurityComponents)extensionComponents);
            if (providers == null || providers.isEmpty()) continue;
            customRoleProviders.put(extension.extensionName(), providers);
        }
        NativeRolesStore nativeRolesStore = new NativeRolesStore(this.settings, client, this.getLicenseState(), this.systemIndices.getMainIndexManager(), clusterService, reservedRoleNameChecker, xContentRegistry);
        ApiKeyService apiKeyService = new ApiKeyService(this.settings, Clock.systemUTC(), client, this.systemIndices.getMainIndexManager(), clusterService, cacheInvalidatorRegistry, threadPool, telemetryProvider.getMeterRegistry(), featureService);
        components.add(apiKeyService);
        RoleProviders roleProviders = new RoleProviders(reservedRolesStore, (FileRolesStore)this.fileRolesStore.get(), nativeRolesStore, customRoleProviders, this.getLicenseState());
        CompositeRolesStore allRolesStore = new CompositeRolesStore(this.settings, clusterService, roleProviders, privilegeStore, threadPool.getThreadContext(), this.getLicenseState(), fieldPermissionsCache, apiKeyService, serviceAccountService, projectResolver, (DocumentSubsetBitsetCache)this.dlsBitsetCache.get(), restrictedIndices, Security.buildRoleBuildingExecutor(threadPool, this.settings), new DeprecationRoleDescriptorConsumer(clusterService, projectResolver, threadPool));
        this.systemIndices.getMainIndexManager().addStateListener((TriConsumer<ProjectId, SecurityIndexManager.IndexState, SecurityIndexManager.IndexState>)((TriConsumer)allRolesStore::onSecurityIndexStateChange));
        ProfileService profileService = new ProfileService(this.settings, this.getClock(), client, this.systemIndices.getProfileIndexManager(), realms);
        components.add(profileService);
        InitialNodeSecurityAutoConfiguration.maybeGenerateEnrollmentTokensAndElasticCredentialsOnNodeStartup(nativeUsersStore, this.systemIndices.getMainIndexManager(), this.getSslService(), client, environment, runnable -> this.nodeStartedListenable.addListener(ActionListener.running((Runnable)runnable)), threadPool);
        this.getLicenseState().addListener(allRolesStore::invalidateAll);
        AuthenticationFailureHandler failureHandler = this.createAuthenticationFailureHandler(realms, extensionComponents);
        boolean operatorPrivilegesEnabled = (Boolean)OperatorPrivileges.OPERATOR_PRIVILEGES_ENABLED.get(this.settings);
        if (operatorPrivilegesEnabled) {
            logger.info("operator privileges are enabled");
            if (this.operatorOnlyRegistry.get() == null) {
                this.operatorOnlyRegistry.set((Object)new DefaultOperatorOnlyRegistry(clusterService.getClusterSettings()));
            }
            this.operatorPrivilegesService.set((Object)new OperatorPrivileges.DefaultOperatorPrivilegesService(this.getLicenseState(), new FileOperatorUsersStore(environment, resourceWatcherService), (OperatorOnlyRegistry)this.operatorOnlyRegistry.get()));
        } else {
            this.operatorPrivilegesService.set((Object)OperatorPrivileges.NOOP_OPERATOR_PRIVILEGES_SERVICE);
        }
        List<CustomAuthenticator> customAuthenticators = this.getCustomAuthenticatorFromExtensions(extensionComponents);
        PluggableAuthenticatorChain pluggableAuthenticatorChain = new PluggableAuthenticatorChain(customAuthenticators);
        components.add(pluggableAuthenticatorChain);
        components.addAll(customAuthenticators);
        this.authcService.set((Object)new AuthenticationService(this.settings, realms, auditTrailService, failureHandler, threadPool, anonymousUser, tokenService, apiKeyService, serviceAccountService, (OperatorPrivileges.OperatorPrivilegesService)this.operatorPrivilegesService.get(), pluggableAuthenticatorChain, telemetryProvider.getMeterRegistry()));
        components.add(this.authcService.get());
        this.systemIndices.getMainIndexManager().addStateListener((TriConsumer<ProjectId, SecurityIndexManager.IndexState, SecurityIndexManager.IndexState>)((TriConsumer)((AuthenticationService)this.authcService.get())::onSecurityIndexStateChange));
        this.dlsFlsEnabled.set((Object)((Boolean)XPackSettings.DLS_FLS_ENABLED.get(this.settings)));
        Set<Object> requestInterceptors = Sets.newHashSet((Object[])new RequestInterceptor[]{new ResizeRequestInterceptor(threadPool, this.getLicenseState(), auditTrailService, (Boolean)this.dlsFlsEnabled.get()), new IndicesAliasesRequestInterceptor(threadPool.getThreadContext(), this.getLicenseState(), auditTrailService, (Boolean)this.dlsFlsEnabled.get())});
        if (((Boolean)this.dlsFlsEnabled.get()).booleanValue()) {
            requestInterceptors.addAll(Arrays.asList(new SearchRequestInterceptor(threadPool, this.getLicenseState()), new ShardSearchRequestInterceptor(threadPool, this.getLicenseState()), new UpdateRequestInterceptor(threadPool, this.getLicenseState()), new BulkShardRequestInterceptor(threadPool, this.getLicenseState()), new DlsFlsLicenseRequestInterceptor(threadPool.getThreadContext(), this.getLicenseState()), new SearchRequestCacheDisablingInterceptor(threadPool, this.getLicenseState()), new ValidateRequestInterceptor(threadPool, this.getLicenseState())));
        }
        requestInterceptors = Collections.unmodifiableSet(requestInterceptors);
        if (this.authorizationDenialMessages.get() == null) {
            this.authorizationDenialMessages.set((Object)new AuthorizationDenialMessages.Default());
        }
        AuthorizedProjectsResolver authorizedProjectsResolver = this.getCustomAuthorizedProjectsResolverOrDefault(extensionComponents);
        AuthorizationService authzService = new AuthorizationService(this.settings, allRolesStore, fieldPermissionsCache, clusterService, auditTrailService, failureHandler, threadPool, anonymousUser, this.getAuthorizationEngine(), requestInterceptors, this.getLicenseState(), expressionResolver, (OperatorPrivileges.OperatorPrivilegesService)this.operatorPrivilegesService.get(), restrictedIndices, (AuthorizationDenialMessages)this.authorizationDenialMessages.get(), linkedProjectConfigService, projectResolver, authorizedProjectsResolver, new CrossProjectModeDecider(this.settings), projectRoutingResolver);
        components.add(nativeRolesStore);
        components.add(reservedRolesStore);
        components.add(allRolesStore);
        components.add(authzService);
        components.add(new PluginComponentBinding(AuthorizedProjectsResolver.class, (Object)authorizedProjectsResolver));
        SecondaryAuthenticator secondaryAuthenticator = new SecondaryAuthenticator((SecurityContext)this.securityContext.get(), (AuthenticationService)this.authcService.get(), auditTrailService);
        this.secondayAuthc.set((Object)secondaryAuthenticator);
        components.add(secondaryAuthenticator);
        this.ipFilter.set((Object)new IPFilter(this.settings, auditTrailService, clusterService.getClusterSettings(), this.getLicenseState()));
        components.add(this.ipFilter.get());
        DestructiveOperations destructiveOperations = new DestructiveOperations(this.settings, clusterService.getClusterSettings());
        RemoteClusterSecurityComponents rcsComponents = new RemoteClusterSecurityComponents((AuthenticationService)this.authcService.get(), authzService, (SecurityContext)this.securityContext.get(), apiKeyService, resourceWatcherService, projectResolver, this.getLicenseState(), clusterService, environment, threadPool, this.settings, client);
        this.remoteClusterSecurityExtension.set((Object)this.getRemoteClusterSecurityExtension(rcsComponents));
        this.remoteClusterAuthenticationService.set((Object)((RemoteClusterSecurityExtension)this.remoteClusterSecurityExtension.get()).getAuthenticationService());
        components.add(new PluginComponentBinding(RemoteClusterAuthenticationService.class, (Object)((RemoteClusterAuthenticationService)this.remoteClusterAuthenticationService.get())));
        RemoteClusterTransportInterceptor remoteClusterTransportInterceptor = ((RemoteClusterSecurityExtension)this.remoteClusterSecurityExtension.get()).getTransportInterceptor();
        components.add(new PluginComponentBinding(RemoteClusterTransportInterceptor.class, (Object)remoteClusterTransportInterceptor));
        this.securityInterceptor.set((Object)new SecurityServerTransportInterceptor(this.settings, threadPool, (AuthenticationService)this.authcService.get(), authzService, this.getSslService(), (SecurityContext)this.securityContext.get(), destructiveOperations, remoteClusterTransportInterceptor));
        this.securityActionFilter.set((Object)new SecurityActionFilter((AuthenticationService)this.authcService.get(), authzService, auditTrailService, this.getLicenseState(), threadPool, (SecurityContext)this.securityContext.get(), destructiveOperations, this.secondaryAuthActions.get() == null ? Set::of : (SecondaryAuthActions)this.secondaryAuthActions.get()));
        components.add(new SecurityUsageServices(realms, allRolesStore, nativeRoleMappingStore, (IPFilter)this.ipFilter.get(), profileService, apiKeyService));
        this.reservedRoleMappingAction.set((Object)new ReservedRoleMappingAction());
        if (QueryableBuiltInRolesSynchronizer.QUERYABLE_BUILT_IN_ROLES_ENABLED) {
            if (this.queryableRolesProviderFactory.get() == null) {
                this.queryableRolesProviderFactory.set((Object)new QueryableBuiltInRolesProviderFactory.Default());
            }
            components.add(new QueryableBuiltInRolesSynchronizer(clusterService, featureService, (QueryableBuiltInRolesProviderFactory)this.queryableRolesProviderFactory.get(), nativeRolesStore, reservedRolesStore, (FileRolesStore)this.fileRolesStore.get(), threadPool));
        }
        cacheInvalidatorRegistry.validate();
        this.setClosableAndReloadableComponents(components);
        return components;
    }

    private void setClosableAndReloadableComponents(List<Object> components) {
        Iterable allComponents = Iterables.flatten(List.of(components, List.of(this.remoteClusterSecurityExtension.get())));
        ArrayList<ReloadableSecurityComponent> reloadableComponents = new ArrayList<ReloadableSecurityComponent>();
        ArrayList<Closeable> closableComponents = new ArrayList<Closeable>();
        for (Object component : allComponents) {
            Object unwrapped = Security.unwrapComponentObject(component);
            if (unwrapped instanceof ReloadableSecurityComponent) {
                ReloadableSecurityComponent reloadable = (ReloadableSecurityComponent)unwrapped;
                reloadableComponents.add(reloadable);
            }
            if (!(unwrapped instanceof Closeable)) continue;
            Closeable closeable = (Closeable)unwrapped;
            closableComponents.add(closeable);
        }
        this.reloadableComponents.set(List.copyOf(reloadableComponents));
        this.closableComponents.set(List.copyOf(closableComponents));
    }

    private static Object unwrapComponentObject(Object component) {
        if (component instanceof PluginComponentBinding) {
            PluginComponentBinding pcb = (PluginComponentBinding)component;
            return pcb.impl();
        }
        return component;
    }

    private RemoteClusterSecurityExtension getRemoteClusterSecurityExtension(RemoteClusterSecurityExtension.Components components) {
        assert (this.remoteClusterSecurityExtensionProvider.get() != null) : "security plugin extensions should have been loaded first";
        RemoteClusterSecurityExtension rcsExtension = ((RemoteClusterSecurityExtension.Provider)this.remoteClusterSecurityExtensionProvider.get()).getExtension(components);
        assert (rcsExtension != null);
        if (!Security.isInternalRemoteClusterSecurityExtension(rcsExtension)) {
            throw new IllegalStateException("The [" + rcsExtension.getClass().getCanonicalName() + "] extension tried to install a  " + RemoteClusterSecurityExtension.class.getSimpleName() + ". This functionality is not available to external extensions.");
        }
        return rcsExtension;
    }

    private List<CustomAuthenticator> getCustomAuthenticatorFromExtensions(SecurityExtension.SecurityComponents extensionComponents) {
        HashMap<String, List> customAuthenticatorsByExtension = new HashMap<String, List>();
        for (SecurityExtension securityExtension : this.securityExtensions) {
            List customAuthenticators = securityExtension.getCustomAuthenticators(extensionComponents);
            if (customAuthenticators == null) continue;
            if (!Security.isInternalExtension(securityExtension)) {
                throw new IllegalStateException("The [" + securityExtension.extensionName() + "] extension tried to install a  " + CustomAuthenticator.class.getSimpleName() + ". This functionality is not available to external extensions.");
            }
            customAuthenticatorsByExtension.put(securityExtension.extensionName(), customAuthenticators);
        }
        if (customAuthenticatorsByExtension.isEmpty()) {
            logger.debug("No custom implementations for [{}] provided by security extensions.", (Object)CustomAuthenticator.class.getCanonicalName());
            return List.of();
        }
        if (customAuthenticatorsByExtension.size() > 1) {
            throw new IllegalStateException("Multiple extensions tried to install custom authenticators: " + String.valueOf(customAuthenticatorsByExtension.keySet()));
        }
        Map.Entry authenticatorByExtensionEntry = customAuthenticatorsByExtension.entrySet().iterator().next();
        List customAuthenticators = (List)authenticatorByExtensionEntry.getValue();
        String extensionName = (String)authenticatorByExtensionEntry.getKey();
        for (CustomAuthenticator authenticator : customAuthenticators) {
            logger.debug("{} implementation [{}] provided by extension [{}]", (Object)CustomAuthenticator.class.getSimpleName(), (Object)authenticator.getClass().getCanonicalName(), (Object)extensionName);
        }
        return customAuthenticators;
    }

    private AuthorizedProjectsResolver getCustomAuthorizedProjectsResolverOrDefault(SecurityExtension.SecurityComponents extensionComponents) {
        AuthorizedProjectsResolver customAuthorizedProjectsResolver = this.findValueFromExtensions("authorized projects resolver", extension -> {
            AuthorizedProjectsResolver authorizedProjectsResolver = extension.getAuthorizedProjectsResolver(extensionComponents);
            if (authorizedProjectsResolver != null && !Security.isInternalExtension(extension)) {
                throw new IllegalStateException("The [" + extension.getClass().getName() + "] extension tried to install a custom AuthorizedProjectsResolver. This functionality is not available to external extensions.");
            }
            return authorizedProjectsResolver;
        });
        return customAuthorizedProjectsResolver == null ? new AuthorizedProjectsResolver.Default() : customAuthorizedProjectsResolver;
    }

    private ServiceAccountService createServiceAccountService(List<Object> components, CacheInvalidatorRegistry cacheInvalidatorRegistry, SecurityExtension.SecurityComponents extensionComponents, Supplier<IndexServiceAccountTokenStore> indexServiceAccountTokenStoreSupplier, Supplier<FileServiceAccountTokenStore> fileServiceAccountTokenStoreSupplier) {
        HashMap<String, ServiceAccountTokenStore> accountTokenStoreByExtension = new HashMap<String, ServiceAccountTokenStore>();
        for (SecurityExtension extension : this.securityExtensions) {
            ServiceAccountTokenStore serviceAccountTokenStore = extension.getServiceAccountTokenStore(extensionComponents);
            if (serviceAccountTokenStore == null) continue;
            if (!Security.isInternalExtension(extension)) {
                throw new IllegalStateException("The [" + extension.getClass().getName() + "] extension tried to install a custom ServiceAccountTokenStore. This functionality is not available to external extensions.");
            }
            accountTokenStoreByExtension.put(extension.extensionName(), serviceAccountTokenStore);
        }
        if (accountTokenStoreByExtension.size() > 1) {
            throw new IllegalStateException("More than one extension provided a ServiceAccountTokenStore override: " + String.valueOf(accountTokenStoreByExtension.keySet()));
        }
        if (accountTokenStoreByExtension.isEmpty()) {
            FileServiceAccountTokenStore fileServiceAccountTokenStore = fileServiceAccountTokenStoreSupplier.get();
            IndexServiceAccountTokenStore indexServiceAccountTokenStore = indexServiceAccountTokenStoreSupplier.get();
            components.add(new PluginComponentBinding(NodeLocalServiceAccountTokenStore.class, (Object)fileServiceAccountTokenStore));
            components.add(fileServiceAccountTokenStore);
            components.add(indexServiceAccountTokenStore);
            cacheInvalidatorRegistry.registerAlias("service", Set.of("file_service_account_token", "index_service_account_token"));
            return new ServiceAccountService((Client)this.client.get(), new CompositeServiceAccountTokenStore(List.of(fileServiceAccountTokenStore, indexServiceAccountTokenStore), ((Client)this.client.get()).threadPool().getThreadContext()), indexServiceAccountTokenStore);
        }
        Optional extensionStore = accountTokenStoreByExtension.values().stream().findFirst();
        components.add(new PluginComponentBinding(NodeLocalServiceAccountTokenStore.class, (token, listener) -> {
            throw new IllegalStateException("Node local config not supported by [" + String.valueOf(((ServiceAccountTokenStore)extensionStore.get()).getClass()) + "]");
        }));
        components.add(extensionStore);
        logger.debug("Service account authentication handled by extension, disabling file and index token stores");
        return new ServiceAccountService((Client)this.client.get(), (ServiceAccountTokenStore)extensionStore.get());
    }

    private static boolean isInternalExtension(SecurityExtension extension) {
        return Security.isInternalExtension(extension.getClass());
    }

    private static boolean isInternalRemoteClusterSecurityExtension(RemoteClusterSecurityExtension extension) {
        return Security.isInternalExtension(extension.getClass());
    }

    private static boolean isInternalExtension(Class<?> extensionClass) {
        String canonicalName = extensionClass.getCanonicalName();
        if (canonicalName == null) {
            return false;
        }
        return canonicalName.startsWith("org.elasticsearch.xpack.") || canonicalName.startsWith("co.elastic.elasticsearch.");
    }

    private static Executor buildRoleBuildingExecutor(ThreadPool threadPool, Settings settings) {
        int allocatedProcessors = EsExecutors.allocatedProcessors((Settings)settings);
        ThrottledTaskRunner throttledTaskRunner = new ThrottledTaskRunner("build_roles", allocatedProcessors, (Executor)threadPool.generic());
        return r -> throttledTaskRunner.enqueueTask((ActionListener)new ActionListener<Releasable>(){

            public void onResponse(Releasable releasable) {
                try (Releasable releasable2 = releasable;){
                    r.run();
                }
            }

            public void onFailure(Exception e) {
                if (r instanceof AbstractRunnable) {
                    AbstractRunnable abstractRunnable = (AbstractRunnable)r;
                    abstractRunnable.onFailure(e);
                }
                logger.error("unexpected failure running " + String.valueOf(r), (Throwable)e);
                assert (false) : new AssertionError("unexpected failure running " + String.valueOf(r), e);
            }
        });
    }

    private AuthorizationEngine getAuthorizationEngine() {
        return this.findValueFromExtensions("authorization engine", extension -> extension.getAuthorizationEngine(this.settings));
    }

    private AuthenticationFailureHandler createAuthenticationFailureHandler(Realms realms, SecurityExtension.SecurityComponents components) {
        AuthenticationFailureHandler failureHandler = this.findValueFromExtensions("authentication failure handler", extension -> extension.getAuthenticationFailureHandler(components));
        if (failureHandler == null) {
            logger.debug("Using default authentication failure handler");
            Supplier<Map> headersSupplier = () -> {
                HashMap<String, List> defaultFailureResponseHeaders = new HashMap<String, List>();
                realms.getActiveRealms().forEach(realm -> {
                    Map realmFailureHeaders = realm.getAuthenticationFailureHeaders();
                    realmFailureHeaders.forEach((key, value) -> value.stream().filter(v -> !defaultFailureResponseHeaders.computeIfAbsent((String)key, x -> new ArrayList()).contains(v)).forEach(v -> ((List)defaultFailureResponseHeaders.get(key)).add(v)));
                });
                if (TokenService.isTokenServiceEnabled(this.settings).booleanValue()) {
                    String bearerScheme = "Bearer realm=\"security\"";
                    if (!defaultFailureResponseHeaders.computeIfAbsent("WWW-Authenticate", x -> new ArrayList()).contains(bearerScheme)) {
                        ((List)defaultFailureResponseHeaders.get("WWW-Authenticate")).add(bearerScheme);
                    }
                }
                if (((Boolean)XPackSettings.API_KEY_SERVICE_ENABLED_SETTING.get(this.settings)).booleanValue()) {
                    String apiKeyScheme = "ApiKey";
                    if (!defaultFailureResponseHeaders.computeIfAbsent("WWW-Authenticate", x -> new ArrayList()).contains("ApiKey")) {
                        ((List)defaultFailureResponseHeaders.get("WWW-Authenticate")).add("ApiKey");
                    }
                }
                return defaultFailureResponseHeaders;
            };
            DefaultAuthenticationFailureHandler finalDefaultFailureHandler = new DefaultAuthenticationFailureHandler(headersSupplier.get());
            failureHandler = finalDefaultFailureHandler;
            this.getLicenseState().addListener(() -> finalDefaultFailureHandler.setHeaders((Map)headersSupplier.get()));
        }
        return failureHandler;
    }

    @Nullable
    private <T> T findValueFromExtensions(String valueType, Function<SecurityExtension, T> method) {
        T foundValue = null;
        String fromExtension = null;
        for (SecurityExtension extension : this.securityExtensions) {
            T extensionValue = method.apply(extension);
            if (extensionValue == null) continue;
            if (foundValue == null) {
                foundValue = extensionValue;
                fromExtension = extension.extensionName();
                continue;
            }
            throw new IllegalStateException("Extensions [" + fromExtension + "] and [" + extension.extensionName() + "]  both attempted to provide a value for [" + valueType + "]");
        }
        if (foundValue == null) {
            return null;
        }
        logger.debug("Using [{}] [{}] from extension [{}]", (Object)valueType, foundValue, fromExtension);
        return foundValue;
    }

    public Settings additionalSettings() {
        return Security.additionalSettings(this.settings, this.enabled);
    }

    /*
     * Enabled aggressive block sorting
     */
    static Settings additionalSettings(Settings settings, boolean enabled) {
        if (!enabled) {
            return Settings.EMPTY;
        }
        Settings.Builder builder = Settings.builder();
        builder.put(SecuritySettings.addTransportSettings((Settings)settings));
        if (NetworkModule.HTTP_TYPE_SETTING.exists(settings)) {
            String httpType = (String)NetworkModule.HTTP_TYPE_SETTING.get(settings);
            if (!httpType.equals("security4")) {
                String message = String.format(Locale.ROOT, "http type setting [%s] must be [%s] but is [%s]", "http.type", "security4", httpType);
                throw new IllegalArgumentException(message);
            }
            SecurityHttpSettings.overrideSettings(builder, settings);
        } else {
            builder.put("http.type", "security4");
            SecurityHttpSettings.overrideSettings(builder, settings);
        }
        builder.put(SecuritySettings.addUserSettings((Settings)settings));
        return builder.build();
    }

    public List<Setting<?>> getSettings() {
        return Security.getSettings(this.securityExtensions, (RemoteClusterSecurityExtension.Provider)this.remoteClusterSecurityExtensionProvider.get());
    }

    public static List<Setting<?>> getSettings(List<SecurityExtension> securityExtensions, RemoteClusterSecurityExtension.Provider remoteClusterSecurityExtensionProvider) {
        ArrayList settingsList = new ArrayList();
        settingsList.add(XPackSettings.FIPS_MODE_ENABLED);
        settingsList.add(XPackSettings.FIPS_REQUIRED_PROVIDERS);
        SSLService.registerSettings(settingsList);
        IPFilter.addSettings(settingsList);
        LoggingAuditTrail.registerSettings(settingsList);
        AnonymousUser.addSettings(settingsList);
        settingsList.addAll(InternalRealmsSettings.getSettings());
        ReservedRealm.addSettings(settingsList);
        AuthenticationService.addSettings(settingsList);
        AuthorizationService.addSettings(settingsList);
        Automatons.addSettings(settingsList);
        settingsList.addAll(CompositeRolesStore.getSettings());
        settingsList.addAll(DocumentSubsetBitsetCache.getSettings());
        settingsList.add(FieldPermissionsCache.CACHE_SIZE_SETTING);
        settingsList.add(TokenService.TOKEN_EXPIRATION);
        settingsList.add(TokenService.DELETE_INTERVAL);
        settingsList.add(TokenService.DELETE_TIMEOUT);
        settingsList.add(ProfileService.MAX_SIZE_SETTING);
        settingsList.addAll(SSLConfigurationSettings.getProfileSettings());
        settingsList.add(ApiKeyService.STORED_HASH_ALGO_SETTING);
        settingsList.add(ApiKeyService.DELETE_TIMEOUT);
        settingsList.add(ApiKeyService.DELETE_INTERVAL);
        settingsList.add(ApiKeyService.DELETE_RETENTION_PERIOD);
        settingsList.add(ApiKeyService.CACHE_HASH_ALGO_SETTING);
        settingsList.add(ApiKeyService.CACHE_MAX_KEYS_SETTING);
        settingsList.add(ApiKeyService.CACHE_TTL_SETTING);
        settingsList.add(ApiKeyService.DOC_CACHE_TTL_SETTING);
        settingsList.add(ApiKeyService.CERTIFICATE_IDENTITY_PATTERN_CACHE_TTL_SETTING);
        settingsList.add(ApiKeyService.CERTIFICATE_IDENTITY_PATTERN_CACHE_MAX_KEYS_SETTING);
        settingsList.add(NativePrivilegeStore.CACHE_MAX_APPLICATIONS_SETTING);
        settingsList.add(NativePrivilegeStore.CACHE_TTL_SETTING);
        settingsList.add(OperatorPrivileges.OPERATOR_PRIVILEGES_ENABLED);
        settingsList.add(CachingServiceAccountTokenStore.CACHE_TTL_SETTING);
        settingsList.add(CachingServiceAccountTokenStore.CACHE_HASH_ALGO_SETTING);
        settingsList.add(CachingServiceAccountTokenStore.CACHE_MAX_TOKENS_SETTING);
        settingsList.add(SimpleRole.CACHE_SIZE_SETTING);
        settingsList.add(NativeRoleMappingStore.LAST_LOAD_CACHE_ENABLED_SETTING);
        settingsList.addAll(remoteClusterSecurityExtensionProvider.getSettings());
        settingsList.add(Setting.stringListSetting((String)SecurityField.setting((String)"hide_settings"), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        return settingsList;
    }

    public Collection<RestHeaderDefinition> getRestHeaders() {
        HashSet<RestHeaderDefinition> headers = new HashSet<RestHeaderDefinition>();
        headers.add(new RestHeaderDefinition("Authorization", false));
        headers.add(new RestHeaderDefinition("es-secondary-authorization", false));
        if (((Boolean)XPackSettings.AUDIT_ENABLED.get(this.settings)).booleanValue()) {
            headers.add(new RestHeaderDefinition("X-Forwarded-For", true));
        }
        if (((Boolean)AuthenticationServiceField.RUN_AS_ENABLED.get(this.settings)).booleanValue()) {
            headers.add(new RestHeaderDefinition("es-security-runas-user", false));
        }
        headers.add(new RestHeaderDefinition("ES-Client-Authentication", false));
        return headers;
    }

    public List<String> getSettingsFilter() {
        List asArray = this.settings.getAsList(SecurityField.setting((String)"hide_settings"));
        ArrayList<String> settingsFilter = new ArrayList<String>(asArray);
        settingsFilter.add("transport.profiles.*." + SecurityField.setting((String)"*"));
        return settingsFilter;
    }

    public List<BootstrapCheck> getBootstrapChecks() {
        return (List)this.bootstrapChecks.get();
    }

    public void onIndexModule(IndexModule module) {
        if (this.enabled) {
            assert (this.getLicenseState() != null);
            if (((Boolean)XPackSettings.DLS_FLS_ENABLED.get(this.settings)).booleanValue()) {
                assert (this.dlsBitsetCache.get() != null);
                module.setReaderWrapper(indexService -> new SecurityIndexReaderWrapper(shardId -> indexService.newSearchExecutionContext(shardId.id(), 0, null, () -> {
                    throw new IllegalArgumentException("permission filters are not allowed to use the current timestamp");
                }, null, Collections.emptyMap()), (DocumentSubsetBitsetCache)this.dlsBitsetCache.get(), (SecurityContext)this.securityContext.get(), this.getLicenseState(), indexService.getScriptService()));
                module.forceQueryCacheProvider((indexSettings, cache) -> new OptOutQueryCache(indexSettings.getIndex(), (IndicesQueryCache)cache, (ThreadContext)this.threadContext.get()));
            }
            module.addSearchOperationListener((SearchOperationListener)new SecuritySearchOperationListener((SecurityContext)this.securityContext.get(), (AuditTrailService)this.auditTrailService.get()));
        }
    }

    public List<ActionPlugin.ActionHandler> getActions() {
        ActionPlugin.ActionHandler usageAction = new ActionPlugin.ActionHandler(XPackUsageFeatureAction.SECURITY, SecurityUsageTransportAction.class);
        ActionPlugin.ActionHandler infoAction = new ActionPlugin.ActionHandler(XPackInfoFeatureAction.SECURITY, SecurityInfoTransportAction.class);
        if (!this.enabled) {
            return Arrays.asList(usageAction, infoAction);
        }
        return Stream.of(new ActionPlugin.ActionHandler((ActionType)ClearRealmCacheAction.INSTANCE, TransportClearRealmCacheAction.class), new ActionPlugin.ActionHandler((ActionType)ClearRolesCacheAction.INSTANCE, TransportClearRolesCacheAction.class), new ActionPlugin.ActionHandler((ActionType)ClearPrivilegesCacheAction.INSTANCE, TransportClearPrivilegesCacheAction.class), new ActionPlugin.ActionHandler((ActionType)ClearSecurityCacheAction.INSTANCE, TransportClearSecurityCacheAction.class), new ActionPlugin.ActionHandler((ActionType)GetUsersAction.INSTANCE, TransportGetUsersAction.class), new ActionPlugin.ActionHandler(ActionTypes.QUERY_USER_ACTION, TransportQueryUserAction.class), new ActionPlugin.ActionHandler((ActionType)PutUserAction.INSTANCE, TransportPutUserAction.class), new ActionPlugin.ActionHandler((ActionType)DeleteUserAction.INSTANCE, TransportDeleteUserAction.class), new ActionPlugin.ActionHandler((ActionType)GetRolesAction.INSTANCE, TransportGetRolesAction.class), new ActionPlugin.ActionHandler(ActionTypes.QUERY_ROLE_ACTION, TransportQueryRoleAction.class), new ActionPlugin.ActionHandler((ActionType)PutRoleAction.INSTANCE, TransportPutRoleAction.class), new ActionPlugin.ActionHandler(ActionTypes.BULK_PUT_ROLES, TransportBulkPutRolesAction.class), new ActionPlugin.ActionHandler(ActionTypes.BULK_DELETE_ROLES, TransportBulkDeleteRolesAction.class), new ActionPlugin.ActionHandler((ActionType)DeleteRoleAction.INSTANCE, TransportDeleteRoleAction.class), new ActionPlugin.ActionHandler(TransportChangePasswordAction.TYPE, TransportChangePasswordAction.class), new ActionPlugin.ActionHandler((ActionType)AuthenticateAction.INSTANCE, TransportAuthenticateAction.class), new ActionPlugin.ActionHandler(TransportSetEnabledAction.TYPE, TransportSetEnabledAction.class), new ActionPlugin.ActionHandler((ActionType)HasPrivilegesAction.INSTANCE, TransportHasPrivilegesAction.class), new ActionPlugin.ActionHandler((ActionType)GetUserPrivilegesAction.INSTANCE, TransportGetUserPrivilegesAction.class), new ActionPlugin.ActionHandler((ActionType)GetRoleMappingsAction.INSTANCE, TransportGetRoleMappingsAction.class), new ActionPlugin.ActionHandler((ActionType)PutRoleMappingAction.INSTANCE, TransportPutRoleMappingAction.class), new ActionPlugin.ActionHandler((ActionType)DeleteRoleMappingAction.INSTANCE, TransportDeleteRoleMappingAction.class), new ActionPlugin.ActionHandler((ActionType)CreateTokenAction.INSTANCE, TransportCreateTokenAction.class), new ActionPlugin.ActionHandler((ActionType)InvalidateTokenAction.INSTANCE, TransportInvalidateTokenAction.class), new ActionPlugin.ActionHandler((ActionType)GetCertificateInfoAction.INSTANCE, TransportGetCertificateInfoAction.class), new ActionPlugin.ActionHandler((ActionType)RefreshTokenAction.INSTANCE, TransportRefreshTokenAction.class), new ActionPlugin.ActionHandler((ActionType)SamlPrepareAuthenticationAction.INSTANCE, TransportSamlPrepareAuthenticationAction.class), new ActionPlugin.ActionHandler((ActionType)SamlAuthenticateAction.INSTANCE, TransportSamlAuthenticateAction.class), new ActionPlugin.ActionHandler((ActionType)SamlLogoutAction.INSTANCE, TransportSamlLogoutAction.class), new ActionPlugin.ActionHandler((ActionType)SamlInvalidateSessionAction.INSTANCE, TransportSamlInvalidateSessionAction.class), new ActionPlugin.ActionHandler(TransportSamlCompleteLogoutAction.TYPE, TransportSamlCompleteLogoutAction.class), new ActionPlugin.ActionHandler((ActionType)SamlSpMetadataAction.INSTANCE, TransportSamlSpMetadataAction.class), new ActionPlugin.ActionHandler((ActionType)OpenIdConnectPrepareAuthenticationAction.INSTANCE, TransportOpenIdConnectPrepareAuthenticationAction.class), new ActionPlugin.ActionHandler((ActionType)OpenIdConnectAuthenticateAction.INSTANCE, TransportOpenIdConnectAuthenticateAction.class), new ActionPlugin.ActionHandler((ActionType)OpenIdConnectLogoutAction.INSTANCE, TransportOpenIdConnectLogoutAction.class), new ActionPlugin.ActionHandler((ActionType)GetBuiltinPrivilegesAction.INSTANCE, TransportGetBuiltinPrivilegesAction.class), new ActionPlugin.ActionHandler((ActionType)GetPrivilegesAction.INSTANCE, TransportGetPrivilegesAction.class), new ActionPlugin.ActionHandler((ActionType)PutPrivilegesAction.INSTANCE, TransportPutPrivilegesAction.class), new ActionPlugin.ActionHandler((ActionType)DeletePrivilegesAction.INSTANCE, TransportDeletePrivilegesAction.class), new ActionPlugin.ActionHandler((ActionType)CreateApiKeyAction.INSTANCE, TransportCreateApiKeyAction.class), new ActionPlugin.ActionHandler((ActionType)CreateCrossClusterApiKeyAction.INSTANCE, TransportCreateCrossClusterApiKeyAction.class), new ActionPlugin.ActionHandler((ActionType)GrantApiKeyAction.INSTANCE, TransportGrantApiKeyAction.class), new ActionPlugin.ActionHandler((ActionType)InvalidateApiKeyAction.INSTANCE, TransportInvalidateApiKeyAction.class), new ActionPlugin.ActionHandler((ActionType)GetApiKeyAction.INSTANCE, TransportGetApiKeyAction.class), new ActionPlugin.ActionHandler((ActionType)QueryApiKeyAction.INSTANCE, TransportQueryApiKeyAction.class), new ActionPlugin.ActionHandler((ActionType)UpdateApiKeyAction.INSTANCE, TransportUpdateApiKeyAction.class), new ActionPlugin.ActionHandler((ActionType)BulkUpdateApiKeyAction.INSTANCE, TransportBulkUpdateApiKeyAction.class), new ActionPlugin.ActionHandler((ActionType)UpdateCrossClusterApiKeyAction.INSTANCE, TransportUpdateCrossClusterApiKeyAction.class), new ActionPlugin.ActionHandler((ActionType)DelegatePkiAuthenticationAction.INSTANCE, TransportDelegatePkiAuthenticationAction.class), new ActionPlugin.ActionHandler((ActionType)CreateServiceAccountTokenAction.INSTANCE, TransportCreateServiceAccountTokenAction.class), new ActionPlugin.ActionHandler((ActionType)DeleteServiceAccountTokenAction.INSTANCE, TransportDeleteServiceAccountTokenAction.class), new ActionPlugin.ActionHandler((ActionType)GetServiceAccountCredentialsAction.INSTANCE, TransportGetServiceAccountCredentialsAction.class), new ActionPlugin.ActionHandler((ActionType)GetServiceAccountNodesCredentialsAction.INSTANCE, TransportGetServiceAccountNodesCredentialsAction.class), new ActionPlugin.ActionHandler((ActionType)GetServiceAccountAction.INSTANCE, TransportGetServiceAccountAction.class), new ActionPlugin.ActionHandler((ActionType)KibanaEnrollmentAction.INSTANCE, TransportKibanaEnrollmentAction.class), new ActionPlugin.ActionHandler((ActionType)NodeEnrollmentAction.INSTANCE, TransportNodeEnrollmentAction.class), new ActionPlugin.ActionHandler((ActionType)ProfileHasPrivilegesAction.INSTANCE, TransportProfileHasPrivilegesAction.class), new ActionPlugin.ActionHandler((ActionType)GetProfilesAction.INSTANCE, TransportGetProfilesAction.class), new ActionPlugin.ActionHandler((ActionType)ActivateProfileAction.INSTANCE, TransportActivateProfileAction.class), new ActionPlugin.ActionHandler((ActionType)UpdateProfileDataAction.INSTANCE, TransportUpdateProfileDataAction.class), new ActionPlugin.ActionHandler((ActionType)SuggestProfilesAction.INSTANCE, TransportSuggestProfilesAction.class), new ActionPlugin.ActionHandler((ActionType)SetProfileEnabledAction.INSTANCE, TransportSetProfileEnabledAction.class), new ActionPlugin.ActionHandler(GetSecuritySettingsAction.INSTANCE, TransportGetSecuritySettingsAction.class), new ActionPlugin.ActionHandler(UpdateSecuritySettingsAction.INSTANCE, TransportUpdateSecuritySettingsAction.class), new ActionPlugin.ActionHandler(ActionTypes.RELOAD_REMOTE_CLUSTER_CREDENTIALS_ACTION, TransportReloadRemoteClusterCredentialsAction.class), new ActionPlugin.ActionHandler((ActionType)UpdateIndexMigrationVersionAction.INSTANCE, UpdateIndexMigrationVersionAction.TransportAction.class), new ActionPlugin.ActionHandler((ActionType)GetSecurityStatsAction.INSTANCE, TransportSecurityStatsAction.class), usageAction, infoAction).filter(Objects::nonNull).toList();
    }

    public List<ActionFilter> getActionFilters() {
        if (!this.enabled) {
            return Collections.emptyList();
        }
        return Collections.singletonList((ActionFilter)this.securityActionFilter.get());
    }

    public List<RestHandler> getRestHandlers(Settings settings, NamedWriteableRegistry namedWriteableRegistry, RestController restController, ClusterSettings clusterSettings, IndexScopedSettings indexScopedSettings, SettingsFilter settingsFilter, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<DiscoveryNodes> nodesInCluster, Predicate<NodeFeature> clusterSupportsFeature) {
        if (!this.enabled) {
            return Collections.emptyList();
        }
        return Stream.of(new RestHandler[]{new RestAuthenticateAction(settings, (SecurityContext)this.securityContext.get(), this.getLicenseState()), new RestClearRealmCacheAction(settings, this.getLicenseState()), new RestClearRolesCacheAction(settings, this.getLicenseState()), new RestClearPrivilegesCacheAction(settings, this.getLicenseState()), new RestClearApiKeyCacheAction(settings, this.getLicenseState()), new RestClearServiceAccountTokenStoreCacheAction(settings, this.getLicenseState()), new RestGetUsersAction(settings, this.getLicenseState()), new RestQueryUserAction(settings, this.getLicenseState()), new RestPutUserAction(settings, this.getLicenseState()), new RestDeleteUserAction(settings, this.getLicenseState()), new RestGetRolesAction(settings, this.getLicenseState()), new RestQueryRoleAction(settings, this.getLicenseState()), new RestBulkPutRolesAction(settings, this.getLicenseState(), (BulkPutRoleRequestBuilderFactory)this.bulkPutRoleRequestBuilderFactory.get()), new RestBulkDeleteRolesAction(settings, this.getLicenseState()), new RestPutRoleAction(settings, this.getLicenseState(), (PutRoleRequestBuilderFactory)this.putRoleRequestBuilderFactory.get()), new RestDeleteRoleAction(settings, this.getLicenseState()), new RestChangePasswordAction(settings, (SecurityContext)this.securityContext.get(), this.getLicenseState()), new RestSetEnabledAction(settings, this.getLicenseState()), new RestHasPrivilegesAction(settings, (SecurityContext)this.securityContext.get(), this.getLicenseState(), (HasPrivilegesRequestBuilderFactory)this.hasPrivilegesRequestBuilderFactory.get()), new RestGetUserPrivilegesAction(settings, (SecurityContext)this.securityContext.get(), this.getLicenseState()), new RestGetRoleMappingsAction(settings, this.getLicenseState()), new RestPutRoleMappingAction(settings, this.getLicenseState()), new RestDeleteRoleMappingAction(settings, this.getLicenseState()), new RestGetTokenAction(settings, this.getLicenseState()), new RestInvalidateTokenAction(settings, this.getLicenseState()), new RestGetCertificateInfoAction(), new RestSamlPrepareAuthenticationAction(settings, this.getLicenseState()), new RestSamlAuthenticateAction(settings, this.getLicenseState()), new RestSamlLogoutAction(settings, this.getLicenseState()), new RestSamlInvalidateSessionAction(settings, this.getLicenseState()), new RestSamlCompleteLogoutAction(settings, this.getLicenseState()), new RestSamlSpMetadataAction(settings, this.getLicenseState()), new RestOpenIdConnectPrepareAuthenticationAction(settings, this.getLicenseState()), new RestOpenIdConnectAuthenticateAction(settings, this.getLicenseState()), new RestOpenIdConnectLogoutAction(settings, this.getLicenseState()), new RestGetBuiltinPrivilegesAction(settings, this.getLicenseState(), (GetBuiltinPrivilegesResponseTranslator)this.getBuiltinPrivilegesResponseTranslator.get()), new RestGetPrivilegesAction(settings, this.getLicenseState()), new RestPutPrivilegesAction(settings, this.getLicenseState()), new RestDeletePrivilegesAction(settings, this.getLicenseState()), new RestCreateApiKeyAction(settings, this.getLicenseState(), (CreateApiKeyRequestBuilderFactory)this.createApiKeyRequestBuilderFactory.get()), new RestCreateCrossClusterApiKeyAction(settings, this.getLicenseState()), new RestUpdateApiKeyAction(settings, this.getLicenseState(), (UpdateApiKeyRequestTranslator)this.updateApiKeyRequestTranslator.get()), new RestBulkUpdateApiKeyAction(settings, this.getLicenseState(), (BulkUpdateApiKeyRequestTranslator)this.bulkUpdateApiKeyRequestTranslator.get()), new RestUpdateCrossClusterApiKeyAction(settings, this.getLicenseState()), new RestGrantApiKeyAction(settings, this.getLicenseState(), (RestGrantApiKeyAction.RequestTranslator)this.grantApiKeyRequestTranslator.get()), new RestInvalidateApiKeyAction(settings, this.getLicenseState()), new RestGetApiKeyAction(settings, this.getLicenseState()), new RestQueryApiKeyAction(settings, this.getLicenseState()), new RestDelegatePkiAuthenticationAction(settings, this.getLicenseState()), new RestCreateServiceAccountTokenAction(settings, this.getLicenseState()), new RestDeleteServiceAccountTokenAction(settings, this.getLicenseState()), new RestGetServiceAccountCredentialsAction(settings, this.getLicenseState()), new RestGetServiceAccountAction(settings, this.getLicenseState()), new RestKibanaEnrollAction(settings, this.getLicenseState()), new RestNodeEnrollmentAction(settings, this.getLicenseState()), new RestProfileHasPrivilegesAction(settings, this.getLicenseState()), new RestGetProfilesAction(settings, this.getLicenseState()), new RestActivateProfileAction(settings, this.getLicenseState()), new RestUpdateProfileDataAction(settings, this.getLicenseState()), new RestSuggestProfilesAction(settings, this.getLicenseState()), new RestEnableProfileAction(settings, this.getLicenseState()), new RestDisableProfileAction(settings, this.getLicenseState()), new RestGetSecuritySettingsAction(settings, this.getLicenseState()), new RestUpdateSecuritySettingsAction(settings, this.getLicenseState()), new RestSecurityStatsAction(settings, this.getLicenseState(), clusterSupportsFeature)}).filter(Objects::nonNull).toList();
    }

    public Map<String, Processor.Factory> getProcessors(Processor.Parameters parameters) {
        return Map.of("set_security_user", new SetSecurityUserProcessor.Factory(() -> this.securityContext.get(), this.settings));
    }

    public void onNodeStarted() {
        this.nodeStartedListenable.onResponse(null);
    }

    static void validateRealmSettings(Settings settings) {
        Set badRealmSettings = settings.keySet().stream().filter(k -> k.startsWith("xpack.security.authc.realms.")).filter(key -> {
            String suffix = key.substring("xpack.security.authc.realms.".length());
            return suffix.indexOf(46) == suffix.lastIndexOf(46);
        }).collect(Collectors.toSet());
        if (!badRealmSettings.isEmpty()) {
            String sampleRealmSetting = RealmSettings.realmSettingPrefix((RealmConfig.RealmIdentifier)new RealmConfig.RealmIdentifier("file", "my_file")) + "order";
            throw new IllegalArgumentException("Incorrect realm settings found. Realm settings have been changed to include the type as part of the setting key.\nFor example '" + sampleRealmSetting + "'\nFound invalid config: " + org.elasticsearch.common.Strings.collectionToDelimitedString(badRealmSettings, (String)", ") + "\nPlease see the breaking changes documentation.");
        }
    }

    static void validateForFips(Settings settings) {
        List<String> unsatisfiedProviders;
        Setting<String> apiKeyStoredHashSettings;
        String apiKeyStoredHashAlgo;
        Setting serviceTokenStoredHashSettings;
        String serviceTokenStoredHashAlgo;
        String selectedAlgorithm;
        Settings keystorePathSettings;
        ArrayList<CallSite> validationErrors = new ArrayList<CallSite>();
        Settings keystoreTypeSettings = settings.filter(k -> k.endsWith("keystore.type")).filter(k -> settings.get(k).equalsIgnoreCase("jks"));
        if (!keystoreTypeSettings.isEmpty()) {
            validationErrors.add((CallSite)((Object)("JKS Keystores cannot be used in a FIPS 140 compliant JVM. Please revisit [" + keystoreTypeSettings.toDelimitedString(',') + "] settings")));
        }
        if (!(keystorePathSettings = settings.filter(k -> k.endsWith("keystore.path")).filter(k -> !settings.hasValue(k.replace(".path", ".type"))).filter(k -> KeyStoreUtil.inferKeyStoreType((String)settings.get(k)).equals("jks"))).isEmpty()) {
            validationErrors.add((CallSite)((Object)("JKS Keystores cannot be used in a FIPS 140 compliant JVM. Please revisit [" + keystorePathSettings.toDelimitedString(',') + "] settings")));
        }
        if (!(selectedAlgorithm = (String)XPackSettings.PASSWORD_HASHING_ALGORITHM.get(settings)).toLowerCase(Locale.ROOT).startsWith("pbkdf2")) {
            validationErrors.add((CallSite)((Object)("Only PBKDF2 is allowed for stored credential hashing in a FIPS 140 JVM. Please set the appropriate value for [ " + XPackSettings.PASSWORD_HASHING_ALGORITHM.getKey() + " ] setting.")));
        }
        if (!(serviceTokenStoredHashAlgo = (String)(serviceTokenStoredHashSettings = XPackSettings.SERVICE_TOKEN_HASHING_ALGORITHM).get(settings)).toLowerCase(Locale.ROOT).startsWith("pbkdf2")) {
            logger.warn("Only PBKDF2 is allowed for stored credential hashing in a FIPS 140 JVM. Please set the appropriate value for [{}] setting.", (Object)serviceTokenStoredHashSettings.getKey());
        }
        if (!(apiKeyStoredHashAlgo = (String)(apiKeyStoredHashSettings = ApiKeyService.STORED_HASH_ALGO_SETTING).get(settings)).toLowerCase(Locale.ROOT).startsWith("ssha256") && !apiKeyStoredHashAlgo.toLowerCase(Locale.ROOT).startsWith("pbkdf2")) {
            logger.warn("[{}] is not recommended for stored API key hashing in a FIPS 140 JVM. The recommended hasher for [{}] is SSHA256.", apiKeyStoredHashSettings, (Object)apiKeyStoredHashSettings.getKey());
        }
        Settings cacheHashAlgoSettings = settings.filter(k -> k.endsWith(".cache.hash_algo"));
        cacheHashAlgoSettings.keySet().forEach(key -> {
            String setting = cacheHashAlgoSettings.get(key);
            assert (setting != null);
            String hashAlgoName = setting.toLowerCase(Locale.ROOT);
            if (!hashAlgoName.equals("ssha256") && !hashAlgoName.startsWith("pbkdf2")) {
                logger.warn("[{}] is not recommended for in-memory credential hashing in a FIPS 140 JVM. The recommended hasher for [{}] is SSHA256.", (Object)setting, key);
            }
        });
        HashSet<String> foundProviders = new HashSet<String>();
        for (Provider provider : java.security.Security.getProviders()) {
            foundProviders.add(provider.getName().toLowerCase(Locale.ROOT));
            if (!logger.isTraceEnabled()) continue;
            logger.trace("Security Provider: " + provider.getName() + ", Version: " + provider.getVersionStr());
            provider.entrySet().forEach(entry -> logger.trace("\t" + String.valueOf(entry.getKey())));
        }
        List requiredProviders = (List)XPackSettings.FIPS_REQUIRED_PROVIDERS.get(settings);
        logger.info("JVM Security Providers: " + String.valueOf(foundProviders));
        if (requiredProviders != null && !requiredProviders.isEmpty() && !(unsatisfiedProviders = requiredProviders.stream().map(s -> s.toLowerCase(Locale.ROOT)).filter(element -> !foundProviders.contains(element)).toList()).isEmpty()) {
            String errorMessage = "Could not find required FIPS security provider: " + String.valueOf(unsatisfiedProviders);
            logger.error(errorMessage);
            validationErrors.add((CallSite)((Object)errorMessage));
        }
        if (!validationErrors.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Validation for FIPS 140 mode failed: \n");
            int index = 0;
            for (String string : validationErrors) {
                sb.append(++index).append(": ").append(string).append(";\n");
            }
            throw new IllegalArgumentException(sb.toString());
        }
    }

    public List<TransportInterceptor> getTransportInterceptors(NamedWriteableRegistry namedWriteableRegistry, ThreadContext threadContext) {
        if (!this.enabled) {
            return Collections.emptyList();
        }
        return Collections.singletonList(new TransportInterceptor(){

            public <T extends TransportRequest> TransportRequestHandler<T> interceptHandler(String action, Executor executor, boolean forceExecution, TransportRequestHandler<T> actualHandler) {
                assert (Security.this.securityInterceptor.get() != null);
                return ((TransportInterceptor)Security.this.securityInterceptor.get()).interceptHandler(action, executor, forceExecution, actualHandler);
            }

            public TransportInterceptor.AsyncSender interceptSender(TransportInterceptor.AsyncSender sender) {
                assert (Security.this.securityInterceptor.get() != null);
                return ((TransportInterceptor)Security.this.securityInterceptor.get()).interceptSender(sender);
            }
        });
    }

    public Map<String, Supplier<Transport>> getTransports(Settings settings, ThreadPool threadPool, PageCacheRecycler pageCacheRecycler, CircuitBreakerService circuitBreakerService, NamedWriteableRegistry namedWriteableRegistry, NetworkService networkService) {
        if (!this.enabled) {
            return Collections.emptyMap();
        }
        IPFilter ipFilter = (IPFilter)this.ipFilter.get();
        return Map.of("security4", () -> {
            this.transportReference.set((Object)new SecurityNetty4ServerTransport(settings, TransportVersion.current(), threadPool, networkService, pageCacheRecycler, namedWriteableRegistry, circuitBreakerService, ipFilter, this.getSslService(), this.getNettySharedGroupFactory(settings), (RemoteClusterAuthenticationService)this.remoteClusterAuthenticationService.get()));
            return (Transport)this.transportReference.get();
        });
    }

    public Map<String, Supplier<HttpServerTransport>> getHttpTransports(Settings settings, ThreadPool threadPool, BigArrays bigArrays, PageCacheRecycler pageCacheRecycler, CircuitBreakerService circuitBreakerService, NamedXContentRegistry xContentRegistry, NetworkService networkService, HttpServerTransport.Dispatcher dispatcher, BiConsumer<HttpPreRequest, ThreadContext> perRequestThreadContext, ClusterSettings clusterSettings, TelemetryProvider telemetryProvider) {
        if (!this.enabled) {
            return Collections.emptyMap();
        }
        final IPFilter ipFilter = (IPFilter)this.ipFilter.get();
        AcceptChannelHandler.AcceptPredicate acceptPredicate = new AcceptChannelHandler.AcceptPredicate(){

            public void setBoundAddress(BoundTransportAddress boundHttpTransportAddress) {
                ipFilter.setBoundHttpTransportAddress(boundHttpTransportAddress);
            }

            public boolean test(String profile, InetSocketAddress peerAddress) {
                return ipFilter.accept(profile, peerAddress);
            }
        };
        HashMap<String, Supplier<HttpServerTransport>> httpTransports = new HashMap<String, Supplier<HttpServerTransport>>();
        httpTransports.put("security4", () -> {
            TLSConfig tlsConfig;
            BiConsumer<Channel, ThreadContext> populateClientCertificate;
            boolean ssl = (Boolean)XPackSettings.HTTP_SSL_ENABLED.get(settings);
            SSLService sslService = this.getSslService();
            if (ssl) {
                SslProfile sslProfile = sslService.profile(XPackSettings.HTTP_SSL_PREFIX);
                SslConfiguration sslConfiguration = sslProfile.configuration();
                if (!SSLService.isConfigurationValidForServerUsage((SslConfiguration)sslConfiguration)) {
                    throw new IllegalArgumentException("a key must be provided to run as a server. the key should be configured using the [xpack.security.http.ssl.key] or [xpack.security.http.ssl.keystore.path] setting");
                }
                populateClientCertificate = SSLService.isSSLClientAuthEnabled((SslConfiguration)sslConfiguration) ? (channel, threadContext) -> SSLEngineUtils.extractClientCertificates(logger, threadContext, channel) : (channel, threadContext) -> {};
                tlsConfig = new TLSConfig((arg_0, arg_1) -> ((SslProfile)sslProfile).engine(arg_0, arg_1));
            } else {
                tlsConfig = TLSConfig.noTLS();
                populateClientCertificate = (channel, threadContext) -> {};
            }
            AuthenticationService authenticationService = (AuthenticationService)this.authcService.get();
            ThreadContext threadContext2 = (ThreadContext)this.threadContext.get();
            return Security.getHttpServerTransportWithHeadersValidator(settings, networkService, threadPool, xContentRegistry, dispatcher, clusterSettings, this.getNettySharedGroupFactory(settings), telemetryProvider, tlsConfig, acceptPredicate, (httpRequest, channel, listener) -> {
                HttpPreRequest httpPreRequest = HttpHeadersAuthenticatorUtils.asHttpPreRequest((io.netty.handler.codec.http.HttpRequest)httpRequest);
                perRequestThreadContext.accept(httpPreRequest, threadContext2);
                populateClientCertificate.accept(channel, threadContext2);
                RemoteHostHeader.process(channel, threadContext2);
                authenticationService.authenticate(httpPreRequest, (ActionListener<Authentication>)listener.delegateFailureAndWrap((l, ignored) -> l.onResponse(null)));
            }, (httpRequest, channel, listener) -> {
                HttpPreRequest httpPreRequest = HttpHeadersAuthenticatorUtils.asHttpPreRequest((io.netty.handler.codec.http.HttpRequest)httpRequest);
                perRequestThreadContext.accept(httpPreRequest, threadContext2);
                populateClientCertificate.accept(channel, threadContext2);
                RemoteHostHeader.process(channel, threadContext2);
                listener.onResponse(null);
            });
        });
        return httpTransports;
    }

    public static Netty4HttpServerTransport getHttpServerTransportWithHeadersValidator(Settings settings, NetworkService networkService, ThreadPool threadPool, NamedXContentRegistry xContentRegistry, HttpServerTransport.Dispatcher dispatcher, ClusterSettings clusterSettings, SharedGroupFactory sharedGroupFactory, TelemetryProvider telemetryProvider, TLSConfig tlsConfig, @Nullable AcceptChannelHandler.AcceptPredicate acceptPredicate, HttpValidator httpValidator, HttpValidator httpOptionsValidator) {
        return Security.getHttpServerTransportWithHeadersValidator(settings, networkService, threadPool, xContentRegistry, dispatcher, clusterSettings, sharedGroupFactory, telemetryProvider, tlsConfig, acceptPredicate, (httpRequest, channel, listener) -> {
            if (httpRequest.method() == HttpMethod.OPTIONS) {
                if (HttpUtil.getContentLength((HttpMessage)httpRequest, (long)-1L) > 1L || HttpUtil.isTransferEncodingChunked((HttpMessage)httpRequest)) {
                    listener.onFailure((Exception)new ElasticsearchStatusException("OPTIONS requests with a payload body are not supported", RestStatus.BAD_REQUEST, new Object[0]));
                } else {
                    httpOptionsValidator.validate(httpRequest, channel, listener);
                }
            } else {
                httpValidator.validate(httpRequest, channel, listener);
            }
        });
    }

    public static Netty4HttpServerTransport getHttpServerTransportWithHeadersValidator(Settings settings, NetworkService networkService, ThreadPool threadPool, NamedXContentRegistry xContentRegistry, HttpServerTransport.Dispatcher dispatcher, ClusterSettings clusterSettings, SharedGroupFactory sharedGroupFactory, TelemetryProvider telemetryProvider, TLSConfig tlsConfig, @Nullable AcceptChannelHandler.AcceptPredicate acceptPredicate, HttpValidator httpValidator) {
        return new Netty4HttpServerTransport(settings, networkService, threadPool, xContentRegistry, dispatcher, clusterSettings, sharedGroupFactory, telemetryProvider, tlsConfig, acceptPredicate, Objects.requireNonNull(httpValidator)){

            protected void populatePerRequestThreadContext(RestRequest restRequest, ThreadContext threadContext) {
                ThreadContext.StoredContext authenticationThreadContext = HttpHeadersAuthenticatorUtils.extractAuthenticationContext((HttpRequest)restRequest.getHttpRequest());
                if (authenticationThreadContext == null) {
                    throw new ElasticsearchSecurityException("Request is not authenticated", new Object[0]);
                }
                authenticationThreadContext.restore();
            }
        };
    }

    public RestInterceptor getRestHandlerInterceptor(ThreadContext threadContext) {
        return new SecurityRestFilter(this.enabled, threadContext, (SecondaryAuthenticator)this.secondayAuthc.get(), (AuditTrailService)this.auditTrailService.get(), (OperatorPrivileges.OperatorPrivilegesService)this.operatorPrivilegesService.get());
    }

    public List<ExecutorBuilder<?>> getExecutorBuilders(Settings settings) {
        if (this.enabled) {
            int allocatedProcessors = EsExecutors.allocatedProcessors((Settings)settings);
            return List.of(new FixedExecutorBuilder(settings, "security-token-key", 1, 1000, "xpack.security.authc.token.thread_pool", EsExecutors.TaskTrackingConfig.DO_NOT_TRACK), new FixedExecutorBuilder(settings, SECURITY_CRYPTO_THREAD_POOL_NAME, (allocatedProcessors + 1) / 2, 1000, "xpack.security.crypto.thread_pool", EsExecutors.TaskTrackingConfig.DO_NOT_TRACK));
        }
        return Collections.emptyList();
    }

    public UnaryOperator<Map<String, IndexTemplateMetadata>> getIndexTemplateMetadataUpgrader() {
        return templates -> {
            templates.remove("security_audit_log");
            templates.remove("security-index-template");
            return templates;
        };
    }

    public Function<String, FieldPredicate> getFieldFilter() {
        if (this.enabled) {
            return index -> {
                XPackLicenseState licenseState = this.getLicenseState();
                IndicesAccessControl indicesAccessControl = (IndicesAccessControl)AuthorizationServiceField.INDICES_PERMISSIONS_VALUE.get((ThreadContext)this.threadContext.get());
                if (!((Boolean)this.dlsFlsEnabled.get()).booleanValue()) {
                    return FieldPredicate.ACCEPT_ALL;
                }
                if (indicesAccessControl == null) {
                    return FieldPredicate.ACCEPT_ALL;
                }
                assert (indicesAccessControl.isGranted());
                IndexNameExpressionResolver.assertExpressionHasNullOrDataSelector((String)index);
                IndicesAccessControl.IndexAccessControl indexPermissions = indicesAccessControl.getIndexPermissions(index);
                if (indexPermissions == null) {
                    return FieldPredicate.ACCEPT_ALL;
                }
                FieldPermissions fieldPermissions = indexPermissions.getFieldPermissions();
                if (!fieldPermissions.hasFieldLevelSecurity()) {
                    return FieldPredicate.ACCEPT_ALL;
                }
                if (!SecurityField.FIELD_LEVEL_SECURITY_FEATURE.checkWithoutTracking(licenseState)) {
                    return FieldPredicate.ACCEPT_ALL;
                }
                return fieldPermissions.fieldPredicate();
            };
        }
        return super.getFieldFilter();
    }

    public BiConsumer<DiscoveryNode, ClusterState> getJoinValidator() {
        if (this.enabled) {
            return new ValidateLicenseForFIPS((Boolean)XPackSettings.FIPS_MODE_ENABLED.get(this.settings), this.getLicenseService());
        }
        return null;
    }

    public void reload(Settings settings) throws Exception {
        if (this.enabled) {
            ArrayList<Exception> reloadExceptions = new ArrayList<Exception>();
            try {
                this.reloadRemoteClusterCredentials(settings);
            }
            catch (Exception ex) {
                reloadExceptions.add(ex);
            }
            this.getReloadableSecurityComponents().forEach(component -> {
                try {
                    component.reload(settings);
                }
                catch (Exception ex) {
                    reloadExceptions.add(ex);
                }
            });
            if (!reloadExceptions.isEmpty()) {
                ElasticsearchException combinedException = new ElasticsearchException("secure settings reload failed for one or more security components", new Object[0]);
                reloadExceptions.forEach(arg_0 -> combinedException.addSuppressed(arg_0));
                throw combinedException;
            }
        } else {
            this.ensureNoRemoteClusterCredentialsOnDisabledSecurity(settings);
        }
    }

    private void reloadRemoteClusterCredentials(Settings settingsWithKeystore) {
        if (DiscoveryNode.isStateless((Settings)this.settings)) {
            return;
        }
        UnsafePlainActionFuture future = new UnsafePlainActionFuture(new String[]{"generic"});
        this.getClient().execute(ActionTypes.RELOAD_REMOTE_CLUSTER_CREDENTIALS_ACTION, (ActionRequest)new TransportReloadRemoteClusterCredentialsAction.Request(settingsWithKeystore), (ActionListener)future);
        future.actionGet();
    }

    public Map<String, String> getAuthContextForSlowLog() {
        if (this.securityContext.get() != null && ((SecurityContext)this.securityContext.get()).getAuthentication() != null) {
            Map<String, String> authContext;
            Authentication authentication = ((SecurityContext)this.securityContext.get()).getAuthentication();
            if (authentication.isCrossClusterAccess()) {
                Authentication originalAuthentication = Authentication.getAuthenticationFromCrossClusterAccessMetadata((Authentication)authentication);
                authContext = this.createAuthContextMap(originalAuthentication);
            } else {
                authContext = this.createAuthContextMap(authentication);
            }
            return authContext;
        }
        return Map.of();
    }

    private Map<String, String> createAuthContextMap(Authentication auth) {
        HashMap<String, String> authContext = new HashMap<String, String>();
        Subject authenticatingSubject = auth.getAuthenticatingSubject();
        Subject effectiveSubject = auth.getEffectiveSubject();
        if (authenticatingSubject.getUser() != null) {
            authContext.put("user.name", authenticatingSubject.getUser().principal());
            authContext.put("user.realm", authenticatingSubject.getRealm().getName());
            if (authenticatingSubject.getUser().fullName() != null) {
                authContext.put("user.full_name", authenticatingSubject.getUser().fullName());
            }
        }
        if (auth.isRunAs() && effectiveSubject.getUser() != null) {
            authContext.put("user.effective.name", effectiveSubject.getUser().principal());
            authContext.put("user.effective.realm", effectiveSubject.getRealm().getName());
            if (effectiveSubject.getUser().fullName() != null) {
                authContext.put("user.effective.full_name", effectiveSubject.getUser().fullName());
            }
        }
        authContext.put("auth.type", auth.getAuthenticationType().name());
        if (auth.isApiKey()) {
            authContext.put("apikey.id", Objects.toString(authenticatingSubject.getMetadata().get("_security_api_key_id")));
            Object apiKeyName = authenticatingSubject.getMetadata().get("_security_api_key_name");
            if (apiKeyName != null) {
                authContext.put("apikey.name", apiKeyName.toString());
            }
        }
        return authContext;
    }

    public void loadExtensions(ExtensiblePlugin.ExtensionLoader loader) {
        this.securityExtensions.addAll(loader.loadExtensions(SecurityExtension.class));
        this.loadSingletonExtensionAndSetOnce(loader, this.operatorOnlyRegistry, OperatorOnlyRegistry.class);
        this.loadSingletonExtensionAndSetOnce(loader, this.putRoleRequestBuilderFactory, PutRoleRequestBuilderFactory.class);
        this.loadSingletonExtensionAndSetOnce(loader, this.getBuiltinPrivilegesResponseTranslator, GetBuiltinPrivilegesResponseTranslator.class);
        this.loadSingletonExtensionAndSetOnce(loader, this.updateApiKeyRequestTranslator, UpdateApiKeyRequestTranslator.class);
        this.loadSingletonExtensionAndSetOnce(loader, this.bulkUpdateApiKeyRequestTranslator, BulkUpdateApiKeyRequestTranslator.class);
        this.loadSingletonExtensionAndSetOnce(loader, this.createApiKeyRequestBuilderFactory, CreateApiKeyRequestBuilderFactory.class);
        this.loadSingletonExtensionAndSetOnce(loader, this.hasPrivilegesRequestBuilderFactory, HasPrivilegesRequestBuilderFactory.class);
        this.loadSingletonExtensionAndSetOnce(loader, this.authorizationDenialMessages, AuthorizationDenialMessages.class);
        this.loadSingletonExtensionAndSetOnce(loader, this.reservedRoleNameCheckerFactory, ReservedRoleNameChecker.Factory.class);
        this.loadSingletonExtensionAndSetOnce(loader, this.grantApiKeyRequestTranslator, RestGrantApiKeyAction.RequestTranslator.class);
        this.loadSingletonExtensionAndSetOnce(loader, this.fileRoleValidator, FileRoleValidator.class);
        this.loadSingletonExtensionAndSetOnce(loader, this.secondaryAuthActions, SecondaryAuthActions.class);
        this.loadSingletonExtensionAndSetOnce(loader, this.queryableRolesProviderFactory, QueryableBuiltInRolesProviderFactory.class);
        this.loadSingletonExtensionAndSetOnce(loader, this.samlAuthenticateResponseHandlerFactory, SamlAuthenticateResponseHandler.Factory.class);
        this.loadSingletonExtensionAndSetOnce(loader, this.remoteClusterSecurityExtensionProvider, RemoteClusterSecurityExtension.Provider.class, CrossClusterAccessSecurityExtension.Provider::new);
    }

    private <T> void loadSingletonExtensionAndSetOnce(ExtensiblePlugin.ExtensionLoader loader, SetOnce<T> setOnce, Class<T> clazz) {
        this.loadSingletonExtensionAndSetOnce(loader, setOnce, clazz, () -> null);
    }

    private <T> void loadSingletonExtensionAndSetOnce(ExtensiblePlugin.ExtensionLoader loader, SetOnce<T> setOnce, Class<T> clazz, Supplier<T> defaultExtensionProvider) {
        List loaded = loader.loadExtensions(clazz);
        if (loaded.size() > 1) {
            throw new IllegalStateException(String.valueOf(clazz) + " may not have multiple implementations");
        }
        if (loaded.size() == 1) {
            Object singleLoaded = loaded.get(0);
            setOnce.set(singleLoaded);
            logger.debug("Loaded implementation [{}] for interface [{}]", (Object)singleLoaded.getClass().getCanonicalName(), clazz);
        } else {
            T defaultExtension = defaultExtensionProvider.get();
            if (defaultExtension != null) {
                logger.debug("Falling back on default implementation [{}] for interface [{}]", (Object)defaultExtension.getClass().getCanonicalName(), clazz);
                setOnce.set(defaultExtension);
            }
        }
    }

    private synchronized SharedGroupFactory getNettySharedGroupFactory(Settings settings) {
        if (this.sharedGroupFactory.get() != null) {
            assert (((SharedGroupFactory)this.sharedGroupFactory.get()).getSettings().equals((Object)settings)) : "Different settings than originally provided";
            return (SharedGroupFactory)this.sharedGroupFactory.get();
        }
        this.sharedGroupFactory.set((Object)new SharedGroupFactory(settings));
        return (SharedGroupFactory)this.sharedGroupFactory.get();
    }

    public Collection<SystemIndexDescriptor> getSystemIndexDescriptors(Settings settings) {
        return this.systemIndices.getSystemIndexDescriptors();
    }

    public String getFeatureName() {
        return "security";
    }

    public String getFeatureDescription() {
        return "Manages configuration for Security features, such as users and roles";
    }

    public CheckedBiConsumer<ShardSearchRequest, StreamOutput, IOException> getRequestCacheKeyDifferentiator() {
        if (!this.enabled) {
            return null;
        }
        return new DlsFlsRequestCacheDifferentiator(this.getLicenseState(), this.securityContext, this.scriptServiceReference);
    }

    public List<PersistentTasksExecutor<?>> getPersistentTasksExecutor(ClusterService clusterService, ThreadPool threadPool, Client client, SettingsModule settingsModule, IndexNameExpressionResolver expressionResolver) {
        SecurityMigrations.Manager manager = (SecurityMigrations.Manager)this.migrationManager.get();
        return manager == null ? List.of() : List.of(manager.getPersistentTasksExecutor(client, threadPool));
    }

    List<ReservedProjectStateHandler<?>> reservedProjectStateHandlers() {
        if (!this.enabled) {
            return Collections.emptyList();
        }
        return List.of((ReservedProjectStateHandler)this.reservedRoleMappingAction.get());
    }

    OperatorPrivileges.OperatorPrivilegesService getOperatorPrivilegesService() {
        return (OperatorPrivileges.OperatorPrivilegesService)this.operatorPrivilegesService.get();
    }

    public void close() throws IOException {
        if (this.enabled && this.closableComponents.get() != null) {
            IOUtils.close((Iterable)((Iterable)this.closableComponents.get()));
        }
    }

    private static /* synthetic */ Boolean lambda$resolveSecuredConfigFile$1(Path legacyConfig) {
        return Files.exists(legacyConfig, new LinkOption[0]);
    }

    static final class ValidateLicenseForFIPS
    implements BiConsumer<DiscoveryNode, ClusterState> {
        private final boolean inFipsMode;
        private final LicenseService licenseService;

        ValidateLicenseForFIPS(boolean inFipsMode, LicenseService licenseService) {
            this.inFipsMode = inFipsMode;
            this.licenseService = licenseService;
        }

        @Override
        public void accept(DiscoveryNode node, ClusterState state) {
            if (this.inFipsMode) {
                License license;
                LicenseService licenseService = this.licenseService;
                if (licenseService instanceof ClusterStateLicenseService) {
                    ClusterStateLicenseService clusterStateLicenseService = (ClusterStateLicenseService)licenseService;
                    license = clusterStateLicenseService.getLicense(state.metadata());
                } else {
                    license = this.licenseService.getLicense();
                }
                if (license != null && !XPackLicenseState.isFipsAllowedForOperationMode((License.OperationMode)license.operationMode())) {
                    throw new IllegalStateException("FIPS mode cannot be used with a [" + String.valueOf(license.operationMode()) + "] license. It is only allowed with a Platinum or Trial license.");
                }
            }
        }
    }
}

