# -----------------------------------------------------------------------------
# Copyright (c) 2021, 2024, Oracle and/or its affiliates.
#
# This software is dual-licensed to you under the Universal Permissive License
# (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl and Apache License
# 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose
# either license.
#
# If you elect to accept the software under the Apache License, Version 2.0,
# the following applies:
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
# -----------------------------------------------------------------------------

# -----------------------------------------------------------------------------
# defaults.py
#
# Contains the Defaults class used for managing default values used throughout
# the module.
# -----------------------------------------------------------------------------

from . import base_impl
from . import __name__ as MODULE_NAME


class Defaults:
    """
    Identifies the default values used by the driver.
    """

    __module__ = MODULE_NAME

    def __init__(self) -> None:
        self._impl = base_impl.DEFAULTS

    @property
    def arraysize(self) -> int:
        """
        Specifies the default arraysize to use when cursors are created.
        """
        return self._impl.arraysize

    @arraysize.setter
    def arraysize(self, value: int):
        self._impl.arraysize = value

    @property
    def config_dir(self) -> str:
        """
        Specifies the directory to search for tnsnames.ora.
        """
        return self._impl.config_dir

    @config_dir.setter
    def config_dir(self, value: str):
        self._impl.config_dir = value

    @property
    def fetch_lobs(self) -> bool:
        """
        Specifies whether queries that contain LOBs should return LOB objects
        or their contents instead.
        """
        return self._impl.fetch_lobs

    @fetch_lobs.setter
    def fetch_lobs(self, value: str):
        self._impl.fetch_lobs = value

    @property
    def fetch_decimals(self) -> bool:
        """
        Specifies whether queries that contain numbers should return
        decimal.Decimal objects or floating point numbers.
        """
        return self._impl.fetch_decimals

    @fetch_decimals.setter
    def fetch_decimals(self, value: str):
        self._impl.fetch_decimals = value

    @property
    def prefetchrows(self) -> int:
        """
        Specifies the default number of rows to prefetch when cursors are
        executed.
        """
        return self._impl.prefetchrows

    @prefetchrows.setter
    def prefetchrows(self, value: int):
        self._impl.prefetchrows = value

    @property
    def stmtcachesize(self) -> int:
        """
        Specifies the default size of the statement cache.
        """
        return self._impl.stmtcachesize

    @stmtcachesize.setter
    def stmtcachesize(self, value: int):
        self._impl.stmtcachesize = value


defaults = Defaults()
