/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.am;

import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;

public class DateTimeValue {
    private final int year;
    private final int month;
    private final int day;
    private final int hours;
    private final int minutes;
    private final int seconds;
    private final int nanos;

    private DateTimeValue(Calendar cal, int nanoFraction) {
        this.year = cal.get(1);
        this.month = cal.get(2);
        this.day = cal.get(5);
        this.hours = cal.get(11);
        this.minutes = cal.get(12);
        this.seconds = cal.get(13);
        int millis = cal.get(14);
        this.nanos = millis * 1000000 + nanoFraction % 1000000;
    }

    DateTimeValue(java.sql.Date date, Calendar cal) {
        this(DateTimeValue.initCalendar(cal, date), 0);
    }

    DateTimeValue(Time time, Calendar cal) {
        this(DateTimeValue.initCalendar(cal, time), 0);
    }

    DateTimeValue(Timestamp ts, Calendar cal) {
        this(DateTimeValue.initCalendar(cal, ts), ts.getNanos());
    }

    public DateTimeValue(java.sql.Date date) {
        this(date, Calendar.getInstance());
    }

    public DateTimeValue(Time time) {
        this(time, Calendar.getInstance());
    }

    public DateTimeValue(Timestamp ts) {
        this(ts, Calendar.getInstance());
    }

    private static Calendar initCalendar(Calendar cal, Date date) {
        cal.clear();
        cal.setTime(date);
        return cal;
    }

    public int getYear() {
        return this.year;
    }

    public int getMonth() {
        return this.month;
    }

    public int getDayOfMonth() {
        return this.day;
    }

    public int getHours() {
        return this.hours;
    }

    public int getMinutes() {
        return this.minutes;
    }

    public int getSeconds() {
        return this.seconds;
    }

    public int getNanos() {
        return this.nanos;
    }
}

