/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.compress;

import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.kafka.common.compress.GzipCompression;
import org.apache.kafka.common.compress.Lz4Compression;
import org.apache.kafka.common.compress.NoCompression;
import org.apache.kafka.common.compress.SnappyCompression;
import org.apache.kafka.common.compress.ZstdCompression;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.utils.BufferSupplier;
import org.apache.kafka.common.utils.ByteBufferOutputStream;

public interface Compression {
    public static final NoCompression NONE = Compression.none().build();

    public CompressionType type();

    public OutputStream wrapForOutput(ByteBufferOutputStream var1, byte var2);

    public InputStream wrapForInput(ByteBuffer var1, byte var2, BufferSupplier var3);

    default public int decompressionOutputSize() {
        throw new UnsupportedOperationException("Size of decompression buffer is not defined for this compression type=" + this.type().name);
    }

    public static Builder<? extends Compression> of(String compressionName) {
        CompressionType compressionType = CompressionType.forName(compressionName);
        return Compression.of(compressionType);
    }

    public static Builder<? extends Compression> of(CompressionType compressionType) {
        switch (compressionType) {
            case NONE: {
                return Compression.none();
            }
            case GZIP: {
                return Compression.gzip();
            }
            case SNAPPY: {
                return Compression.snappy();
            }
            case LZ4: {
                return Compression.lz4();
            }
            case ZSTD: {
                return Compression.zstd();
            }
        }
        throw new IllegalArgumentException("Unknown compression type: " + compressionType.name);
    }

    public static NoCompression.Builder none() {
        return new NoCompression.Builder();
    }

    public static GzipCompression.Builder gzip() {
        return new GzipCompression.Builder();
    }

    public static SnappyCompression.Builder snappy() {
        return new SnappyCompression.Builder();
    }

    public static Lz4Compression.Builder lz4() {
        return new Lz4Compression.Builder();
    }

    public static ZstdCompression.Builder zstd() {
        return new ZstdCompression.Builder();
    }

    public static interface Builder<T extends Compression> {
        public T build();
    }
}

