/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.support;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.elasticsearch.common.Strings;
import org.elasticsearch.search.aggregations.AggregationErrors;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.aggregations.bucket.SingleBucketAggregator;
import org.elasticsearch.search.aggregations.metrics.NumericMetricsAggregator;
import org.elasticsearch.search.profile.aggregation.ProfilingAggregator;
import org.elasticsearch.search.sort.SortOrder;
import org.elasticsearch.search.sort.SortValue;

public class AggregationPath {
    private static final String AGG_DELIM = ">";
    private final List<PathElement> pathElements;

    public static boolean pathElementContainsBucketKey(PathElement pathElement) {
        return pathElement != null && pathElement.key() != null && pathElement.key().startsWith("'") && pathElement.key().endsWith("'");
    }

    public static List<String> pathElementsAsStringList(List<PathElement> pathElements) {
        ArrayList<String> stringPathElements = new ArrayList<String>();
        for (PathElement pathElement : pathElements) {
            stringPathElements.add(pathElement.name);
            if (pathElement.key != null) {
                stringPathElements.add(pathElement.key);
            }
            if (pathElement.metric == null) continue;
            stringPathElements.add(pathElement.metric);
        }
        return stringPathElements;
    }

    public static AggregationPath parse(String path) {
        String[] elements = Strings.tokenizeToStringArray(path, AGG_DELIM);
        ArrayList<PathElement> tokens = new ArrayList<PathElement>(elements.length);
        String[] tuple = new String[2];
        for (int i = 0; i < elements.length; ++i) {
            int keyIndex;
            String element = elements[i];
            if (i == elements.length - 1) {
                keyIndex = element.lastIndexOf(91);
                int metricIndex = element.lastIndexOf(46);
                if (keyIndex >= 0) {
                    if (keyIndex == 0 || keyIndex > element.length() - 3) {
                        throw AggregationErrors.invalidPathElement(element, path);
                    }
                    int endKeyIndex = element.lastIndexOf(93);
                    if (endKeyIndex < keyIndex) {
                        throw AggregationErrors.invalidPathElement(element, path);
                    }
                    if (metricIndex < 0 && endKeyIndex != element.length() - 1) {
                        throw AggregationErrors.invalidPathElement(element, path);
                    }
                    tokens.add(new PathElement(element, element.substring(0, keyIndex), element.substring(keyIndex + 1, endKeyIndex), metricIndex < endKeyIndex ? null : element.substring(metricIndex + 1)));
                    continue;
                }
                if (metricIndex < 0) {
                    tokens.add(new PathElement(element, element, null, null));
                    continue;
                }
                if (metricIndex == 0 || metricIndex > element.length() - 2) {
                    throw AggregationErrors.invalidPathElement(element, path);
                }
                tuple = AggregationPath.split(element, metricIndex, tuple);
                tokens.add(new PathElement(element, tuple[0], null, tuple[1]));
                continue;
            }
            keyIndex = element.lastIndexOf(91);
            if (keyIndex >= 0) {
                if (keyIndex == 0 || keyIndex > element.length() - 3) {
                    throw AggregationErrors.invalidPathElement(element, path);
                }
                if (element.charAt(element.length() - 1) != ']') {
                    throw AggregationErrors.invalidPathElement(element, path);
                }
                tokens.add(new PathElement(element, element.substring(0, keyIndex), element.substring(keyIndex + 1, element.length() - 1), null));
                continue;
            }
            tokens.add(new PathElement(element, element, null, null));
        }
        return new AggregationPath(tokens);
    }

    public AggregationPath(List<PathElement> tokens) {
        this.pathElements = tokens;
        if (tokens == null || tokens.size() == 0) {
            throw new IllegalArgumentException("Invalid path [" + String.valueOf(this) + "]");
        }
    }

    public String toString() {
        return Strings.arrayToDelimitedString(this.pathElements.toArray(), AGG_DELIM);
    }

    public PathElement lastPathElement() {
        return this.pathElements.get(this.pathElements.size() - 1);
    }

    public List<PathElement> getPathElements() {
        return this.pathElements;
    }

    public List<String> getPathElementsAsStringList() {
        return AggregationPath.pathElementsAsStringList(this.pathElements);
    }

    public SortValue resolveValue(InternalAggregations aggregations) {
        try {
            Iterator<PathElement> path = this.pathElements.iterator();
            assert (path.hasNext());
            return aggregations.sortValue(path.next(), path);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Invalid aggregation order path [" + String.valueOf(this) + "]. " + e.getMessage(), e);
        }
    }

    public Aggregator resolveAggregator(Aggregator root) {
        Iterator<PathElement> path = this.pathElements.iterator();
        assert (path.hasNext());
        return root.resolveSortPathOnValidAgg(path.next(), path);
    }

    public Aggregator resolveTopmostAggregator(Aggregator root) {
        PathElement token = this.pathElements.get(0);
        Aggregator aggregator = ProfilingAggregator.unwrap(root.subAggregator(token.name));
        assert (aggregator instanceof SingleBucketAggregator || aggregator instanceof NumericMetricsAggregator) : "this should be picked up before aggregation execution - on validate";
        return aggregator;
    }

    public Aggregator.BucketComparator bucketComparator(Aggregator root, SortOrder order) {
        return this.resolveAggregator(root).bucketComparator(Optional.ofNullable(this.lastPathElement().key).orElse(this.lastPathElement().metric), order);
    }

    private static String[] split(String toSplit, int index, String[] result) {
        result[0] = toSplit.substring(0, index);
        result[1] = toSplit.substring(index + 1);
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AggregationPath other = (AggregationPath)obj;
        return this.pathElements.equals(other.pathElements);
    }

    public int hashCode() {
        return this.pathElements.hashCode();
    }

    public record PathElement(String fullName, String name, String key, String metric) {
        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PathElement token = (PathElement)o;
            return Objects.equals(this.key, token.key) && Objects.equals(this.name, token.name) && Objects.equals(this.metric, token.metric);
        }

        @Override
        public int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + (this.key != null ? this.key.hashCode() : 0);
            result = 31 * result + (this.metric != null ? this.metric.hashCode() : 0);
            return result;
        }

        @Override
        public String toString() {
            return this.fullName;
        }
    }
}

