/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.action.fieldcaps.FieldCapabilitiesRequest;
import org.elasticsearch.action.fieldcaps.FieldCapabilitiesResponse;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.CheckedConsumer;
import org.elasticsearch.index.query.AbstractQueryBuilder;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.Scope;
import org.elasticsearch.rest.ServerlessScope;
import org.elasticsearch.rest.action.RestCancellableNodeClient;
import org.elasticsearch.rest.action.RestRefCountedChunkedToXContentListener;
import org.elasticsearch.search.crossproject.CrossProjectModeDecider;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.XContentParser;

@ServerlessScope(value=Scope.PUBLIC)
public class RestFieldCapabilitiesAction
extends BaseRestHandler {
    private final Settings settings;
    private final CrossProjectModeDecider crossProjectModeDecider;
    private static final ParseField INDEX_FILTER_FIELD = new ParseField("index_filter", new String[0]);
    private static final ParseField RUNTIME_MAPPINGS_FIELD = new ParseField("runtime_mappings", new String[0]);
    private static final ParseField FIELDS_FIELD = new ParseField("fields", new String[0]);
    private static final ParseField PROJECT_ROUTING = new ParseField("project_routing", new String[0]);
    private static final ObjectParser<FieldCapabilitiesRequest, Void> PARSER = new ObjectParser("field_caps_request");

    public RestFieldCapabilitiesAction(Settings settings) {
        this.settings = settings;
        this.crossProjectModeDecider = new CrossProjectModeDecider(settings);
    }

    @Override
    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.GET, "/_field_caps"), new RestHandler.Route(RestRequest.Method.POST, "/_field_caps"), new RestHandler.Route(RestRequest.Method.GET, "/{index}/_field_caps"), new RestHandler.Route(RestRequest.Method.POST, "/{index}/_field_caps"));
    }

    @Override
    public String getName() {
        return "field_capabilities_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        FieldCapabilitiesRequest fieldRequest = new FieldCapabilitiesRequest();
        boolean crossProjectEnabled = this.crossProjectModeDecider.crossProjectEnabled();
        if (this.crossProjectModeDecider.crossProjectEnabled()) {
            fieldRequest.projectRouting(request.param("project_routing", null));
            fieldRequest.includeResolvedTo(true);
        }
        String[] indices = Strings.splitStringByCommaToArray(request.param("index"));
        fieldRequest.indices(indices);
        if (crossProjectEnabled && fieldRequest.allowsCrossProject()) {
            IndicesOptions cpsIdxOpts = IndicesOptions.builder(fieldRequest.indicesOptions()).crossProjectModeOptions(new IndicesOptions.CrossProjectModeOptions(true)).build();
            fieldRequest.indicesOptions(cpsIdxOpts);
        }
        fieldRequest.indicesOptions(IndicesOptions.fromRequest(request, fieldRequest.indicesOptions()));
        fieldRequest.includeUnmapped(request.paramAsBoolean("include_unmapped", false));
        fieldRequest.includeEmptyFields(request.paramAsBoolean("include_empty_fields", true));
        fieldRequest.filters(request.paramAsStringArray("filters", Strings.EMPTY_ARRAY));
        fieldRequest.types(request.paramAsStringArray("types", Strings.EMPTY_ARRAY));
        request.withContentOrSourceParamParserOrNull((CheckedConsumer<XContentParser, IOException>)((CheckedConsumer)parser -> {
            if (parser != null) {
                PARSER.parse(parser, (Object)fieldRequest, null);
            }
        }));
        if (request.hasParam("fields")) {
            if (fieldRequest.fields().length > 0) {
                throw new IllegalArgumentException("can't specify a request body and [fields] request parameter, either specify a request body or the [fields] request parameter");
            }
            fieldRequest.fields(Strings.splitStringByCommaToArray(request.param("fields")));
        }
        return channel -> {
            RestCancellableNodeClient cancelClient = new RestCancellableNodeClient(client, request.getHttpChannel());
            cancelClient.fieldCaps(fieldRequest, new RestRefCountedChunkedToXContentListener<FieldCapabilitiesResponse>((RestChannel)channel));
        };
    }

    static {
        PARSER.declareObject(FieldCapabilitiesRequest::indexFilter, (p, c) -> AbstractQueryBuilder.parseTopLevelQuery(p), INDEX_FILTER_FIELD);
        PARSER.declareObject(FieldCapabilitiesRequest::runtimeFields, (p, c) -> p.map(), RUNTIME_MAPPINGS_FIELD);
        PARSER.declareStringArray(ObjectParser.fromList(String.class, FieldCapabilitiesRequest::fields), FIELDS_FIELD);
        PARSER.declareString(FieldCapabilitiesRequest::projectRouting, PROJECT_ROUTING);
    }
}

