/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.time.ZoneId;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.queries.spans.SpanMultiTermQueryWrapper;
import org.apache.lucene.queries.spans.SpanQuery;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.FieldExistsQuery;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.CharacterRunAutomaton;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.geo.ShapeRelation;
import org.elasticsearch.common.time.DateMathParser;
import org.elasticsearch.common.unit.Fuzziness;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.fielddata.FieldDataContext;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.mapper.BlockLoader;
import org.elasticsearch.index.mapper.FieldNamesFieldMapper;
import org.elasticsearch.index.mapper.IndexType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.TextSearchInfo;
import org.elasticsearch.index.mapper.TimeSeriesParams;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.index.mapper.blockloader.BlockLoaderFunctionConfig;
import org.elasticsearch.index.query.QueryRewriteContext;
import org.elasticsearch.index.query.QueryShardException;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.SearchService;
import org.elasticsearch.search.lookup.SearchLookup;

public abstract class MappedFieldType {
    private final String name;
    protected final IndexType indexType;
    private final boolean isStored;
    private final Map<String, String> meta;

    public MappedFieldType(String name, IndexType indexType, boolean isStored, Map<String, String> meta) {
        this.name = Mapper.internFieldName(name);
        this.indexType = indexType;
        this.isStored = isStored;
        this.meta = meta.size() <= 1 ? Map.copyOf(meta) : meta;
    }

    public IndexFieldData.Builder fielddataBuilder(FieldDataContext fieldDataContext) {
        throw new IllegalArgumentException("Fielddata is not supported on field [" + this.name() + "] of type [" + this.typeName() + "]");
    }

    public abstract ValueFetcher valueFetcher(SearchExecutionContext var1, @Nullable String var2);

    public abstract String typeName();

    public String familyTypeName() {
        return this.typeName();
    }

    public String name() {
        return this.name;
    }

    public boolean hasDocValues() {
        return this.indexType.hasDocValues();
    }

    public CollapseType collapseType() {
        return CollapseType.NONE;
    }

    public Object valueForDisplay(Object value) {
        return value;
    }

    public boolean isSearchable() {
        return this.indexType != IndexType.NONE;
    }

    public final IndexType indexType() {
        return this.indexType;
    }

    public final boolean isStored() {
        return this.isStored;
    }

    @Nullable
    public Function<byte[], Number> pointReaderIfPossible() {
        return null;
    }

    public boolean isAggregatable() {
        return this.hasDocValues();
    }

    public boolean isDimension() {
        return false;
    }

    public boolean isVectorEmbedding() {
        return false;
    }

    public boolean hasScriptValues() {
        return false;
    }

    public List<String> dimensions() {
        return Collections.emptyList();
    }

    public TimeSeriesParams.MetricType getMetricType() {
        return null;
    }

    public String getDefaultHighlighter() {
        return "unified";
    }

    public abstract Query termQuery(Object var1, @Nullable SearchExecutionContext var2);

    public Query termQueryCaseInsensitive(Object value, @Nullable SearchExecutionContext context) {
        throw new QueryShardException((QueryRewriteContext)context, "[" + this.name + "] field which is of type [" + this.typeName() + "], does not support case insensitive term queries", new Object[0]);
    }

    public Query termsQuery(Collection<?> values, @Nullable SearchExecutionContext context) {
        HashSet dedupe = new HashSet(values);
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        for (Object value : dedupe) {
            builder.add(this.termQuery(value, context), BooleanClause.Occur.SHOULD);
        }
        return new ConstantScoreQuery((Query)builder.build());
    }

    public Query rangeQuery(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, ShapeRelation relation, ZoneId timeZone, DateMathParser parser, SearchExecutionContext context) {
        throw new IllegalArgumentException("Field [" + this.name + "] of type [" + this.typeName() + "] does not support range queries");
    }

    public Query fuzzyQuery(Object value, Fuzziness fuzziness, int prefixLength, int maxExpansions, boolean transpositions, SearchExecutionContext context, @Nullable MultiTermQuery.RewriteMethod rewriteMethod) {
        throw new IllegalArgumentException("Can only use fuzzy queries on keyword and text fields - not on [" + this.name + "] which is of type [" + this.typeName() + "]");
    }

    public Query fuzzyQuery(Object value, Fuzziness fuzziness, int prefixLength, int maxExpansions, boolean transpositions, SearchExecutionContext context) {
        return this.fuzzyQuery(value, fuzziness, prefixLength, maxExpansions, transpositions, context, null);
    }

    public final Query prefixQuery(String value, @Nullable MultiTermQuery.RewriteMethod method, SearchExecutionContext context) {
        return this.prefixQuery(value, method, false, context);
    }

    public Query prefixQuery(String value, @Nullable MultiTermQuery.RewriteMethod method, boolean caseInsensitve, SearchExecutionContext context) {
        throw new QueryShardException((QueryRewriteContext)context, "Can only use prefix queries on keyword, text and wildcard fields - not on [" + this.name + "] which is of type [" + this.typeName() + "]", new Object[0]);
    }

    public final Query wildcardQuery(String value, @Nullable MultiTermQuery.RewriteMethod method, SearchExecutionContext context) {
        return this.wildcardQuery(value, method, false, context);
    }

    public Query wildcardLikeQuery(String value, @Nullable MultiTermQuery.RewriteMethod method, boolean caseInsensitve, SearchExecutionContext context) {
        return this.wildcardQuery(value, method, caseInsensitve, context);
    }

    public Query wildcardQuery(String value, @Nullable MultiTermQuery.RewriteMethod method, boolean caseInsensitve, SearchExecutionContext context) {
        throw new QueryShardException((QueryRewriteContext)context, "Can only use wildcard queries on keyword, text and wildcard fields - not on [" + this.name + "] which is of type [" + this.typeName() + "]", new Object[0]);
    }

    public Query normalizedWildcardQuery(String value, @Nullable MultiTermQuery.RewriteMethod method, SearchExecutionContext context) {
        throw new QueryShardException((QueryRewriteContext)context, "Can only use wildcard queries on keyword, text and wildcard fields - not on [" + this.name + "] which is of type [" + this.typeName() + "]", new Object[0]);
    }

    public Query regexpQuery(String value, int syntaxFlags, int matchFlags, int maxDeterminizedStates, @Nullable MultiTermQuery.RewriteMethod method, SearchExecutionContext context) {
        throw new QueryShardException((QueryRewriteContext)context, "Can only use regexp queries on keyword and text fields - not on [" + this.name + "] which is of type [" + this.typeName() + "]", new Object[0]);
    }

    public Query automatonQuery(Supplier<Automaton> automatonSupplier, Supplier<CharacterRunAutomaton> characterRunAutomatonSupplier, @Nullable MultiTermQuery.RewriteMethod method, SearchExecutionContext context, String description) {
        throw new QueryShardException((QueryRewriteContext)context, "Can only use automaton queries on keyword fields - not on [" + this.name + "] which is of type [" + this.typeName() + "]", new Object[0]);
    }

    public Query existsQuery(SearchExecutionContext context) {
        if (this.hasDocValues() || this.indexType.hasTerms() && this.getTextSearchInfo().hasNorms()) {
            return new FieldExistsQuery(this.name());
        }
        return new TermQuery(new Term("_field_names", this.name()));
    }

    public Query phraseQuery(TokenStream stream, int slop, boolean enablePositionIncrements, SearchExecutionContext context) throws IOException {
        throw new IllegalArgumentException("Can only use phrase queries on text fields - not on [" + this.name + "] which is of type [" + this.typeName() + "]");
    }

    public Query multiPhraseQuery(TokenStream stream, int slop, boolean enablePositionIncrements, SearchExecutionContext context) throws IOException {
        throw new IllegalArgumentException("Can only use phrase queries on text fields - not on [" + this.name + "] which is of type [" + this.typeName() + "]");
    }

    public Query phrasePrefixQuery(TokenStream stream, int slop, int maxExpansions, SearchExecutionContext context) throws IOException {
        throw new IllegalArgumentException("Can only use phrase prefix queries on text fields - not on [" + this.name + "] which is of type [" + this.typeName() + "]");
    }

    public SpanQuery spanPrefixQuery(String value, SpanMultiTermQueryWrapper.SpanRewriteMethod method, SearchExecutionContext context) {
        throw new IllegalArgumentException("Can only use span prefix queries on text fields - not on [" + this.name + "] which is of type [" + this.typeName() + "]");
    }

    public Query distanceFeatureQuery(Object origin, String pivot, SearchExecutionContext context) {
        throw new IllegalArgumentException("Illegal data type of [" + this.typeName() + "]![distance_feature] query can only be run on a date, date_nanos or geo_point field type!");
    }

    public Relation isFieldWithinQuery(IndexReader reader, Object from, Object to, boolean includeLower, boolean includeUpper, ZoneId timeZone, DateMathParser dateMathParser, QueryRewriteContext context) throws IOException {
        return Relation.INTERSECTS;
    }

    protected final void failIfNoDocValues() {
        if (!this.hasDocValues()) {
            throw new IllegalArgumentException("Can't load fielddata on [" + this.name() + "] because fielddata is unsupported on fields of type [" + this.typeName() + "]. Use doc values instead.");
        }
    }

    protected final void failIfNotIndexed() {
        if (this.indexType.hasOnlyDocValues() || this.indexType == IndexType.NONE) {
            throw new IllegalArgumentException("Cannot search on field [" + this.name() + "] since it is not indexed.");
        }
    }

    protected final void failIfNotIndexedNorDocValuesFallback(SearchExecutionContext context) {
        if (!this.indexType.hasDocValues() && context.indexVersionCreated().isLegacyIndexVersion()) {
            throw new IllegalArgumentException("Cannot search on field [" + this.name() + "] of legacy index since it does not have doc values.");
        }
        if (this.indexType == IndexType.NONE) {
            throw new IllegalArgumentException("Cannot search on field [" + this.name() + "] since it is not indexed nor has doc values.");
        }
        if (this.indexType.hasOnlyDocValues() && !context.allowExpensiveQueries()) {
            throw new ElasticsearchException("Cannot search on field [" + this.name() + "] since it is not indexed and '" + SearchService.ALLOW_EXPENSIVE_QUERIES.getKey() + "' is set to false.", new Object[0]);
        }
    }

    public boolean eagerGlobalOrdinals() {
        return false;
    }

    public boolean mayExistInIndex(SearchExecutionContext context) {
        return true;
    }

    public DocValueFormat docValueFormat(@Nullable String format, ZoneId timeZone) {
        this.checkNoFormat(format);
        this.checkNoTimeZone(timeZone);
        return DocValueFormat.RAW;
    }

    protected void checkNoFormat(@Nullable String format) {
        if (format != null) {
            throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] does not support custom formats");
        }
    }

    protected void checkNoTimeZone(@Nullable ZoneId timeZone) {
        if (timeZone != null) {
            throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] does not support custom time zones");
        }
    }

    public Map<String, String> meta() {
        return this.meta;
    }

    public TextSearchInfo getTextSearchInfo() {
        return TextSearchInfo.NONE;
    }

    public TermsEnum getTerms(IndexReader reader, String prefix, boolean caseInsensitive, String searchAfter) throws IOException {
        return null;
    }

    public void validateMatchedRoutingPath(String routingPath) {
        if (this.hasScriptValues()) {
            throw new IllegalArgumentException("All fields that match routing_path must be configured with [time_series_dimension: true] or flattened fields with a list of dimensions in [time_series_dimensions] and without the [script] parameter. [" + this.name() + "] has a [script] parameter.");
        }
        if (!this.isDimension()) {
            throw new IllegalArgumentException("All fields that match routing_path must be configured with [time_series_dimension: true] or flattened fields with a list of dimensions in [time_series_dimensions] and without the [script] parameter. [" + this.name() + "] was not a dimension.");
        }
    }

    public boolean fieldHasValue(FieldInfos fieldInfos) {
        return fieldInfos.fieldInfo(this.name()) != null;
    }

    public BlockLoader blockLoader(BlockLoaderContext blContext) {
        return null;
    }

    public boolean supportsBlockLoaderConfig(BlockLoaderFunctionConfig config, FieldExtractPreference preference) {
        return false;
    }

    public static enum CollapseType {
        NONE,
        KEYWORD,
        NUMERIC;

    }

    public static enum Relation {
        WITHIN,
        INTERSECTS,
        DISJOINT;

    }

    public static interface BlockLoaderContext {
        public String indexName();

        public IndexSettings indexSettings();

        public FieldExtractPreference fieldExtractPreference();

        public SearchLookup lookup();

        public Set<String> sourcePaths(String var1);

        public String parentField(String var1);

        public FieldNamesFieldMapper.FieldNamesFieldType fieldNames();

        @Nullable
        default public BlockLoaderFunctionConfig blockLoaderFunctionConfig() {
            return null;
        }
    }

    public static enum FieldExtractPreference {
        DOC_VALUES,
        EXTRACT_SPATIAL_BOUNDS,
        NONE,
        STORED;

    }

    public static enum FielddataOperation {
        SEARCH,
        SCRIPT;

    }
}

