/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.env;

import java.io.IOException;
import java.util.ServiceLoader;
import org.elasticsearch.Build;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.env.DefaultBuildVersion;
import org.elasticsearch.internal.BuildExtension;
import org.elasticsearch.plugins.ExtensionLoader;
import org.elasticsearch.xcontent.ToXContentFragment;

public abstract class BuildVersion
implements ToXContentFragment,
Writeable {
    public abstract boolean canRemoveAssumedFeatures();

    public abstract boolean onOrAfterMinimumCompatible();

    public abstract boolean isFutureVersion();

    public abstract String toNodeMetadata();

    public abstract BuildVersion minimumCompatibilityVersion();

    public static BuildVersion fromVersionId(int versionId) {
        return CurrentExtensionHolder.BUILD_EXTENSION.fromVersionId(versionId);
    }

    public static BuildVersion fromNodeMetadata(String version) {
        return CurrentExtensionHolder.BUILD_EXTENSION.fromNodeMetadata(version);
    }

    public static BuildVersion fromString(String version) {
        return CurrentExtensionHolder.BUILD_EXTENSION.fromString(version);
    }

    public static BuildVersion fromStream(StreamInput input) throws IOException {
        return CurrentExtensionHolder.BUILD_EXTENSION.fromStream(input);
    }

    public static BuildVersion current() {
        return CurrentExtensionHolder.BUILD_EXTENSION.currentBuildVersion();
    }

    private static class CurrentExtensionHolder {
        private static final BuildExtension BUILD_EXTENSION = CurrentExtensionHolder.findExtension();

        private CurrentExtensionHolder() {
        }

        private static BuildExtension findExtension() {
            return ExtensionLoader.loadSingleton(ServiceLoader.load(BuildExtension.class)).orElse(new DefaultBuildExtension());
        }
    }

    private static class DefaultBuildExtension
    implements BuildExtension {
        private DefaultBuildExtension() {
        }

        @Override
        public Build getCurrentBuild() {
            return Build.current();
        }

        @Override
        public BuildVersion currentBuildVersion() {
            return DefaultBuildVersion.CURRENT;
        }

        @Override
        public BuildVersion fromVersionId(int versionId) {
            return new DefaultBuildVersion(versionId);
        }

        @Override
        public BuildVersion fromString(String version) {
            return new DefaultBuildVersion(version);
        }

        @Override
        public BuildVersion fromStream(StreamInput in) throws IOException {
            return new DefaultBuildVersion(in);
        }
    }
}

