/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.sampling;

import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.admin.indices.sampling.GetSampleConfigurationAction;
import org.elasticsearch.action.admin.indices.sampling.SamplingConfiguration;
import org.elasticsearch.action.admin.indices.sampling.SamplingMetadata;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.local.TransportLocalProjectMetadataAction;
import org.elasticsearch.cluster.ProjectState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.ProjectMetadata;
import org.elasticsearch.cluster.project.ProjectResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;

public class TransportGetSampleConfigurationAction
extends TransportLocalProjectMetadataAction<GetSampleConfigurationAction.Request, GetSampleConfigurationAction.Response> {
    private static final Logger logger = LogManager.getLogger(TransportGetSampleConfigurationAction.class);
    private final IndexNameExpressionResolver indexNameExpressionResolver;

    @Inject
    public TransportGetSampleConfigurationAction(ActionFilters actionFilters, TransportService transportService, ClusterService clusterService, ProjectResolver projectResolver, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("indices:monitor/sample/config/get", actionFilters, transportService.getTaskManager(), clusterService, EsExecutors.DIRECT_EXECUTOR_SERVICE, projectResolver);
        this.indexNameExpressionResolver = indexNameExpressionResolver;
    }

    @Override
    protected void localClusterStateOperation(Task task, GetSampleConfigurationAction.Request request, ProjectState state, ActionListener<GetSampleConfigurationAction.Response> listener) {
        ProjectMetadata projectMetadata = state.metadata();
        try {
            this.indexNameExpressionResolver.concreteIndexNames(projectMetadata, (IndicesRequest)request);
        }
        catch (IndexNotFoundException e) {
            logger.debug("Index not found: [{}]", (Object)request.getIndex());
            listener.onFailure(e);
            return;
        }
        if (projectMetadata == null) {
            logger.debug("No project metadata found for index [{}]", (Object)request.getIndex());
            listener.onResponse(new GetSampleConfigurationAction.Response(request.getIndex(), null));
            return;
        }
        SamplingMetadata samplingMetadata = (SamplingMetadata)projectMetadata.custom("sampling");
        if (samplingMetadata == null) {
            logger.debug("No sampling metadata found for index [{}]", (Object)request.getIndex());
            listener.onResponse(new GetSampleConfigurationAction.Response(request.getIndex(), null));
            return;
        }
        Map<String, SamplingConfiguration> indexToSampleConfigMap = samplingMetadata.getIndexToSamplingConfigMap();
        SamplingConfiguration config = indexToSampleConfigMap.get(request.getIndex());
        if (config == null) {
            logger.debug("No sampling configuration found for index [{}]", (Object)request.getIndex());
            listener.onResponse(new GetSampleConfigurationAction.Response(request.getIndex(), config));
            return;
        }
        logger.debug("Retrieved sampling configuration for index [{}]", (Object)request.getIndex());
        listener.onResponse(new GetSampleConfigurationAction.Response(request.getIndex(), config));
    }

    @Override
    protected ClusterBlockException checkBlock(GetSampleConfigurationAction.Request request, ProjectState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
    }
}

