/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.refresh;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.ElasticsearchTimeoutException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.admin.indices.refresh.UnpromotableShardRefreshRequest;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.broadcast.unpromotable.TransportBroadcastUnpromotableAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateObserver;
import org.elasticsearch.cluster.action.shard.ShardStateAction;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.MetadataCreateIndexService;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.node.NodeClosedException;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportUnpromotableShardRefreshAction
extends TransportBroadcastUnpromotableAction<UnpromotableShardRefreshRequest, ActionResponse.Empty> {
    public static final String NAME = "indices:admin/refresh/unpromotable";
    private final IndicesService indicesService;
    private final ThreadPool threadPool;
    private final boolean useRefreshBlock;
    static final /* synthetic */ boolean $assertionsDisabled;

    @Inject
    public TransportUnpromotableShardRefreshAction(ClusterService clusterService, TransportService transportService, ShardStateAction shardStateAction, ActionFilters actionFilters, IndicesService indicesService, ThreadPool threadPool) {
        this(clusterService, transportService, shardStateAction, actionFilters, indicesService, threadPool, MetadataCreateIndexService.useRefreshBlock(clusterService.getSettings()));
    }

    public TransportUnpromotableShardRefreshAction(ClusterService clusterService, TransportService transportService, ShardStateAction shardStateAction, ActionFilters actionFilters, IndicesService indicesService, ThreadPool threadPool, boolean useRefreshBlock) {
        super(NAME, clusterService, transportService, shardStateAction, actionFilters, UnpromotableShardRefreshRequest::new, transportService.getThreadPool().executor("refresh"));
        this.indicesService = indicesService;
        this.threadPool = threadPool;
        this.useRefreshBlock = useRefreshBlock;
    }

    @Override
    protected void doExecute(Task task, UnpromotableShardRefreshRequest request, ActionListener<ActionResponse.Empty> listener) {
        this.beforeDispatchingRequestToUnpromotableShards(request, listener.delegateFailure((l, unused) -> {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("dispatching refresh request for unpromotable shard {}", (Object)request.shardId());
            }
            super.doExecute(task, request, l);
        }));
    }

    private void beforeDispatchingRequestToUnpromotableShards(final UnpromotableShardRefreshRequest request, final ActionListener<Void> listener) {
        if (!this.useRefreshBlock) {
            listener.onResponse(null);
            return;
        }
        ClusterStateObserver clusterStateObserver = new ClusterStateObserver(this.clusterService, request.getTimeout(), this.logger, this.threadPool.getThreadContext());
        if (!TransportUnpromotableShardRefreshAction.isIndexBlockedForRefresh(request.shardId().getIndexName(), clusterStateObserver.setAndGetObservedState())) {
            listener.onResponse(null);
            return;
        }
        clusterStateObserver.waitForNextChange(new ClusterStateObserver.Listener(){

            @Override
            public void onNewClusterState(ClusterState state) {
                listener.onResponse(null);
            }

            @Override
            public void onClusterServiceClose() {
                listener.onFailure(new NodeClosedException(TransportUnpromotableShardRefreshAction.this.clusterService.localNode()));
            }

            @Override
            public void onTimeout(TimeValue timeout) {
                listener.onFailure(new ElasticsearchTimeoutException("shard refresh timed out waiting for index block to be removed", (Throwable)new ClusterBlockException(Map.of(request.shardId().getIndexName(), Set.of(IndexMetadata.INDEX_REFRESH_BLOCK))), new Object[0]));
            }
        }, clusterState -> !TransportUnpromotableShardRefreshAction.isIndexBlockedForRefresh(request.shardId().getIndexName(), clusterState));
    }

    private static boolean isIndexBlockedForRefresh(String index, ClusterState state) {
        return state.blocks().hasIndexBlock(index, IndexMetadata.INDEX_REFRESH_BLOCK);
    }

    @Override
    protected void unpromotableShardOperation(Task task, UnpromotableShardRefreshRequest request, ActionListener<ActionResponse.Empty> responseListener) {
        IndexShard shard;
        IndexService indexService = this.indicesService.indexService(request.shardId().getIndex());
        IndexShard indexShard = shard = indexService == null ? null : indexService.getShardOrNull(request.shardId().id());
        if (shard == null) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("unpromotable shard {} not yet created, responding OK to refresh request", (Object)request.shardId());
            }
            responseListener.onResponse(ActionResponse.Empty.INSTANCE);
            return;
        }
        long primaryTerm = request.getPrimaryTerm();
        if (!$assertionsDisabled && -1L >= primaryTerm) {
            throw new AssertionError(primaryTerm);
        }
        long segmentGeneration = request.getSegmentGeneration();
        if (!$assertionsDisabled && -1L >= segmentGeneration) {
            throw new AssertionError(segmentGeneration);
        }
        ActionListener.run(responseListener, listener -> shard.waitForPrimaryTermAndGeneration(primaryTerm, segmentGeneration, listener.map(l -> {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("refreshed unpromotable shard {} for requested primary term {} and segment generation {}", (Object)request.shardId(), (Object)primaryTerm, (Object)segmentGeneration);
            }
            return ActionResponse.Empty.INSTANCE;
        })));
    }

    @Override
    protected ActionResponse.Empty combineUnpromotableShardResponses(List<ActionResponse.Empty> empties) {
        return ActionResponse.Empty.INSTANCE;
    }

    @Override
    protected ActionResponse.Empty readResponse(StreamInput in) {
        return ActionResponse.Empty.INSTANCE;
    }

    @Override
    protected ActionResponse.Empty emptyResponse() {
        return ActionResponse.Empty.INSTANCE;
    }

    static {
        boolean bl = $assertionsDisabled = !TransportUnpromotableShardRefreshAction.class.desiredAssertionStatus();
        if (!$assertionsDisabled && !NAME.equals(NAME)) {
            throw new AssertionError();
        }
    }
}

