/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.node.reload;

import java.io.IOException;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.support.TransportAction;
import org.elasticsearch.action.support.nodes.BaseNodeResponse;
import org.elasticsearch.action.support.nodes.BaseNodesResponse;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;

public class NodesReloadSecureSettingsResponse
extends BaseNodesResponse<NodeResponse>
implements ToXContentFragment {
    public NodesReloadSecureSettingsResponse(ClusterName clusterName, List<NodeResponse> nodes, List<FailedNodeException> failures) {
        super(clusterName, nodes, failures);
    }

    @Override
    protected List<NodeResponse> readNodesFrom(StreamInput in) throws IOException {
        return (List)TransportAction.localOnly();
    }

    @Override
    protected void writeNodesTo(StreamOutput out, List<NodeResponse> nodes) throws IOException {
        TransportAction.localOnly();
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("nodes");
        for (NodeResponse node : this.getNodes()) {
            builder.startObject(node.getNode().getId());
            builder.field("name", node.getNode().getName());
            Exception e = node.reloadException();
            if (e != null) {
                builder.startObject("reload_exception");
                ElasticsearchException.generateThrowableXContent(builder, params, e);
                builder.endObject();
            }
            if (node.secureSettingNames() != null) {
                builder.array("secure_setting_names", b -> {
                    for (String settingName : Stream.of(node.secureSettingNames()).sorted().toList()) {
                        b.value(settingName);
                    }
                });
            }
            if (node.keystorePath() != null) {
                builder.field("keystore_path", node.keystorePath());
            }
            if (node.keystoreDigest() != null) {
                builder.field("keystore_digest", node.keystoreDigest());
            }
            if (node.keystoreLastModifiedTime() != null) {
                builder.field("keystore_last_modified_time", (Object)Instant.ofEpochMilli(node.keystoreLastModifiedTime()));
            }
            builder.endObject();
        }
        builder.endObject();
        return builder;
    }

    public String toString() {
        return Strings.toString((ToXContent)this, true, true);
    }

    public static class NodeResponse
    extends BaseNodeResponse {
        public static final TransportVersion KEYSTORE_DETAILS = TransportVersion.fromName("keystore_details_in_reload_secure_settings_response");
        private final Exception reloadException;
        private final String[] secureSettingNames;
        private final String keystorePath;
        private final String keystoreDigest;
        private final Long keystoreLastModifiedTime;

        public NodeResponse(StreamInput in) throws IOException {
            super(in);
            this.reloadException = in.readOptionalException();
            if (in.getTransportVersion().supports(KEYSTORE_DETAILS)) {
                this.secureSettingNames = in.readOptionalStringArray();
                this.keystorePath = in.readOptionalString();
                this.keystoreDigest = in.readOptionalString();
                this.keystoreLastModifiedTime = in.readOptionalLong();
            } else {
                this.secureSettingNames = null;
                this.keystorePath = null;
                this.keystoreDigest = null;
                this.keystoreLastModifiedTime = null;
            }
        }

        public NodeResponse(DiscoveryNode node, Exception reloadException, String[] secureSettingNames, String keystorePath, String keystoreDigest, Long keystoreLastModifiedTime) {
            super(node);
            this.reloadException = reloadException;
            this.secureSettingNames = secureSettingNames;
            this.keystorePath = keystorePath;
            this.keystoreDigest = keystoreDigest;
            this.keystoreLastModifiedTime = keystoreLastModifiedTime;
        }

        public Exception reloadException() {
            return this.reloadException;
        }

        public String[] secureSettingNames() {
            return this.secureSettingNames;
        }

        public String keystorePath() {
            return this.keystorePath;
        }

        public String keystoreDigest() {
            return this.keystoreDigest;
        }

        public Long keystoreLastModifiedTime() {
            return this.keystoreLastModifiedTime;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeOptionalException(this.reloadException);
            if (out.getTransportVersion().supports(KEYSTORE_DETAILS)) {
                out.writeOptionalStringArray(this.secureSettingNames);
                out.writeOptionalString(this.keystorePath);
                out.writeOptionalString(this.keystoreDigest);
                out.writeOptionalLong(this.keystoreLastModifiedTime);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NodeResponse that = (NodeResponse)o;
            return Objects.equals(this.reloadException, that.reloadException) && Arrays.equals(this.secureSettingNames, that.secureSettingNames) && Objects.equals(this.keystorePath, that.keystorePath) && Objects.equals(this.keystoreDigest, that.keystoreDigest) && Objects.equals(this.keystoreLastModifiedTime, that.keystoreLastModifiedTime);
        }

        public int hashCode() {
            return Objects.hash(this.reloadException, Arrays.hashCode(this.secureSettingNames), this.keystorePath, this.keystoreDigest, this.keystoreLastModifiedTime);
        }
    }
}

