/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.planner;

import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.IntFunction;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.logging.HeaderWarning;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.compute.aggregation.AggregatorMode;
import org.elasticsearch.compute.aggregation.GroupingAggregator;
import org.elasticsearch.compute.aggregation.blockhash.BlockHash;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.lucene.IndexedByShardId;
import org.elasticsearch.compute.lucene.LuceneCountOperator;
import org.elasticsearch.compute.lucene.LuceneSliceQueue;
import org.elasticsearch.compute.lucene.LuceneSourceOperator;
import org.elasticsearch.compute.lucene.LuceneTopNSourceOperator;
import org.elasticsearch.compute.lucene.TimeSeriesSourceOperator;
import org.elasticsearch.compute.lucene.read.ValuesSourceReaderOperator;
import org.elasticsearch.compute.operator.Operator;
import org.elasticsearch.compute.operator.SourceOperator;
import org.elasticsearch.compute.operator.TimeSeriesAggregationOperator;
import org.elasticsearch.core.AbstractRefCounted;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.index.IndexMode;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.index.analysis.AnalysisRegistry;
import org.elasticsearch.index.get.ShardGetService;
import org.elasticsearch.index.mapper.BlockLoader;
import org.elasticsearch.index.mapper.FieldNamesFieldMapper;
import org.elasticsearch.index.mapper.IndexType;
import org.elasticsearch.index.mapper.KeywordFieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.MappingLookup;
import org.elasticsearch.index.mapper.NestedLookup;
import org.elasticsearch.index.mapper.SourceLoader;
import org.elasticsearch.index.mapper.TextSearchInfo;
import org.elasticsearch.index.mapper.blockloader.BlockLoaderFunctionConfig;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.ConstantScoreQueryBuilder;
import org.elasticsearch.index.query.ExistsQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.index.query.TermQueryBuilder;
import org.elasticsearch.index.query.TermsQueryBuilder;
import org.elasticsearch.index.search.NestedHelper;
import org.elasticsearch.logging.LogManager;
import org.elasticsearch.logging.Logger;
import org.elasticsearch.search.fetch.StoredFieldsSpec;
import org.elasticsearch.search.fetch.subphase.FetchSourceContext;
import org.elasticsearch.search.internal.AliasFilter;
import org.elasticsearch.search.lookup.SearchLookup;
import org.elasticsearch.search.lookup.SourceFilter;
import org.elasticsearch.search.sort.SortAndFormats;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.FieldAttribute;
import org.elasticsearch.xpack.esql.core.expression.FoldContext;
import org.elasticsearch.xpack.esql.core.expression.NamedExpression;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.core.type.EsField;
import org.elasticsearch.xpack.esql.core.type.FunctionEsField;
import org.elasticsearch.xpack.esql.core.type.KeywordEsField;
import org.elasticsearch.xpack.esql.core.type.MultiTypeEsField;
import org.elasticsearch.xpack.esql.core.type.PotentiallyUnmappedKeywordEsField;
import org.elasticsearch.xpack.esql.expression.function.scalar.EsqlScalarFunction;
import org.elasticsearch.xpack.esql.plan.physical.EsQueryExec;
import org.elasticsearch.xpack.esql.plan.physical.EstimatesRowSize;
import org.elasticsearch.xpack.esql.plan.physical.FieldExtractExec;
import org.elasticsearch.xpack.esql.plan.physical.TimeSeriesAggregateExec;
import org.elasticsearch.xpack.esql.planner.AbstractPhysicalOperationProviders;
import org.elasticsearch.xpack.esql.planner.Layout;
import org.elasticsearch.xpack.esql.planner.LocalExecutionPlanner;
import org.elasticsearch.xpack.esql.planner.PlannerSettings;
import org.elasticsearch.xpack.esql.planner.PlannerUtils;
import org.elasticsearch.xpack.esql.planner.TypeConverter;
import org.elasticsearch.xpack.esql.plugin.EsqlPlugin;

public class EsPhysicalOperationProviders
extends AbstractPhysicalOperationProviders {
    private static final Logger logger = LogManager.getLogger(EsPhysicalOperationProviders.class);
    private final IndexedByShardId<? extends ShardContext> shardContexts;
    private final PlannerSettings plannerSettings;

    public EsPhysicalOperationProviders(FoldContext foldContext, IndexedByShardId<? extends ShardContext> shardContexts, AnalysisRegistry analysisRegistry, PlannerSettings plannerSettings) {
        super(foldContext, analysisRegistry);
        this.shardContexts = shardContexts;
        this.plannerSettings = plannerSettings;
    }

    @Override
    public final LocalExecutionPlanner.PhysicalOperation fieldExtractPhysicalOperation(FieldExtractExec fieldExtractExec, LocalExecutionPlanner.PhysicalOperation source) {
        Layout.Builder layout = source.layout.builder();
        Attribute sourceAttr = fieldExtractExec.sourceAttribute();
        int docChannel = source.layout.get(sourceAttr.id()).channel();
        for (Attribute attr : fieldExtractExec.attributesToExtract()) {
            layout.append((NamedExpression)attr);
        }
        List<ValuesSourceReaderOperator.FieldInfo> fields = this.extractFields(fieldExtractExec);
        IndexedByShardId readers = this.shardContexts.map(s -> new ValuesSourceReaderOperator.ShardContext(s.searcher().getIndexReader(), arg_0 -> ((ShardContext)s).newSourceLoader(arg_0), s.storedFieldsSequentialProportion()));
        return source.with((Operator.OperatorFactory)new ValuesSourceReaderOperator.Factory(this.plannerSettings.valuesLoadingJumboSize(), fields, readers, docChannel), layout.build());
    }

    private static String getFieldName(Attribute attr) {
        String string;
        if (attr instanceof FieldAttribute) {
            FieldAttribute fa = (FieldAttribute)attr;
            string = fa.fieldName().string();
        } else {
            string = attr.name();
        }
        return string;
    }

    private BlockLoader getBlockLoaderFor(int shardId, Attribute attr, MappedFieldType.FieldExtractPreference fieldExtractPreference) {
        FieldAttribute fieldAttr;
        EsField esField;
        FieldAttribute fa;
        EsField esField2;
        DefaultShardContext shardContext = (DefaultShardContext)this.shardContexts.get(shardId);
        if (attr instanceof FieldAttribute && (esField2 = (fa = (FieldAttribute)attr).field()) instanceof PotentiallyUnmappedKeywordEsField) {
            PotentiallyUnmappedKeywordEsField kf = (PotentiallyUnmappedKeywordEsField)esField2;
            shardContext = new DefaultShardContextForUnmappedField(shardContext, kf);
        }
        BlockLoaderFunctionConfig functionConfig = null;
        if (attr instanceof FieldAttribute && (esField = (fieldAttr = (FieldAttribute)attr).field()) instanceof FunctionEsField) {
            FunctionEsField functionEsField = (FunctionEsField)esField;
            functionConfig = functionEsField.functionConfig();
        }
        boolean isUnsupported = attr.dataType() == DataType.UNSUPPORTED;
        String fieldName = EsPhysicalOperationProviders.getFieldName(attr);
        BlockLoader blockLoader = shardContext.blockLoader(fieldName, isUnsupported, fieldExtractPreference, functionConfig);
        MultiTypeEsField unionTypes = EsPhysicalOperationProviders.findUnionTypes(attr);
        if (unionTypes != null) {
            String indexName = shardContext.ctx.getFullyQualifiedIndex().getName();
            Expression conversion = unionTypes.getConversionExpressionForIndex(indexName);
            return conversion == null ? BlockLoader.CONSTANT_NULLS : new TypeConvertingBlockLoader(blockLoader, (EsqlScalarFunction)conversion);
        }
        return blockLoader;
    }

    @Nullable
    private static MultiTypeEsField findUnionTypes(Attribute attr) {
        FieldAttribute fa;
        EsField esField;
        if (attr instanceof FieldAttribute && (esField = (fa = (FieldAttribute)attr).field()) instanceof MultiTypeEsField) {
            MultiTypeEsField multiTypeEsField = (MultiTypeEsField)esField;
            return multiTypeEsField;
        }
        return null;
    }

    public Function<org.elasticsearch.compute.lucene.ShardContext, List<LuceneSliceQueue.QueryAndTags>> querySupplier(QueryBuilder builder) {
        QueryBuilder qb = builder == null ? QueryBuilders.matchAllQuery().boost(0.0f) : builder;
        return ctx -> List.of(new LuceneSliceQueue.QueryAndTags(((ShardContext)this.shardContexts.get(ctx.index())).toQuery(qb), List.of()));
    }

    public Function<org.elasticsearch.compute.lucene.ShardContext, List<LuceneSliceQueue.QueryAndTags>> querySupplier(List<EsQueryExec.QueryBuilderAndTags> queryAndTagsFromEsQueryExec) {
        return ctx -> queryAndTagsFromEsQueryExec.stream().map(queryBuilderAndTags -> {
            QueryBuilder qb = queryBuilderAndTags.query();
            return new LuceneSliceQueue.QueryAndTags(((ShardContext)this.shardContexts.get(ctx.index())).toQuery((QueryBuilder)(qb == null ? QueryBuilders.matchAllQuery().boost(0.0f) : qb)), queryBuilderAndTags.tags());
        }).toList();
    }

    @Override
    public final LocalExecutionPlanner.PhysicalOperation sourcePhysicalOperation(EsQueryExec esQueryExec, LocalExecutionPlanner.LocalExecutionPlannerContext context) {
        Object luceneFactory;
        logger.trace("Query Exec is {}", new Object[]{esQueryExec});
        List<EsQueryExec.Sort> sorts = esQueryExec.sorts();
        assert (esQueryExec.estimatedRowSize() != null) : "estimated row size not initialized";
        int rowEstimatedSize = esQueryExec.estimatedRowSize();
        int limit = esQueryExec.limit() != null ? (Integer)esQueryExec.limit().fold(context.foldCtx()) : Integer.MAX_VALUE;
        boolean scoring = esQueryExec.hasScoring();
        if (sorts != null && !sorts.isEmpty()) {
            ArrayList sortBuilders = new ArrayList(sorts.size());
            long estimatedPerRowSortSize = 0L;
            for (EsQueryExec.Sort sort : sorts) {
                sortBuilders.add(sort.sortBuilder());
                estimatedPerRowSortSize += (long)EstimatesRowSize.estimateSize(sort.resulType());
            }
            luceneFactory = new LuceneTopNSourceOperator.Factory(this.shardContexts, this.querySupplier(esQueryExec.query()), context.queryPragmas().dataPartitioning(this.plannerSettings.defaultDataPartitioning()), context.queryPragmas().taskConcurrency(), context.pageSize(esQueryExec, rowEstimatedSize), limit, sortBuilders, estimatedPerRowSortSize *= 2L, scoring);
        } else {
            luceneFactory = esQueryExec.indexMode() == IndexMode.TIME_SERIES ? new TimeSeriesSourceOperator.Factory(this.shardContexts, this.querySupplier(esQueryExec.queryBuilderAndTags()), context.queryPragmas().taskConcurrency(), context.pageSize(esQueryExec, rowEstimatedSize), limit) : new LuceneSourceOperator.Factory(this.shardContexts, this.querySupplier(esQueryExec.queryBuilderAndTags()), context.queryPragmas().dataPartitioning(this.plannerSettings.defaultDataPartitioning()), context.autoPartitioningStrategy(), context.queryPragmas().taskConcurrency(), context.pageSize(esQueryExec, rowEstimatedSize), limit, scoring);
        }
        Layout.Builder layout = new Layout.Builder();
        layout.append(esQueryExec.output());
        int instanceCount = Math.max(1, luceneFactory.taskConcurrency());
        context.driverParallelism(new LocalExecutionPlanner.DriverParallelism(LocalExecutionPlanner.DriverParallelism.Type.DATA_PARALLELISM, instanceCount));
        return LocalExecutionPlanner.PhysicalOperation.fromSource((SourceOperator.SourceOperatorFactory)luceneFactory, layout.build());
    }

    List<ValuesSourceReaderOperator.FieldInfo> extractFields(FieldExtractExec fieldExtractExec) {
        List<Attribute> attributes = fieldExtractExec.attributesToExtract();
        ArrayList<ValuesSourceReaderOperator.FieldInfo> fieldInfos = new ArrayList<ValuesSourceReaderOperator.FieldInfo>(attributes.size());
        HashSet nullsFilteredFields = new HashSet();
        fieldExtractExec.forEachDown(EsQueryExec.class, queryExec -> {
            QueryBuilder q = queryExec.queryBuilderAndTags().get(0).query();
            if (q != null) {
                nullsFilteredFields.addAll(EsPhysicalOperationProviders.nullsFilteredFieldsAfterSourceQuery(q));
            }
        });
        for (Attribute attr : attributes) {
            DataType dataType = attr.dataType();
            MappedFieldType.FieldExtractPreference fieldExtractPreference = fieldExtractExec.fieldExtractPreference(attr);
            ElementType elementType = PlannerUtils.toElementType(dataType, fieldExtractPreference);
            IntFunction<BlockLoader> loader = s -> this.getBlockLoaderFor(s, attr, fieldExtractPreference);
            String fieldName = EsPhysicalOperationProviders.getFieldName(attr);
            boolean nullsFiltered = nullsFilteredFields.contains(fieldName);
            fieldInfos.add(new ValuesSourceReaderOperator.FieldInfo(fieldName, elementType, nullsFiltered, loader));
        }
        return fieldInfos;
    }

    static Set<String> nullsFilteredFieldsAfterSourceQuery(QueryBuilder sourceQuery) {
        QueryBuilder queryBuilder = sourceQuery;
        Objects.requireNonNull(queryBuilder);
        QueryBuilder queryBuilder2 = queryBuilder;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ExistsQueryBuilder.class, TermQueryBuilder.class, TermsQueryBuilder.class, RangeQueryBuilder.class, ConstantScoreQueryBuilder.class, BoolQueryBuilder.class}, (Object)queryBuilder2, n)) {
            case 0 -> {
                ExistsQueryBuilder q = (ExistsQueryBuilder)queryBuilder2;
                yield Set.of(q.fieldName());
            }
            case 1 -> {
                TermQueryBuilder q = (TermQueryBuilder)queryBuilder2;
                yield Set.of(q.fieldName());
            }
            case 2 -> {
                TermsQueryBuilder q = (TermsQueryBuilder)queryBuilder2;
                yield Set.of(q.fieldName());
            }
            case 3 -> {
                RangeQueryBuilder q = (RangeQueryBuilder)queryBuilder2;
                yield Set.of(q.fieldName());
            }
            case 4 -> {
                ConstantScoreQueryBuilder q = (ConstantScoreQueryBuilder)queryBuilder2;
                yield EsPhysicalOperationProviders.nullsFilteredFieldsAfterSourceQuery(q.innerQuery());
            }
            case 5 -> {
                BoolQueryBuilder q = (BoolQueryBuilder)queryBuilder2;
                HashSet<String> fields = new HashSet<String>();
                for (List clauses : List.of(q.must(), q.filter())) {
                    for (QueryBuilder c : clauses) {
                        fields.addAll(EsPhysicalOperationProviders.nullsFilteredFieldsAfterSourceQuery(c));
                    }
                }
                yield fields;
            }
            default -> Set.of();
        };
    }

    public LuceneCountOperator.Factory countSource(LocalExecutionPlanner.LocalExecutionPlannerContext context, Function<org.elasticsearch.compute.lucene.ShardContext, List<LuceneSliceQueue.QueryAndTags>> queryFunction, List<ElementType> tagTypes, Expression limit) {
        return new LuceneCountOperator.Factory(this.shardContexts, queryFunction, context.queryPragmas().dataPartitioning(this.plannerSettings.defaultDataPartitioning()), context.queryPragmas().taskConcurrency(), tagTypes, limit == null ? Integer.MAX_VALUE : (Integer)limit.fold(context.foldCtx()));
    }

    @Override
    public Operator.OperatorFactory timeSeriesAggregatorOperatorFactory(TimeSeriesAggregateExec ts, AggregatorMode aggregatorMode, List<GroupingAggregator.Factory> aggregatorFactories, List<BlockHash.GroupSpec> groupSpecs, LocalExecutionPlanner.LocalExecutionPlannerContext context) {
        return new TimeSeriesAggregationOperator.Factory(ts.timeBucketRounding(context.foldCtx()), ts.timeBucket() != null && ts.timeBucket().dataType() == DataType.DATE_NANOS, groupSpecs, aggregatorMode, aggregatorFactories, context.pageSize(ts, ts.estimatedRowSize()));
    }

    public static class DefaultShardContext
    extends ShardContext {
        private final int index;
        private final Releasable releasable;
        private final SearchExecutionContext ctx;
        private final AliasFilter aliasFilter;
        private final String shardIdentifier;

        public DefaultShardContext(int index, Releasable releasable, SearchExecutionContext ctx, AliasFilter aliasFilter) {
            this.index = index;
            this.releasable = releasable;
            this.ctx = ctx;
            this.aliasFilter = aliasFilter;
            this.shardIdentifier = this.ctx.getFullyQualifiedIndex().getName() + ":" + this.ctx.getShardId();
        }

        public int index() {
            return this.index;
        }

        public IndexSearcher searcher() {
            return this.ctx.searcher();
        }

        public Optional<SortAndFormats> buildSort(List<SortBuilder<?>> sorts) throws IOException {
            return SortBuilder.buildSort(sorts, (SearchExecutionContext)this.ctx, (boolean)false);
        }

        public String shardIdentifier() {
            return this.shardIdentifier;
        }

        public SourceLoader newSourceLoader(Set<String> sourcePaths) {
            SourceFilter filter = sourcePaths != null ? new SourceFilter(sourcePaths.toArray(new String[0]), null) : null;
            FetchSourceContext fetchSourceContext = filter != null ? FetchSourceContext.of((boolean)true, null, (String[])filter.getIncludes(), (String[])filter.getExcludes()) : null;
            Tuple result = ShardGetService.maybeExcludeVectorFields((MappingLookup)this.ctx.getMappingLookup(), (IndexSettings)this.ctx.getIndexSettings(), (FetchSourceContext)fetchSourceContext, null);
            SourceFilter vectorFilter = (SourceFilter)result.v2();
            if (vectorFilter != null) {
                filter = vectorFilter;
            }
            return this.ctx.newSourceLoader(filter, false);
        }

        @Override
        public Query toQuery(QueryBuilder queryBuilder) {
            Query query = this.ctx.toQuery(queryBuilder).query();
            if (this.ctx.nestedLookup() != NestedLookup.EMPTY && NestedHelper.mightMatchNestedDocs((Query)query, (SearchExecutionContext)this.ctx)) {
                query = new BooleanQuery.Builder().add(query, BooleanClause.Occur.MUST).add(Queries.newNonNestedFilter((IndexVersion)this.ctx.indexVersionCreated()), BooleanClause.Occur.FILTER).build();
            }
            if (this.aliasFilter != AliasFilter.EMPTY) {
                Query filterQuery = this.ctx.toQuery(this.aliasFilter.getQueryBuilder()).query();
                query = new BooleanQuery.Builder().add(query, BooleanClause.Occur.MUST).add(filterQuery, BooleanClause.Occur.FILTER).build();
            }
            return query;
        }

        public BlockLoader blockLoader(String name, boolean asUnsupportedSource, final MappedFieldType.FieldExtractPreference fieldExtractPreference, final BlockLoaderFunctionConfig blockLoaderFunctionConfig) {
            if (asUnsupportedSource) {
                return BlockLoader.CONSTANT_NULLS;
            }
            MappedFieldType fieldType = this.fieldType(name);
            if (fieldType == null) {
                return BlockLoader.CONSTANT_NULLS;
            }
            BlockLoader loader = fieldType.blockLoader(new MappedFieldType.BlockLoaderContext(){

                public String indexName() {
                    return ctx.getFullyQualifiedIndex().getName();
                }

                public IndexSettings indexSettings() {
                    return ctx.getIndexSettings();
                }

                public MappedFieldType.FieldExtractPreference fieldExtractPreference() {
                    return fieldExtractPreference;
                }

                public SearchLookup lookup() {
                    return ctx.lookup();
                }

                public Set<String> sourcePaths(String name) {
                    return ctx.sourcePath(name);
                }

                public String parentField(String field) {
                    return ctx.parentPath(field);
                }

                public FieldNamesFieldMapper.FieldNamesFieldType fieldNames() {
                    return (FieldNamesFieldMapper.FieldNamesFieldType)ctx.lookup().fieldType("_field_names");
                }

                public BlockLoaderFunctionConfig blockLoaderFunctionConfig() {
                    return blockLoaderFunctionConfig;
                }
            });
            if (loader == null) {
                HeaderWarning.addWarning((String)"Field [{}] cannot be retrieved, it is unsupported or not indexed; returning null", (Object[])new Object[]{name});
                return BlockLoader.CONSTANT_NULLS;
            }
            return loader;
        }

        @Nullable
        public MappedFieldType fieldType(String name) {
            return this.ctx.getFieldType(name);
        }

        @Override
        public double storedFieldsSequentialProportion() {
            return (Double)EsqlPlugin.STORED_FIELDS_SEQUENTIAL_PROPORTION.get(this.ctx.getIndexSettings().getSettings());
        }

        public void close() {
            this.releasable.close();
        }
    }

    private static class DefaultShardContextForUnmappedField
    extends DefaultShardContext {
        private static final FieldType UNMAPPED_FIELD_TYPE = new FieldType((IndexableFieldType)KeywordFieldMapper.Defaults.FIELD_TYPE);
        private final KeywordEsField unmappedEsField;

        DefaultShardContextForUnmappedField(DefaultShardContext ctx, PotentiallyUnmappedKeywordEsField unmappedEsField) {
            super(ctx.index, ctx.releasable, ctx.ctx, ctx.aliasFilter);
            this.unmappedEsField = unmappedEsField;
        }

        @Override
        @Nullable
        public MappedFieldType fieldType(String name) {
            MappedFieldType superResult = super.fieldType(name);
            return superResult == null && name.equals(this.unmappedEsField.getName()) ? DefaultShardContextForUnmappedField.createUnmappedFieldType(name, this) : superResult;
        }

        static MappedFieldType createUnmappedFieldType(String name, DefaultShardContext context) {
            KeywordFieldMapper.Builder builder = new KeywordFieldMapper.Builder(name, context.ctx.getIndexSettings());
            builder.docValues(false);
            builder.indexed(false);
            return new KeywordFieldMapper.KeywordFieldType(name, IndexType.terms((boolean)false, (boolean)false), new TextSearchInfo(UNMAPPED_FIELD_TYPE, builder.similarity(), Lucene.KEYWORD_ANALYZER, Lucene.KEYWORD_ANALYZER), Lucene.KEYWORD_ANALYZER, builder, context.ctx.isSourceSynthetic());
        }

        static {
            UNMAPPED_FIELD_TYPE.setDocValuesType(DocValuesType.NONE);
            UNMAPPED_FIELD_TYPE.setIndexOptions(IndexOptions.NONE);
            UNMAPPED_FIELD_TYPE.setStored(false);
            UNMAPPED_FIELD_TYPE.freeze();
        }
    }

    private static class TypeConvertingBlockLoader
    implements BlockLoader {
        private final BlockLoader delegate;
        private final TypeConverter typeConverter;

        protected TypeConvertingBlockLoader(BlockLoader delegate, EsqlScalarFunction convertFunction) {
            this.delegate = delegate;
            this.typeConverter = TypeConverter.fromScalarFunction(convertFunction);
        }

        public BlockLoader.Builder builder(BlockLoader.BlockFactory factory, int expectedCount) {
            return this.delegate.builder(factory, expectedCount);
        }

        public BlockLoader.Block convert(BlockLoader.Block block) {
            return this.typeConverter.convert((Block)block);
        }

        public BlockLoader.ColumnAtATimeReader columnAtATimeReader(LeafReaderContext context) throws IOException {
            final BlockLoader.ColumnAtATimeReader reader = this.delegate.columnAtATimeReader(context);
            if (reader == null) {
                return null;
            }
            return new BlockLoader.ColumnAtATimeReader(){

                public BlockLoader.Block read(BlockLoader.BlockFactory factory, BlockLoader.Docs docs, int offset, boolean nullsFiltered) throws IOException {
                    BlockLoader.Block block = reader.read(factory, docs, offset, nullsFiltered);
                    return typeConverter.convert((Block)block);
                }

                public boolean canReuse(int startingDocID) {
                    return reader.canReuse(startingDocID);
                }

                public String toString() {
                    return reader.toString();
                }
            };
        }

        public BlockLoader.RowStrideReader rowStrideReader(LeafReaderContext context) throws IOException {
            return this.delegate.rowStrideReader(context);
        }

        public StoredFieldsSpec rowStrideStoredFieldSpec() {
            return this.delegate.rowStrideStoredFieldSpec();
        }

        public boolean supportsOrdinals() {
            return false;
        }

        public SortedSetDocValues ordinals(LeafReaderContext context) {
            throw new IllegalArgumentException("Ordinals are not supported for type conversion");
        }

        public final String toString() {
            return "TypeConvertingBlockLoader[delegate=" + String.valueOf(this.delegate) + ", typeConverter=" + String.valueOf(this.typeConverter) + "]";
        }
    }

    public static abstract class ShardContext
    implements org.elasticsearch.compute.lucene.ShardContext,
    Releasable {
        private final AbstractRefCounted refCounted = new AbstractRefCounted(){

            protected void closeInternal() {
                this.close();
            }
        };

        public void incRef() {
            this.refCounted.incRef();
        }

        public boolean tryIncRef() {
            return this.refCounted.tryIncRef();
        }

        public boolean decRef() {
            return this.refCounted.decRef();
        }

        public boolean hasReferences() {
            return this.refCounted.hasReferences();
        }

        public abstract Query toQuery(QueryBuilder var1);

        public abstract double storedFieldsSequentialProportion();
    }
}

