/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plan.logical.promql.operator.arithmetic;

import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.Pow;
import org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic.Add;
import org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic.Div;
import org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic.Mod;
import org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic.Mul;
import org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic.Sub;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.plan.logical.promql.operator.VectorBinaryOperator;
import org.elasticsearch.xpack.esql.plan.logical.promql.operator.VectorMatch;

public class VectorBinaryArithmetic
extends VectorBinaryOperator {
    private final ArithmeticOp op;

    public VectorBinaryArithmetic(Source source, LogicalPlan left, LogicalPlan right, VectorMatch match, ArithmeticOp op) {
        super(source, left, right, match, true, op);
        this.op = op;
    }

    public ArithmeticOp op() {
        return this.op;
    }

    @Override
    public VectorBinaryOperator replaceChildren(LogicalPlan newLeft, LogicalPlan newRight) {
        return new VectorBinaryArithmetic(this.source(), newLeft, newRight, this.match(), this.op());
    }

    protected NodeInfo<VectorBinaryArithmetic> info() {
        return NodeInfo.create((Node)this, VectorBinaryArithmetic::new, (Object)((Object)this.left()), (Object)((Object)this.right()), (Object)this.match(), (Object)this.op());
    }

    public static enum ArithmeticOp implements VectorBinaryOperator.BinaryOp
    {
        ADD,
        SUB,
        MUL,
        DIV,
        MOD,
        POW;


        @Override
        public VectorBinaryOperator.ScalarFunctionFactory asFunction() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> Add::new;
                case 1 -> Sub::new;
                case 2 -> Mul::new;
                case 3 -> Div::new;
                case 4 -> Mod::new;
                case 5 -> Pow::new;
            };
        }
    }
}

