/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.parser;

import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.Build;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.logging.HeaderWarning;
import org.elasticsearch.common.lucene.BytesRefs;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.dissect.DissectException;
import org.elasticsearch.dissect.DissectParser;
import org.elasticsearch.index.IndexMode;
import org.elasticsearch.transport.RemoteClusterAware;
import org.elasticsearch.xpack.esql.VerificationException;
import org.elasticsearch.xpack.esql.action.EsqlCapabilities;
import org.elasticsearch.xpack.esql.action.PromqlFeatures;
import org.elasticsearch.xpack.esql.capabilities.TelemetryAware;
import org.elasticsearch.xpack.esql.common.Failure;
import org.elasticsearch.xpack.esql.core.expression.Alias;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.expression.EmptyAttribute;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.Expressions;
import org.elasticsearch.xpack.esql.core.expression.FoldContext;
import org.elasticsearch.xpack.esql.core.expression.Literal;
import org.elasticsearch.xpack.esql.core.expression.MapExpression;
import org.elasticsearch.xpack.esql.core.expression.MetadataAttribute;
import org.elasticsearch.xpack.esql.core.expression.NameId;
import org.elasticsearch.xpack.esql.core.expression.NamedExpression;
import org.elasticsearch.xpack.esql.core.expression.ReferenceAttribute;
import org.elasticsearch.xpack.esql.core.expression.UnresolvedAttribute;
import org.elasticsearch.xpack.esql.core.expression.UnresolvedStar;
import org.elasticsearch.xpack.esql.core.expression.UnresolvedTimestamp;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.core.util.CollectionUtils;
import org.elasticsearch.xpack.esql.core.util.Holder;
import org.elasticsearch.xpack.esql.core.util.StringUtils;
import org.elasticsearch.xpack.esql.expression.NamedExpressions;
import org.elasticsearch.xpack.esql.expression.Order;
import org.elasticsearch.xpack.esql.expression.UnresolvedNamePattern;
import org.elasticsearch.xpack.esql.expression.function.UnresolvedFunction;
import org.elasticsearch.xpack.esql.expression.predicate.Predicates;
import org.elasticsearch.xpack.esql.expression.predicate.logical.BinaryLogic;
import org.elasticsearch.xpack.esql.expression.predicate.logical.Not;
import org.elasticsearch.xpack.esql.expression.predicate.operator.comparison.Equals;
import org.elasticsearch.xpack.esql.expression.predicate.operator.comparison.EsqlBinaryComparison;
import org.elasticsearch.xpack.esql.parser.AbstractBuilder;
import org.elasticsearch.xpack.esql.parser.EsqlBaseParser;
import org.elasticsearch.xpack.esql.parser.ExpressionBuilder;
import org.elasticsearch.xpack.esql.parser.ParserUtils;
import org.elasticsearch.xpack.esql.parser.ParsingException;
import org.elasticsearch.xpack.esql.parser.PlanFactory;
import org.elasticsearch.xpack.esql.parser.PromqlParser;
import org.elasticsearch.xpack.esql.parser.QueryParam;
import org.elasticsearch.xpack.esql.parser.promql.PromqlParserUtils;
import org.elasticsearch.xpack.esql.plan.EsqlStatement;
import org.elasticsearch.xpack.esql.plan.IndexPattern;
import org.elasticsearch.xpack.esql.plan.QuerySetting;
import org.elasticsearch.xpack.esql.plan.logical.Aggregate;
import org.elasticsearch.xpack.esql.plan.logical.ChangePoint;
import org.elasticsearch.xpack.esql.plan.logical.Dissect;
import org.elasticsearch.xpack.esql.plan.logical.Drop;
import org.elasticsearch.xpack.esql.plan.logical.Enrich;
import org.elasticsearch.xpack.esql.plan.logical.Eval;
import org.elasticsearch.xpack.esql.plan.logical.Explain;
import org.elasticsearch.xpack.esql.plan.logical.Filter;
import org.elasticsearch.xpack.esql.plan.logical.Fork;
import org.elasticsearch.xpack.esql.plan.logical.Grok;
import org.elasticsearch.xpack.esql.plan.logical.InlineStats;
import org.elasticsearch.xpack.esql.plan.logical.Insist;
import org.elasticsearch.xpack.esql.plan.logical.Keep;
import org.elasticsearch.xpack.esql.plan.logical.Limit;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.plan.logical.Lookup;
import org.elasticsearch.xpack.esql.plan.logical.MvExpand;
import org.elasticsearch.xpack.esql.plan.logical.OrderBy;
import org.elasticsearch.xpack.esql.plan.logical.Rename;
import org.elasticsearch.xpack.esql.plan.logical.Row;
import org.elasticsearch.xpack.esql.plan.logical.Sample;
import org.elasticsearch.xpack.esql.plan.logical.SourceCommand;
import org.elasticsearch.xpack.esql.plan.logical.Subquery;
import org.elasticsearch.xpack.esql.plan.logical.TimeSeriesAggregate;
import org.elasticsearch.xpack.esql.plan.logical.UnionAll;
import org.elasticsearch.xpack.esql.plan.logical.UnresolvedRelation;
import org.elasticsearch.xpack.esql.plan.logical.fuse.Fuse;
import org.elasticsearch.xpack.esql.plan.logical.inference.Completion;
import org.elasticsearch.xpack.esql.plan.logical.inference.InferencePlan;
import org.elasticsearch.xpack.esql.plan.logical.inference.Rerank;
import org.elasticsearch.xpack.esql.plan.logical.join.LookupJoin;
import org.elasticsearch.xpack.esql.plan.logical.promql.PromqlCommand;
import org.elasticsearch.xpack.esql.plan.logical.show.ShowInfo;
import org.joni.exception.SyntaxException;

public class LogicalPlanBuilder
extends ExpressionBuilder {
    private static final String TIME = "time";
    private static final String START = "start";
    private static final String END = "end";
    private static final String STEP = "step";
    private static final Set<String> PROMQL_ALLOWED_PARAMS = Set.of("time", "start", "end", "step");
    public static final int MAX_QUERY_DEPTH = 500;
    private int queryDepth = 0;

    public LogicalPlanBuilder(ExpressionBuilder.ParsingContext context) {
        super(context);
    }

    protected EsqlStatement statement(ParseTree ctx) {
        EsqlStatement p = ParserUtils.typedParsing(this, ctx, EsqlStatement.class);
        return p;
    }

    protected LogicalPlan plan(ParseTree ctx) {
        Explain explain;
        LogicalPlan p = ParserUtils.typedParsing(this, ctx, LogicalPlan.class);
        if (!(p instanceof Explain) && p.anyMatch(logicalPlan -> logicalPlan instanceof Explain)) {
            throw new ParsingException(ParserUtils.source(ctx), "EXPLAIN does not support downstream commands", new Object[0]);
        }
        if (p instanceof Explain && (explain = (Explain)p).query().anyMatch(logicalPlan -> logicalPlan instanceof Explain)) {
            throw new ParsingException(ParserUtils.source(ctx), "EXPLAIN cannot be used inside another EXPLAIN command", new Object[0]);
        }
        Iterator<ParsingException> errors = this.context.params().parsingErrors();
        if (!errors.hasNext()) {
            return p;
        }
        throw ParsingException.combineParsingExceptions(errors);
    }

    @Override
    public EsqlStatement visitStatements(EsqlBaseParser.StatementsContext ctx) {
        ArrayList<QuerySetting> settings = new ArrayList<QuerySetting>();
        for (EsqlBaseParser.SetCommandContext setCommandContext : ctx.setCommand()) {
            settings.add(this.visitSetCommand(setCommandContext));
        }
        LogicalPlan query = this.visitSingleStatement(ctx.singleStatement());
        return new EsqlStatement(query, settings);
    }

    protected List<LogicalPlan> plans(List<? extends ParserRuleContext> ctxs) {
        return ParserUtils.visitList(this, ctxs, LogicalPlan.class);
    }

    @Override
    public LogicalPlan visitSingleStatement(EsqlBaseParser.SingleStatementContext ctx) {
        LogicalPlan plan = this.plan((ParseTree)ctx.query());
        this.telemetryAccounting(plan);
        return plan;
    }

    @Override
    public QuerySetting visitSetCommand(EsqlBaseParser.SetCommandContext ctx) {
        Alias field = this.visitSetField(ctx.setField());
        return new QuerySetting(ParserUtils.source(ctx), field);
    }

    @Override
    public Alias visitSetField(EsqlBaseParser.SetFieldContext ctx) {
        String name = this.visitIdentifier(ctx.identifier());
        Expression value = this.expression((ParseTree)ctx.constant());
        return new Alias(ParserUtils.source(ctx), name, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LogicalPlan visitCompositeQuery(EsqlBaseParser.CompositeQueryContext ctx) {
        ++this.queryDepth;
        if (this.queryDepth > 500) {
            throw new ParsingException("ESQL statement exceeded the maximum query depth allowed ({}): [{}]", 500, ctx.getText());
        }
        try {
            LogicalPlan input = this.plan((ParseTree)ctx.query());
            this.telemetryAccounting(input);
            PlanFactory makePlan = ParserUtils.typedParsing(this, (ParseTree)ctx.processingCommand(), PlanFactory.class);
            LogicalPlan logicalPlan = (LogicalPlan)((Object)makePlan.apply(input));
            return logicalPlan;
        }
        finally {
            --this.queryDepth;
        }
    }

    private LogicalPlan telemetryAccounting(LogicalPlan node) {
        if (node instanceof TelemetryAware) {
            TelemetryAware ma = (TelemetryAware)((Object)node);
            this.context.telemetry().command(ma);
        }
        return node;
    }

    @Override
    public PlanFactory visitEvalCommand(EsqlBaseParser.EvalCommandContext ctx) {
        return p -> new Eval(ParserUtils.source(ctx), (LogicalPlan)((Object)p), (List<Alias>)this.visitFields(ctx.fields()));
    }

    @Override
    public PlanFactory visitGrokCommand(EsqlBaseParser.GrokCommandContext ctx) {
        return p -> {
            Source source = ParserUtils.source(ctx);
            FoldContext patternFoldContext = FoldContext.small();
            List<String> patterns = ctx.string().stream().map(stringContext -> BytesRefs.toString((Object)this.visitString((EsqlBaseParser.StringContext)((Object)((Object)stringContext))).fold(patternFoldContext))).toList();
            for (int i = 0; i < patterns.size(); ++i) {
                String pattern = patterns.get(i);
                try {
                    Grok.pattern(source, pattern);
                    continue;
                }
                catch (SyntaxException e) {
                    throw new ParsingException(ParserUtils.source(ctx.string(i)), "Invalid GROK pattern [{}]: [{}]", pattern, e.getMessage());
                }
            }
            String combinePattern = org.elasticsearch.grok.Grok.combinePatterns(patterns);
            Grok.Parser grokParser = Grok.pattern(source, combinePattern);
            this.validateGrokPattern(source, grokParser, combinePattern, patterns);
            Grok result = new Grok(ParserUtils.source(ctx), (LogicalPlan)((Object)p), this.expression((ParseTree)ctx.primaryExpression()), grokParser);
            return result;
        };
    }

    private void validateGrokPattern(Source source, Grok.Parser grokParser, String pattern, List<String> originalPatterns) {
        HashMap<String, DataType> definedAttributes = new HashMap<String, DataType>();
        for (Attribute field : grokParser.extractedFields()) {
            DataType type;
            String name = field.name();
            DataType prev = definedAttributes.put(name, type = field.dataType());
            if (prev == null) continue;
            if (originalPatterns.size() == 1) {
                throw new ParsingException(source, "Invalid GROK pattern [{}]: the attribute [{}] is defined multiple times with different types", originalPatterns.getFirst(), name);
            }
            throw new ParsingException(source, "Invalid GROK patterns {}: the attribute [{}] is defined multiple times with different types", originalPatterns, name);
        }
    }

    @Override
    public PlanFactory visitDissectCommand(EsqlBaseParser.DissectCommandContext ctx) {
        return p -> {
            String pattern = BytesRefs.toString((Object)this.visitString(ctx.string()).fold(FoldContext.small()));
            Object options = this.visitDissectCommandOptions(ctx.dissectCommandOptions());
            String appendSeparator = "";
            for (Map.Entry item : options.entrySet()) {
                if (!((String)item.getKey()).equalsIgnoreCase("append_separator")) {
                    throw new ParsingException(ParserUtils.source(ctx), "Invalid option for dissect: [{}]", item.getKey());
                }
                if (!(item.getValue() instanceof BytesRef)) {
                    throw new ParsingException(ParserUtils.source(ctx), "Invalid value for dissect append_separator: expected a string, but was [{}]", item.getValue());
                }
                appendSeparator = BytesRefs.toString(item.getValue());
            }
            Source src = ParserUtils.source(ctx);
            try {
                DissectParser parser = new DissectParser(pattern, appendSeparator);
                Set referenceKeys = parser.referenceKeys();
                if (!referenceKeys.isEmpty()) {
                    throw new ParsingException(src, "Reference keys not supported in dissect patterns: [%{*{}}]", referenceKeys.iterator().next());
                }
                Dissect.Parser esqlDissectParser = new Dissect.Parser(pattern, appendSeparator, parser);
                List<Attribute> keys = esqlDissectParser.keyAttributes(src);
                return new Dissect(src, (LogicalPlan)((Object)p), this.expression((ParseTree)ctx.primaryExpression()), esqlDissectParser, keys);
            }
            catch (DissectException e) {
                throw new ParsingException(src, "Invalid pattern for dissect: [{}]", pattern);
            }
        };
    }

    @Override
    public PlanFactory visitMvExpandCommand(EsqlBaseParser.MvExpandCommandContext ctx) {
        UnresolvedAttribute field = this.visitQualifiedName(ctx.qualifiedName());
        Source src = ParserUtils.source(ctx);
        return child -> new MvExpand(src, (LogicalPlan)((Object)child), (NamedExpression)field, (Attribute)new UnresolvedAttribute(src, field.qualifier(), field.name(), null));
    }

    @Override
    public Map<String, Object> visitDissectCommandOptions(EsqlBaseParser.DissectCommandOptionsContext ctx) {
        if (ctx == null) {
            return Map.of();
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (EsqlBaseParser.DissectCommandOptionContext option : ctx.dissectCommandOption()) {
            result.put(this.visitIdentifier(option.identifier()), this.expression((ParseTree)option.constant()).fold(FoldContext.small()));
        }
        return result;
    }

    @Override
    public LogicalPlan visitRowCommand(EsqlBaseParser.RowCommandContext ctx) {
        return new Row(ParserUtils.source(ctx), (List<Alias>)NamedExpressions.mergeOutputExpressions((List<? extends NamedExpression>)this.visitFields(ctx.fields()), List.of()));
    }

    private LogicalPlan visitRelation(Source source, SourceCommand command, EsqlBaseParser.IndexPatternAndMetadataFieldsContext ctx) {
        List<EsqlBaseParser.IndexPatternOrSubqueryContext> ctxs = ctx == null ? null : ctx.indexPatternOrSubquery();
        ArrayList indexPatternsCtx = new ArrayList();
        ArrayList<EsqlBaseParser.SubqueryContext> subqueriesCtx = new ArrayList<EsqlBaseParser.SubqueryContext>();
        if (ctxs != null) {
            ctxs.forEach(c -> {
                if (c.indexPattern() != null) {
                    indexPatternsCtx.add(c.indexPattern());
                } else {
                    subqueriesCtx.add(c.subquery());
                }
            });
        }
        IndexPattern table = new IndexPattern(source, this.visitIndexPattern((List)indexPatternsCtx));
        List<Subquery> subqueries = this.visitSubqueriesInFromCommand(subqueriesCtx);
        LinkedHashMap<String, MetadataAttribute> metadataMap = new LinkedHashMap<String, MetadataAttribute>();
        if (ctx.metadata() != null) {
            for (TerminalNode c2 : ctx.metadata().UNQUOTED_SOURCE()) {
                String id = c2.getText();
                Source src = ParserUtils.source(c2);
                if (!MetadataAttribute.isSupported((String)id)) {
                    throw new ParsingException(src, "unsupported metadata field [" + id + "]", new Object[0]);
                }
                Attribute a = (Attribute)metadataMap.put(id, MetadataAttribute.create((Source)src, (String)id));
                if (a == null) continue;
                throw new ParsingException(src, "metadata field [" + id + "] already declared [" + String.valueOf(a.source().source()) + "]", new Object[0]);
            }
        }
        List<Attribute> metadataFields = List.of((Attribute[])metadataMap.values().toArray(Attribute[]::new));
        UnresolvedRelation unresolvedRelation = new UnresolvedRelation(source, table, false, metadataFields, null, command);
        if (subqueries.isEmpty()) {
            return unresolvedRelation;
        }
        if (command == SourceCommand.TS) {
            throw new ParsingException(source, "Subqueries are not supported in TS command", new Object[0]);
        }
        ArrayList<LogicalPlan> mainQueryAndSubqueries = new ArrayList<LogicalPlan>(subqueries.size() + 1);
        if (!table.indexPattern().isEmpty()) {
            mainQueryAndSubqueries.add(unresolvedRelation);
            this.telemetryAccounting(unresolvedRelation);
        }
        mainQueryAndSubqueries.addAll(subqueries);
        if (mainQueryAndSubqueries.size() == 1) {
            return table.indexPattern().isEmpty() ? subqueries.get(0).plan() : unresolvedRelation;
        }
        return new UnionAll(ParserUtils.source(ctxs.getFirst(), (ParserRuleContext)ctxs.getLast()), mainQueryAndSubqueries, List.of());
    }

    private List<Subquery> visitSubqueriesInFromCommand(List<EsqlBaseParser.SubqueryContext> ctxs) {
        if (!EsqlCapabilities.Cap.SUBQUERY_IN_FROM_COMMAND.isEnabled()) {
            return List.of();
        }
        if (ctxs == null) {
            return List.of();
        }
        ArrayList<Subquery> subqueries = new ArrayList<Subquery>();
        for (EsqlBaseParser.SubqueryContext ctx : ctxs) {
            LogicalPlan plan = this.visitSubquery(ctx);
            subqueries.add(new Subquery(ParserUtils.source(ctx), plan));
        }
        return subqueries;
    }

    @Override
    public LogicalPlan visitSubquery(EsqlBaseParser.SubqueryContext ctx) {
        EsqlBaseParser.FromCommandContext fromCtx = ctx.fromCommand();
        LogicalPlan plan = this.visitFromCommand(fromCtx);
        List<PlanFactory> processingCommands = ParserUtils.visitList(this, ctx.processingCommand(), PlanFactory.class);
        for (PlanFactory processingCommand : processingCommands) {
            this.telemetryAccounting(plan);
            plan = (LogicalPlan)((Object)processingCommand.apply(plan));
        }
        this.telemetryAccounting(plan);
        return plan;
    }

    @Override
    public LogicalPlan visitFromCommand(EsqlBaseParser.FromCommandContext ctx) {
        return this.visitRelation(ParserUtils.source(ctx), SourceCommand.FROM, ctx.indexPatternAndMetadataFields());
    }

    @Override
    public PlanFactory visitInsistCommand(EsqlBaseParser.InsistCommandContext ctx) {
        Source source = ParserUtils.source(ctx);
        List<NamedExpression> fields = this.visitQualifiedNamePatterns(ctx.qualifiedNamePatterns(), ne -> {
            if (ne instanceof UnresolvedStar || ne instanceof UnresolvedNamePattern) {
                Source neSource = ne.source();
                throw new ParsingException(neSource, "INSIST doesn't support wildcards, found [{}]", neSource.text());
            }
        });
        return input -> new Insist(source, (LogicalPlan)((Object)input), (List<? extends Attribute>)fields.stream().map(ne -> new UnresolvedAttribute(ne.source(), ne.name())).toList());
    }

    @Override
    public PlanFactory visitStatsCommand(EsqlBaseParser.StatsCommandContext ctx) {
        Stats stats = this.stats(ParserUtils.source(ctx), ctx.grouping, ctx.stats);
        return input -> {
            if (!input.anyMatch(p -> p instanceof Aggregate) && input.anyMatch(p -> {
                UnresolvedRelation ur;
                return p instanceof UnresolvedRelation && (ur = (UnresolvedRelation)p).indexMode() == IndexMode.TIME_SERIES;
            })) {
                return new TimeSeriesAggregate(ParserUtils.source(ctx), (LogicalPlan)((Object)input), stats.groupings, stats.aggregates, null);
            }
            return new Aggregate(ParserUtils.source(ctx), (LogicalPlan)((Object)input), stats.groupings, stats.aggregates);
        };
    }

    private Stats stats(Source source, EsqlBaseParser.FieldsContext groupingsCtx, EsqlBaseParser.AggFieldsContext aggregatesCtx) {
        List<NamedExpression> groupings = this.visitGrouping(groupingsCtx);
        ArrayList<Attribute> aggregates = new ArrayList<Attribute>((Collection<Attribute>)this.visitAggFields(aggregatesCtx));
        if (aggregates.isEmpty() && groupings.isEmpty()) {
            throw new ParsingException(source, "At least one aggregation or grouping expression required in [{}]", source.text());
        }
        if (!groupings.isEmpty() && !aggregates.isEmpty()) {
            LinkedHashSet groupNames = new LinkedHashSet(Expressions.names(groupings));
            LinkedHashSet linkedHashSet = new LinkedHashSet(Expressions.names((Collection)Expressions.references(groupings)));
            for (NamedExpression namedExpression : aggregates) {
                Expression e = Alias.unwrap((Expression)namedExpression);
                if (e.resolved() || e instanceof UnresolvedFunction) continue;
                String name = e.sourceText();
                if (groupNames.contains(name)) {
                    this.fail(e, "grouping key [{}] already specified in the STATS BY clause", name);
                    continue;
                }
                if (!linkedHashSet.contains(name)) continue;
                this.fail(e, "Cannot specify grouping expression [{}] as an aggregate", name);
            }
        }
        for (Expression expression : groupings) {
            aggregates.add(Expressions.attribute((Expression)expression));
        }
        return new Stats(new ArrayList<NamedExpression>(groupings), aggregates);
    }

    private void fail(Expression exp, String message, Object ... args) {
        throw new VerificationException(Collections.singletonList(Failure.fail(exp, message, args)));
    }

    @Override
    public PlanFactory visitInlineStatsCommand(EsqlBaseParser.InlineStatsCommandContext ctx) {
        Source source = ParserUtils.source(ctx);
        if (!EsqlCapabilities.Cap.INLINE_STATS.isEnabled()) {
            throw new ParsingException(source, "INLINE STATS command currently requires a snapshot build", new Object[0]);
        }
        if (ctx.INLINESTATS() != null) {
            HeaderWarning.addWarning((String)"Line {}:{}: INLINESTATS is deprecated, use INLINE STATS instead", (Object[])new Object[]{source.source().getLineNumber(), source.source().getColumnNumber()});
        }
        Object aggFields = this.visitAggFields(ctx.stats);
        ArrayList<NamedExpression> aggregates = new ArrayList<NamedExpression>((Collection<NamedExpression>)aggFields);
        List<NamedExpression> groupings = this.visitGrouping(ctx.grouping);
        aggregates.addAll(groupings);
        return input -> new InlineStats(source, new Aggregate(source, (LogicalPlan)((Object)input), (List<Expression>)new ArrayList<Expression>(groupings), (List<? extends NamedExpression>)aggregates));
    }

    @Override
    public PlanFactory visitWhereCommand(EsqlBaseParser.WhereCommandContext ctx) {
        Expression expression = this.expression((ParseTree)ctx.booleanExpression());
        return input -> new Filter(ParserUtils.source(ctx), (LogicalPlan)((Object)input), expression);
    }

    @Override
    public PlanFactory visitLimitCommand(EsqlBaseParser.LimitCommandContext ctx) {
        Integer i;
        Source source = ParserUtils.source(ctx);
        Object val = this.expression((ParseTree)ctx.constant()).fold(FoldContext.small());
        if (val instanceof Integer && (i = (Integer)val) >= 0) {
            return input -> new Limit(source, (Expression)new Literal(source, (Object)i, DataType.INTEGER), (LogicalPlan)((Object)input));
        }
        String valueType = this.expression((ParseTree)ctx.constant()).dataType().typeName();
        throw new ParsingException(source, "value of [" + source.text() + "] must be a non negative integer, found value [" + ctx.constant().getText() + "] type [" + valueType + "]", new Object[0]);
    }

    @Override
    public PlanFactory visitSortCommand(EsqlBaseParser.SortCommandContext ctx) {
        List<Order> orders = ParserUtils.visitList(this, ctx.orderExpression(), Order.class);
        Source source = ParserUtils.source(ctx);
        return input -> new OrderBy(source, (LogicalPlan)((Object)input), orders);
    }

    @Override
    public Explain visitExplainCommand(EsqlBaseParser.ExplainCommandContext ctx) {
        return new Explain(ParserUtils.source(ctx), this.plan((ParseTree)ctx.subqueryExpression().query()));
    }

    @Override
    public PlanFactory visitDropCommand(EsqlBaseParser.DropCommandContext ctx) {
        List<NamedExpression> removals = this.visitQualifiedNamePatterns(ctx.qualifiedNamePatterns(), ne -> {
            if (ne instanceof UnresolvedStar) {
                Source src = ne.source();
                throw new ParsingException(src, "Removing all fields is not allowed [{}]", src.text());
            }
        });
        return child -> new Drop(ParserUtils.source(ctx), (LogicalPlan)((Object)child), removals);
    }

    @Override
    public PlanFactory visitRenameCommand(EsqlBaseParser.RenameCommandContext ctx) {
        List<Alias> renamings = ctx.renameClause().stream().map(this::visitRenameClause).toList();
        return child -> new Rename(ParserUtils.source(ctx), (LogicalPlan)((Object)child), renamings);
    }

    @Override
    public PlanFactory visitKeepCommand(EsqlBaseParser.KeepCommandContext ctx) {
        Holder hasSeenStar = new Holder((Object)false);
        List<NamedExpression> projections = this.visitQualifiedNamePatterns(ctx.qualifiedNamePatterns(), ne -> {
            if (ne instanceof UnresolvedStar) {
                if (((Boolean)hasSeenStar.get()).booleanValue()) {
                    Source src = ne.source();
                    throw new ParsingException(src, "Cannot specify [*] more than once", src.text());
                }
                hasSeenStar.set((Object)Boolean.TRUE);
            }
        });
        return child -> new Keep(ParserUtils.source(ctx), (LogicalPlan)((Object)child), (List<? extends NamedExpression>)projections);
    }

    @Override
    public LogicalPlan visitShowInfo(EsqlBaseParser.ShowInfoContext ctx) {
        return new ShowInfo(ParserUtils.source(ctx));
    }

    @Override
    public PlanFactory visitEnrichCommand(EsqlBaseParser.EnrichCommandContext ctx) {
        return child -> {
            String patternString;
            EmptyAttribute matchField;
            Source source = ParserUtils.source(ctx);
            Tuple<Enrich.Mode, String> tuple = LogicalPlanBuilder.parsePolicyName(ctx.policyName);
            Enrich.Mode mode = (Enrich.Mode)((Object)((Object)tuple.v1()));
            String policyNameString = (String)tuple.v2();
            Object object = matchField = ctx.ON() != null ? this.visitQualifiedNamePattern(ctx.matchField) : new EmptyAttribute(source);
            if (matchField instanceof UnresolvedNamePattern) {
                UnresolvedNamePattern up = (UnresolvedNamePattern)matchField;
                v1 = up.pattern();
            } else {
                v1 = patternString = matchField instanceof UnresolvedStar ? "*" : null;
            }
            if (patternString != null) {
                throw new ParsingException(source, "Using wildcards [*] in ENRICH WITH projections is not allowed, found [{}]", patternString);
            }
            List<NamedExpression> keepClauses = ParserUtils.visitList(this, ctx.enrichWithClause(), NamedExpression.class);
            if (mode == Enrich.Mode.REMOTE) {
                child = (LogicalPlan)child.transformDown(LookupJoin.class, lj -> new LookupJoin(lj.source(), lj.left(), lj.right(), lj.config(), true));
            }
            return new Enrich(source, (LogicalPlan)((Object)child), mode, (Expression)Literal.keyword((Source)ParserUtils.source(ctx.policyName), (String)policyNameString), (NamedExpression)matchField, null, Map.of(), (List<NamedExpression>)(keepClauses.isEmpty() ? List.of() : keepClauses));
        };
    }

    @Override
    public PlanFactory visitChangePointCommand(EsqlBaseParser.ChangePointCommandContext ctx) {
        Source src = ParserUtils.source(ctx);
        UnresolvedAttribute value = this.visitQualifiedName(ctx.value);
        UnresolvedAttribute key = ctx.key == null ? new UnresolvedAttribute(src, "@timestamp") : this.visitQualifiedName(ctx.key);
        UnresolvedAttribute parsedTargetTypeColumn = this.visitQualifiedName(ctx.targetType);
        UnresolvedAttribute parsedTargetPvalueColumn = this.visitQualifiedName(ctx.targetPvalue);
        if (parsedTargetTypeColumn != null && parsedTargetTypeColumn.qualifier() != null) {
            throw LogicalPlanBuilder.qualifiersUnsupportedInFieldDefinitions(parsedTargetTypeColumn.source(), ctx.targetType.getText());
        }
        if (parsedTargetPvalueColumn != null && parsedTargetPvalueColumn.qualifier() != null) {
            throw LogicalPlanBuilder.qualifiersUnsupportedInFieldDefinitions(parsedTargetPvalueColumn.source(), ctx.targetPvalue.getText());
        }
        ReferenceAttribute targetType = new ReferenceAttribute(src, null, parsedTargetTypeColumn == null ? "type" : parsedTargetTypeColumn.name(), DataType.KEYWORD);
        ReferenceAttribute targetPvalue = new ReferenceAttribute(src, null, parsedTargetPvalueColumn == null ? "pvalue" : parsedTargetPvalueColumn.name(), DataType.DOUBLE);
        return arg_0 -> LogicalPlanBuilder.lambda$visitChangePointCommand$26(src, (Attribute)value, (Attribute)key, (Attribute)targetType, (Attribute)targetPvalue, arg_0);
    }

    private static Tuple<Enrich.Mode, String> parsePolicyName(EsqlBaseParser.EnrichPolicyNameContext ctx) {
        String stringValue;
        if (ctx.ENRICH_POLICY_NAME() != null) {
            stringValue = ctx.ENRICH_POLICY_NAME().getText();
        } else {
            stringValue = ctx.QUOTED_STRING().getText();
            stringValue = stringValue.substring(1, stringValue.length() - 1);
        }
        int index = stringValue.indexOf(":");
        Enrich.Mode mode = null;
        if (index >= 0) {
            String modeValue = stringValue.substring(0, index);
            if (modeValue.startsWith("_")) {
                mode = Enrich.Mode.from(modeValue.substring(1));
            }
            if (mode == null) {
                throw new ParsingException(ParserUtils.source(ctx), "Unrecognized value [{}], ENRICH policy qualifier needs to be one of {}", modeValue, Arrays.stream(Enrich.Mode.values()).map(s -> "_" + String.valueOf(s)).toList());
            }
        } else {
            mode = Enrich.Mode.ANY;
        }
        String policyName = index < 0 ? stringValue : stringValue.substring(index + 1);
        return new Tuple((Object)mode, (Object)policyName);
    }

    @Override
    public LogicalPlan visitTimeSeriesCommand(EsqlBaseParser.TimeSeriesCommandContext ctx) {
        return this.visitRelation(ParserUtils.source(ctx), SourceCommand.TS, ctx.indexPatternAndMetadataFields());
    }

    @Override
    public PlanFactory visitLookupCommand(EsqlBaseParser.LookupCommandContext ctx) {
        if (!Build.current().isSnapshot()) {
            throw new ParsingException(ParserUtils.source(ctx), "LOOKUP__ is in preview and only available in SNAPSHOT build", new Object[0]);
        }
        Source source = ParserUtils.source(ctx);
        List<NamedExpression> matchFields = this.visitQualifiedNamePatterns(ctx.qualifiedNamePatterns(), ne -> {
            if (ne instanceof UnresolvedNamePattern || ne instanceof UnresolvedStar) {
                Source src = ne.source();
                throw new ParsingException(src, "Using wildcards [*] in LOOKUP ON is not allowed yet [{}]", src.text());
            }
            if (!(ne instanceof UnresolvedAttribute)) {
                throw new IllegalStateException("visitQualifiedNamePatterns can only return UnresolvedNamePattern, UnresolvedStar or UnresolvedAttribute");
            }
        });
        Literal tableName = Literal.keyword((Source)source, (String)this.visitIndexPattern((List)List.of(ctx.indexPattern())));
        return p -> new Lookup(source, (LogicalPlan)((Object)p), (Expression)tableName, (List<Attribute>)matchFields, null);
    }

    @Override
    public PlanFactory visitJoinCommand(EsqlBaseParser.JoinCommandContext ctx) {
        Source source = ParserUtils.source(ctx);
        if (!EsqlCapabilities.Cap.JOIN_LOOKUP_V12.isEnabled()) {
            throw new ParsingException(source, "JOIN is in preview and only available in SNAPSHOT build", new Object[0]);
        }
        if (ctx.type != null && ctx.type.getType() != 24) {
            String joinType = ctx.type == null ? "(INNER)" : ctx.type.getText();
            throw new ParsingException(source, "only LOOKUP JOIN available, {} JOIN unsupported at the moment", joinType);
        }
        EsqlBaseParser.JoinTargetContext target = ctx.joinTarget();
        String rightPattern = this.visitIndexPattern((List)List.of(target.index));
        if (rightPattern.contains("*")) {
            throw new ParsingException(ParserUtils.source(target), "invalid index pattern [{}], * is not allowed in LOOKUP JOIN", rightPattern);
        }
        if (RemoteClusterAware.isRemoteIndexName((String)rightPattern)) {
            throw new ParsingException(ParserUtils.source(target), "invalid index pattern [{}], remote clusters are not supported with LOOKUP JOIN", rightPattern);
        }
        if (rightPattern.contains("::")) {
            throw new ParsingException(ParserUtils.source(target), "invalid index pattern [{}], index pattern selectors are not supported in LOOKUP JOIN", rightPattern);
        }
        UnresolvedRelation right = new UnresolvedRelation(ParserUtils.source(target), new IndexPattern(ParserUtils.source(target.index), rightPattern), false, Collections.emptyList(), IndexMode.LOOKUP, null);
        EsqlBaseParser.JoinConditionContext condition = ctx.joinCondition();
        JoinInfo joinInfo = ParserUtils.typedParsing(this, (ParseTree)condition, JoinInfo.class);
        return p -> {
            boolean hasRemotes = p.anyMatch(node -> {
                if (node instanceof UnresolvedRelation) {
                    UnresolvedRelation r = (UnresolvedRelation)node;
                    return Arrays.stream(Strings.splitStringByCommaToArray((String)r.indexPattern().indexPattern())).anyMatch(RemoteClusterAware::isRemoteIndexName);
                }
                return false;
            });
            if (hasRemotes && !EsqlCapabilities.Cap.ENABLE_LOOKUP_JOIN_ON_REMOTE.isEnabled()) {
                throw new ParsingException(source, "remote clusters are not supported with LOOKUP JOIN", new Object[0]);
            }
            return new LookupJoin(source, (LogicalPlan)((Object)p), right, joinInfo.joinFields(), hasRemotes, Predicates.combineAndWithSource(joinInfo.joinExpressions(), ParserUtils.source(condition)));
        };
    }

    @Override
    public JoinInfo visitJoinCondition(EsqlBaseParser.JoinConditionContext ctx) {
        boolean isFieldBased;
        List<Expression> expressions = ParserUtils.visitList(this, ctx.booleanExpression(), Expression.class);
        if (expressions.isEmpty()) {
            throw new ParsingException(ParserUtils.source(ctx), "JOIN ON clause cannot be empty", new Object[0]);
        }
        boolean bl = isFieldBased = expressions.get(0) instanceof UnresolvedAttribute || expressions.get(0) instanceof Literal;
        if (isFieldBased) {
            return this.processFieldBasedJoin(expressions);
        }
        return this.processExpressionBasedJoin(expressions, ctx);
    }

    private JoinInfo processFieldBasedJoin(List<Expression> expressions) {
        ArrayList<Attribute> joinFields = new ArrayList<Attribute>(expressions.size());
        for (Expression f : expressions) {
            if (f instanceof UnresolvedAttribute) {
                UnresolvedAttribute ua = (UnresolvedAttribute)f;
                if (ua.qualifier() != null) {
                    throw new ParsingException(ua.source(), "JOIN ON clause only supports unqualified fields, found [{}]", ua.qualifiedName());
                }
                joinFields.add((Attribute)ua);
                continue;
            }
            throw new ParsingException(f.source(), "JOIN ON clause must be a comma separated list of fields or a single expression, found [{}]", f.sourceText());
        }
        this.validateJoinFields(joinFields);
        return new JoinInfo(joinFields, Collections.emptyList());
    }

    private JoinInfo processExpressionBasedJoin(List<Expression> expressions, EsqlBaseParser.JoinConditionContext ctx) {
        if (!EsqlCapabilities.Cap.LOOKUP_JOIN_ON_BOOLEAN_EXPRESSION.isEnabled()) {
            throw new ParsingException(ParserUtils.source(ctx), "JOIN ON clause only supports fields at the moment.", new Object[0]);
        }
        ArrayList<Attribute> joinFields = new ArrayList<Attribute>();
        ArrayList<Expression> joinExpressions = new ArrayList<Expression>();
        if (expressions.size() != 1) {
            throw new ParsingException(ParserUtils.source(ctx), "JOIN ON clause with expressions only supports a single expression, found [{}]", expressions);
        }
        expressions = Predicates.splitAnd(expressions.get(0));
        for (Expression f : expressions) {
            this.addJoinExpression(f, joinFields, joinExpressions, ctx);
        }
        if (joinFields.isEmpty()) {
            throw new ParsingException(ParserUtils.source(ctx), "JOIN ON clause with expressions must contain at least one condition relating the left index and the lookup index", new Object[0]);
        }
        return new JoinInfo(joinFields, joinExpressions);
    }

    private void addJoinExpression(Expression exp, List<Attribute> joinFields, List<Expression> joinExpressions, EsqlBaseParser.JoinConditionContext ctx) {
        EsqlBinaryComparison comparison;
        Expression expression;
        if (this.containsBareFieldsInBooleanExpression(exp = this.handleNegationOfEquals(exp))) {
            throw new ParsingException(ParserUtils.source(ctx), "JOIN ON clause only supports fields or AND of Binary Expressions at the moment, found [{}]", exp.sourceText());
        }
        if (exp instanceof EsqlBinaryComparison && (expression = (comparison = (EsqlBinaryComparison)exp).left()) instanceof UnresolvedAttribute) {
            UnresolvedAttribute left = (UnresolvedAttribute)expression;
            expression = comparison.right();
            if (expression instanceof UnresolvedAttribute) {
                UnresolvedAttribute right = (UnresolvedAttribute)expression;
                joinFields.add((Attribute)left);
                joinFields.add((Attribute)right);
            }
        }
        joinExpressions.add(exp);
    }

    private boolean containsBareFieldsInBooleanExpression(Expression expression) {
        if (expression instanceof UnresolvedAttribute) {
            return true;
        }
        if (expression instanceof EsqlBinaryComparison) {
            return false;
        }
        if (expression instanceof BinaryLogic) {
            BinaryLogic binaryLogic = (BinaryLogic)expression;
            return this.containsBareFieldsInBooleanExpression(binaryLogic.left()) || this.containsBareFieldsInBooleanExpression(binaryLogic.right());
        }
        return false;
    }

    private void validateJoinFields(List<Attribute> joinFields) {
        if (joinFields.size() > 1) {
            LinkedHashSet<String> matchFieldNames = new LinkedHashSet<String>();
            for (Attribute field : joinFields) {
                if (matchFieldNames.add(field.name())) continue;
                throw new ParsingException(field.source(), "JOIN ON clause does not support multiple fields with the same name, found multiple instances of [{}]", field.name());
            }
        }
    }

    private Expression handleNegationOfEquals(Expression f) {
        Object e;
        Not not;
        if (f instanceof Not && (not = (Not)f).children().size() == 1 && (e = not.children().get(0)) instanceof Equals) {
            Equals equals = (Equals)e;
            return equals.negate();
        }
        return f;
    }

    private void checkForRemoteClusters(LogicalPlan plan, Source source, String commandName) {
        plan.forEachUp(UnresolvedRelation.class, r -> {
            for (String indexPattern : Strings.splitStringByCommaToArray((String)r.indexPattern().indexPattern())) {
                if (!RemoteClusterAware.isRemoteIndexName((String)indexPattern)) continue;
                throw new ParsingException(source, "invalid index pattern [{}], remote clusters are not supported with {}", r.indexPattern().indexPattern(), commandName);
            }
        });
    }

    @Override
    public PlanFactory visitForkCommand(EsqlBaseParser.ForkCommandContext ctx) {
        Object subQueries = this.visitForkSubQueries(ctx.forkSubQueries());
        if (subQueries.size() > 8) {
            throw new ParsingException(ParserUtils.source(ctx), "Fork supports up to 8 branches", new Object[0]);
        }
        return arg_0 -> this.lambda$visitForkCommand$34(ctx, (List)subQueries, arg_0);
    }

    @Override
    public List<PlanFactory> visitForkSubQueries(EsqlBaseParser.ForkSubQueriesContext ctx) {
        ArrayList<PlanFactory> list = new ArrayList<PlanFactory>();
        int count = 1;
        NameId firstForkNameId = null;
        for (EsqlBaseParser.ForkSubQueryContext subQueryCtx : ctx.forkSubQuery()) {
            PlanFactory subQuery = this.visitForkSubQuery(subQueryCtx);
            Literal literal = Literal.keyword((Source)ParserUtils.source(ctx), (String)("fork" + count++));
            Alias alias = null;
            if (firstForkNameId == null) {
                alias = new Alias(ParserUtils.source(ctx), "_fork", (Expression)literal);
                firstForkNameId = alias.id();
            } else {
                alias = new Alias(ParserUtils.source(ctx), "_fork", (Expression)literal, firstForkNameId);
            }
            Alias finalAlias = alias;
            PlanFactory eval = p -> new Eval(ParserUtils.source(ctx), (LogicalPlan)((Object)((Object)subQuery.apply(p))), List.of(finalAlias));
            list.add(eval);
        }
        return List.copyOf(list);
    }

    @Override
    public PlanFactory visitForkSubQuery(EsqlBaseParser.ForkSubQueryContext ctx) {
        EsqlBaseParser.ForkSubQueryCommandContext subCtx = ctx.forkSubQueryCommand();
        if (subCtx instanceof EsqlBaseParser.SingleForkSubQueryCommandContext) {
            EsqlBaseParser.SingleForkSubQueryCommandContext sglCtx = (EsqlBaseParser.SingleForkSubQueryCommandContext)subCtx;
            return ParserUtils.typedParsing(this, (ParseTree)sglCtx.forkSubQueryProcessingCommand(), PlanFactory.class);
        }
        if (subCtx instanceof EsqlBaseParser.CompositeForkSubQueryContext) {
            EsqlBaseParser.CompositeForkSubQueryContext compCtx = (EsqlBaseParser.CompositeForkSubQueryContext)subCtx;
            return this.visitCompositeForkSubQuery(compCtx);
        }
        throw new AssertionError((Object)("Unknown context: " + String.valueOf((Object)ctx)));
    }

    @Override
    public PlanFactory visitCompositeForkSubQuery(EsqlBaseParser.CompositeForkSubQueryContext ctx) {
        PlanFactory lowerPlan = ParserUtils.typedParsing(this, (ParseTree)ctx.forkSubQueryCommand(), PlanFactory.class);
        PlanFactory makePlan = ParserUtils.typedParsing(this, (ParseTree)ctx.forkSubQueryProcessingCommand(), PlanFactory.class);
        return input -> (LogicalPlan)((Object)((Object)makePlan.apply((LogicalPlan)((Object)((Object)lowerPlan.apply(input))))));
    }

    @Override
    public PlanFactory visitFuseCommand(EsqlBaseParser.FuseCommandContext ctx) {
        Source source = ParserUtils.source(ctx);
        return input -> {
            Fuse.FuseType fuseType;
            Attribute scoreAttr = this.visitFuseScoreBy(ctx.fuseConfiguration(), source);
            Attribute discriminatorAttr = this.visitFuseGroupBy(ctx.fuseConfiguration(), source);
            List<NamedExpression> keys = this.visitFuseKeyBy(ctx.fuseConfiguration(), source);
            MapExpression options = this.visitFuseOptions(ctx.fuseConfiguration());
            String fuseTypeName = ctx.fuseType == null ? Fuse.FuseType.RRF.name() : this.visitIdentifier(ctx.fuseType);
            try {
                fuseType = Fuse.FuseType.valueOf(fuseTypeName.toUpperCase(Locale.ROOT));
            }
            catch (IllegalArgumentException e) {
                throw new ParsingException(ParserUtils.source(ctx), "Fuse type " + fuseTypeName + " is not supported", new Object[0]);
            }
            return new Fuse(source, (LogicalPlan)((Object)input), scoreAttr, discriminatorAttr, keys, fuseType, options);
        };
    }

    private Attribute visitFuseScoreBy(List<EsqlBaseParser.FuseConfigurationContext> fuseConfigurationContexts, Source source) {
        UnresolvedAttribute scoreAttr = null;
        for (EsqlBaseParser.FuseConfigurationContext fuseConfigurationContext : fuseConfigurationContexts) {
            if (fuseConfigurationContext.score == null) continue;
            if (scoreAttr != null) {
                throw new ParsingException(ParserUtils.source(fuseConfigurationContext), "Only one SCORE BY can be specified", new Object[0]);
            }
            scoreAttr = this.visitQualifiedName(fuseConfigurationContext.score);
        }
        return scoreAttr == null ? new UnresolvedAttribute(source, "_score") : scoreAttr;
    }

    private Attribute visitFuseGroupBy(List<EsqlBaseParser.FuseConfigurationContext> fuseConfigurationContexts, Source source) {
        UnresolvedAttribute groupByAttr = null;
        for (EsqlBaseParser.FuseConfigurationContext fuseConfigurationContext : fuseConfigurationContexts) {
            if (fuseConfigurationContext.group == null) continue;
            if (groupByAttr != null) {
                throw new ParsingException(ParserUtils.source(fuseConfigurationContext), "Only one GROUP BY can be specified", new Object[0]);
            }
            groupByAttr = this.visitQualifiedName(fuseConfigurationContext.group);
        }
        return groupByAttr == null ? new UnresolvedAttribute(source, "_fork") : groupByAttr;
    }

    private List<NamedExpression> visitFuseKeyBy(List<EsqlBaseParser.FuseConfigurationContext> fuseConfigurationContexts, Source source) {
        List<UnresolvedAttribute> keys = null;
        for (EsqlBaseParser.FuseConfigurationContext fuseConfigurationContext : fuseConfigurationContexts) {
            if (fuseConfigurationContext.key == null) continue;
            if (keys != null) {
                throw new ParsingException(ParserUtils.source(fuseConfigurationContext), "Only one KEY BY can be specified", new Object[0]);
            }
            keys = this.visitGrouping(fuseConfigurationContext.key);
        }
        return keys == null ? List.of(new UnresolvedAttribute(source, "_id"), new UnresolvedAttribute(source, "_index")) : keys;
    }

    private MapExpression visitFuseOptions(List<EsqlBaseParser.FuseConfigurationContext> fuseConfigurationContexts) {
        MapExpression options = null;
        for (EsqlBaseParser.FuseConfigurationContext fuseConfigurationContext : fuseConfigurationContexts) {
            if (fuseConfigurationContext.options == null) continue;
            if (options != null) {
                throw new ParsingException(ParserUtils.source(fuseConfigurationContext), "Only one WITH can be specified", new Object[0]);
            }
            options = this.visitMapExpression(fuseConfigurationContext.options);
        }
        return options;
    }

    @Override
    public PlanFactory visitRerankCommand(EsqlBaseParser.RerankCommandContext ctx) {
        Source source = ParserUtils.source(ctx);
        Object rerankFields = this.visitRerankFields(ctx.rerankFields());
        Expression queryText = this.expression((ParseTree)ctx.queryText);
        UnresolvedAttribute scoreAttribute = this.visitQualifiedName(ctx.targetField, new UnresolvedAttribute(source, "_score"));
        if (scoreAttribute.qualifier() != null) {
            throw LogicalPlanBuilder.qualifiersUnsupportedInFieldDefinitions(scoreAttribute.source(), ctx.targetField.getText());
        }
        return arg_0 -> this.lambda$visitRerankCommand$38(source, queryText, (List)rerankFields, (Attribute)scoreAttribute, ctx, arg_0);
    }

    private Rerank applyRerankOptions(Rerank rerank, EsqlBaseParser.CommandNamedParametersContext ctx) {
        MapExpression optionExpression = this.visitCommandNamedParameters(ctx);
        if (optionExpression == null) {
            return rerank;
        }
        Map optionsMap = optionExpression.keyFoldedMap();
        Expression inferenceId = (Expression)optionsMap.remove("inference_id");
        if (inferenceId != null) {
            rerank = this.applyInferenceId(rerank, inferenceId);
        }
        if (!optionsMap.isEmpty()) {
            throw new ParsingException(ParserUtils.source(ctx), "Inavalid option [{}] in RERANK, expected one of [{}]", optionsMap.keySet().stream().findAny().get(), rerank.validOptionNames());
        }
        return rerank;
    }

    @Override
    public PlanFactory visitCompletionCommand(EsqlBaseParser.CompletionCommandContext ctx) {
        Source source = ParserUtils.source(ctx);
        Expression prompt = this.expression((ParseTree)ctx.prompt);
        UnresolvedAttribute targetField = this.visitQualifiedName(ctx.targetField, new UnresolvedAttribute(source, "completion"));
        if (targetField.qualifier() != null) {
            throw LogicalPlanBuilder.qualifiersUnsupportedInFieldDefinitions(targetField.source(), ctx.targetField.getText());
        }
        return arg_0 -> this.lambda$visitCompletionCommand$39(source, prompt, (Attribute)targetField, ctx, arg_0);
    }

    private Completion applyCompletionOptions(Completion completion, EsqlBaseParser.CommandNamedParametersContext ctx) {
        MapExpression optionsExpression;
        MapExpression mapExpression = optionsExpression = ctx == null ? null : this.visitCommandNamedParameters(ctx);
        if (optionsExpression == null || !optionsExpression.containsKey((Object)"inference_id")) {
            throw new ParsingException(completion.source(), "Missing mandatory option [{}] in COMPLETION", "inference_id");
        }
        Map optionsMap = optionsExpression.keyFoldedMap();
        Expression inferenceId = (Expression)optionsMap.remove("inference_id");
        if (inferenceId != null) {
            completion = this.applyInferenceId(completion, inferenceId);
        }
        if (!optionsMap.isEmpty()) {
            throw new ParsingException(ParserUtils.source(ctx), "Inavalid option [{}] in COMPLETION, expected one of [{}]", optionsMap.keySet().stream().findAny().get(), completion.validOptionNames());
        }
        return completion;
    }

    private <InferencePlanType extends InferencePlan<InferencePlanType>> InferencePlanType applyInferenceId(InferencePlanType inferencePlan, Expression inferenceId) {
        if (!(inferenceId instanceof Literal && DataType.isString((DataType)inferenceId.dataType()))) {
            throw new ParsingException(inferenceId.source(), "Option [{}] must be a valid string, found [{}]", "inference_id", inferenceId.source().text());
        }
        return inferencePlan.withInferenceId(inferenceId);
    }

    @Override
    public PlanFactory visitSampleCommand(EsqlBaseParser.SampleCommandContext ctx) {
        Double probability;
        Source source = ParserUtils.source(ctx);
        Object val = this.expression((ParseTree)ctx.probability).fold(FoldContext.small());
        if (val instanceof Double && (probability = (Double)val) > 0.0 && probability < 1.0) {
            return input -> new Sample(source, (Expression)new Literal(source, (Object)probability, DataType.DOUBLE), (LogicalPlan)((Object)input));
        }
        throw new ParsingException(ParserUtils.source(ctx), "invalid value for SAMPLE probability [" + BytesRefs.toString((Object)val) + "], expecting a number between 0 and 1, exclusive", new Object[0]);
    }

    @Override
    public LogicalPlan visitPromqlCommand(EsqlBaseParser.PromqlCommandContext ctx) {
        LogicalPlan promqlPlan;
        Source source = ParserUtils.source(ctx);
        if (!PromqlFeatures.isEnabled()) {
            throw new ParsingException(source, "PROMQL command is not available. Requires snapshot build with capability [promql_vX] enabled", new Object[0]);
        }
        IndexPattern table = ctx.indexPattern().isEmpty() ? new IndexPattern(source, "*") : new IndexPattern(source, this.visitIndexPattern((List)ctx.indexPattern()));
        UnresolvedRelation unresolvedRelation = new UnresolvedRelation(source, table, false, List.of(), null, SourceCommand.PROMQL);
        PromqlParams params = this.parsePromqlParams(ctx, source);
        List<EsqlBaseParser.PromqlQueryPartContext> queryCtx = ctx.promqlQueryPart();
        if (queryCtx == null || queryCtx.isEmpty()) {
            throw new ParsingException(source, "PromQL expression cannot be empty", new Object[0]);
        }
        Token startToken = queryCtx.getFirst().start;
        Token stopToken = queryCtx.getLast().stop;
        String promqlQuery = ParserUtils.source(startToken, stopToken).text();
        if (promqlQuery.isBlank()) {
            throw new ParsingException(source, "PromQL expression cannot be empty", new Object[0]);
        }
        int promqlStartLine = startToken.getLine();
        int promqlStartColumn = startToken.getCharPositionInLine();
        PromqlParser promqlParser = new PromqlParser();
        try {
            promqlPlan = promqlParser.createStatement(promqlQuery, params.startLiteral(), params.endLiteral(), promqlStartLine, promqlStartColumn);
        }
        catch (ParsingException pe) {
            throw PromqlParserUtils.adjustParsingException(pe, promqlStartLine, promqlStartColumn);
        }
        return new PromqlCommand(source, unresolvedRelation, promqlPlan, params.startLiteral(), params.endLiteral(), params.stepLiteral(), (Expression)new UnresolvedTimestamp(source));
    }

    private PromqlParams parsePromqlParams(EsqlBaseParser.PromqlCommandContext ctx, Source source) {
        Instant time = null;
        Instant start = null;
        Instant end = null;
        Duration step = null;
        HashSet<String> paramsSeen = new HashSet<String>();
        block14: for (EsqlBaseParser.PromqlParamContext paramCtx : ctx.promqlParam()) {
            EsqlBaseParser.PromqlParamContentContext paramNameCtx = paramCtx.name;
            String name = this.parseParamName(paramCtx.name);
            if (!paramsSeen.add(name)) {
                throw new ParsingException(ParserUtils.source(paramNameCtx), "[{}] already specified", name);
            }
            Source valueSource = ParserUtils.source(paramCtx.value);
            String valueString = this.parseParamValue(paramCtx.value);
            switch (name) {
                case "time": {
                    time = PromqlParserUtils.parseDate(valueSource, valueString);
                    continue block14;
                }
                case "start": {
                    start = PromqlParserUtils.parseDate(valueSource, valueString);
                    continue block14;
                }
                case "end": {
                    end = PromqlParserUtils.parseDate(valueSource, valueString);
                    continue block14;
                }
                case "step": {
                    try {
                        step = Duration.ofSeconds(Integer.parseInt(valueString));
                    }
                    catch (NumberFormatException ignore) {
                        step = PromqlParserUtils.parseDuration(valueSource, valueString);
                    }
                    continue block14;
                }
            }
            Object message = "Unknown parameter [{}]";
            List similar = StringUtils.findSimilar((String)name, PROMQL_ALLOWED_PARAMS);
            if (!CollectionUtils.isEmpty((Collection)similar)) {
                message = (String)message + ", did you mean " + (similar.size() == 1 ? "[" + (String)similar.get(0) + "]" : "any of " + String.valueOf(similar)) + "?";
            }
            throw new ParsingException(ParserUtils.source(paramNameCtx), (String)message, name);
        }
        if (time != null) {
            if (start != null || end != null || step != null) {
                throw new ParsingException(source, "Specify either [{}] for instant query or [{}], [{}] or [{}] for a range query", TIME, STEP, START, END);
            }
            start = time;
            end = time;
        } else if (step != null) {
            if (start != null || end != null) {
                if (start == null || end == null) {
                    throw new ParsingException(source, "Parameters [{}] and [{}] must either both be specified or both be omitted for a range query", START, END);
                }
                if (end.isBefore(start)) {
                    throw new ParsingException(source, "invalid parameter \"end\": end timestamp must not be before start time", end, start);
                }
            }
            if (!step.isPositive()) {
                throw new ParsingException(source, "invalid parameter \"step\": zero or negative query resolution step widths are not accepted. Try a positive integer", step);
            }
        } else {
            throw new ParsingException(source, "Parameter [{}] or [{}] is required", STEP, TIME);
        }
        return new PromqlParams(source, start, end, step);
    }

    private String parseParamName(EsqlBaseParser.PromqlParamContentContext ctx) {
        if (ctx.UNQUOTED_SOURCE() != null) {
            return ctx.UNQUOTED_SOURCE().getText();
        }
        if (ctx.QUOTED_IDENTIFIER() != null) {
            return AbstractBuilder.unquote(ctx.QUOTED_IDENTIFIER().getText());
        }
        throw new ParsingException(ParserUtils.source(ctx), "Parameter name [{}] must be an identifier", ctx.getText());
    }

    private String parseParamValue(EsqlBaseParser.PromqlParamContentContext ctx) {
        if (ctx.UNQUOTED_SOURCE() != null) {
            return ctx.UNQUOTED_SOURCE().getText();
        }
        if (ctx.QUOTED_STRING() != null) {
            return AbstractBuilder.unquote(ctx.QUOTED_STRING().getText());
        }
        if (ctx.NAMED_OR_POSITIONAL_PARAM() != null) {
            QueryParam param = this.paramByNameOrPosition(ctx.NAMED_OR_POSITIONAL_PARAM());
            return param.value().toString();
        }
        if (ctx.QUOTED_IDENTIFIER() != null) {
            throw new ParsingException(ParserUtils.source(ctx), "Parameter value [{}] must not be a quoted identifier", ctx.getText());
        }
        throw new ParsingException(ParserUtils.source(ctx), "Invalid parameter value [{}]", ctx.getText());
    }

    private /* synthetic */ LogicalPlan lambda$visitCompletionCommand$39(Source source, Expression prompt, Attribute targetField, EsqlBaseParser.CompletionCommandContext ctx, LogicalPlan p) {
        this.checkForRemoteClusters(p, source, "COMPLETION");
        return this.applyCompletionOptions(new Completion(source, p, prompt, targetField), ctx.commandNamedParameters());
    }

    private /* synthetic */ LogicalPlan lambda$visitRerankCommand$38(Source source, Expression queryText, List rerankFields, Attribute scoreAttribute, EsqlBaseParser.RerankCommandContext ctx, LogicalPlan p) {
        this.checkForRemoteClusters(p, source, "RERANK");
        return this.applyRerankOptions(new Rerank(source, p, queryText, rerankFields, scoreAttribute), ctx.commandNamedParameters());
    }

    private /* synthetic */ LogicalPlan lambda$visitForkCommand$34(EsqlBaseParser.ForkCommandContext ctx, List subQueries, LogicalPlan input) {
        if (!EsqlCapabilities.Cap.ENABLE_FORK_FOR_REMOTE_INDICES.isEnabled()) {
            this.checkForRemoteClusters(input, ParserUtils.source(ctx), "FORK");
        }
        List<LogicalPlan> subPlans = subQueries.stream().map(planFactory -> (LogicalPlan)((Object)((Object)planFactory.apply(input)))).toList();
        return new Fork(ParserUtils.source(ctx), subPlans, List.of());
    }

    private static /* synthetic */ LogicalPlan lambda$visitChangePointCommand$26(Source src, Attribute value, Attribute key, Attribute targetType, Attribute targetPvalue, LogicalPlan child) {
        return new ChangePoint(src, child, value, key, targetType, targetPvalue);
    }

    private record Stats(List<Expression> groupings, List<? extends NamedExpression> aggregates) {
    }

    private record JoinInfo(List<Attribute> joinFields, List<Expression> joinExpressions) {
    }

    public record PromqlParams(Source source, Instant start, Instant end, Duration step) {
        public Literal startLiteral() {
            if (this.start == null) {
                return Literal.NULL;
            }
            return Literal.dateTime((Source)this.source, (Instant)this.start);
        }

        public Literal endLiteral() {
            if (this.end == null) {
                return Literal.NULL;
            }
            return Literal.dateTime((Source)this.source, (Instant)this.end);
        }

        public Literal stepLiteral() {
            if (this.step == null) {
                return Literal.NULL;
            }
            return Literal.timeDuration((Source)this.source, (Duration)this.step);
        }
    }
}

