/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xpack.esql.core.capabilities.Unresolvable;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.FieldAttribute;
import org.elasticsearch.xpack.esql.core.expression.NameId;
import org.elasticsearch.xpack.esql.core.expression.NamedExpression;
import org.elasticsearch.xpack.esql.core.expression.Nullability;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.core.type.EsField;
import org.elasticsearch.xpack.esql.core.type.UnsupportedEsField;
import org.elasticsearch.xpack.esql.core.util.PlanStreamInput;
import org.elasticsearch.xpack.esql.core.util.PlanStreamOutput;

public final class UnsupportedAttribute
extends FieldAttribute
implements Unresolvable {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Attribute.class, "UnsupportedAttribute", UnsupportedAttribute::readFrom);
    public static final NamedWriteableRegistry.Entry NAMED_EXPRESSION_ENTRY = new NamedWriteableRegistry.Entry(NamedExpression.class, UnsupportedAttribute.ENTRY.name, UnsupportedAttribute::readFrom);
    public static final NamedWriteableRegistry.Entry EXPRESSION_ENTRY = new NamedWriteableRegistry.Entry(Expression.class, UnsupportedAttribute.ENTRY.name, UnsupportedAttribute::readFrom);
    private final boolean hasCustomMessage;
    private final String message;

    private static String errorMessage(String name, UnsupportedEsField field) {
        return "Cannot use field [" + name + "] with unsupported type [" + String.join((CharSequence)",", field.getOriginalTypes()) + "]";
    }

    public UnsupportedAttribute(Source source, String name, UnsupportedEsField field) {
        this(source, name, field, null);
    }

    public UnsupportedAttribute(Source source, String name, UnsupportedEsField field, @Nullable String customMessage) {
        this(source, name, field, customMessage, null);
    }

    public UnsupportedAttribute(Source source, String name, UnsupportedEsField field, @Nullable String customMessage, @Nullable NameId id) {
        this(source, null, name, field, customMessage, id);
    }

    public UnsupportedAttribute(Source source, @Nullable String qualifier, String name, UnsupportedEsField field, @Nullable String customMessage, @Nullable NameId id) {
        super(source, null, qualifier, name, (EsField)field, Nullability.TRUE, id, false);
        this.hasCustomMessage = customMessage != null;
        this.message = customMessage == null ? UnsupportedAttribute.errorMessage(this.name(), field) : customMessage;
    }

    private static UnsupportedAttribute innerReadFrom(StreamInput in) throws IOException {
        Source source = Source.readFrom((StreamInput)((org.elasticsearch.xpack.esql.io.stream.PlanStreamInput)in));
        String qualifier = UnsupportedAttribute.readQualifier((PlanStreamInput)((org.elasticsearch.xpack.esql.io.stream.PlanStreamInput)in), (TransportVersion)in.getTransportVersion());
        String name = ((org.elasticsearch.xpack.esql.io.stream.PlanStreamInput)in).readCachedString();
        UnsupportedEsField field = (UnsupportedEsField)EsField.readFrom((StreamInput)in);
        String message = in.readOptionalString();
        NameId id = NameId.readFrom((StreamInput)((org.elasticsearch.xpack.esql.io.stream.PlanStreamInput)in));
        return new UnsupportedAttribute(source, qualifier, name, field, message, id);
    }

    public void writeTo(StreamOutput out) throws IOException {
        if (((PlanStreamOutput)out).writeAttributeCacheHeader((Attribute)this)) {
            Source.EMPTY.writeTo(out);
            this.checkAndSerializeQualifier((PlanStreamOutput)out, out.getTransportVersion());
            ((PlanStreamOutput)out).writeCachedString(this.name());
            this.field().writeTo(out);
            out.writeOptionalString(this.hasCustomMessage ? this.message : null);
            this.id().writeTo(out);
        }
    }

    public static UnsupportedAttribute readFrom(StreamInput in) throws IOException {
        return (UnsupportedAttribute)((Object)((org.elasticsearch.xpack.esql.io.stream.PlanStreamInput)in).readAttributeWithCache(UnsupportedAttribute::innerReadFrom));
    }

    public String getWriteableName() {
        return UnsupportedAttribute.ENTRY.name;
    }

    public boolean resolved() {
        return false;
    }

    public UnsupportedEsField field() {
        return (UnsupportedEsField)super.field();
    }

    public FieldAttribute.FieldName fieldName() {
        if (this.lazyFieldName == null) {
            this.lazyFieldName = new FieldAttribute.FieldName(this.name());
        }
        return this.lazyFieldName;
    }

    protected NodeInfo<FieldAttribute> info() {
        return NodeInfo.create((Node)this, UnsupportedAttribute::new, (Object)this.qualifier(), (Object)this.name(), (Object)this.field(), (Object)(this.hasCustomMessage ? this.message : null), (Object)this.id());
    }

    protected Attribute clone(Source source, String qualifier, String name, DataType type, Nullability nullability, NameId id, boolean synthetic) {
        return new UnsupportedAttribute(source, qualifier, name, this.field(), this.hasCustomMessage ? this.message : null, id);
    }

    protected String label() {
        return "!";
    }

    public String toString() {
        return "!" + this.qualifiedName();
    }

    public String nodeString() {
        return this.toString();
    }

    public String unresolvedMessage() {
        return this.message;
    }

    public boolean hasCustomMessage() {
        return this.hasCustomMessage;
    }

    protected int innerHashCode(boolean ignoreIds) {
        return Objects.hash(super.innerHashCode(ignoreIds), this.hasCustomMessage, this.message);
    }

    protected boolean innerEquals(Object o, boolean ignoreIds) {
        UnsupportedAttribute other = (UnsupportedAttribute)((Object)o);
        return super.innerEquals((Object)other, ignoreIds) && this.hasCustomMessage == other.hasCustomMessage && Objects.equals(this.message, other.message);
    }

    public List<String> originalTypes() {
        return this.field().getOriginalTypes();
    }
}

