/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.data;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.compute.data.AbstractNonThreadSafeRefCounted;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BooleanVector;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.data.TDigestBlock;
import org.elasticsearch.compute.data.Vector;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.ReleasableIterator;
import org.elasticsearch.core.Releasables;

public final class TDigestArrayBlock
extends AbstractNonThreadSafeRefCounted
implements TDigestBlock {
    private final DoubleBlock minima;
    private final DoubleBlock maxima;
    private final DoubleBlock sums;
    private final LongBlock valueCounts;
    private final BytesRefBlock encodedDigests;

    public TDigestArrayBlock(BytesRefBlock encodedDigests, DoubleBlock minima, DoubleBlock maxima, DoubleBlock sums, LongBlock valueCounts) {
        this.encodedDigests = encodedDigests;
        this.minima = minima;
        this.maxima = maxima;
        this.sums = sums;
        this.valueCounts = valueCounts;
    }

    private List<Block> getSubBlocks() {
        return List.of(this.minima, this.maxima, this.sums, this.valueCounts, this.encodedDigests);
    }

    @Override
    protected void closeInternal() {
        Releasables.close(this.getSubBlocks());
    }

    @Override
    public Vector asVector() {
        return null;
    }

    @Override
    public int getTotalValueCount() {
        return this.encodedDigests.getTotalValueCount();
    }

    @Override
    public int getPositionCount() {
        return this.encodedDigests.getPositionCount();
    }

    @Override
    public int getFirstValueIndex(int position) {
        return position;
    }

    @Override
    public int getValueCount(int position) {
        return this.isNull(position) ? 0 : 1;
    }

    @Override
    public ElementType elementType() {
        throw new UnsupportedOperationException("Need to implement this later");
    }

    @Override
    public BlockFactory blockFactory() {
        return this.encodedDigests.blockFactory();
    }

    @Override
    public void allowPassingToDifferentDriver() {
        this.getSubBlocks().forEach(Block::allowPassingToDifferentDriver);
    }

    @Override
    public boolean isNull(int position) {
        return this.encodedDigests.isNull(position);
    }

    @Override
    public boolean mayHaveNulls() {
        return this.encodedDigests.mayHaveNulls();
    }

    @Override
    public boolean areAllValuesNull() {
        return this.encodedDigests.areAllValuesNull();
    }

    @Override
    public boolean mayHaveMultivaluedFields() {
        return false;
    }

    @Override
    public boolean doesHaveMultivaluedFields() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Block filter(int ... positions) {
        DoubleBlock filteredMinima = null;
        DoubleBlock filteredMaxima = null;
        DoubleBlock filteredSums = null;
        LongBlock filteredValueCounts = null;
        BytesRefBlock filteredEncodedDigests = null;
        boolean success = false;
        try {
            filteredEncodedDigests = this.encodedDigests.filter(positions);
            filteredMinima = this.minima.filter(positions);
            filteredMaxima = this.maxima.filter(positions);
            filteredSums = this.sums.filter(positions);
            filteredValueCounts = this.valueCounts.filter(positions);
            return new TDigestArrayBlock(filteredEncodedDigests, filteredMinima, filteredMaxima, filteredSums, filteredValueCounts);
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            Releasables.close((Releasable[])new Releasable[]{filteredMinima, filteredMaxima, filteredSums, filteredValueCounts, filteredEncodedDigests});
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Block keepMask(BooleanVector mask) {
        DoubleBlock filteredMinima = null;
        DoubleBlock filteredMaxima = null;
        DoubleBlock filteredSums = null;
        LongBlock filteredValueCounts = null;
        BytesRefBlock filteredEncodedDigests = null;
        boolean success = false;
        try {
            filteredEncodedDigests = this.encodedDigests.keepMask(mask);
            filteredMinima = this.minima.keepMask(mask);
            filteredMaxima = this.maxima.keepMask(mask);
            filteredSums = this.sums.keepMask(mask);
            filteredValueCounts = this.valueCounts.keepMask(mask);
            return new TDigestArrayBlock(filteredEncodedDigests, filteredMinima, filteredMaxima, filteredSums, filteredValueCounts);
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            Releasables.close((Releasable[])new Releasable[]{filteredMinima, filteredMaxima, filteredSums, filteredValueCounts, filteredEncodedDigests});
            throw throwable;
        }
    }

    @Override
    public ReleasableIterator<? extends Block> lookup(IntBlock positions, ByteSizeValue targetBlockSize) {
        throw new UnsupportedOperationException("Lookup is not supported on TDigestArrayBlock");
    }

    @Override
    public Block.MvOrdering mvOrdering() {
        return Block.MvOrdering.UNORDERED;
    }

    @Override
    public Block expand() {
        this.incRef();
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Block deepCopy(BlockFactory blockFactory) {
        DoubleBlock copiedMinima = null;
        DoubleBlock copiedMaxima = null;
        DoubleBlock copiedSums = null;
        LongBlock copiedValueCounts = null;
        BytesRefBlock copiedEncodedDigests = null;
        boolean success = false;
        try {
            copiedEncodedDigests = this.encodedDigests.deepCopy(blockFactory);
            copiedMinima = this.minima.deepCopy(blockFactory);
            copiedMaxima = this.maxima.deepCopy(blockFactory);
            copiedSums = this.sums.deepCopy(blockFactory);
            copiedValueCounts = this.valueCounts.deepCopy(blockFactory);
            return new TDigestArrayBlock(copiedEncodedDigests, copiedMinima, copiedMaxima, copiedSums, copiedValueCounts);
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            Releasables.close((Releasable[])new Releasable[]{copiedMinima, copiedMaxima, copiedSums, copiedValueCounts, copiedEncodedDigests});
            throw throwable;
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        Block.writeTypedBlock(this.encodedDigests, out);
        Block.writeTypedBlock(this.minima, out);
        Block.writeTypedBlock(this.maxima, out);
        Block.writeTypedBlock(this.sums, out);
        Block.writeTypedBlock(this.valueCounts, out);
    }

    public long ramBytesUsed() {
        long bytes = 0L;
        for (Block b : this.getSubBlocks()) {
            bytes += b.ramBytesUsed();
        }
        return bytes;
    }
}

