/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation;

import java.util.List;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.compute.aggregation.AggregatorFunction;
import org.elasticsearch.compute.aggregation.IntermediateStateDesc;
import org.elasticsearch.compute.aggregation.MinBytesRefAggregator;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BooleanBlock;
import org.elasticsearch.compute.data.BooleanVector;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.BytesRefVector;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;

public final class MinBytesRefAggregatorFunction
implements AggregatorFunction {
    private static final List<IntermediateStateDesc> INTERMEDIATE_STATE_DESC = List.of(new IntermediateStateDesc("min", ElementType.BYTES_REF), new IntermediateStateDesc("seen", ElementType.BOOLEAN));
    private final DriverContext driverContext;
    private final MinBytesRefAggregator.SingleState state;
    private final List<Integer> channels;

    public MinBytesRefAggregatorFunction(DriverContext driverContext, List<Integer> channels, MinBytesRefAggregator.SingleState state) {
        this.driverContext = driverContext;
        this.channels = channels;
        this.state = state;
    }

    public static MinBytesRefAggregatorFunction create(DriverContext driverContext, List<Integer> channels) {
        return new MinBytesRefAggregatorFunction(driverContext, channels, MinBytesRefAggregator.initSingle(driverContext));
    }

    public static List<IntermediateStateDesc> intermediateStateDesc() {
        return INTERMEDIATE_STATE_DESC;
    }

    @Override
    public int intermediateBlockCount() {
        return INTERMEDIATE_STATE_DESC.size();
    }

    @Override
    public void addRawInput(Page page, BooleanVector mask) {
        if (!mask.allFalse()) {
            if (mask.allTrue()) {
                this.addRawInputNotMasked(page);
            } else {
                this.addRawInputMasked(page, mask);
            }
        }
    }

    private void addRawInputMasked(Page page, BooleanVector mask) {
        BytesRefBlock valueBlock = (BytesRefBlock)page.getBlock(this.channels.get(0));
        BytesRefVector valueVector = valueBlock.asVector();
        if (valueVector == null) {
            this.addRawBlock(valueBlock, mask);
            return;
        }
        this.addRawVector(valueVector, mask);
    }

    private void addRawInputNotMasked(Page page) {
        BytesRefBlock valueBlock = (BytesRefBlock)page.getBlock(this.channels.get(0));
        BytesRefVector valueVector = valueBlock.asVector();
        if (valueVector == null) {
            this.addRawBlock(valueBlock);
            return;
        }
        this.addRawVector(valueVector);
    }

    private void addRawVector(BytesRefVector valueVector) {
        BytesRef valueScratch = new BytesRef();
        for (int valuesPosition = 0; valuesPosition < valueVector.getPositionCount(); ++valuesPosition) {
            BytesRef valueValue = valueVector.getBytesRef(valuesPosition, valueScratch);
            MinBytesRefAggregator.combine(this.state, valueValue);
        }
    }

    private void addRawVector(BytesRefVector valueVector, BooleanVector mask) {
        BytesRef valueScratch = new BytesRef();
        for (int valuesPosition = 0; valuesPosition < valueVector.getPositionCount(); ++valuesPosition) {
            if (!mask.getBoolean(valuesPosition)) continue;
            BytesRef valueValue = valueVector.getBytesRef(valuesPosition, valueScratch);
            MinBytesRefAggregator.combine(this.state, valueValue);
        }
    }

    private void addRawBlock(BytesRefBlock valueBlock) {
        BytesRef valueScratch = new BytesRef();
        for (int p = 0; p < valueBlock.getPositionCount(); ++p) {
            int valueValueCount = valueBlock.getValueCount(p);
            if (valueValueCount == 0) continue;
            int valueStart = valueBlock.getFirstValueIndex(p);
            int valueEnd = valueStart + valueValueCount;
            for (int valueOffset = valueStart; valueOffset < valueEnd; ++valueOffset) {
                BytesRef valueValue = valueBlock.getBytesRef(valueOffset, valueScratch);
                MinBytesRefAggregator.combine(this.state, valueValue);
            }
        }
    }

    private void addRawBlock(BytesRefBlock valueBlock, BooleanVector mask) {
        BytesRef valueScratch = new BytesRef();
        for (int p = 0; p < valueBlock.getPositionCount(); ++p) {
            int valueValueCount;
            if (!mask.getBoolean(p) || (valueValueCount = valueBlock.getValueCount(p)) == 0) continue;
            int valueStart = valueBlock.getFirstValueIndex(p);
            int valueEnd = valueStart + valueValueCount;
            for (int valueOffset = valueStart; valueOffset < valueEnd; ++valueOffset) {
                BytesRef valueValue = valueBlock.getBytesRef(valueOffset, valueScratch);
                MinBytesRefAggregator.combine(this.state, valueValue);
            }
        }
    }

    @Override
    public void addIntermediateInput(Page page) {
        assert (this.channels.size() == this.intermediateBlockCount());
        assert (page.getBlockCount() >= this.channels.get(0) + MinBytesRefAggregatorFunction.intermediateStateDesc().size());
        Object minUncast = page.getBlock(this.channels.get(0));
        if (minUncast.areAllValuesNull()) {
            return;
        }
        BytesRefVector min = ((BytesRefBlock)minUncast).asVector();
        assert (min.getPositionCount() == 1);
        Object seenUncast = page.getBlock(this.channels.get(1));
        if (seenUncast.areAllValuesNull()) {
            return;
        }
        BooleanVector seen = ((BooleanBlock)seenUncast).asVector();
        assert (seen.getPositionCount() == 1);
        BytesRef minScratch = new BytesRef();
        MinBytesRefAggregator.combineIntermediate(this.state, min.getBytesRef(0, minScratch), seen.getBoolean(0));
    }

    @Override
    public void evaluateIntermediate(Block[] blocks, int offset, DriverContext driverContext) {
        this.state.toIntermediate(blocks, offset, driverContext);
    }

    @Override
    public void evaluateFinal(Block[] blocks, int offset, DriverContext driverContext) {
        blocks[offset] = MinBytesRefAggregator.evaluateFinal(this.state, driverContext);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append("[");
        sb.append("channels=").append(this.channels);
        sb.append("]");
        return sb.toString();
    }

    public void close() {
        this.state.close();
    }
}

