/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.util;

import java.util.Map;
import java.util.regex.Pattern;

public class NamedFormatter {
    private static final Pattern PARAM_REGEX = Pattern.compile("\\\\(.) | (% \\( ([^)]+) \\) )", 4);

    private NamedFormatter() {
    }

    public static String format(String fmt, Map<String, Object> values) {
        return PARAM_REGEX.matcher(fmt).replaceAll(match -> {
            if (match.group(1) != null) {
                return match.group(1);
            }
            String paramName = match.group(3);
            if (values.containsKey(paramName)) {
                return values.get(paramName).toString();
            }
            throw new IllegalArgumentException("No parameter value for %(" + paramName + ")");
        });
    }
}

