/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.simdvec.internal;

import java.lang.foreign.MemorySegment;
import java.lang.invoke.MethodHandle;
import org.elasticsearch.nativeaccess.NativeAccess;
import org.elasticsearch.nativeaccess.VectorSimilarityFunctions;

public class Similarities {
    static final VectorSimilarityFunctions DISTANCE_FUNCS = (VectorSimilarityFunctions)NativeAccess.instance().getVectorSimilarityFunctions().orElseThrow(AssertionError::new);
    static final MethodHandle DOT_PRODUCT_7U = DISTANCE_FUNCS.dotProductHandle7u();
    static final MethodHandle SQUARE_DISTANCE_7U = DISTANCE_FUNCS.squareDistanceHandle7u();
    static final MethodHandle DOT_PRODUCT_7U_BULK = DISTANCE_FUNCS.dotProductHandle7uBulk();

    static int dotProduct7u(MemorySegment a, MemorySegment b, int length) {
        try {
            return DOT_PRODUCT_7U.invokeExact(a, b, length);
        }
        catch (Throwable e) {
            if (e instanceof Error) {
                Error err = (Error)e;
                throw err;
            }
            if (e instanceof RuntimeException) {
                RuntimeException re = (RuntimeException)e;
                throw re;
            }
            throw new RuntimeException(e);
        }
    }

    static int squareDistance7u(MemorySegment a, MemorySegment b, int length) {
        try {
            return SQUARE_DISTANCE_7U.invokeExact(a, b, length);
        }
        catch (Throwable e) {
            if (e instanceof Error) {
                Error err = (Error)e;
                throw err;
            }
            if (e instanceof RuntimeException) {
                RuntimeException re = (RuntimeException)e;
                throw re;
            }
            throw new RuntimeException(e);
        }
    }

    static void dotProduct7uBulk(MemorySegment a, MemorySegment b, int length, int count, MemorySegment scores) {
        try {
            DOT_PRODUCT_7U_BULK.invokeExact(a, b, length, count, scores);
        }
        catch (Throwable e) {
            if (e instanceof Error) {
                Error err = (Error)e;
                throw err;
            }
            if (e instanceof RuntimeException) {
                RuntimeException re = (RuntimeException)e;
                throw re;
            }
            throw new RuntimeException(e);
        }
    }
}

