/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2AsyncClient;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.DescribeManagedPrefixListsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeManagedPrefixListsResponse;
import software.amazon.awssdk.services.ec2.model.ManagedPrefixList;

public class DescribeManagedPrefixListsPublisher
implements SdkPublisher<DescribeManagedPrefixListsResponse> {
    private final Ec2AsyncClient client;
    private final DescribeManagedPrefixListsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeManagedPrefixListsPublisher(Ec2AsyncClient client, DescribeManagedPrefixListsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeManagedPrefixListsPublisher(Ec2AsyncClient client, DescribeManagedPrefixListsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeManagedPrefixListsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeManagedPrefixListsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ManagedPrefixList> prefixLists() {
        Function<DescribeManagedPrefixListsResponse, Iterator> getIterator = response -> {
            if (response != null && response.prefixLists() != null) {
                return response.prefixLists().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeManagedPrefixListsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeManagedPrefixListsResponseFetcher
    implements AsyncPageFetcher<DescribeManagedPrefixListsResponse> {
        private DescribeManagedPrefixListsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeManagedPrefixListsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeManagedPrefixListsResponse> nextPage(DescribeManagedPrefixListsResponse previousPage) {
            if (previousPage == null) {
                return DescribeManagedPrefixListsPublisher.this.client.describeManagedPrefixLists(DescribeManagedPrefixListsPublisher.this.firstRequest);
            }
            return DescribeManagedPrefixListsPublisher.this.client.describeManagedPrefixLists((DescribeManagedPrefixListsRequest)((Object)DescribeManagedPrefixListsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

