/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cloud.azure.classic.management;

import com.microsoft.windowsazure.core.utils.KeyStoreType;
import com.microsoft.windowsazure.management.compute.models.HostedServiceGetDetailedResponse;
import java.net.URI;
import java.net.URISyntaxException;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.discovery.azure.classic.AzureSeedHostsProvider;

public interface AzureComputeService {
    public HostedServiceGetDetailedResponse getServiceDetails();

    public static final class Discovery {
        public static final Setting<TimeValue> REFRESH_SETTING = Setting.positiveTimeSetting((String)"discovery.azure.refresh_interval", (TimeValue)TimeValue.timeValueSeconds((long)0L), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
        public static final Setting<AzureSeedHostsProvider.HostType> HOST_TYPE_SETTING = new Setting("discovery.azure.host.type", AzureSeedHostsProvider.HostType.PRIVATE_IP.name(), AzureSeedHostsProvider.HostType::fromString, new Setting.Property[]{Setting.Property.NodeScope});
        public static final Setting<String> ENDPOINT_NAME_SETTING = Setting.simpleString((String)"discovery.azure.endpoint.name", (String)"elasticsearch", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
        public static final Setting<String> DEPLOYMENT_NAME_SETTING = Setting.simpleString((String)"discovery.azure.deployment.name", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
        public static final Setting<AzureSeedHostsProvider.Deployment> DEPLOYMENT_SLOT_SETTING = new Setting("discovery.azure.deployment.slot", AzureSeedHostsProvider.Deployment.PRODUCTION.name(), AzureSeedHostsProvider.Deployment::fromString, new Setting.Property[]{Setting.Property.NodeScope});
    }

    public static final class Management {
        public static final Setting<String> SUBSCRIPTION_ID_SETTING = Setting.simpleString((String)"cloud.azure.management.subscription.id", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered});
        public static final Setting<String> SERVICE_NAME_SETTING = Setting.simpleString((String)"cloud.azure.management.cloud.service.name", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
        public static final Setting<String> KEYSTORE_PATH_SETTING = Setting.simpleString((String)"cloud.azure.management.keystore.path", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered});
        public static final Setting<String> KEYSTORE_PASSWORD_SETTING = Setting.simpleString((String)"cloud.azure.management.keystore.password", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered});
        public static final Setting<KeyStoreType> KEYSTORE_TYPE_SETTING = new Setting("cloud.azure.management.keystore.type", KeyStoreType.pkcs12.name(), KeyStoreType::fromString, new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered});
        public static final Setting<URI> ENDPOINT_SETTING = new Setting("cloud.azure.management.endpoint", "https://management.core.windows.net/", s -> {
            try {
                return new URI((String)s);
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(e);
            }
        }, new Setting.Property[]{Setting.Property.NodeScope});
    }
}

