/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.shared.common.i18n;

import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import org.apache.derby.shared.common.error.ShutdownException;
import org.apache.derby.shared.common.i18n.BundleFinder;
import org.apache.derby.shared.common.info.JVMInfo;
import org.apache.derby.shared.common.reference.ModuleUtil;

public final class MessageService {
    private static final Locale EN = new Locale("en", "US");
    private static final String LOCALE_STUB = "locale_";
    private static final String CLIENT_MESSAGES = "clientmessages";
    private static final String TOOLS_MESSAGES = "toolsmessages";
    private static final String SYSINFO_MESSAGES = "sysinfoMessages";
    private static final String SERVER_MESSAGES = "drda";
    private static BundleFinder finder;

    private MessageService() {
    }

    public static ResourceBundle getBundleForLocale(Locale locale, String msgId) {
        try {
            return MessageService.getBundleWithEnDefault("org.apache.derby.loc.m" + MessageService.hashString50(msgId), locale);
        }
        catch (MissingResourceException missingResourceException) {
            return null;
        }
    }

    public static void setFinder(BundleFinder theFinder) {
        finder = theFinder;
    }

    public static String getTextMessage(String messageId, Object ... arguments) {
        try {
            return MessageService.formatMessage(MessageService.getBundle(messageId), messageId, arguments, true);
        }
        catch (MissingResourceException missingResourceException) {
        }
        catch (ShutdownException shutdownException) {
            // empty catch block
        }
        return MessageService.formatMessage(MessageService.getBundleForLocale(EN, messageId), messageId, arguments, false);
    }

    public static String getProperty(String messageId, String propertyName) {
        ResourceBundle bundle = MessageService.getBundle(messageId);
        try {
            if (bundle != null) {
                return bundle.getString(messageId.concat(".").concat(propertyName));
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return null;
    }

    public static String formatMessage(ResourceBundle bundle, String messageId, Object[] arguments, boolean lastChance) {
        block12: {
            if (arguments == null) {
                arguments = new Object[]{};
            }
            if (bundle != null) {
                try {
                    messageId = bundle.getString(messageId);
                    try {
                        return MessageFormat.format(messageId, arguments);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                    }
                    catch (NullPointerException nullPointerException) {
                    }
                }
                catch (MissingResourceException mre) {
                    if (!lastChance) break block12;
                    throw mre;
                }
            }
        }
        if (messageId == null) {
            messageId = "UNKNOWN";
        }
        StringBuffer sb = new StringBuffer(messageId);
        int len = arguments.length;
        if (len > 0) {
            sb.append(" : ");
        }
        for (int i = 0; i < len; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append('[');
            sb.append(i);
            sb.append("] ");
            if (arguments[i] == null) {
                sb.append("null");
                continue;
            }
            sb.append(arguments[i].toString());
        }
        return sb.toString();
    }

    private static ResourceBundle getBundle(String messageId) {
        ResourceBundle bundle = null;
        if (finder != null) {
            bundle = finder.getBundle(messageId);
        }
        if (bundle == null) {
            bundle = MessageService.getBundleForLocale(Locale.getDefault(), messageId);
        }
        return bundle;
    }

    public static ResourceBundle getBundleWithEnDefault(String resource, Locale locale) {
        Locale defaultLocale;
        ResourceBundle retval = null;
        retval = MessageService.getBundle(resource, locale);
        if (retval == null && !(defaultLocale = Locale.getDefault()).equals(locale)) {
            retval = MessageService.getBundle(resource, defaultLocale);
        }
        if (retval == null) {
            retval = MessageService.lookupBundle(resource, EN);
        }
        return retval;
    }

    private static ResourceBundle getBundle(String resource, Locale locale) {
        ResourceBundle retval = null;
        try {
            retval = MessageService.lookupBundle(MessageService.localizeResourceName(resource, locale.toString()), locale);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        if (retval == null) {
            try {
                retval = MessageService.lookupBundle(MessageService.localizeResourceName(resource, locale.getLanguage()), locale);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return retval;
    }

    private static ResourceBundle lookupBundle(String resource, Locale locale) {
        if (JVMInfo.isModuleAware()) {
            return MessageService.lookupBundleInModule(resource, locale);
        }
        return ResourceBundle.getBundle(resource, locale);
    }

    public static ResourceBundle lookupBundleInModule(String resource, Locale locale) {
        String moduleName;
        boolean useEnglish = locale.getLanguage().equals(EN.getLanguage());
        boolean useEngineModule = false;
        boolean localizationModule = false;
        if (resource.contains(CLIENT_MESSAGES)) {
            moduleName = "org.apache.derby.client";
        } else if (resource.contains(SERVER_MESSAGES)) {
            moduleName = "org.apache.derby.server";
        } else if (resource.contains(TOOLS_MESSAGES) || resource.contains(SYSINFO_MESSAGES)) {
            if (useEnglish) {
                moduleName = "org.apache.derby.tools";
            } else {
                moduleName = ModuleUtil.localizationModuleName(locale.toString());
                localizationModule = true;
            }
        } else if (useEnglish) {
            moduleName = "org.apache.derby.engine";
            useEngineModule = true;
        } else {
            moduleName = ModuleUtil.localizationModuleName(locale.toString());
            localizationModule = true;
        }
        Module messageModule = ModuleUtil.derbyModule(moduleName);
        if (messageModule == null && localizationModule) {
            moduleName = ModuleUtil.localizationModuleName(locale.getLanguage());
            messageModule = ModuleUtil.derbyModule(moduleName);
        }
        if (messageModule == null) {
            return null;
        }
        ResourceBundle result = MessageService.lookupBundleInModule(messageModule, resource, locale.toString(), useEnglish, useEngineModule);
        if (result == null) {
            result = MessageService.lookupBundleInModule(messageModule, resource, locale.getLanguage(), useEnglish, useEngineModule);
        }
        return result;
    }

    private static ResourceBundle lookupBundleInModule(Module messageModule, String resource, String localeSuffix, boolean useEnglish, boolean useEngineModule) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(resource.replace('.', '/'));
        if (!useEnglish) {
            buffer.append("_");
            buffer.append(localeSuffix);
        }
        if (useEngineModule && useEnglish) {
            buffer.append("_en");
        }
        buffer.append(".properties");
        String fullResourceName = buffer.toString();
        return MessageService.getModuleResourceBundle(fullResourceName, messageModule);
    }

    private static PropertyResourceBundle getModuleResourceBundle(final String resourceName, final Module module) {
        try {
            InputStream is = AccessController.doPrivileged(new PrivilegedExceptionAction<InputStream>(){

                @Override
                public InputStream run() throws IOException {
                    return module.getResourceAsStream(resourceName);
                }
            });
            if (is != null) {
                return new PropertyResourceBundle(is);
            }
            return null;
        }
        catch (Exception ioe) {
            System.out.println(ioe.getMessage());
            return null;
        }
    }

    private static String localizeResourceName(String original, String localeName) {
        if (original == null || original.contains(CLIENT_MESSAGES) || original.contains(SERVER_MESSAGES)) {
            return original;
        }
        if (EN.toString().equals(localeName)) {
            return original;
        }
        int lastDotIdx = original.lastIndexOf(46);
        String retval = original.substring(0, lastDotIdx + 1) + LOCALE_STUB + localeName + original.substring(lastDotIdx, original.length());
        return retval;
    }

    public static int hashString50(String key) {
        int hash = 0;
        int len = key.length();
        if (len > 5) {
            len = 5;
        }
        for (int i = 0; i < len; ++i) {
            hash += key.charAt(i);
        }
        return hash %= 50;
    }
}

