/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.adal4j;

import com.microsoft.aad.adal4j.AuthenticationException;
import com.microsoft.aad.adal4j.LogHelper;
import com.microsoft.aad.adal4j.StringHelper;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Proxy;
import java.net.URL;
import java.util.Map;
import java.util.Scanner;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import org.slf4j.Logger;

class HttpHelper {
    HttpHelper() {
    }

    static String executeHttpGet(Logger log, String url, Proxy proxy, SSLSocketFactory sslSocketFactory) throws Exception {
        return HttpHelper.executeHttpGet(log, url, null, proxy, sslSocketFactory);
    }

    static String executeHttpGet(Logger log, String url, Map<String, String> headers, Proxy proxy, SSLSocketFactory sslSocketFactory) throws Exception {
        HttpsURLConnection conn = HttpHelper.openConnection(url, proxy, sslSocketFactory);
        return HttpHelper.executeGetRequest(log, headers, conn);
    }

    static String executeHttpPost(Logger log, String url, String postData, Proxy proxy, SSLSocketFactory sslSocketFactory) throws Exception {
        return HttpHelper.executeHttpPost(log, url, postData, null, proxy, sslSocketFactory);
    }

    static String executeHttpPost(Logger log, String url, String postData, Map<String, String> headers, Proxy proxy, SSLSocketFactory sslSocketFactory) throws Exception {
        HttpsURLConnection conn = HttpHelper.openConnection(url, proxy, sslSocketFactory);
        return HttpHelper.executePostRequest(log, postData, headers, conn);
    }

    static String inputStreamToString(InputStream is) {
        Scanner s = new Scanner(is).useDelimiter("\\A");
        return s.hasNext() ? s.next() : "";
    }

    static String readResponseFromConnection(HttpsURLConnection conn) throws AuthenticationException, IOException {
        try (InputStream is = null;){
            if (conn.getResponseCode() != 200) {
                String msg = "Server returned HTTP response code: " + conn.getResponseCode() + " for URL : " + conn.getURL();
                is = conn.getErrorStream();
                if (is != null) {
                    msg = msg + ", Error details : " + HttpHelper.inputStreamToString(is);
                }
                throw new AuthenticationException(msg);
            }
            is = conn.getInputStream();
            String string = HttpHelper.inputStreamToString(is);
            return string;
        }
    }

    static HttpsURLConnection openConnection(URL finalURL, Proxy proxy, SSLSocketFactory sslSocketFactory) throws IOException {
        HttpsURLConnection connection = proxy != null ? (HttpsURLConnection)finalURL.openConnection(proxy) : (HttpsURLConnection)finalURL.openConnection();
        if (sslSocketFactory != null) {
            connection.setSSLSocketFactory(sslSocketFactory);
        }
        return connection;
    }

    static HttpsURLConnection openConnection(String url, Proxy proxy, SSLSocketFactory sslSocketFactory) throws IOException {
        return HttpHelper.openConnection(new URL(url), proxy, sslSocketFactory);
    }

    static HttpsURLConnection configureAdditionalHeaders(HttpsURLConnection conn, Map<String, String> headers) throws IOException {
        if (headers != null) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                conn.setRequestProperty(entry.getKey(), entry.getValue());
            }
        }
        return conn;
    }

    static void verifyReturnedCorrelationId(Logger log, HttpsURLConnection conn, String sentCorrelationId) {
        if (StringHelper.isBlank(conn.getHeaderField("client-request-id")) || !conn.getHeaderField("client-request-id").equals(sentCorrelationId)) {
            String msg = LogHelper.createMessage(String.format("Sent (%s) Correlation Id is not same as received (%s).", sentCorrelationId, conn.getHeaderField("client-request-id")), sentCorrelationId);
            log.info(msg);
        }
    }

    private static String executeGetRequest(Logger log, Map<String, String> headers, HttpsURLConnection conn) throws IOException {
        HttpHelper.configureAdditionalHeaders(conn, headers);
        return HttpHelper.getResponse(log, headers, conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String executePostRequest(Logger log, String postData, Map<String, String> headers, HttpsURLConnection conn) throws IOException {
        HttpHelper.configureAdditionalHeaders(conn, headers);
        conn.setRequestMethod("POST");
        conn.setDoOutput(true);
        try (DataOutputStream wr = null;){
            wr = new DataOutputStream(conn.getOutputStream());
            wr.writeBytes(postData);
            wr.flush();
            String string = HttpHelper.getResponse(log, headers, conn);
            return string;
        }
    }

    private static String getResponse(Logger log, Map<String, String> headers, HttpsURLConnection conn) throws IOException {
        String response = HttpHelper.readResponseFromConnection(conn);
        if (headers != null) {
            HttpHelper.verifyReturnedCorrelationId(log, conn, headers.get("client-request-id"));
        }
        return response;
    }
}

