/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.conn;

import java.util.ArrayList;
import java.util.TimerTask;
import org.apache.derby.iapi.services.context.ContextImpl;
import org.apache.derby.iapi.services.timer.TimerFactory;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.ParameterValueSet;
import org.apache.derby.iapi.sql.ResultSet;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.conn.SQLSessionContext;
import org.apache.derby.iapi.sql.conn.StatementContext;
import org.apache.derby.iapi.sql.depend.Dependency;
import org.apache.derby.iapi.sql.depend.DependencyManager;
import org.apache.derby.iapi.sql.execute.NoPutResultSet;
import org.apache.derby.impl.sql.conn.GenericLanguageConnectionFactory;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;

final class GenericStatementContext
extends ContextImpl
implements StatementContext {
    private boolean setSavePoint;
    private String internalSavePointName;
    private ResultSet topResultSet;
    private ArrayList<Dependency> dependencies;
    private NoPutResultSet[] subqueryTrackingArray;
    private NoPutResultSet[] materializedSubqueries;
    private final LanguageConnectionContext lcc;
    private boolean inUse = true;
    private volatile boolean cancellationFlag = false;
    private CancelQueryTask cancelTask = null;
    private boolean parentInTrigger;
    private boolean isForReadOnly = false;
    private boolean isAtomic;
    private boolean isSystemCode;
    private boolean rollbackParentContext;
    private boolean statementWasInvalidated;
    private String stmtText;
    private ParameterValueSet pvs;
    private short sqlAllowed = (short)-1;
    private Activation activation;
    private SQLSessionContext sqlSessionContext;

    GenericStatementContext(LanguageConnectionContext lcc) {
        super(lcc.getContextManager(), "StatementContext");
        this.lcc = lcc;
        SanityManager.ASSERT((lcc != null ? 1 : 0) != 0, (String)"Failed to get language connection context");
        this.internalSavePointName = lcc.getUniqueSavepointName();
    }

    private static TimerFactory getTimerFactory() {
        return GenericLanguageConnectionFactory.getMonitor().getTimerFactory();
    }

    @Override
    public void setInUse(boolean parentInTrigger, boolean isAtomic, boolean isForReadOnly, String stmtText, ParameterValueSet pvs, long timeoutMillis) {
        this.inUse = true;
        this.parentInTrigger = parentInTrigger;
        this.isForReadOnly = isForReadOnly;
        this.isAtomic = isAtomic;
        this.stmtText = stmtText;
        this.pvs = pvs;
        this.rollbackParentContext = false;
        if (timeoutMillis > 0L) {
            this.cancelTask = new CancelQueryTask(this);
            GenericStatementContext.getTimerFactory().schedule(this.cancelTask, timeoutMillis);
        }
    }

    @Override
    public void clearInUse() {
        this.stuffTopResultSet(null, null);
        this.inUse = false;
        this.parentInTrigger = false;
        this.isAtomic = false;
        this.isForReadOnly = false;
        this.stmtText = null;
        this.sqlAllowed = (short)-1;
        this.isSystemCode = false;
        this.rollbackParentContext = false;
        this.statementWasInvalidated = false;
        if (this.cancelTask != null) {
            this.cancelTask.forgetContext();
            this.cancelTask = null;
        }
        this.cancellationFlag = false;
        this.activation = null;
        this.sqlSessionContext = null;
    }

    @Override
    public void setSavePoint() throws StandardException {
        if (SanityManager.DEBUG_ON((String)"traceSavepoints")) {
            SanityManager.DEBUG_PRINT((String)"GenericStatementContext.setSavePoint()", (String)this.internalSavePointName);
        }
        this.pleaseBeOnStack();
        this.lcc.getTransactionExecute().setSavePoint(this.internalSavePointName, null);
        this.setSavePoint = true;
    }

    @Override
    public void resetSavePoint() throws StandardException {
        if (SanityManager.DEBUG_ON((String)"traceSavepoints")) {
            SanityManager.DEBUG_PRINT((String)"GenericStatementContext.resetSavePoint()", (String)this.internalSavePointName);
        }
        if (this.inUse && this.setSavePoint) {
            this.lcc.getTransactionExecute().setSavePoint(this.internalSavePointName, null);
        }
    }

    @Override
    public void clearSavePoint() throws StandardException {
        if (SanityManager.DEBUG_ON((String)"traceSavepoints")) {
            SanityManager.DEBUG_PRINT((String)"GenericStatementContext.clearSavePoint()", (String)this.internalSavePointName);
        }
        this.pleaseBeOnStack();
        SanityManager.ASSERT((boolean)this.setSavePoint, (String)"setSavePoint is expected to be true");
        this.lcc.getTransactionExecute().releaseSavePoint(this.internalSavePointName, null);
        this.setSavePoint = false;
    }

    @Override
    public void setTopResultSet(ResultSet topResultSet, NoPutResultSet[] subqueryTrackingArray) throws StandardException {
        this.pleaseBeOnStack();
        if (this.materializedSubqueries != null) {
            if (subqueryTrackingArray != null) {
                if (this.materializedSubqueries.length != subqueryTrackingArray.length) {
                    SanityManager.THROWASSERT((String)("this.ms.length (" + this.materializedSubqueries.length + ") expected to = sta.length(" + subqueryTrackingArray.length + ")"));
                }
                for (int index = 0; index < subqueryTrackingArray.length; ++index) {
                    if (this.materializedSubqueries[index] == null) continue;
                    subqueryTrackingArray[index] = this.materializedSubqueries[index];
                }
            } else {
                subqueryTrackingArray = this.materializedSubqueries;
            }
            this.materializedSubqueries = null;
        }
        this.stuffTopResultSet(topResultSet, subqueryTrackingArray);
    }

    private void stuffTopResultSet(ResultSet topResultSet, NoPutResultSet[] subqueryTrackingArray) {
        this.topResultSet = topResultSet;
        this.subqueryTrackingArray = subqueryTrackingArray;
        this.dependencies = null;
    }

    @Override
    public void setSubqueryResultSet(int subqueryNumber, NoPutResultSet subqueryResultSet, int numSubqueries) throws StandardException {
        this.pleaseBeOnStack();
        if (this.subqueryTrackingArray == null) {
            if (this.topResultSet == null) {
                this.subqueryTrackingArray = new NoPutResultSet[numSubqueries];
                this.materializedSubqueries = new NoPutResultSet[numSubqueries];
            } else {
                this.subqueryTrackingArray = this.topResultSet.getSubqueryTrackingArray(numSubqueries);
            }
        }
        this.subqueryTrackingArray[subqueryNumber] = subqueryResultSet;
        if (this.materializedSubqueries != null) {
            this.materializedSubqueries[subqueryNumber] = subqueryResultSet;
        }
    }

    @Override
    public NoPutResultSet[] getSubqueryTrackingArray() throws StandardException {
        this.pleaseBeOnStack();
        return this.subqueryTrackingArray;
    }

    @Override
    public void addDependency(Dependency dy) throws StandardException {
        this.pleaseBeOnStack();
        if (this.dependencies == null) {
            this.dependencies = new ArrayList();
        }
        this.dependencies.add(dy);
    }

    @Override
    public boolean inTrigger() {
        return this.parentInTrigger;
    }

    @Override
    public void cleanupOnError(Throwable error) throws StandardException {
        if (SanityManager.DEBUG_ON((String)"traceSavepoints")) {
            SanityManager.DEBUG_PRINT((String)"GenericStatementContext.cleanupOnError()", (String)String.valueOf(this.hashCode()));
        }
        try {
            int severity = 40000;
            if (error instanceof StandardException) {
                StandardException se = (StandardException)error;
                severity = se.getSeverity();
                if ("XCL32.S".equals(se.getMessageId())) {
                    this.statementWasInvalidated = true;
                }
            }
            if (!this.inUse) {
                return;
            }
            if (this.topResultSet != null) {
                this.topResultSet.cleanUp();
            }
            if (this.subqueryTrackingArray != null) {
                for (int index = 0; index < this.subqueryTrackingArray.length; ++index) {
                    if (this.subqueryTrackingArray[index] == null) continue;
                    this.subqueryTrackingArray[index].cleanUp();
                }
            }
            if (this.dependencies != null) {
                DependencyManager dmgr = this.lcc.getDataDictionary().getDependencyManager();
                for (Dependency dy : this.dependencies) {
                    dmgr.clearInMemoryDependency(dy);
                }
                this.dependencies = null;
            }
            if (severity <= 20000 && this.setSavePoint) {
                if (SanityManager.DEBUG_ON((String)"traceSavepoints")) {
                    SanityManager.DEBUG_PRINT((String)"GenericStatementContext.cleanupOnError", (String)("rolling back to: " + this.internalSavePointName));
                }
                this.lcc.internalRollbackToSavepoint(this.internalSavePointName, false, null);
                this.clearSavePoint();
            }
            if (severity >= 30000) {
                this.setSavePoint = false;
            }
            this.lcc.popStatementContext(this, error);
        }
        catch (Exception ex) {
            ex.initCause(error);
            throw StandardException.unexpectedUserException((Throwable)ex);
        }
    }

    @Override
    public boolean isLastHandler(int severity) {
        return this.inUse && !this.rollbackParentContext && severity == 20000;
    }

    @Override
    public boolean onStack() {
        return this.inUse;
    }

    @Override
    public boolean isAtomic() {
        return this.isAtomic;
    }

    @Override
    public String getStatementText() {
        return this.stmtText;
    }

    private void pleaseBeOnStack() throws StandardException {
        if (!this.inUse) {
            throw StandardException.newException((String)"40XC0", (Object[])new Object[0]);
        }
    }

    @Override
    public boolean inUse() {
        return this.inUse;
    }

    @Override
    public boolean isForReadOnly() {
        return this.isForReadOnly;
    }

    @Override
    public boolean isCancelled() {
        return this.cancellationFlag;
    }

    @Override
    public void cancel() {
        this.cancellationFlag = true;
    }

    @Override
    public void setSQLAllowed(short allow, boolean force) {
        if (force || allow > this.sqlAllowed) {
            this.sqlAllowed = allow;
        }
    }

    @Override
    public short getSQLAllowed() {
        if (!this.inUse) {
            return 3;
        }
        return this.sqlAllowed;
    }

    @Override
    public void setParentRollback() {
        this.rollbackParentContext = true;
    }

    @Override
    public void setSystemCode() {
        this.isSystemCode = true;
    }

    @Override
    public boolean getSystemCode() {
        return this.isSystemCode;
    }

    @Override
    public StringBuffer appendErrorInfo() {
        StringBuffer sb = ((ContextImpl)((Object)this.lcc)).appendErrorInfo();
        if (sb != null) {
            sb.append("Failed Statement is: ");
            sb.append(this.getStatementText());
            if (this.pvs != null && this.pvs.getParameterCount() > 0) {
                String pvsString = " with " + this.pvs.getParameterCount() + " parameters " + this.pvs.toString();
                sb.append(pvsString);
            }
        }
        return sb;
    }

    @Override
    public void setActivation(Activation a) {
        this.activation = a;
    }

    @Override
    public Activation getActivation() {
        return this.activation;
    }

    @Override
    public SQLSessionContext getSQLSessionContext() {
        return this.sqlSessionContext;
    }

    @Override
    public void setSQLSessionContext(SQLSessionContext ctx) {
        this.sqlSessionContext = ctx;
    }

    @Override
    public boolean getStatementWasInvalidated() {
        return this.statementWasInvalidated;
    }

    private static class CancelQueryTask
    extends TimerTask {
        private StatementContext statementContext;

        public CancelQueryTask(StatementContext ctx) {
            this.statementContext = ctx;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            CancelQueryTask cancelQueryTask = this;
            synchronized (cancelQueryTask) {
                if (this.statementContext != null) {
                    this.statementContext.cancel();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void forgetContext() {
            CancelQueryTask cancelQueryTask = this;
            synchronized (cancelQueryTask) {
                this.statementContext = null;
            }
            GenericStatementContext.getTimerFactory().cancel(this);
        }
    }
}

